/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.encoding.PDFDocEncodingCharset;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.persistence.util.COSHEXTable;

public class COSString
extends COSBase {
    private static final Log LOG = LogFactory.getLog(COSString.class);
    public static final byte[] STRING_OPEN = new byte[]{40};
    public static final byte[] STRING_CLOSE = new byte[]{41};
    public static final byte[] HEX_STRING_OPEN = new byte[]{60};
    public static final byte[] HEX_STRING_CLOSE = new byte[]{62};
    public static final byte[] ESCAPE = new byte[]{92};
    public static final byte[] CR_ESCAPE = new byte[]{92, 114};
    public static final byte[] LF_ESCAPE = new byte[]{92, 110};
    public static final byte[] HT_ESCAPE = new byte[]{92, 116};
    public static final byte[] BS_ESCAPE = new byte[]{92, 98};
    public static final byte[] FF_ESCAPE = new byte[]{92, 102};
    private ByteArrayOutputStream out = null;
    private String str = null;
    private boolean forceHexForm = false;

    public COSString() {
        this.out = new ByteArrayOutputStream();
    }

    @Deprecated
    public COSString(boolean isDictionaryValue) {
        this();
    }

    public COSString(String value) {
        try {
            boolean unicode16 = false;
            char[] chars = value.toCharArray();
            int length = chars.length;
            for (int i = 0; i < length; ++i) {
                if (chars[i] <= '\u00ff') continue;
                unicode16 = true;
                break;
            }
            if (unicode16) {
                byte[] data = value.getBytes("UTF-16BE");
                this.out = new ByteArrayOutputStream(data.length + 2);
                this.out.write(254);
                this.out.write(255);
                this.out.write(data);
            } else {
                byte[] data = value.getBytes("ISO-8859-1");
                this.out = new ByteArrayOutputStream(data.length);
                this.out.write(data);
            }
        }
        catch (IOException ignore) {
            LOG.error(ignore, ignore);
        }
    }

    public COSString(byte[] value) {
        try {
            this.out = new ByteArrayOutputStream(value.length);
            this.out.write(value);
        }
        catch (IOException ignore) {
            LOG.error(ignore, ignore);
        }
    }

    public void setForceLiteralForm(boolean v) {
        this.forceHexForm = !v;
    }

    public void setForceHexForm(boolean v) {
        this.forceHexForm = v;
    }

    public static COSString createFromHexString(String hex) throws IOException {
        return COSString.createFromHexString(hex, false);
    }

    public static COSString createFromHexString(String hex, boolean force) throws IOException {
        COSString retval = new COSString();
        StringBuilder hexBuffer = new StringBuilder(hex.trim());
        if (hexBuffer.length() % 2 != 0) {
            hexBuffer.append('0');
        }
        int length = hexBuffer.length();
        for (int i = 0; i < length; i += 2) {
            try {
                retval.append(Integer.parseInt(hexBuffer.substring(i, i + 2), 16));
                continue;
            }
            catch (NumberFormatException e) {
                if (force) {
                    retval.append(63);
                    continue;
                }
                IOException exception = new IOException("Invalid hex string: " + hex);
                exception.initCause(e);
                throw exception;
            }
        }
        return retval;
    }

    public String getHexString() {
        StringBuilder retval = new StringBuilder(this.out.size() * 2);
        byte[] data = this.getBytes();
        int length = data.length;
        for (int i = 0; i < length; ++i) {
            retval.append(COSHEXTable.HEX_TABLE[(data[i] + 256) % 256]);
        }
        return retval.toString();
    }

    public String getString() {
        String retval;
        if (this.str != null) {
            return this.str;
        }
        Charset charset = PDFDocEncodingCharset.INSTANCE;
        byte[] data = this.getBytes();
        int start = 0;
        if (data.length > 2) {
            if (data[0] == -1 && data[1] == -2) {
                charset = Charset.forName("UTF-16LE");
                start = 2;
            } else if (data[0] == -2 && data[1] == -1) {
                charset = Charset.forName("UTF-16BE");
                start = 2;
            }
        }
        this.str = retval = COSString.toString(data, start, data.length - start, charset);
        return retval;
    }

    private static String toString(byte[] data, int offset, int length, Charset charset) {
        CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(data, offset, length));
        return charBuffer.toString();
    }

    public void append(byte[] data) throws IOException {
        this.out.write(data);
        this.str = null;
    }

    public void append(int in) throws IOException {
        this.out.write(in);
        this.str = null;
    }

    public void reset() {
        this.out.reset();
        this.str = null;
    }

    public byte[] getBytes() {
        return this.out.toByteArray();
    }

    public String toString() {
        return "COSString{" + this.getString() + "}";
    }

    public void writePDF(OutputStream output) throws IOException {
        int i;
        boolean outsideASCII = false;
        byte[] bytes = this.getBytes();
        int length = bytes.length;
        for (i = 0; i < length && !outsideASCII; ++i) {
            outsideASCII = bytes[i] < 0;
        }
        if (!outsideASCII && !this.forceHexForm) {
            output.write(STRING_OPEN);
            block9: for (i = 0; i < length; ++i) {
                int b = (bytes[i] + 256) % 256;
                switch (b) {
                    case 40: 
                    case 41: 
                    case 92: {
                        output.write(ESCAPE);
                        output.write((byte)b);
                        continue block9;
                    }
                    case 10: {
                        output.write(LF_ESCAPE);
                        continue block9;
                    }
                    case 13: {
                        output.write(CR_ESCAPE);
                        continue block9;
                    }
                    case 9: {
                        output.write(HT_ESCAPE);
                        continue block9;
                    }
                    case 8: {
                        output.write(BS_ESCAPE);
                        continue block9;
                    }
                    case 12: {
                        output.write(FF_ESCAPE);
                        continue block9;
                    }
                    default: {
                        output.write((byte)b);
                    }
                }
            }
            output.write(STRING_CLOSE);
        } else {
            output.write(HEX_STRING_OPEN);
            for (i = 0; i < length; ++i) {
                output.write(COSHEXTable.TABLE[(bytes[i] + 256) % 256]);
            }
            output.write(HEX_STRING_CLOSE);
        }
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromString(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof COSString) {
            COSString strObj = (COSString)obj;
            return this.getString().equals(strObj.getString()) && this.forceHexForm == strObj.forceHexForm;
        }
        return false;
    }

    public int hashCode() {
        int result = this.getString().hashCode();
        return result += this.forceHexForm ? 17 : 0;
    }
}

