/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.crypt;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionPluginSpi;
import org.firebirdsql.jaybird.util.PluginLoader;

public final class EncryptionPluginRegistry {
    private EncryptionPluginRegistry() {
    }

    public static EncryptionPluginSpi getEncryptionPluginSpi(EncryptionIdentifier encryptionIdentifier) {
        return Holder.PLUGIN_SPI_MAP.get(encryptionIdentifier);
    }

    private static Map<EncryptionIdentifier, EncryptionPluginSpi> findEncryptionPluginSpi() {
        Collection<EncryptionPluginSpi> pluginSpis = PluginLoader.findPlugins(EncryptionPluginSpi.class, List.of("org.firebirdsql.gds.ng.wire.crypt.arc4.Arc4EncryptionPluginSpi", "org.firebirdsql.gds.ng.wire.crypt.chacha.ChaChaEncryptionPluginSpi"));
        HashMap<EncryptionIdentifier, EncryptionPluginSpi> pluginSpiMap = new HashMap<EncryptionIdentifier, EncryptionPluginSpi>();
        for (EncryptionPluginSpi pluginSpi : pluginSpis) {
            EncryptionPluginSpi existingPluginSpi = pluginSpiMap.putIfAbsent(pluginSpi.encryptionIdentifier(), pluginSpi);
            if (existingPluginSpi == null) continue;
            System.getLogger(EncryptionPluginRegistry.class.getName()).log(System.Logger.Level.WARNING, "Encryption plugin SPI with id {0} was already registered for plugin {1}, skipping plugin {2}", pluginSpi.encryptionIdentifier(), existingPluginSpi.getClass().getName(), pluginSpi.getClass().getName());
        }
        return pluginSpiMap;
    }

    private static class Holder {
        private static final Map<EncryptionIdentifier, EncryptionPluginSpi> PLUGIN_SPI_MAP = Map.copyOf(EncryptionPluginRegistry.findEncryptionPluginSpi());

        private Holder() {
        }
    }
}

