# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_ruff_global_optspecs
	string join \n v/verbose q/quiet s/silent config= isolated h/help V/version
end

function __fish_ruff_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_ruff_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_ruff_using_subcommand
	set -l cmd (__fish_ruff_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c ruff -n "__fish_ruff_needs_command" -l config -d 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`' -r
complete -c ruff -n "__fish_ruff_needs_command" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_ruff_needs_command" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_ruff_needs_command" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_ruff_needs_command" -l isolated -d 'Ignore all configuration files'
complete -c ruff -n "__fish_ruff_needs_command" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_ruff_needs_command" -s V -l version -d 'Print version'
complete -c ruff -n "__fish_ruff_needs_command" -f -a "check" -d 'Run Ruff on the given files or directories'
complete -c ruff -n "__fish_ruff_needs_command" -f -a "rule" -d 'Explain a rule (or all rules)'
complete -c ruff -n "__fish_ruff_needs_command" -f -a "config" -d 'List or describe the available configuration options'
complete -c ruff -n "__fish_ruff_needs_command" -f -a "linter" -d 'List all supported upstream linters'
complete -c ruff -n "__fish_ruff_needs_command" -f -a "clean" -d 'Clear any caches in the current directory and any subdirectories'
complete -c ruff -n "__fish_ruff_needs_command" -f -a "generate-shell-completion" -d 'Generate shell completion'
complete -c ruff -n "__fish_ruff_needs_command" -f -a "format" -d 'Run the Ruff formatter on the given files or directories'
complete -c ruff -n "__fish_ruff_needs_command" -f -a "server" -d 'Run the language server'
complete -c ruff -n "__fish_ruff_needs_command" -f -a "analyze" -d 'Run analysis over Python source code'
complete -c ruff -n "__fish_ruff_needs_command" -f -a "version" -d 'Display Ruff\'s version'
complete -c ruff -n "__fish_ruff_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ruff -n "__fish_ruff_using_subcommand check" -l output-format -d 'Output serialization format for violations. The default serialization format is "full"' -r -f -a "concise\t''
full\t''
json\t''
json-lines\t''
junit\t''
grouped\t''
github\t''
gitlab\t''
pylint\t''
rdjson\t''
azure\t''
sarif\t''"
complete -c ruff -n "__fish_ruff_using_subcommand check" -s o -l output-file -d 'Specify file to write the linter output to (default: stdout)' -r -F
complete -c ruff -n "__fish_ruff_using_subcommand check" -l target-version -d 'The minimum Python version that should be supported' -r -f -a "py37\t''
py38\t''
py39\t''
py310\t''
py311\t''
py312\t''
py313\t''
py314\t''"
complete -c ruff -n "__fish_ruff_using_subcommand check" -l select -d 'Comma-separated list of rule codes to enable (or ALL, to enable all rules)' -r -f -a "ALL\t'all rules'
AIR\t'Airflow'
ERA\t'eradicate'
FAST\t'FastAPI'
YTT\t'flake8-2020'
ANN\t'flake8-annotations'
ASYNC\t'flake8-async'
S\t'flake8-bandit'
BLE\t'flake8-blind-except'
FBT\t'flake8-boolean-trap'
B\t'flake8-bugbear'
A\t'flake8-builtins'
COM\t'flake8-commas'
C4\t'flake8-comprehensions'
CPY\t'flake8-copyright'
DTZ\t'flake8-datetimez'
T10\t'flake8-debugger'
DJ\t'flake8-django'
EM\t'flake8-errmsg'
EXE\t'flake8-executable'
FIX\t'flake8-fixme'
FA\t'flake8-future-annotations'
INT\t'flake8-gettext'
ISC\t'flake8-implicit-str-concat'
ICN\t'flake8-import-conventions'
LOG\t'flake8-logging'
G\t'flake8-logging-format'
INP\t'flake8-no-pep420'
PIE\t'flake8-pie'
T20\t'flake8-print'
PYI\t'flake8-pyi'
PT\t'flake8-pytest-style'
Q\t'flake8-quotes'
RSE\t'flake8-raise'
RET\t'flake8-return'
SLF\t'flake8-self'
SIM\t'flake8-simplify'
SLOT\t'flake8-slots'
TID\t'flake8-tidy-imports'
TD\t'flake8-todos'
TC\t'flake8-type-checking'
ARG\t'flake8-unused-arguments'
PTH\t'flake8-use-pathlib'
FLY\t'flynt'
I\t'isort'
C90\t'mccabe'
NPY\t'NumPy-specific rules'
PD\t'pandas-vet'
N\t'pep8-naming'
PERF\t'Perflint'
DOC\t'pydoclint'
D\t'pydocstyle'
F\t'Pyflakes'
PGH\t'pygrep-hooks'
PL\t'Pylint'
UP\t'pyupgrade'
FURB\t'refurb'
RUF\t'Ruff-specific rules'
TRY\t'tryceratops'
AIR001\t'airflow-variable-name-task-id-mismatch'
AIR002\t'airflow-dag-no-schedule-argument'
AIR301\t'airflow3-removal'
AIR302\t'airflow3-moved-to-provider'
AIR311\t'airflow3-suggested-update'
AIR312\t'airflow3-suggested-to-move-to-provider'
ERA001\t'commented-out-code'
FAST001\t'fast-api-redundant-response-model'
FAST002\t'fast-api-non-annotated-dependency'
FAST003\t'fast-api-unused-path-parameter'
YTT101\t'sys-version-slice3'
YTT102\t'sys-version2'
YTT103\t'sys-version-cmp-str3'
YTT201\t'sys-version-info0-eq3'
YTT202\t'six-py3'
YTT203\t'sys-version-info1-cmp-int'
YTT204\t'sys-version-info-minor-cmp-int'
YTT301\t'sys-version0'
YTT302\t'sys-version-cmp-str10'
YTT303\t'sys-version-slice1'
ANN001\t'missing-type-function-argument'
ANN002\t'missing-type-args'
ANN003\t'missing-type-kwargs'
ANN101\t'missing-type-self'
ANN102\t'missing-type-cls'
ANN201\t'missing-return-type-undocumented-public-function'
ANN202\t'missing-return-type-private-function'
ANN204\t'missing-return-type-special-method'
ANN205\t'missing-return-type-static-method'
ANN206\t'missing-return-type-class-method'
ANN401\t'any-type'
ASYNC100\t'cancel-scope-no-checkpoint'
ASYNC105\t'trio-sync-call'
ASYNC109\t'async-function-with-timeout'
ASYNC110\t'async-busy-wait'
ASYNC115\t'async-zero-sleep'
ASYNC116\t'long-sleep-not-forever'
ASYNC210\t'blocking-http-call-in-async-function'
ASYNC212\t'blocking-http-call-httpx-in-async-function'
ASYNC220\t'create-subprocess-in-async-function'
ASYNC221\t'run-process-in-async-function'
ASYNC222\t'wait-for-process-in-async-function'
ASYNC230\t'blocking-open-call-in-async-function'
ASYNC240\t'blocking-path-method-in-async-function'
ASYNC250\t'blocking-input-in-async-function'
ASYNC251\t'blocking-sleep-in-async-function'
S101\t'assert'
S102\t'exec-builtin'
S103\t'bad-file-permissions'
S104\t'hardcoded-bind-all-interfaces'
S105\t'hardcoded-password-string'
S106\t'hardcoded-password-func-arg'
S107\t'hardcoded-password-default'
S108\t'hardcoded-temp-file'
S110\t'try-except-pass'
S112\t'try-except-continue'
S113\t'request-without-timeout'
S201\t'flask-debug-true'
S202\t'tarfile-unsafe-members'
S301\t'suspicious-pickle-usage'
S302\t'suspicious-marshal-usage'
S303\t'suspicious-insecure-hash-usage'
S304\t'suspicious-insecure-cipher-usage'
S305\t'suspicious-insecure-cipher-mode-usage'
S306\t'suspicious-mktemp-usage'
S307\t'suspicious-eval-usage'
S308\t'suspicious-mark-safe-usage'
S310\t'suspicious-url-open-usage'
S311\t'suspicious-non-cryptographic-random-usage'
S312\t'suspicious-telnet-usage'
S313\t'suspicious-xmlc-element-tree-usage'
S314\t'suspicious-xml-element-tree-usage'
S315\t'suspicious-xml-expat-reader-usage'
S316\t'suspicious-xml-expat-builder-usage'
S317\t'suspicious-xml-sax-usage'
S318\t'suspicious-xml-mini-dom-usage'
S319\t'suspicious-xml-pull-dom-usage'
S320\t'suspicious-xmle-tree-usage'
S321\t'suspicious-ftp-lib-usage'
S323\t'suspicious-unverified-context-usage'
S324\t'hashlib-insecure-hash-function'
S401\t'suspicious-telnetlib-import'
S402\t'suspicious-ftplib-import'
S403\t'suspicious-pickle-import'
S404\t'suspicious-subprocess-import'
S405\t'suspicious-xml-etree-import'
S406\t'suspicious-xml-sax-import'
S407\t'suspicious-xml-expat-import'
S408\t'suspicious-xml-minidom-import'
S409\t'suspicious-xml-pulldom-import'
S410\t'suspicious-lxml-import'
S411\t'suspicious-xmlrpc-import'
S412\t'suspicious-httpoxy-import'
S413\t'suspicious-pycrypto-import'
S415\t'suspicious-pyghmi-import'
S501\t'request-with-no-cert-validation'
S502\t'ssl-insecure-version'
S503\t'ssl-with-bad-defaults'
S504\t'ssl-with-no-version'
S505\t'weak-cryptographic-key'
S506\t'unsafe-yaml-load'
S507\t'ssh-no-host-key-verification'
S508\t'snmp-insecure-version'
S509\t'snmp-weak-cryptography'
S601\t'paramiko-call'
S602\t'subprocess-popen-with-shell-equals-true'
S603\t'subprocess-without-shell-equals-true'
S604\t'call-with-shell-equals-true'
S605\t'start-process-with-a-shell'
S606\t'start-process-with-no-shell'
S607\t'start-process-with-partial-path'
S608\t'hardcoded-sql-expression'
S609\t'unix-command-wildcard-injection'
S610\t'django-extra'
S611\t'django-raw-sql'
S612\t'logging-config-insecure-listen'
S701\t'jinja2-autoescape-false'
S702\t'mako-templates'
S704\t'unsafe-markup-use'
BLE001\t'blind-except'
FBT001\t'boolean-type-hint-positional-argument'
FBT002\t'boolean-default-value-positional-argument'
FBT003\t'boolean-positional-value-in-call'
B002\t'unary-prefix-increment-decrement'
B003\t'assignment-to-os-environ'
B004\t'unreliable-callable-check'
B005\t'strip-with-multi-characters'
B006\t'mutable-argument-default'
B007\t'unused-loop-control-variable'
B008\t'function-call-in-default-argument'
B009\t'get-attr-with-constant'
B010\t'set-attr-with-constant'
B011\t'assert-false'
B012\t'jump-statement-in-finally'
B013\t'redundant-tuple-in-exception-handler'
B014\t'duplicate-handler-exception'
B015\t'useless-comparison'
B016\t'raise-literal'
B017\t'assert-raises-exception'
B018\t'useless-expression'
B019\t'cached-instance-method'
B020\t'loop-variable-overrides-iterator'
B021\t'f-string-docstring'
B022\t'useless-contextlib-suppress'
B023\t'function-uses-loop-variable'
B024\t'abstract-base-class-without-abstract-method'
B025\t'duplicate-try-block-exception'
B026\t'star-arg-unpacking-after-keyword-arg'
B027\t'empty-method-without-abstract-decorator'
B028\t'no-explicit-stacklevel'
B029\t'except-with-empty-tuple'
B030\t'except-with-non-exception-classes'
B031\t'reuse-of-groupby-generator'
B032\t'unintentional-type-annotation'
B033\t'duplicate-value'
B034\t're-sub-positional-args'
B035\t'static-key-dict-comprehension'
B039\t'mutable-contextvar-default'
B901\t'return-in-generator'
B903\t'class-as-data-structure'
B904\t'raise-without-from-inside-except'
B905\t'zip-without-explicit-strict'
B909\t'loop-iterator-mutation'
B911\t'batched-without-explicit-strict'
B912\t'map-without-explicit-strict'
A001\t'builtin-variable-shadowing'
A002\t'builtin-argument-shadowing'
A003\t'builtin-attribute-shadowing'
A004\t'builtin-import-shadowing'
A005\t'stdlib-module-shadowing'
A006\t'builtin-lambda-argument-shadowing'
COM812\t'missing-trailing-comma'
COM818\t'trailing-comma-on-bare-tuple'
COM819\t'prohibited-trailing-comma'
C400\t'unnecessary-generator-list'
C401\t'unnecessary-generator-set'
C402\t'unnecessary-generator-dict'
C403\t'unnecessary-list-comprehension-set'
C404\t'unnecessary-list-comprehension-dict'
C405\t'unnecessary-literal-set'
C406\t'unnecessary-literal-dict'
C408\t'unnecessary-collection-call'
C409\t'unnecessary-literal-within-tuple-call'
C410\t'unnecessary-literal-within-list-call'
C411\t'unnecessary-list-call'
C413\t'unnecessary-call-around-sorted'
C414\t'unnecessary-double-cast-or-process'
C415\t'unnecessary-subscript-reversal'
C416\t'unnecessary-comprehension'
C417\t'unnecessary-map'
C418\t'unnecessary-literal-within-dict-call'
C419\t'unnecessary-comprehension-in-call'
C420\t'unnecessary-dict-comprehension-for-iterable'
CPY001\t'missing-copyright-notice'
DTZ001\t'call-datetime-without-tzinfo'
DTZ002\t'call-datetime-today'
DTZ003\t'call-datetime-utcnow'
DTZ004\t'call-datetime-utcfromtimestamp'
DTZ005\t'call-datetime-now-without-tzinfo'
DTZ006\t'call-datetime-fromtimestamp'
DTZ007\t'call-datetime-strptime-without-zone'
DTZ011\t'call-date-today'
DTZ012\t'call-date-fromtimestamp'
DTZ901\t'datetime-min-max'
T100\t'debugger'
DJ001\t'django-nullable-model-string-field'
DJ003\t'django-locals-in-render-function'
DJ006\t'django-exclude-with-model-form'
DJ007\t'django-all-with-model-form'
DJ008\t'django-model-without-dunder-str'
DJ012\t'django-unordered-body-content-in-model'
DJ013\t'django-non-leading-receiver-decorator'
EM101\t'raw-string-in-exception'
EM102\t'f-string-in-exception'
EM103\t'dot-format-in-exception'
EXE001\t'shebang-not-executable'
EXE002\t'shebang-missing-executable-file'
EXE003\t'shebang-missing-python'
EXE004\t'shebang-leading-whitespace'
EXE005\t'shebang-not-first-line'
FIX001\t'line-contains-fixme'
FIX002\t'line-contains-todo'
FIX003\t'line-contains-xxx'
FIX004\t'line-contains-hack'
FA100\t'future-rewritable-type-annotation'
FA102\t'future-required-type-annotation'
INT001\t'f-string-in-get-text-func-call'
INT002\t'format-in-get-text-func-call'
INT003\t'printf-in-get-text-func-call'
ISC001\t'single-line-implicit-string-concatenation'
ISC002\t'multi-line-implicit-string-concatenation'
ISC003\t'explicit-string-concatenation'
ICN001\t'unconventional-import-alias'
ICN002\t'banned-import-alias'
ICN003\t'banned-import-from'
LOG001\t'direct-logger-instantiation'
LOG002\t'invalid-get-logger-argument'
LOG004\t'log-exception-outside-except-handler'
LOG007\t'exception-without-exc-info'
LOG009\t'undocumented-warn'
LOG014\t'exc-info-outside-except-handler'
LOG015\t'root-logger-call'
G001\t'logging-string-format'
G002\t'logging-percent-format'
G003\t'logging-string-concat'
G004\t'logging-f-string'
G010\t'logging-warn'
G101\t'logging-extra-attr-clash'
G201\t'logging-exc-info'
G202\t'logging-redundant-exc-info'
INP001\t'implicit-namespace-package'
PIE790\t'unnecessary-placeholder'
PIE794\t'duplicate-class-field-definition'
PIE796\t'non-unique-enums'
PIE800\t'unnecessary-spread'
PIE804\t'unnecessary-dict-kwargs'
PIE807\t'reimplemented-container-builtin'
PIE808\t'unnecessary-range-start'
PIE810\t'multiple-starts-ends-with'
T201\t'print'
T203\t'p-print'
PYI001\t'unprefixed-type-param'
PYI002\t'complex-if-statement-in-stub'
PYI003\t'unrecognized-version-info-check'
PYI004\t'patch-version-comparison'
PYI005\t'wrong-tuple-length-version-comparison'
PYI006\t'bad-version-info-comparison'
PYI007\t'unrecognized-platform-check'
PYI008\t'unrecognized-platform-name'
PYI009\t'pass-statement-stub-body'
PYI010\t'non-empty-stub-body'
PYI011\t'typed-argument-default-in-stub'
PYI012\t'pass-in-class-body'
PYI013\t'ellipsis-in-non-empty-class-body'
PYI014\t'argument-default-in-stub'
PYI015\t'assignment-default-in-stub'
PYI016\t'duplicate-union-member'
PYI017\t'complex-assignment-in-stub'
PYI018\t'unused-private-type-var'
PYI019\t'custom-type-var-for-self'
PYI020\t'quoted-annotation-in-stub'
PYI021\t'docstring-in-stub'
PYI024\t'collections-named-tuple'
PYI025\t'unaliased-collections-abc-set-import'
PYI026\t'type-alias-without-annotation'
PYI029\t'str-or-repr-defined-in-stub'
PYI030\t'unnecessary-literal-union'
PYI032\t'any-eq-ne-annotation'
PYI033\t'type-comment-in-stub'
PYI034\t'non-self-return-type'
PYI035\t'unassigned-special-variable-in-stub'
PYI036\t'bad-exit-annotation'
PYI041\t'redundant-numeric-union'
PYI042\t'snake-case-type-alias'
PYI043\t't-suffixed-type-alias'
PYI044\t'future-annotations-in-stub'
PYI045\t'iter-method-return-iterable'
PYI046\t'unused-private-protocol'
PYI047\t'unused-private-type-alias'
PYI048\t'stub-body-multiple-statements'
PYI049\t'unused-private-typed-dict'
PYI050\t'no-return-argument-annotation-in-stub'
PYI051\t'redundant-literal-union'
PYI052\t'unannotated-assignment-in-stub'
PYI053\t'string-or-bytes-too-long'
PYI054\t'numeric-literal-too-long'
PYI055\t'unnecessary-type-union'
PYI056\t'unsupported-method-call-on-all'
PYI057\t'byte-string-usage'
PYI058\t'generator-return-from-iter-method'
PYI059\t'generic-not-last-base-class'
PYI061\t'redundant-none-literal'
PYI062\t'duplicate-literal-member'
PYI063\t'pep484-style-positional-only-parameter'
PYI064\t'redundant-final-literal'
PYI066\t'bad-version-info-order'
PT001\t'pytest-fixture-incorrect-parentheses-style'
PT002\t'pytest-fixture-positional-args'
PT003\t'pytest-extraneous-scope-function'
PT004\t'pytest-missing-fixture-name-underscore'
PT005\t'pytest-incorrect-fixture-name-underscore'
PT006\t'pytest-parametrize-names-wrong-type'
PT007\t'pytest-parametrize-values-wrong-type'
PT008\t'pytest-patch-with-lambda'
PT009\t'pytest-unittest-assertion'
PT010\t'pytest-raises-without-exception'
PT011\t'pytest-raises-too-broad'
PT012\t'pytest-raises-with-multiple-statements'
PT013\t'pytest-incorrect-pytest-import'
PT014\t'pytest-duplicate-parametrize-test-cases'
PT015\t'pytest-assert-always-false'
PT016\t'pytest-fail-without-message'
PT017\t'pytest-assert-in-except'
PT018\t'pytest-composite-assertion'
PT019\t'pytest-fixture-param-without-value'
PT020\t'pytest-deprecated-yield-fixture'
PT021\t'pytest-fixture-finalizer-callback'
PT022\t'pytest-useless-yield-fixture'
PT023\t'pytest-incorrect-mark-parentheses-style'
PT024\t'pytest-unnecessary-asyncio-mark-on-fixture'
PT025\t'pytest-erroneous-use-fixtures-on-fixture'
PT026\t'pytest-use-fixtures-without-parameters'
PT027\t'pytest-unittest-raises-assertion'
PT028\t'pytest-parameter-with-default-argument'
PT029\t'pytest-warns-without-warning'
PT030\t'pytest-warns-too-broad'
PT031\t'pytest-warns-with-multiple-statements'
Q000\t'bad-quotes-inline-string'
Q001\t'bad-quotes-multiline-string'
Q002\t'bad-quotes-docstring'
Q003\t'avoidable-escaped-quote'
Q004\t'unnecessary-escaped-quote'
RSE102\t'unnecessary-paren-on-raise-exception'
RET501\t'unnecessary-return-none'
RET502\t'implicit-return-value'
RET503\t'implicit-return'
RET504\t'unnecessary-assign'
RET505\t'superfluous-else-return'
RET506\t'superfluous-else-raise'
RET507\t'superfluous-else-continue'
RET508\t'superfluous-else-break'
SLF001\t'private-member-access'
SIM101\t'duplicate-isinstance-call'
SIM102\t'collapsible-if'
SIM103\t'needless-bool'
SIM105\t'suppressible-exception'
SIM107\t'return-in-try-except-finally'
SIM108\t'if-else-block-instead-of-if-exp'
SIM109\t'compare-with-tuple'
SIM110\t'reimplemented-builtin'
SIM112\t'uncapitalized-environment-variables'
SIM113\t'enumerate-for-loop'
SIM114\t'if-with-same-arms'
SIM115\t'open-file-with-context-handler'
SIM116\t'if-else-block-instead-of-dict-lookup'
SIM117\t'multiple-with-statements'
SIM118\t'in-dict-keys'
SIM201\t'negate-equal-op'
SIM202\t'negate-not-equal-op'
SIM208\t'double-negation'
SIM210\t'if-expr-with-true-false'
SIM211\t'if-expr-with-false-true'
SIM212\t'if-expr-with-twisted-arms'
SIM220\t'expr-and-not-expr'
SIM221\t'expr-or-not-expr'
SIM222\t'expr-or-true'
SIM223\t'expr-and-false'
SIM300\t'yoda-conditions'
SIM401\t'if-else-block-instead-of-dict-get'
SIM905\t'split-static-string'
SIM910\t'dict-get-with-none-default'
SIM911\t'zip-dict-keys-and-values'
SLOT000\t'no-slots-in-str-subclass'
SLOT001\t'no-slots-in-tuple-subclass'
SLOT002\t'no-slots-in-namedtuple-subclass'
TID251\t'banned-api'
TID252\t'relative-imports'
TID253\t'banned-module-level-imports'
TD001\t'invalid-todo-tag'
TD002\t'missing-todo-author'
TD003\t'missing-todo-link'
TD004\t'missing-todo-colon'
TD005\t'missing-todo-description'
TD006\t'invalid-todo-capitalization'
TD007\t'missing-space-after-todo-colon'
TC001\t'typing-only-first-party-import'
TC002\t'typing-only-third-party-import'
TC003\t'typing-only-standard-library-import'
TC004\t'runtime-import-in-type-checking-block'
TC005\t'empty-type-checking-block'
TC006\t'runtime-cast-value'
TC007\t'unquoted-type-alias'
TC008\t'quoted-type-alias'
TC010\t'runtime-string-union'
ARG001\t'unused-function-argument'
ARG002\t'unused-method-argument'
ARG003\t'unused-class-method-argument'
ARG004\t'unused-static-method-argument'
ARG005\t'unused-lambda-argument'
PTH100\t'os-path-abspath'
PTH101\t'os-chmod'
PTH102\t'os-mkdir'
PTH103\t'os-makedirs'
PTH104\t'os-rename'
PTH105\t'os-replace'
PTH106\t'os-rmdir'
PTH107\t'os-remove'
PTH108\t'os-unlink'
PTH109\t'os-getcwd'
PTH110\t'os-path-exists'
PTH111\t'os-path-expanduser'
PTH112\t'os-path-isdir'
PTH113\t'os-path-isfile'
PTH114\t'os-path-islink'
PTH115\t'os-readlink'
PTH116\t'os-stat'
PTH117\t'os-path-isabs'
PTH118\t'os-path-join'
PTH119\t'os-path-basename'
PTH120\t'os-path-dirname'
PTH121\t'os-path-samefile'
PTH122\t'os-path-splitext'
PTH123\t'builtin-open'
PTH124\t'py-path'
PTH201\t'path-constructor-current-directory'
PTH202\t'os-path-getsize'
PTH203\t'os-path-getatime'
PTH204\t'os-path-getmtime'
PTH205\t'os-path-getctime'
PTH206\t'os-sep-split'
PTH207\t'glob'
PTH208\t'os-listdir'
PTH210\t'invalid-pathlib-with-suffix'
PTH211\t'os-symlink'
FLY002\t'static-join-to-f-string'
I001\t'unsorted-imports'
I002\t'missing-required-import'
C901\t'complex-structure'
NPY001\t'numpy-deprecated-type-alias'
NPY002\t'numpy-legacy-random'
NPY003\t'numpy-deprecated-function'
NPY201\t'numpy2-deprecation'
N801\t'invalid-class-name'
N802\t'invalid-function-name'
N803\t'invalid-argument-name'
N804\t'invalid-first-argument-name-for-class-method'
N805\t'invalid-first-argument-name-for-method'
N806\t'non-lowercase-variable-in-function'
N807\t'dunder-function-name'
N811\t'constant-imported-as-non-constant'
N812\t'lowercase-imported-as-non-lowercase'
N813\t'camelcase-imported-as-lowercase'
N814\t'camelcase-imported-as-constant'
N815\t'mixed-case-variable-in-class-scope'
N816\t'mixed-case-variable-in-global-scope'
N817\t'camelcase-imported-as-acronym'
N818\t'error-suffix-on-exception-name'
N999\t'invalid-module-name'
PD002\t'pandas-use-of-inplace-argument'
PD003\t'pandas-use-of-dot-is-null'
PD004\t'pandas-use-of-dot-not-null'
PD007\t'pandas-use-of-dot-ix'
PD008\t'pandas-use-of-dot-at'
PD009\t'pandas-use-of-dot-iat'
PD010\t'pandas-use-of-dot-pivot-or-unstack'
PD011\t'pandas-use-of-dot-values'
PD012\t'pandas-use-of-dot-read-table'
PD013\t'pandas-use-of-dot-stack'
PD015\t'pandas-use-of-pd-merge'
PD101\t'pandas-nunique-constant-series-check'
PD901\t'pandas-df-variable-name'
PERF101\t'unnecessary-list-cast'
PERF102\t'incorrect-dict-iterator'
PERF203\t'try-except-in-loop'
PERF401\t'manual-list-comprehension'
PERF402\t'manual-list-copy'
PERF403\t'manual-dict-comprehension'
E101\t'mixed-spaces-and-tabs'
E111\t'indentation-with-invalid-multiple'
E112\t'no-indented-block'
E113\t'unexpected-indentation'
E114\t'indentation-with-invalid-multiple-comment'
E115\t'no-indented-block-comment'
E116\t'unexpected-indentation-comment'
E117\t'over-indented'
E201\t'whitespace-after-open-bracket'
E202\t'whitespace-before-close-bracket'
E203\t'whitespace-before-punctuation'
E204\t'whitespace-after-decorator'
E211\t'whitespace-before-parameters'
E221\t'multiple-spaces-before-operator'
E222\t'multiple-spaces-after-operator'
E223\t'tab-before-operator'
E224\t'tab-after-operator'
E225\t'missing-whitespace-around-operator'
E226\t'missing-whitespace-around-arithmetic-operator'
E227\t'missing-whitespace-around-bitwise-or-shift-operator'
E228\t'missing-whitespace-around-modulo-operator'
E231\t'missing-whitespace'
E241\t'multiple-spaces-after-comma'
E242\t'tab-after-comma'
E251\t'unexpected-spaces-around-keyword-parameter-equals'
E252\t'missing-whitespace-around-parameter-equals'
E261\t'too-few-spaces-before-inline-comment'
E262\t'no-space-after-inline-comment'
E265\t'no-space-after-block-comment'
E266\t'multiple-leading-hashes-for-block-comment'
E271\t'multiple-spaces-after-keyword'
E272\t'multiple-spaces-before-keyword'
E273\t'tab-after-keyword'
E274\t'tab-before-keyword'
E275\t'missing-whitespace-after-keyword'
E301\t'blank-line-between-methods'
E302\t'blank-lines-top-level'
E303\t'too-many-blank-lines'
E304\t'blank-line-after-decorator'
E305\t'blank-lines-after-function-or-class'
E306\t'blank-lines-before-nested-definition'
E401\t'multiple-imports-on-one-line'
E402\t'module-import-not-at-top-of-file'
E501\t'line-too-long'
E502\t'redundant-backslash'
E701\t'multiple-statements-on-one-line-colon'
E702\t'multiple-statements-on-one-line-semicolon'
E703\t'useless-semicolon'
E711\t'none-comparison'
E712\t'true-false-comparison'
E713\t'not-in-test'
E714\t'not-is-test'
E721\t'type-comparison'
E722\t'bare-except'
E731\t'lambda-assignment'
E741\t'ambiguous-variable-name'
E742\t'ambiguous-class-name'
E743\t'ambiguous-function-name'
E902\t'io-error'
E999\t'syntax-error'
W191\t'tab-indentation'
W291\t'trailing-whitespace'
W292\t'missing-newline-at-end-of-file'
W293\t'blank-line-with-whitespace'
W391\t'too-many-newlines-at-end-of-file'
W505\t'doc-line-too-long'
W605\t'invalid-escape-sequence'
DOC102\t'docstring-extraneous-parameter'
DOC201\t'docstring-missing-returns'
DOC202\t'docstring-extraneous-returns'
DOC402\t'docstring-missing-yields'
DOC403\t'docstring-extraneous-yields'
DOC501\t'docstring-missing-exception'
DOC502\t'docstring-extraneous-exception'
D100\t'undocumented-public-module'
D101\t'undocumented-public-class'
D102\t'undocumented-public-method'
D103\t'undocumented-public-function'
D104\t'undocumented-public-package'
D105\t'undocumented-magic-method'
D106\t'undocumented-public-nested-class'
D107\t'undocumented-public-init'
D200\t'unnecessary-multiline-docstring'
D201\t'blank-line-before-function'
D202\t'blank-line-after-function'
D203\t'incorrect-blank-line-before-class'
D204\t'incorrect-blank-line-after-class'
D205\t'missing-blank-line-after-summary'
D206\t'docstring-tab-indentation'
D207\t'under-indentation'
D208\t'over-indentation'
D209\t'new-line-after-last-paragraph'
D210\t'surrounding-whitespace'
D211\t'blank-line-before-class'
D212\t'multi-line-summary-first-line'
D213\t'multi-line-summary-second-line'
D214\t'overindented-section'
D215\t'overindented-section-underline'
D300\t'triple-single-quotes'
D301\t'escape-sequence-in-docstring'
D400\t'missing-trailing-period'
D401\t'non-imperative-mood'
D402\t'signature-in-docstring'
D403\t'first-word-uncapitalized'
D404\t'docstring-starts-with-this'
D405\t'non-capitalized-section-name'
D406\t'missing-new-line-after-section-name'
D407\t'missing-dashed-underline-after-section'
D408\t'missing-section-underline-after-name'
D409\t'mismatched-section-underline-length'
D410\t'no-blank-line-after-section'
D411\t'no-blank-line-before-section'
D412\t'blank-lines-between-header-and-content'
D413\t'missing-blank-line-after-last-section'
D414\t'empty-docstring-section'
D415\t'missing-terminal-punctuation'
D416\t'missing-section-name-colon'
D417\t'undocumented-param'
D418\t'overload-with-docstring'
D419\t'empty-docstring'
F401\t'unused-import'
F402\t'import-shadowed-by-loop-var'
F403\t'undefined-local-with-import-star'
F404\t'late-future-import'
F405\t'undefined-local-with-import-star-usage'
F406\t'undefined-local-with-nested-import-star-usage'
F407\t'future-feature-not-defined'
F501\t'percent-format-invalid-format'
F502\t'percent-format-expected-mapping'
F503\t'percent-format-expected-sequence'
F504\t'percent-format-extra-named-arguments'
F505\t'percent-format-missing-argument'
F506\t'percent-format-mixed-positional-and-named'
F507\t'percent-format-positional-count-mismatch'
F508\t'percent-format-star-requires-sequence'
F509\t'percent-format-unsupported-format-character'
F521\t'string-dot-format-invalid-format'
F522\t'string-dot-format-extra-named-arguments'
F523\t'string-dot-format-extra-positional-arguments'
F524\t'string-dot-format-missing-arguments'
F525\t'string-dot-format-mixing-automatic'
F541\t'f-string-missing-placeholders'
F601\t'multi-value-repeated-key-literal'
F602\t'multi-value-repeated-key-variable'
F621\t'expressions-in-star-assignment'
F622\t'multiple-starred-expressions'
F631\t'assert-tuple'
F632\t'is-literal'
F633\t'invalid-print-syntax'
F634\t'if-tuple'
F701\t'break-outside-loop'
F702\t'continue-outside-loop'
F704\t'yield-outside-function'
F706\t'return-outside-function'
F707\t'default-except-not-last'
F722\t'forward-annotation-syntax-error'
F811\t'redefined-while-unused'
F821\t'undefined-name'
F822\t'undefined-export'
F823\t'undefined-local'
F841\t'unused-variable'
F842\t'unused-annotation'
F901\t'raise-not-implemented'
PGH001\t'eval'
PGH002\t'deprecated-log-warn'
PGH003\t'blanket-type-ignore'
PGH004\t'blanket-noqa'
PGH005\t'invalid-mock-access'
PLC0105\t'type-name-incorrect-variance'
PLC0131\t'type-bivariance'
PLC0132\t'type-param-name-mismatch'
PLC0205\t'single-string-slots'
PLC0206\t'dict-index-missing-items'
PLC0207\t'missing-maxsplit-arg'
PLC0208\t'iteration-over-set'
PLC0414\t'useless-import-alias'
PLC0415\t'import-outside-top-level'
PLC1802\t'len-test'
PLC1901\t'compare-to-empty-string'
PLC2401\t'non-ascii-name'
PLC2403\t'non-ascii-import-name'
PLC2701\t'import-private-name'
PLC2801\t'unnecessary-dunder-call'
PLC3002\t'unnecessary-direct-lambda-call'
PLE0100\t'yield-in-init'
PLE0101\t'return-in-init'
PLE0115\t'nonlocal-and-global'
PLE0116\t'continue-in-finally'
PLE0117\t'nonlocal-without-binding'
PLE0118\t'load-before-global-declaration'
PLE0237\t'non-slot-assignment'
PLE0241\t'duplicate-bases'
PLE0302\t'unexpected-special-method-signature'
PLE0303\t'invalid-length-return-type'
PLE0304\t'invalid-bool-return-type'
PLE0305\t'invalid-index-return-type'
PLE0307\t'invalid-str-return-type'
PLE0308\t'invalid-bytes-return-type'
PLE0309\t'invalid-hash-return-type'
PLE0604\t'invalid-all-object'
PLE0605\t'invalid-all-format'
PLE0643\t'potential-index-error'
PLE0704\t'misplaced-bare-raise'
PLE1132\t'repeated-keyword-argument'
PLE1141\t'dict-iter-missing-items'
PLE1142\t'await-outside-async'
PLE1205\t'logging-too-many-args'
PLE1206\t'logging-too-few-args'
PLE1300\t'bad-string-format-character'
PLE1307\t'bad-string-format-type'
PLE1310\t'bad-str-strip-call'
PLE1507\t'invalid-envvar-value'
PLE1519\t'singledispatch-method'
PLE1520\t'singledispatchmethod-function'
PLE1700\t'yield-from-in-async-function'
PLE2502\t'bidirectional-unicode'
PLE2510\t'invalid-character-backspace'
PLE2512\t'invalid-character-sub'
PLE2513\t'invalid-character-esc'
PLE2514\t'invalid-character-nul'
PLE2515\t'invalid-character-zero-width-space'
PLE4703\t'modified-iterating-set'
PLR0124\t'comparison-with-itself'
PLR0133\t'comparison-of-constant'
PLR0202\t'no-classmethod-decorator'
PLR0203\t'no-staticmethod-decorator'
PLR0206\t'property-with-parameters'
PLR0402\t'manual-from-import'
PLR0904\t'too-many-public-methods'
PLR0911\t'too-many-return-statements'
PLR0912\t'too-many-branches'
PLR0913\t'too-many-arguments'
PLR0914\t'too-many-locals'
PLR0915\t'too-many-statements'
PLR0916\t'too-many-boolean-expressions'
PLR0917\t'too-many-positional-arguments'
PLR1701\t'repeated-isinstance-calls'
PLR1702\t'too-many-nested-blocks'
PLR1704\t'redefined-argument-from-local'
PLR1706\t'and-or-ternary'
PLR1711\t'useless-return'
PLR1714\t'repeated-equality-comparison'
PLR1716\t'boolean-chained-comparison'
PLR1722\t'sys-exit-alias'
PLR1730\t'if-stmt-min-max'
PLR1733\t'unnecessary-dict-index-lookup'
PLR1736\t'unnecessary-list-index-lookup'
PLR2004\t'magic-value-comparison'
PLR2044\t'empty-comment'
PLR5501\t'collapsible-else-if'
PLR6104\t'non-augmented-assignment'
PLR6201\t'literal-membership'
PLR6301\t'no-self-use'
PLW0108\t'unnecessary-lambda'
PLW0120\t'useless-else-on-loop'
PLW0127\t'self-assigning-variable'
PLW0128\t'redeclared-assigned-name'
PLW0129\t'assert-on-string-literal'
PLW0131\t'named-expr-without-context'
PLW0133\t'useless-exception-statement'
PLW0177\t'nan-comparison'
PLW0211\t'bad-staticmethod-argument'
PLW0244\t'redefined-slots-in-subclass'
PLW0245\t'super-without-brackets'
PLW0406\t'import-self'
PLW0602\t'global-variable-not-assigned'
PLW0603\t'global-statement'
PLW0604\t'global-at-module-level'
PLW0642\t'self-or-cls-assignment'
PLW0711\t'binary-op-exception'
PLW1501\t'bad-open-mode'
PLW1507\t'shallow-copy-environ'
PLW1508\t'invalid-envvar-default'
PLW1509\t'subprocess-popen-preexec-fn'
PLW1510\t'subprocess-run-without-check'
PLW1514\t'unspecified-encoding'
PLW1641\t'eq-without-hash'
PLW2101\t'useless-with-lock'
PLW2901\t'redefined-loop-name'
PLW3201\t'bad-dunder-method-name'
PLW3301\t'nested-min-max'
UP001\t'useless-metaclass-type'
UP003\t'type-of-primitive'
UP004\t'useless-object-inheritance'
UP005\t'deprecated-unittest-alias'
UP006\t'non-pep585-annotation'
UP007\t'non-pep604-annotation-union'
UP008\t'super-call-with-parameters'
UP009\t'utf8-encoding-declaration'
UP010\t'unnecessary-future-import'
UP011\t'lru-cache-without-parameters'
UP012\t'unnecessary-encode-utf8'
UP013\t'convert-typed-dict-functional-to-class'
UP014\t'convert-named-tuple-functional-to-class'
UP015\t'redundant-open-modes'
UP017\t'datetime-timezone-utc'
UP018\t'native-literals'
UP019\t'typing-text-str-alias'
UP020\t'open-alias'
UP021\t'replace-universal-newlines'
UP022\t'replace-stdout-stderr'
UP023\t'deprecated-c-element-tree'
UP024\t'os-error-alias'
UP025\t'unicode-kind-prefix'
UP026\t'deprecated-mock-import'
UP027\t'unpacked-list-comprehension'
UP028\t'yield-in-for-loop'
UP029\t'unnecessary-builtin-import'
UP030\t'format-literals'
UP031\t'printf-string-formatting'
UP032\t'f-string'
UP033\t'lru-cache-with-maxsize-none'
UP034\t'extraneous-parentheses'
UP035\t'deprecated-import'
UP036\t'outdated-version-block'
UP037\t'quoted-annotation'
UP038\t'non-pep604-isinstance'
UP039\t'unnecessary-class-parentheses'
UP040\t'non-pep695-type-alias'
UP041\t'timeout-error-alias'
UP042\t'replace-str-enum'
UP043\t'unnecessary-default-type-args'
UP044\t'non-pep646-unpack'
UP045\t'non-pep604-annotation-optional'
UP046\t'non-pep695-generic-class'
UP047\t'non-pep695-generic-function'
UP049\t'private-type-parameter'
UP050\t'useless-class-metaclass-type'
FURB101\t'read-whole-file'
FURB103\t'write-whole-file'
FURB105\t'print-empty-string'
FURB110\t'if-exp-instead-of-or-operator'
FURB113\t'repeated-append'
FURB116\t'f-string-number-format'
FURB118\t'reimplemented-operator'
FURB122\t'for-loop-writes'
FURB129\t'readlines-in-for'
FURB131\t'delete-full-slice'
FURB132\t'check-and-remove-from-set'
FURB136\t'if-expr-min-max'
FURB140\t'reimplemented-starmap'
FURB142\t'for-loop-set-mutations'
FURB145\t'slice-copy'
FURB148\t'unnecessary-enumerate'
FURB152\t'math-constant'
FURB154\t'repeated-global'
FURB156\t'hardcoded-string-charset'
FURB157\t'verbose-decimal-constructor'
FURB161\t'bit-count'
FURB162\t'fromisoformat-replace-z'
FURB163\t'redundant-log-base'
FURB164\t'unnecessary-from-float'
FURB166\t'int-on-sliced-str'
FURB167\t'regex-flag-alias'
FURB168\t'isinstance-type-none'
FURB169\t'type-none-comparison'
FURB171\t'single-item-membership-test'
FURB177\t'implicit-cwd'
FURB180\t'meta-class-abc-meta'
FURB181\t'hashlib-digest-hex'
FURB187\t'list-reverse-copy'
FURB188\t'slice-to-remove-prefix-or-suffix'
FURB189\t'subclass-builtin'
FURB192\t'sorted-min-max'
RUF001\t'ambiguous-unicode-character-string'
RUF002\t'ambiguous-unicode-character-docstring'
RUF003\t'ambiguous-unicode-character-comment'
RUF005\t'collection-literal-concatenation'
RUF006\t'asyncio-dangling-task'
RUF007\t'zip-instead-of-pairwise'
RUF008\t'mutable-dataclass-default'
RUF009\t'function-call-in-dataclass-default-argument'
RUF010\t'explicit-f-string-type-conversion'
RUF011\t'ruff-static-key-dict-comprehension'
RUF012\t'mutable-class-default'
RUF013\t'implicit-optional'
RUF015\t'unnecessary-iterable-allocation-for-first-element'
RUF016\t'invalid-index-type'
RUF017\t'quadratic-list-summation'
RUF018\t'assignment-in-assert'
RUF019\t'unnecessary-key-check'
RUF020\t'never-union'
RUF021\t'parenthesize-chained-operators'
RUF022\t'unsorted-dunder-all'
RUF023\t'unsorted-dunder-slots'
RUF024\t'mutable-fromkeys-value'
RUF026\t'default-factory-kwarg'
RUF027\t'missing-f-string-syntax'
RUF028\t'invalid-formatter-suppression-comment'
RUF029\t'unused-async'
RUF030\t'assert-with-print-message'
RUF031\t'incorrectly-parenthesized-tuple-in-subscript'
RUF032\t'decimal-from-float-literal'
RUF033\t'post-init-default'
RUF034\t'useless-if-else'
RUF035\t'ruff-unsafe-markup-use'
RUF036\t'none-not-at-end-of-union'
RUF037\t'unnecessary-empty-iterable-within-deque-call'
RUF038\t'redundant-bool-literal'
RUF039\t'unraw-re-pattern'
RUF040\t'invalid-assert-message-literal-argument'
RUF041\t'unnecessary-nested-literal'
RUF043\t'pytest-raises-ambiguous-pattern'
RUF045\t'implicit-class-var-in-dataclass'
RUF046\t'unnecessary-cast-to-int'
RUF047\t'needless-else'
RUF048\t'map-int-version-parsing'
RUF049\t'dataclass-enum'
RUF051\t'if-key-in-dict-del'
RUF052\t'used-dummy-variable'
RUF053\t'class-with-mixed-type-vars'
RUF054\t'indented-form-feed'
RUF055\t'unnecessary-regular-expression'
RUF056\t'falsy-dict-get-fallback'
RUF057\t'unnecessary-round'
RUF058\t'starmap-zip'
RUF059\t'unused-unpacked-variable'
RUF060\t'in-empty-collection'
RUF061\t'legacy-form-pytest-raises'
RUF063\t'access-annotations-from-class-dict'
RUF064\t'non-octal-permissions'
RUF065\t'logging-eager-conversion'
RUF100\t'unused-noqa'
RUF101\t'redirected-noqa'
RUF102\t'invalid-rule-code'
RUF200\t'invalid-pyproject-toml'
TRY002\t'raise-vanilla-class'
TRY003\t'raise-vanilla-args'
TRY004\t'type-check-without-type-error'
TRY200\t'reraise-no-cause'
TRY201\t'verbose-raise'
TRY203\t'useless-try-except'
TRY300\t'try-consider-else'
TRY301\t'raise-within-try'
TRY400\t'error-instead-of-exception'
TRY401\t'verbose-log-message'"
complete -c ruff -n "__fish_ruff_using_subcommand check" -l ignore -d 'Comma-separated list of rule codes to disable' -r -f -a "ALL\t'all rules'
AIR\t'Airflow'
ERA\t'eradicate'
FAST\t'FastAPI'
YTT\t'flake8-2020'
ANN\t'flake8-annotations'
ASYNC\t'flake8-async'
S\t'flake8-bandit'
BLE\t'flake8-blind-except'
FBT\t'flake8-boolean-trap'
B\t'flake8-bugbear'
A\t'flake8-builtins'
COM\t'flake8-commas'
C4\t'flake8-comprehensions'
CPY\t'flake8-copyright'
DTZ\t'flake8-datetimez'
T10\t'flake8-debugger'
DJ\t'flake8-django'
EM\t'flake8-errmsg'
EXE\t'flake8-executable'
FIX\t'flake8-fixme'
FA\t'flake8-future-annotations'
INT\t'flake8-gettext'
ISC\t'flake8-implicit-str-concat'
ICN\t'flake8-import-conventions'
LOG\t'flake8-logging'
G\t'flake8-logging-format'
INP\t'flake8-no-pep420'
PIE\t'flake8-pie'
T20\t'flake8-print'
PYI\t'flake8-pyi'
PT\t'flake8-pytest-style'
Q\t'flake8-quotes'
RSE\t'flake8-raise'
RET\t'flake8-return'
SLF\t'flake8-self'
SIM\t'flake8-simplify'
SLOT\t'flake8-slots'
TID\t'flake8-tidy-imports'
TD\t'flake8-todos'
TC\t'flake8-type-checking'
ARG\t'flake8-unused-arguments'
PTH\t'flake8-use-pathlib'
FLY\t'flynt'
I\t'isort'
C90\t'mccabe'
NPY\t'NumPy-specific rules'
PD\t'pandas-vet'
N\t'pep8-naming'
PERF\t'Perflint'
DOC\t'pydoclint'
D\t'pydocstyle'
F\t'Pyflakes'
PGH\t'pygrep-hooks'
PL\t'Pylint'
UP\t'pyupgrade'
FURB\t'refurb'
RUF\t'Ruff-specific rules'
TRY\t'tryceratops'
AIR001\t'airflow-variable-name-task-id-mismatch'
AIR002\t'airflow-dag-no-schedule-argument'
AIR301\t'airflow3-removal'
AIR302\t'airflow3-moved-to-provider'
AIR311\t'airflow3-suggested-update'
AIR312\t'airflow3-suggested-to-move-to-provider'
ERA001\t'commented-out-code'
FAST001\t'fast-api-redundant-response-model'
FAST002\t'fast-api-non-annotated-dependency'
FAST003\t'fast-api-unused-path-parameter'
YTT101\t'sys-version-slice3'
YTT102\t'sys-version2'
YTT103\t'sys-version-cmp-str3'
YTT201\t'sys-version-info0-eq3'
YTT202\t'six-py3'
YTT203\t'sys-version-info1-cmp-int'
YTT204\t'sys-version-info-minor-cmp-int'
YTT301\t'sys-version0'
YTT302\t'sys-version-cmp-str10'
YTT303\t'sys-version-slice1'
ANN001\t'missing-type-function-argument'
ANN002\t'missing-type-args'
ANN003\t'missing-type-kwargs'
ANN101\t'missing-type-self'
ANN102\t'missing-type-cls'
ANN201\t'missing-return-type-undocumented-public-function'
ANN202\t'missing-return-type-private-function'
ANN204\t'missing-return-type-special-method'
ANN205\t'missing-return-type-static-method'
ANN206\t'missing-return-type-class-method'
ANN401\t'any-type'
ASYNC100\t'cancel-scope-no-checkpoint'
ASYNC105\t'trio-sync-call'
ASYNC109\t'async-function-with-timeout'
ASYNC110\t'async-busy-wait'
ASYNC115\t'async-zero-sleep'
ASYNC116\t'long-sleep-not-forever'
ASYNC210\t'blocking-http-call-in-async-function'
ASYNC212\t'blocking-http-call-httpx-in-async-function'
ASYNC220\t'create-subprocess-in-async-function'
ASYNC221\t'run-process-in-async-function'
ASYNC222\t'wait-for-process-in-async-function'
ASYNC230\t'blocking-open-call-in-async-function'
ASYNC240\t'blocking-path-method-in-async-function'
ASYNC250\t'blocking-input-in-async-function'
ASYNC251\t'blocking-sleep-in-async-function'
S101\t'assert'
S102\t'exec-builtin'
S103\t'bad-file-permissions'
S104\t'hardcoded-bind-all-interfaces'
S105\t'hardcoded-password-string'
S106\t'hardcoded-password-func-arg'
S107\t'hardcoded-password-default'
S108\t'hardcoded-temp-file'
S110\t'try-except-pass'
S112\t'try-except-continue'
S113\t'request-without-timeout'
S201\t'flask-debug-true'
S202\t'tarfile-unsafe-members'
S301\t'suspicious-pickle-usage'
S302\t'suspicious-marshal-usage'
S303\t'suspicious-insecure-hash-usage'
S304\t'suspicious-insecure-cipher-usage'
S305\t'suspicious-insecure-cipher-mode-usage'
S306\t'suspicious-mktemp-usage'
S307\t'suspicious-eval-usage'
S308\t'suspicious-mark-safe-usage'
S310\t'suspicious-url-open-usage'
S311\t'suspicious-non-cryptographic-random-usage'
S312\t'suspicious-telnet-usage'
S313\t'suspicious-xmlc-element-tree-usage'
S314\t'suspicious-xml-element-tree-usage'
S315\t'suspicious-xml-expat-reader-usage'
S316\t'suspicious-xml-expat-builder-usage'
S317\t'suspicious-xml-sax-usage'
S318\t'suspicious-xml-mini-dom-usage'
S319\t'suspicious-xml-pull-dom-usage'
S320\t'suspicious-xmle-tree-usage'
S321\t'suspicious-ftp-lib-usage'
S323\t'suspicious-unverified-context-usage'
S324\t'hashlib-insecure-hash-function'
S401\t'suspicious-telnetlib-import'
S402\t'suspicious-ftplib-import'
S403\t'suspicious-pickle-import'
S404\t'suspicious-subprocess-import'
S405\t'suspicious-xml-etree-import'
S406\t'suspicious-xml-sax-import'
S407\t'suspicious-xml-expat-import'
S408\t'suspicious-xml-minidom-import'
S409\t'suspicious-xml-pulldom-import'
S410\t'suspicious-lxml-import'
S411\t'suspicious-xmlrpc-import'
S412\t'suspicious-httpoxy-import'
S413\t'suspicious-pycrypto-import'
S415\t'suspicious-pyghmi-import'
S501\t'request-with-no-cert-validation'
S502\t'ssl-insecure-version'
S503\t'ssl-with-bad-defaults'
S504\t'ssl-with-no-version'
S505\t'weak-cryptographic-key'
S506\t'unsafe-yaml-load'
S507\t'ssh-no-host-key-verification'
S508\t'snmp-insecure-version'
S509\t'snmp-weak-cryptography'
S601\t'paramiko-call'
S602\t'subprocess-popen-with-shell-equals-true'
S603\t'subprocess-without-shell-equals-true'
S604\t'call-with-shell-equals-true'
S605\t'start-process-with-a-shell'
S606\t'start-process-with-no-shell'
S607\t'start-process-with-partial-path'
S608\t'hardcoded-sql-expression'
S609\t'unix-command-wildcard-injection'
S610\t'django-extra'
S611\t'django-raw-sql'
S612\t'logging-config-insecure-listen'
S701\t'jinja2-autoescape-false'
S702\t'mako-templates'
S704\t'unsafe-markup-use'
BLE001\t'blind-except'
FBT001\t'boolean-type-hint-positional-argument'
FBT002\t'boolean-default-value-positional-argument'
FBT003\t'boolean-positional-value-in-call'
B002\t'unary-prefix-increment-decrement'
B003\t'assignment-to-os-environ'
B004\t'unreliable-callable-check'
B005\t'strip-with-multi-characters'
B006\t'mutable-argument-default'
B007\t'unused-loop-control-variable'
B008\t'function-call-in-default-argument'
B009\t'get-attr-with-constant'
B010\t'set-attr-with-constant'
B011\t'assert-false'
B012\t'jump-statement-in-finally'
B013\t'redundant-tuple-in-exception-handler'
B014\t'duplicate-handler-exception'
B015\t'useless-comparison'
B016\t'raise-literal'
B017\t'assert-raises-exception'
B018\t'useless-expression'
B019\t'cached-instance-method'
B020\t'loop-variable-overrides-iterator'
B021\t'f-string-docstring'
B022\t'useless-contextlib-suppress'
B023\t'function-uses-loop-variable'
B024\t'abstract-base-class-without-abstract-method'
B025\t'duplicate-try-block-exception'
B026\t'star-arg-unpacking-after-keyword-arg'
B027\t'empty-method-without-abstract-decorator'
B028\t'no-explicit-stacklevel'
B029\t'except-with-empty-tuple'
B030\t'except-with-non-exception-classes'
B031\t'reuse-of-groupby-generator'
B032\t'unintentional-type-annotation'
B033\t'duplicate-value'
B034\t're-sub-positional-args'
B035\t'static-key-dict-comprehension'
B039\t'mutable-contextvar-default'
B901\t'return-in-generator'
B903\t'class-as-data-structure'
B904\t'raise-without-from-inside-except'
B905\t'zip-without-explicit-strict'
B909\t'loop-iterator-mutation'
B911\t'batched-without-explicit-strict'
B912\t'map-without-explicit-strict'
A001\t'builtin-variable-shadowing'
A002\t'builtin-argument-shadowing'
A003\t'builtin-attribute-shadowing'
A004\t'builtin-import-shadowing'
A005\t'stdlib-module-shadowing'
A006\t'builtin-lambda-argument-shadowing'
COM812\t'missing-trailing-comma'
COM818\t'trailing-comma-on-bare-tuple'
COM819\t'prohibited-trailing-comma'
C400\t'unnecessary-generator-list'
C401\t'unnecessary-generator-set'
C402\t'unnecessary-generator-dict'
C403\t'unnecessary-list-comprehension-set'
C404\t'unnecessary-list-comprehension-dict'
C405\t'unnecessary-literal-set'
C406\t'unnecessary-literal-dict'
C408\t'unnecessary-collection-call'
C409\t'unnecessary-literal-within-tuple-call'
C410\t'unnecessary-literal-within-list-call'
C411\t'unnecessary-list-call'
C413\t'unnecessary-call-around-sorted'
C414\t'unnecessary-double-cast-or-process'
C415\t'unnecessary-subscript-reversal'
C416\t'unnecessary-comprehension'
C417\t'unnecessary-map'
C418\t'unnecessary-literal-within-dict-call'
C419\t'unnecessary-comprehension-in-call'
C420\t'unnecessary-dict-comprehension-for-iterable'
CPY001\t'missing-copyright-notice'
DTZ001\t'call-datetime-without-tzinfo'
DTZ002\t'call-datetime-today'
DTZ003\t'call-datetime-utcnow'
DTZ004\t'call-datetime-utcfromtimestamp'
DTZ005\t'call-datetime-now-without-tzinfo'
DTZ006\t'call-datetime-fromtimestamp'
DTZ007\t'call-datetime-strptime-without-zone'
DTZ011\t'call-date-today'
DTZ012\t'call-date-fromtimestamp'
DTZ901\t'datetime-min-max'
T100\t'debugger'
DJ001\t'django-nullable-model-string-field'
DJ003\t'django-locals-in-render-function'
DJ006\t'django-exclude-with-model-form'
DJ007\t'django-all-with-model-form'
DJ008\t'django-model-without-dunder-str'
DJ012\t'django-unordered-body-content-in-model'
DJ013\t'django-non-leading-receiver-decorator'
EM101\t'raw-string-in-exception'
EM102\t'f-string-in-exception'
EM103\t'dot-format-in-exception'
EXE001\t'shebang-not-executable'
EXE002\t'shebang-missing-executable-file'
EXE003\t'shebang-missing-python'
EXE004\t'shebang-leading-whitespace'
EXE005\t'shebang-not-first-line'
FIX001\t'line-contains-fixme'
FIX002\t'line-contains-todo'
FIX003\t'line-contains-xxx'
FIX004\t'line-contains-hack'
FA100\t'future-rewritable-type-annotation'
FA102\t'future-required-type-annotation'
INT001\t'f-string-in-get-text-func-call'
INT002\t'format-in-get-text-func-call'
INT003\t'printf-in-get-text-func-call'
ISC001\t'single-line-implicit-string-concatenation'
ISC002\t'multi-line-implicit-string-concatenation'
ISC003\t'explicit-string-concatenation'
ICN001\t'unconventional-import-alias'
ICN002\t'banned-import-alias'
ICN003\t'banned-import-from'
LOG001\t'direct-logger-instantiation'
LOG002\t'invalid-get-logger-argument'
LOG004\t'log-exception-outside-except-handler'
LOG007\t'exception-without-exc-info'
LOG009\t'undocumented-warn'
LOG014\t'exc-info-outside-except-handler'
LOG015\t'root-logger-call'
G001\t'logging-string-format'
G002\t'logging-percent-format'
G003\t'logging-string-concat'
G004\t'logging-f-string'
G010\t'logging-warn'
G101\t'logging-extra-attr-clash'
G201\t'logging-exc-info'
G202\t'logging-redundant-exc-info'
INP001\t'implicit-namespace-package'
PIE790\t'unnecessary-placeholder'
PIE794\t'duplicate-class-field-definition'
PIE796\t'non-unique-enums'
PIE800\t'unnecessary-spread'
PIE804\t'unnecessary-dict-kwargs'
PIE807\t'reimplemented-container-builtin'
PIE808\t'unnecessary-range-start'
PIE810\t'multiple-starts-ends-with'
T201\t'print'
T203\t'p-print'
PYI001\t'unprefixed-type-param'
PYI002\t'complex-if-statement-in-stub'
PYI003\t'unrecognized-version-info-check'
PYI004\t'patch-version-comparison'
PYI005\t'wrong-tuple-length-version-comparison'
PYI006\t'bad-version-info-comparison'
PYI007\t'unrecognized-platform-check'
PYI008\t'unrecognized-platform-name'
PYI009\t'pass-statement-stub-body'
PYI010\t'non-empty-stub-body'
PYI011\t'typed-argument-default-in-stub'
PYI012\t'pass-in-class-body'
PYI013\t'ellipsis-in-non-empty-class-body'
PYI014\t'argument-default-in-stub'
PYI015\t'assignment-default-in-stub'
PYI016\t'duplicate-union-member'
PYI017\t'complex-assignment-in-stub'
PYI018\t'unused-private-type-var'
PYI019\t'custom-type-var-for-self'
PYI020\t'quoted-annotation-in-stub'
PYI021\t'docstring-in-stub'
PYI024\t'collections-named-tuple'
PYI025\t'unaliased-collections-abc-set-import'
PYI026\t'type-alias-without-annotation'
PYI029\t'str-or-repr-defined-in-stub'
PYI030\t'unnecessary-literal-union'
PYI032\t'any-eq-ne-annotation'
PYI033\t'type-comment-in-stub'
PYI034\t'non-self-return-type'
PYI035\t'unassigned-special-variable-in-stub'
PYI036\t'bad-exit-annotation'
PYI041\t'redundant-numeric-union'
PYI042\t'snake-case-type-alias'
PYI043\t't-suffixed-type-alias'
PYI044\t'future-annotations-in-stub'
PYI045\t'iter-method-return-iterable'
PYI046\t'unused-private-protocol'
PYI047\t'unused-private-type-alias'
PYI048\t'stub-body-multiple-statements'
PYI049\t'unused-private-typed-dict'
PYI050\t'no-return-argument-annotation-in-stub'
PYI051\t'redundant-literal-union'
PYI052\t'unannotated-assignment-in-stub'
PYI053\t'string-or-bytes-too-long'
PYI054\t'numeric-literal-too-long'
PYI055\t'unnecessary-type-union'
PYI056\t'unsupported-method-call-on-all'
PYI057\t'byte-string-usage'
PYI058\t'generator-return-from-iter-method'
PYI059\t'generic-not-last-base-class'
PYI061\t'redundant-none-literal'
PYI062\t'duplicate-literal-member'
PYI063\t'pep484-style-positional-only-parameter'
PYI064\t'redundant-final-literal'
PYI066\t'bad-version-info-order'
PT001\t'pytest-fixture-incorrect-parentheses-style'
PT002\t'pytest-fixture-positional-args'
PT003\t'pytest-extraneous-scope-function'
PT004\t'pytest-missing-fixture-name-underscore'
PT005\t'pytest-incorrect-fixture-name-underscore'
PT006\t'pytest-parametrize-names-wrong-type'
PT007\t'pytest-parametrize-values-wrong-type'
PT008\t'pytest-patch-with-lambda'
PT009\t'pytest-unittest-assertion'
PT010\t'pytest-raises-without-exception'
PT011\t'pytest-raises-too-broad'
PT012\t'pytest-raises-with-multiple-statements'
PT013\t'pytest-incorrect-pytest-import'
PT014\t'pytest-duplicate-parametrize-test-cases'
PT015\t'pytest-assert-always-false'
PT016\t'pytest-fail-without-message'
PT017\t'pytest-assert-in-except'
PT018\t'pytest-composite-assertion'
PT019\t'pytest-fixture-param-without-value'
PT020\t'pytest-deprecated-yield-fixture'
PT021\t'pytest-fixture-finalizer-callback'
PT022\t'pytest-useless-yield-fixture'
PT023\t'pytest-incorrect-mark-parentheses-style'
PT024\t'pytest-unnecessary-asyncio-mark-on-fixture'
PT025\t'pytest-erroneous-use-fixtures-on-fixture'
PT026\t'pytest-use-fixtures-without-parameters'
PT027\t'pytest-unittest-raises-assertion'
PT028\t'pytest-parameter-with-default-argument'
PT029\t'pytest-warns-without-warning'
PT030\t'pytest-warns-too-broad'
PT031\t'pytest-warns-with-multiple-statements'
Q000\t'bad-quotes-inline-string'
Q001\t'bad-quotes-multiline-string'
Q002\t'bad-quotes-docstring'
Q003\t'avoidable-escaped-quote'
Q004\t'unnecessary-escaped-quote'
RSE102\t'unnecessary-paren-on-raise-exception'
RET501\t'unnecessary-return-none'
RET502\t'implicit-return-value'
RET503\t'implicit-return'
RET504\t'unnecessary-assign'
RET505\t'superfluous-else-return'
RET506\t'superfluous-else-raise'
RET507\t'superfluous-else-continue'
RET508\t'superfluous-else-break'
SLF001\t'private-member-access'
SIM101\t'duplicate-isinstance-call'
SIM102\t'collapsible-if'
SIM103\t'needless-bool'
SIM105\t'suppressible-exception'
SIM107\t'return-in-try-except-finally'
SIM108\t'if-else-block-instead-of-if-exp'
SIM109\t'compare-with-tuple'
SIM110\t'reimplemented-builtin'
SIM112\t'uncapitalized-environment-variables'
SIM113\t'enumerate-for-loop'
SIM114\t'if-with-same-arms'
SIM115\t'open-file-with-context-handler'
SIM116\t'if-else-block-instead-of-dict-lookup'
SIM117\t'multiple-with-statements'
SIM118\t'in-dict-keys'
SIM201\t'negate-equal-op'
SIM202\t'negate-not-equal-op'
SIM208\t'double-negation'
SIM210\t'if-expr-with-true-false'
SIM211\t'if-expr-with-false-true'
SIM212\t'if-expr-with-twisted-arms'
SIM220\t'expr-and-not-expr'
SIM221\t'expr-or-not-expr'
SIM222\t'expr-or-true'
SIM223\t'expr-and-false'
SIM300\t'yoda-conditions'
SIM401\t'if-else-block-instead-of-dict-get'
SIM905\t'split-static-string'
SIM910\t'dict-get-with-none-default'
SIM911\t'zip-dict-keys-and-values'
SLOT000\t'no-slots-in-str-subclass'
SLOT001\t'no-slots-in-tuple-subclass'
SLOT002\t'no-slots-in-namedtuple-subclass'
TID251\t'banned-api'
TID252\t'relative-imports'
TID253\t'banned-module-level-imports'
TD001\t'invalid-todo-tag'
TD002\t'missing-todo-author'
TD003\t'missing-todo-link'
TD004\t'missing-todo-colon'
TD005\t'missing-todo-description'
TD006\t'invalid-todo-capitalization'
TD007\t'missing-space-after-todo-colon'
TC001\t'typing-only-first-party-import'
TC002\t'typing-only-third-party-import'
TC003\t'typing-only-standard-library-import'
TC004\t'runtime-import-in-type-checking-block'
TC005\t'empty-type-checking-block'
TC006\t'runtime-cast-value'
TC007\t'unquoted-type-alias'
TC008\t'quoted-type-alias'
TC010\t'runtime-string-union'
ARG001\t'unused-function-argument'
ARG002\t'unused-method-argument'
ARG003\t'unused-class-method-argument'
ARG004\t'unused-static-method-argument'
ARG005\t'unused-lambda-argument'
PTH100\t'os-path-abspath'
PTH101\t'os-chmod'
PTH102\t'os-mkdir'
PTH103\t'os-makedirs'
PTH104\t'os-rename'
PTH105\t'os-replace'
PTH106\t'os-rmdir'
PTH107\t'os-remove'
PTH108\t'os-unlink'
PTH109\t'os-getcwd'
PTH110\t'os-path-exists'
PTH111\t'os-path-expanduser'
PTH112\t'os-path-isdir'
PTH113\t'os-path-isfile'
PTH114\t'os-path-islink'
PTH115\t'os-readlink'
PTH116\t'os-stat'
PTH117\t'os-path-isabs'
PTH118\t'os-path-join'
PTH119\t'os-path-basename'
PTH120\t'os-path-dirname'
PTH121\t'os-path-samefile'
PTH122\t'os-path-splitext'
PTH123\t'builtin-open'
PTH124\t'py-path'
PTH201\t'path-constructor-current-directory'
PTH202\t'os-path-getsize'
PTH203\t'os-path-getatime'
PTH204\t'os-path-getmtime'
PTH205\t'os-path-getctime'
PTH206\t'os-sep-split'
PTH207\t'glob'
PTH208\t'os-listdir'
PTH210\t'invalid-pathlib-with-suffix'
PTH211\t'os-symlink'
FLY002\t'static-join-to-f-string'
I001\t'unsorted-imports'
I002\t'missing-required-import'
C901\t'complex-structure'
NPY001\t'numpy-deprecated-type-alias'
NPY002\t'numpy-legacy-random'
NPY003\t'numpy-deprecated-function'
NPY201\t'numpy2-deprecation'
N801\t'invalid-class-name'
N802\t'invalid-function-name'
N803\t'invalid-argument-name'
N804\t'invalid-first-argument-name-for-class-method'
N805\t'invalid-first-argument-name-for-method'
N806\t'non-lowercase-variable-in-function'
N807\t'dunder-function-name'
N811\t'constant-imported-as-non-constant'
N812\t'lowercase-imported-as-non-lowercase'
N813\t'camelcase-imported-as-lowercase'
N814\t'camelcase-imported-as-constant'
N815\t'mixed-case-variable-in-class-scope'
N816\t'mixed-case-variable-in-global-scope'
N817\t'camelcase-imported-as-acronym'
N818\t'error-suffix-on-exception-name'
N999\t'invalid-module-name'
PD002\t'pandas-use-of-inplace-argument'
PD003\t'pandas-use-of-dot-is-null'
PD004\t'pandas-use-of-dot-not-null'
PD007\t'pandas-use-of-dot-ix'
PD008\t'pandas-use-of-dot-at'
PD009\t'pandas-use-of-dot-iat'
PD010\t'pandas-use-of-dot-pivot-or-unstack'
PD011\t'pandas-use-of-dot-values'
PD012\t'pandas-use-of-dot-read-table'
PD013\t'pandas-use-of-dot-stack'
PD015\t'pandas-use-of-pd-merge'
PD101\t'pandas-nunique-constant-series-check'
PD901\t'pandas-df-variable-name'
PERF101\t'unnecessary-list-cast'
PERF102\t'incorrect-dict-iterator'
PERF203\t'try-except-in-loop'
PERF401\t'manual-list-comprehension'
PERF402\t'manual-list-copy'
PERF403\t'manual-dict-comprehension'
E101\t'mixed-spaces-and-tabs'
E111\t'indentation-with-invalid-multiple'
E112\t'no-indented-block'
E113\t'unexpected-indentation'
E114\t'indentation-with-invalid-multiple-comment'
E115\t'no-indented-block-comment'
E116\t'unexpected-indentation-comment'
E117\t'over-indented'
E201\t'whitespace-after-open-bracket'
E202\t'whitespace-before-close-bracket'
E203\t'whitespace-before-punctuation'
E204\t'whitespace-after-decorator'
E211\t'whitespace-before-parameters'
E221\t'multiple-spaces-before-operator'
E222\t'multiple-spaces-after-operator'
E223\t'tab-before-operator'
E224\t'tab-after-operator'
E225\t'missing-whitespace-around-operator'
E226\t'missing-whitespace-around-arithmetic-operator'
E227\t'missing-whitespace-around-bitwise-or-shift-operator'
E228\t'missing-whitespace-around-modulo-operator'
E231\t'missing-whitespace'
E241\t'multiple-spaces-after-comma'
E242\t'tab-after-comma'
E251\t'unexpected-spaces-around-keyword-parameter-equals'
E252\t'missing-whitespace-around-parameter-equals'
E261\t'too-few-spaces-before-inline-comment'
E262\t'no-space-after-inline-comment'
E265\t'no-space-after-block-comment'
E266\t'multiple-leading-hashes-for-block-comment'
E271\t'multiple-spaces-after-keyword'
E272\t'multiple-spaces-before-keyword'
E273\t'tab-after-keyword'
E274\t'tab-before-keyword'
E275\t'missing-whitespace-after-keyword'
E301\t'blank-line-between-methods'
E302\t'blank-lines-top-level'
E303\t'too-many-blank-lines'
E304\t'blank-line-after-decorator'
E305\t'blank-lines-after-function-or-class'
E306\t'blank-lines-before-nested-definition'
E401\t'multiple-imports-on-one-line'
E402\t'module-import-not-at-top-of-file'
E501\t'line-too-long'
E502\t'redundant-backslash'
E701\t'multiple-statements-on-one-line-colon'
E702\t'multiple-statements-on-one-line-semicolon'
E703\t'useless-semicolon'
E711\t'none-comparison'
E712\t'true-false-comparison'
E713\t'not-in-test'
E714\t'not-is-test'
E721\t'type-comparison'
E722\t'bare-except'
E731\t'lambda-assignment'
E741\t'ambiguous-variable-name'
E742\t'ambiguous-class-name'
E743\t'ambiguous-function-name'
E902\t'io-error'
E999\t'syntax-error'
W191\t'tab-indentation'
W291\t'trailing-whitespace'
W292\t'missing-newline-at-end-of-file'
W293\t'blank-line-with-whitespace'
W391\t'too-many-newlines-at-end-of-file'
W505\t'doc-line-too-long'
W605\t'invalid-escape-sequence'
DOC102\t'docstring-extraneous-parameter'
DOC201\t'docstring-missing-returns'
DOC202\t'docstring-extraneous-returns'
DOC402\t'docstring-missing-yields'
DOC403\t'docstring-extraneous-yields'
DOC501\t'docstring-missing-exception'
DOC502\t'docstring-extraneous-exception'
D100\t'undocumented-public-module'
D101\t'undocumented-public-class'
D102\t'undocumented-public-method'
D103\t'undocumented-public-function'
D104\t'undocumented-public-package'
D105\t'undocumented-magic-method'
D106\t'undocumented-public-nested-class'
D107\t'undocumented-public-init'
D200\t'unnecessary-multiline-docstring'
D201\t'blank-line-before-function'
D202\t'blank-line-after-function'
D203\t'incorrect-blank-line-before-class'
D204\t'incorrect-blank-line-after-class'
D205\t'missing-blank-line-after-summary'
D206\t'docstring-tab-indentation'
D207\t'under-indentation'
D208\t'over-indentation'
D209\t'new-line-after-last-paragraph'
D210\t'surrounding-whitespace'
D211\t'blank-line-before-class'
D212\t'multi-line-summary-first-line'
D213\t'multi-line-summary-second-line'
D214\t'overindented-section'
D215\t'overindented-section-underline'
D300\t'triple-single-quotes'
D301\t'escape-sequence-in-docstring'
D400\t'missing-trailing-period'
D401\t'non-imperative-mood'
D402\t'signature-in-docstring'
D403\t'first-word-uncapitalized'
D404\t'docstring-starts-with-this'
D405\t'non-capitalized-section-name'
D406\t'missing-new-line-after-section-name'
D407\t'missing-dashed-underline-after-section'
D408\t'missing-section-underline-after-name'
D409\t'mismatched-section-underline-length'
D410\t'no-blank-line-after-section'
D411\t'no-blank-line-before-section'
D412\t'blank-lines-between-header-and-content'
D413\t'missing-blank-line-after-last-section'
D414\t'empty-docstring-section'
D415\t'missing-terminal-punctuation'
D416\t'missing-section-name-colon'
D417\t'undocumented-param'
D418\t'overload-with-docstring'
D419\t'empty-docstring'
F401\t'unused-import'
F402\t'import-shadowed-by-loop-var'
F403\t'undefined-local-with-import-star'
F404\t'late-future-import'
F405\t'undefined-local-with-import-star-usage'
F406\t'undefined-local-with-nested-import-star-usage'
F407\t'future-feature-not-defined'
F501\t'percent-format-invalid-format'
F502\t'percent-format-expected-mapping'
F503\t'percent-format-expected-sequence'
F504\t'percent-format-extra-named-arguments'
F505\t'percent-format-missing-argument'
F506\t'percent-format-mixed-positional-and-named'
F507\t'percent-format-positional-count-mismatch'
F508\t'percent-format-star-requires-sequence'
F509\t'percent-format-unsupported-format-character'
F521\t'string-dot-format-invalid-format'
F522\t'string-dot-format-extra-named-arguments'
F523\t'string-dot-format-extra-positional-arguments'
F524\t'string-dot-format-missing-arguments'
F525\t'string-dot-format-mixing-automatic'
F541\t'f-string-missing-placeholders'
F601\t'multi-value-repeated-key-literal'
F602\t'multi-value-repeated-key-variable'
F621\t'expressions-in-star-assignment'
F622\t'multiple-starred-expressions'
F631\t'assert-tuple'
F632\t'is-literal'
F633\t'invalid-print-syntax'
F634\t'if-tuple'
F701\t'break-outside-loop'
F702\t'continue-outside-loop'
F704\t'yield-outside-function'
F706\t'return-outside-function'
F707\t'default-except-not-last'
F722\t'forward-annotation-syntax-error'
F811\t'redefined-while-unused'
F821\t'undefined-name'
F822\t'undefined-export'
F823\t'undefined-local'
F841\t'unused-variable'
F842\t'unused-annotation'
F901\t'raise-not-implemented'
PGH001\t'eval'
PGH002\t'deprecated-log-warn'
PGH003\t'blanket-type-ignore'
PGH004\t'blanket-noqa'
PGH005\t'invalid-mock-access'
PLC0105\t'type-name-incorrect-variance'
PLC0131\t'type-bivariance'
PLC0132\t'type-param-name-mismatch'
PLC0205\t'single-string-slots'
PLC0206\t'dict-index-missing-items'
PLC0207\t'missing-maxsplit-arg'
PLC0208\t'iteration-over-set'
PLC0414\t'useless-import-alias'
PLC0415\t'import-outside-top-level'
PLC1802\t'len-test'
PLC1901\t'compare-to-empty-string'
PLC2401\t'non-ascii-name'
PLC2403\t'non-ascii-import-name'
PLC2701\t'import-private-name'
PLC2801\t'unnecessary-dunder-call'
PLC3002\t'unnecessary-direct-lambda-call'
PLE0100\t'yield-in-init'
PLE0101\t'return-in-init'
PLE0115\t'nonlocal-and-global'
PLE0116\t'continue-in-finally'
PLE0117\t'nonlocal-without-binding'
PLE0118\t'load-before-global-declaration'
PLE0237\t'non-slot-assignment'
PLE0241\t'duplicate-bases'
PLE0302\t'unexpected-special-method-signature'
PLE0303\t'invalid-length-return-type'
PLE0304\t'invalid-bool-return-type'
PLE0305\t'invalid-index-return-type'
PLE0307\t'invalid-str-return-type'
PLE0308\t'invalid-bytes-return-type'
PLE0309\t'invalid-hash-return-type'
PLE0604\t'invalid-all-object'
PLE0605\t'invalid-all-format'
PLE0643\t'potential-index-error'
PLE0704\t'misplaced-bare-raise'
PLE1132\t'repeated-keyword-argument'
PLE1141\t'dict-iter-missing-items'
PLE1142\t'await-outside-async'
PLE1205\t'logging-too-many-args'
PLE1206\t'logging-too-few-args'
PLE1300\t'bad-string-format-character'
PLE1307\t'bad-string-format-type'
PLE1310\t'bad-str-strip-call'
PLE1507\t'invalid-envvar-value'
PLE1519\t'singledispatch-method'
PLE1520\t'singledispatchmethod-function'
PLE1700\t'yield-from-in-async-function'
PLE2502\t'bidirectional-unicode'
PLE2510\t'invalid-character-backspace'
PLE2512\t'invalid-character-sub'
PLE2513\t'invalid-character-esc'
PLE2514\t'invalid-character-nul'
PLE2515\t'invalid-character-zero-width-space'
PLE4703\t'modified-iterating-set'
PLR0124\t'comparison-with-itself'
PLR0133\t'comparison-of-constant'
PLR0202\t'no-classmethod-decorator'
PLR0203\t'no-staticmethod-decorator'
PLR0206\t'property-with-parameters'
PLR0402\t'manual-from-import'
PLR0904\t'too-many-public-methods'
PLR0911\t'too-many-return-statements'
PLR0912\t'too-many-branches'
PLR0913\t'too-many-arguments'
PLR0914\t'too-many-locals'
PLR0915\t'too-many-statements'
PLR0916\t'too-many-boolean-expressions'
PLR0917\t'too-many-positional-arguments'
PLR1701\t'repeated-isinstance-calls'
PLR1702\t'too-many-nested-blocks'
PLR1704\t'redefined-argument-from-local'
PLR1706\t'and-or-ternary'
PLR1711\t'useless-return'
PLR1714\t'repeated-equality-comparison'
PLR1716\t'boolean-chained-comparison'
PLR1722\t'sys-exit-alias'
PLR1730\t'if-stmt-min-max'
PLR1733\t'unnecessary-dict-index-lookup'
PLR1736\t'unnecessary-list-index-lookup'
PLR2004\t'magic-value-comparison'
PLR2044\t'empty-comment'
PLR5501\t'collapsible-else-if'
PLR6104\t'non-augmented-assignment'
PLR6201\t'literal-membership'
PLR6301\t'no-self-use'
PLW0108\t'unnecessary-lambda'
PLW0120\t'useless-else-on-loop'
PLW0127\t'self-assigning-variable'
PLW0128\t'redeclared-assigned-name'
PLW0129\t'assert-on-string-literal'
PLW0131\t'named-expr-without-context'
PLW0133\t'useless-exception-statement'
PLW0177\t'nan-comparison'
PLW0211\t'bad-staticmethod-argument'
PLW0244\t'redefined-slots-in-subclass'
PLW0245\t'super-without-brackets'
PLW0406\t'import-self'
PLW0602\t'global-variable-not-assigned'
PLW0603\t'global-statement'
PLW0604\t'global-at-module-level'
PLW0642\t'self-or-cls-assignment'
PLW0711\t'binary-op-exception'
PLW1501\t'bad-open-mode'
PLW1507\t'shallow-copy-environ'
PLW1508\t'invalid-envvar-default'
PLW1509\t'subprocess-popen-preexec-fn'
PLW1510\t'subprocess-run-without-check'
PLW1514\t'unspecified-encoding'
PLW1641\t'eq-without-hash'
PLW2101\t'useless-with-lock'
PLW2901\t'redefined-loop-name'
PLW3201\t'bad-dunder-method-name'
PLW3301\t'nested-min-max'
UP001\t'useless-metaclass-type'
UP003\t'type-of-primitive'
UP004\t'useless-object-inheritance'
UP005\t'deprecated-unittest-alias'
UP006\t'non-pep585-annotation'
UP007\t'non-pep604-annotation-union'
UP008\t'super-call-with-parameters'
UP009\t'utf8-encoding-declaration'
UP010\t'unnecessary-future-import'
UP011\t'lru-cache-without-parameters'
UP012\t'unnecessary-encode-utf8'
UP013\t'convert-typed-dict-functional-to-class'
UP014\t'convert-named-tuple-functional-to-class'
UP015\t'redundant-open-modes'
UP017\t'datetime-timezone-utc'
UP018\t'native-literals'
UP019\t'typing-text-str-alias'
UP020\t'open-alias'
UP021\t'replace-universal-newlines'
UP022\t'replace-stdout-stderr'
UP023\t'deprecated-c-element-tree'
UP024\t'os-error-alias'
UP025\t'unicode-kind-prefix'
UP026\t'deprecated-mock-import'
UP027\t'unpacked-list-comprehension'
UP028\t'yield-in-for-loop'
UP029\t'unnecessary-builtin-import'
UP030\t'format-literals'
UP031\t'printf-string-formatting'
UP032\t'f-string'
UP033\t'lru-cache-with-maxsize-none'
UP034\t'extraneous-parentheses'
UP035\t'deprecated-import'
UP036\t'outdated-version-block'
UP037\t'quoted-annotation'
UP038\t'non-pep604-isinstance'
UP039\t'unnecessary-class-parentheses'
UP040\t'non-pep695-type-alias'
UP041\t'timeout-error-alias'
UP042\t'replace-str-enum'
UP043\t'unnecessary-default-type-args'
UP044\t'non-pep646-unpack'
UP045\t'non-pep604-annotation-optional'
UP046\t'non-pep695-generic-class'
UP047\t'non-pep695-generic-function'
UP049\t'private-type-parameter'
UP050\t'useless-class-metaclass-type'
FURB101\t'read-whole-file'
FURB103\t'write-whole-file'
FURB105\t'print-empty-string'
FURB110\t'if-exp-instead-of-or-operator'
FURB113\t'repeated-append'
FURB116\t'f-string-number-format'
FURB118\t'reimplemented-operator'
FURB122\t'for-loop-writes'
FURB129\t'readlines-in-for'
FURB131\t'delete-full-slice'
FURB132\t'check-and-remove-from-set'
FURB136\t'if-expr-min-max'
FURB140\t'reimplemented-starmap'
FURB142\t'for-loop-set-mutations'
FURB145\t'slice-copy'
FURB148\t'unnecessary-enumerate'
FURB152\t'math-constant'
FURB154\t'repeated-global'
FURB156\t'hardcoded-string-charset'
FURB157\t'verbose-decimal-constructor'
FURB161\t'bit-count'
FURB162\t'fromisoformat-replace-z'
FURB163\t'redundant-log-base'
FURB164\t'unnecessary-from-float'
FURB166\t'int-on-sliced-str'
FURB167\t'regex-flag-alias'
FURB168\t'isinstance-type-none'
FURB169\t'type-none-comparison'
FURB171\t'single-item-membership-test'
FURB177\t'implicit-cwd'
FURB180\t'meta-class-abc-meta'
FURB181\t'hashlib-digest-hex'
FURB187\t'list-reverse-copy'
FURB188\t'slice-to-remove-prefix-or-suffix'
FURB189\t'subclass-builtin'
FURB192\t'sorted-min-max'
RUF001\t'ambiguous-unicode-character-string'
RUF002\t'ambiguous-unicode-character-docstring'
RUF003\t'ambiguous-unicode-character-comment'
RUF005\t'collection-literal-concatenation'
RUF006\t'asyncio-dangling-task'
RUF007\t'zip-instead-of-pairwise'
RUF008\t'mutable-dataclass-default'
RUF009\t'function-call-in-dataclass-default-argument'
RUF010\t'explicit-f-string-type-conversion'
RUF011\t'ruff-static-key-dict-comprehension'
RUF012\t'mutable-class-default'
RUF013\t'implicit-optional'
RUF015\t'unnecessary-iterable-allocation-for-first-element'
RUF016\t'invalid-index-type'
RUF017\t'quadratic-list-summation'
RUF018\t'assignment-in-assert'
RUF019\t'unnecessary-key-check'
RUF020\t'never-union'
RUF021\t'parenthesize-chained-operators'
RUF022\t'unsorted-dunder-all'
RUF023\t'unsorted-dunder-slots'
RUF024\t'mutable-fromkeys-value'
RUF026\t'default-factory-kwarg'
RUF027\t'missing-f-string-syntax'
RUF028\t'invalid-formatter-suppression-comment'
RUF029\t'unused-async'
RUF030\t'assert-with-print-message'
RUF031\t'incorrectly-parenthesized-tuple-in-subscript'
RUF032\t'decimal-from-float-literal'
RUF033\t'post-init-default'
RUF034\t'useless-if-else'
RUF035\t'ruff-unsafe-markup-use'
RUF036\t'none-not-at-end-of-union'
RUF037\t'unnecessary-empty-iterable-within-deque-call'
RUF038\t'redundant-bool-literal'
RUF039\t'unraw-re-pattern'
RUF040\t'invalid-assert-message-literal-argument'
RUF041\t'unnecessary-nested-literal'
RUF043\t'pytest-raises-ambiguous-pattern'
RUF045\t'implicit-class-var-in-dataclass'
RUF046\t'unnecessary-cast-to-int'
RUF047\t'needless-else'
RUF048\t'map-int-version-parsing'
RUF049\t'dataclass-enum'
RUF051\t'if-key-in-dict-del'
RUF052\t'used-dummy-variable'
RUF053\t'class-with-mixed-type-vars'
RUF054\t'indented-form-feed'
RUF055\t'unnecessary-regular-expression'
RUF056\t'falsy-dict-get-fallback'
RUF057\t'unnecessary-round'
RUF058\t'starmap-zip'
RUF059\t'unused-unpacked-variable'
RUF060\t'in-empty-collection'
RUF061\t'legacy-form-pytest-raises'
RUF063\t'access-annotations-from-class-dict'
RUF064\t'non-octal-permissions'
RUF065\t'logging-eager-conversion'
RUF100\t'unused-noqa'
RUF101\t'redirected-noqa'
RUF102\t'invalid-rule-code'
RUF200\t'invalid-pyproject-toml'
TRY002\t'raise-vanilla-class'
TRY003\t'raise-vanilla-args'
TRY004\t'type-check-without-type-error'
TRY200\t'reraise-no-cause'
TRY201\t'verbose-raise'
TRY203\t'useless-try-except'
TRY300\t'try-consider-else'
TRY301\t'raise-within-try'
TRY400\t'error-instead-of-exception'
TRY401\t'verbose-log-message'"
complete -c ruff -n "__fish_ruff_using_subcommand check" -l extend-select -d 'Like --select, but adds additional rule codes on top of those already specified' -r -f -a "ALL\t'all rules'
AIR\t'Airflow'
ERA\t'eradicate'
FAST\t'FastAPI'
YTT\t'flake8-2020'
ANN\t'flake8-annotations'
ASYNC\t'flake8-async'
S\t'flake8-bandit'
BLE\t'flake8-blind-except'
FBT\t'flake8-boolean-trap'
B\t'flake8-bugbear'
A\t'flake8-builtins'
COM\t'flake8-commas'
C4\t'flake8-comprehensions'
CPY\t'flake8-copyright'
DTZ\t'flake8-datetimez'
T10\t'flake8-debugger'
DJ\t'flake8-django'
EM\t'flake8-errmsg'
EXE\t'flake8-executable'
FIX\t'flake8-fixme'
FA\t'flake8-future-annotations'
INT\t'flake8-gettext'
ISC\t'flake8-implicit-str-concat'
ICN\t'flake8-import-conventions'
LOG\t'flake8-logging'
G\t'flake8-logging-format'
INP\t'flake8-no-pep420'
PIE\t'flake8-pie'
T20\t'flake8-print'
PYI\t'flake8-pyi'
PT\t'flake8-pytest-style'
Q\t'flake8-quotes'
RSE\t'flake8-raise'
RET\t'flake8-return'
SLF\t'flake8-self'
SIM\t'flake8-simplify'
SLOT\t'flake8-slots'
TID\t'flake8-tidy-imports'
TD\t'flake8-todos'
TC\t'flake8-type-checking'
ARG\t'flake8-unused-arguments'
PTH\t'flake8-use-pathlib'
FLY\t'flynt'
I\t'isort'
C90\t'mccabe'
NPY\t'NumPy-specific rules'
PD\t'pandas-vet'
N\t'pep8-naming'
PERF\t'Perflint'
DOC\t'pydoclint'
D\t'pydocstyle'
F\t'Pyflakes'
PGH\t'pygrep-hooks'
PL\t'Pylint'
UP\t'pyupgrade'
FURB\t'refurb'
RUF\t'Ruff-specific rules'
TRY\t'tryceratops'
AIR001\t'airflow-variable-name-task-id-mismatch'
AIR002\t'airflow-dag-no-schedule-argument'
AIR301\t'airflow3-removal'
AIR302\t'airflow3-moved-to-provider'
AIR311\t'airflow3-suggested-update'
AIR312\t'airflow3-suggested-to-move-to-provider'
ERA001\t'commented-out-code'
FAST001\t'fast-api-redundant-response-model'
FAST002\t'fast-api-non-annotated-dependency'
FAST003\t'fast-api-unused-path-parameter'
YTT101\t'sys-version-slice3'
YTT102\t'sys-version2'
YTT103\t'sys-version-cmp-str3'
YTT201\t'sys-version-info0-eq3'
YTT202\t'six-py3'
YTT203\t'sys-version-info1-cmp-int'
YTT204\t'sys-version-info-minor-cmp-int'
YTT301\t'sys-version0'
YTT302\t'sys-version-cmp-str10'
YTT303\t'sys-version-slice1'
ANN001\t'missing-type-function-argument'
ANN002\t'missing-type-args'
ANN003\t'missing-type-kwargs'
ANN101\t'missing-type-self'
ANN102\t'missing-type-cls'
ANN201\t'missing-return-type-undocumented-public-function'
ANN202\t'missing-return-type-private-function'
ANN204\t'missing-return-type-special-method'
ANN205\t'missing-return-type-static-method'
ANN206\t'missing-return-type-class-method'
ANN401\t'any-type'
ASYNC100\t'cancel-scope-no-checkpoint'
ASYNC105\t'trio-sync-call'
ASYNC109\t'async-function-with-timeout'
ASYNC110\t'async-busy-wait'
ASYNC115\t'async-zero-sleep'
ASYNC116\t'long-sleep-not-forever'
ASYNC210\t'blocking-http-call-in-async-function'
ASYNC212\t'blocking-http-call-httpx-in-async-function'
ASYNC220\t'create-subprocess-in-async-function'
ASYNC221\t'run-process-in-async-function'
ASYNC222\t'wait-for-process-in-async-function'
ASYNC230\t'blocking-open-call-in-async-function'
ASYNC240\t'blocking-path-method-in-async-function'
ASYNC250\t'blocking-input-in-async-function'
ASYNC251\t'blocking-sleep-in-async-function'
S101\t'assert'
S102\t'exec-builtin'
S103\t'bad-file-permissions'
S104\t'hardcoded-bind-all-interfaces'
S105\t'hardcoded-password-string'
S106\t'hardcoded-password-func-arg'
S107\t'hardcoded-password-default'
S108\t'hardcoded-temp-file'
S110\t'try-except-pass'
S112\t'try-except-continue'
S113\t'request-without-timeout'
S201\t'flask-debug-true'
S202\t'tarfile-unsafe-members'
S301\t'suspicious-pickle-usage'
S302\t'suspicious-marshal-usage'
S303\t'suspicious-insecure-hash-usage'
S304\t'suspicious-insecure-cipher-usage'
S305\t'suspicious-insecure-cipher-mode-usage'
S306\t'suspicious-mktemp-usage'
S307\t'suspicious-eval-usage'
S308\t'suspicious-mark-safe-usage'
S310\t'suspicious-url-open-usage'
S311\t'suspicious-non-cryptographic-random-usage'
S312\t'suspicious-telnet-usage'
S313\t'suspicious-xmlc-element-tree-usage'
S314\t'suspicious-xml-element-tree-usage'
S315\t'suspicious-xml-expat-reader-usage'
S316\t'suspicious-xml-expat-builder-usage'
S317\t'suspicious-xml-sax-usage'
S318\t'suspicious-xml-mini-dom-usage'
S319\t'suspicious-xml-pull-dom-usage'
S320\t'suspicious-xmle-tree-usage'
S321\t'suspicious-ftp-lib-usage'
S323\t'suspicious-unverified-context-usage'
S324\t'hashlib-insecure-hash-function'
S401\t'suspicious-telnetlib-import'
S402\t'suspicious-ftplib-import'
S403\t'suspicious-pickle-import'
S404\t'suspicious-subprocess-import'
S405\t'suspicious-xml-etree-import'
S406\t'suspicious-xml-sax-import'
S407\t'suspicious-xml-expat-import'
S408\t'suspicious-xml-minidom-import'
S409\t'suspicious-xml-pulldom-import'
S410\t'suspicious-lxml-import'
S411\t'suspicious-xmlrpc-import'
S412\t'suspicious-httpoxy-import'
S413\t'suspicious-pycrypto-import'
S415\t'suspicious-pyghmi-import'
S501\t'request-with-no-cert-validation'
S502\t'ssl-insecure-version'
S503\t'ssl-with-bad-defaults'
S504\t'ssl-with-no-version'
S505\t'weak-cryptographic-key'
S506\t'unsafe-yaml-load'
S507\t'ssh-no-host-key-verification'
S508\t'snmp-insecure-version'
S509\t'snmp-weak-cryptography'
S601\t'paramiko-call'
S602\t'subprocess-popen-with-shell-equals-true'
S603\t'subprocess-without-shell-equals-true'
S604\t'call-with-shell-equals-true'
S605\t'start-process-with-a-shell'
S606\t'start-process-with-no-shell'
S607\t'start-process-with-partial-path'
S608\t'hardcoded-sql-expression'
S609\t'unix-command-wildcard-injection'
S610\t'django-extra'
S611\t'django-raw-sql'
S612\t'logging-config-insecure-listen'
S701\t'jinja2-autoescape-false'
S702\t'mako-templates'
S704\t'unsafe-markup-use'
BLE001\t'blind-except'
FBT001\t'boolean-type-hint-positional-argument'
FBT002\t'boolean-default-value-positional-argument'
FBT003\t'boolean-positional-value-in-call'
B002\t'unary-prefix-increment-decrement'
B003\t'assignment-to-os-environ'
B004\t'unreliable-callable-check'
B005\t'strip-with-multi-characters'
B006\t'mutable-argument-default'
B007\t'unused-loop-control-variable'
B008\t'function-call-in-default-argument'
B009\t'get-attr-with-constant'
B010\t'set-attr-with-constant'
B011\t'assert-false'
B012\t'jump-statement-in-finally'
B013\t'redundant-tuple-in-exception-handler'
B014\t'duplicate-handler-exception'
B015\t'useless-comparison'
B016\t'raise-literal'
B017\t'assert-raises-exception'
B018\t'useless-expression'
B019\t'cached-instance-method'
B020\t'loop-variable-overrides-iterator'
B021\t'f-string-docstring'
B022\t'useless-contextlib-suppress'
B023\t'function-uses-loop-variable'
B024\t'abstract-base-class-without-abstract-method'
B025\t'duplicate-try-block-exception'
B026\t'star-arg-unpacking-after-keyword-arg'
B027\t'empty-method-without-abstract-decorator'
B028\t'no-explicit-stacklevel'
B029\t'except-with-empty-tuple'
B030\t'except-with-non-exception-classes'
B031\t'reuse-of-groupby-generator'
B032\t'unintentional-type-annotation'
B033\t'duplicate-value'
B034\t're-sub-positional-args'
B035\t'static-key-dict-comprehension'
B039\t'mutable-contextvar-default'
B901\t'return-in-generator'
B903\t'class-as-data-structure'
B904\t'raise-without-from-inside-except'
B905\t'zip-without-explicit-strict'
B909\t'loop-iterator-mutation'
B911\t'batched-without-explicit-strict'
B912\t'map-without-explicit-strict'
A001\t'builtin-variable-shadowing'
A002\t'builtin-argument-shadowing'
A003\t'builtin-attribute-shadowing'
A004\t'builtin-import-shadowing'
A005\t'stdlib-module-shadowing'
A006\t'builtin-lambda-argument-shadowing'
COM812\t'missing-trailing-comma'
COM818\t'trailing-comma-on-bare-tuple'
COM819\t'prohibited-trailing-comma'
C400\t'unnecessary-generator-list'
C401\t'unnecessary-generator-set'
C402\t'unnecessary-generator-dict'
C403\t'unnecessary-list-comprehension-set'
C404\t'unnecessary-list-comprehension-dict'
C405\t'unnecessary-literal-set'
C406\t'unnecessary-literal-dict'
C408\t'unnecessary-collection-call'
C409\t'unnecessary-literal-within-tuple-call'
C410\t'unnecessary-literal-within-list-call'
C411\t'unnecessary-list-call'
C413\t'unnecessary-call-around-sorted'
C414\t'unnecessary-double-cast-or-process'
C415\t'unnecessary-subscript-reversal'
C416\t'unnecessary-comprehension'
C417\t'unnecessary-map'
C418\t'unnecessary-literal-within-dict-call'
C419\t'unnecessary-comprehension-in-call'
C420\t'unnecessary-dict-comprehension-for-iterable'
CPY001\t'missing-copyright-notice'
DTZ001\t'call-datetime-without-tzinfo'
DTZ002\t'call-datetime-today'
DTZ003\t'call-datetime-utcnow'
DTZ004\t'call-datetime-utcfromtimestamp'
DTZ005\t'call-datetime-now-without-tzinfo'
DTZ006\t'call-datetime-fromtimestamp'
DTZ007\t'call-datetime-strptime-without-zone'
DTZ011\t'call-date-today'
DTZ012\t'call-date-fromtimestamp'
DTZ901\t'datetime-min-max'
T100\t'debugger'
DJ001\t'django-nullable-model-string-field'
DJ003\t'django-locals-in-render-function'
DJ006\t'django-exclude-with-model-form'
DJ007\t'django-all-with-model-form'
DJ008\t'django-model-without-dunder-str'
DJ012\t'django-unordered-body-content-in-model'
DJ013\t'django-non-leading-receiver-decorator'
EM101\t'raw-string-in-exception'
EM102\t'f-string-in-exception'
EM103\t'dot-format-in-exception'
EXE001\t'shebang-not-executable'
EXE002\t'shebang-missing-executable-file'
EXE003\t'shebang-missing-python'
EXE004\t'shebang-leading-whitespace'
EXE005\t'shebang-not-first-line'
FIX001\t'line-contains-fixme'
FIX002\t'line-contains-todo'
FIX003\t'line-contains-xxx'
FIX004\t'line-contains-hack'
FA100\t'future-rewritable-type-annotation'
FA102\t'future-required-type-annotation'
INT001\t'f-string-in-get-text-func-call'
INT002\t'format-in-get-text-func-call'
INT003\t'printf-in-get-text-func-call'
ISC001\t'single-line-implicit-string-concatenation'
ISC002\t'multi-line-implicit-string-concatenation'
ISC003\t'explicit-string-concatenation'
ICN001\t'unconventional-import-alias'
ICN002\t'banned-import-alias'
ICN003\t'banned-import-from'
LOG001\t'direct-logger-instantiation'
LOG002\t'invalid-get-logger-argument'
LOG004\t'log-exception-outside-except-handler'
LOG007\t'exception-without-exc-info'
LOG009\t'undocumented-warn'
LOG014\t'exc-info-outside-except-handler'
LOG015\t'root-logger-call'
G001\t'logging-string-format'
G002\t'logging-percent-format'
G003\t'logging-string-concat'
G004\t'logging-f-string'
G010\t'logging-warn'
G101\t'logging-extra-attr-clash'
G201\t'logging-exc-info'
G202\t'logging-redundant-exc-info'
INP001\t'implicit-namespace-package'
PIE790\t'unnecessary-placeholder'
PIE794\t'duplicate-class-field-definition'
PIE796\t'non-unique-enums'
PIE800\t'unnecessary-spread'
PIE804\t'unnecessary-dict-kwargs'
PIE807\t'reimplemented-container-builtin'
PIE808\t'unnecessary-range-start'
PIE810\t'multiple-starts-ends-with'
T201\t'print'
T203\t'p-print'
PYI001\t'unprefixed-type-param'
PYI002\t'complex-if-statement-in-stub'
PYI003\t'unrecognized-version-info-check'
PYI004\t'patch-version-comparison'
PYI005\t'wrong-tuple-length-version-comparison'
PYI006\t'bad-version-info-comparison'
PYI007\t'unrecognized-platform-check'
PYI008\t'unrecognized-platform-name'
PYI009\t'pass-statement-stub-body'
PYI010\t'non-empty-stub-body'
PYI011\t'typed-argument-default-in-stub'
PYI012\t'pass-in-class-body'
PYI013\t'ellipsis-in-non-empty-class-body'
PYI014\t'argument-default-in-stub'
PYI015\t'assignment-default-in-stub'
PYI016\t'duplicate-union-member'
PYI017\t'complex-assignment-in-stub'
PYI018\t'unused-private-type-var'
PYI019\t'custom-type-var-for-self'
PYI020\t'quoted-annotation-in-stub'
PYI021\t'docstring-in-stub'
PYI024\t'collections-named-tuple'
PYI025\t'unaliased-collections-abc-set-import'
PYI026\t'type-alias-without-annotation'
PYI029\t'str-or-repr-defined-in-stub'
PYI030\t'unnecessary-literal-union'
PYI032\t'any-eq-ne-annotation'
PYI033\t'type-comment-in-stub'
PYI034\t'non-self-return-type'
PYI035\t'unassigned-special-variable-in-stub'
PYI036\t'bad-exit-annotation'
PYI041\t'redundant-numeric-union'
PYI042\t'snake-case-type-alias'
PYI043\t't-suffixed-type-alias'
PYI044\t'future-annotations-in-stub'
PYI045\t'iter-method-return-iterable'
PYI046\t'unused-private-protocol'
PYI047\t'unused-private-type-alias'
PYI048\t'stub-body-multiple-statements'
PYI049\t'unused-private-typed-dict'
PYI050\t'no-return-argument-annotation-in-stub'
PYI051\t'redundant-literal-union'
PYI052\t'unannotated-assignment-in-stub'
PYI053\t'string-or-bytes-too-long'
PYI054\t'numeric-literal-too-long'
PYI055\t'unnecessary-type-union'
PYI056\t'unsupported-method-call-on-all'
PYI057\t'byte-string-usage'
PYI058\t'generator-return-from-iter-method'
PYI059\t'generic-not-last-base-class'
PYI061\t'redundant-none-literal'
PYI062\t'duplicate-literal-member'
PYI063\t'pep484-style-positional-only-parameter'
PYI064\t'redundant-final-literal'
PYI066\t'bad-version-info-order'
PT001\t'pytest-fixture-incorrect-parentheses-style'
PT002\t'pytest-fixture-positional-args'
PT003\t'pytest-extraneous-scope-function'
PT004\t'pytest-missing-fixture-name-underscore'
PT005\t'pytest-incorrect-fixture-name-underscore'
PT006\t'pytest-parametrize-names-wrong-type'
PT007\t'pytest-parametrize-values-wrong-type'
PT008\t'pytest-patch-with-lambda'
PT009\t'pytest-unittest-assertion'
PT010\t'pytest-raises-without-exception'
PT011\t'pytest-raises-too-broad'
PT012\t'pytest-raises-with-multiple-statements'
PT013\t'pytest-incorrect-pytest-import'
PT014\t'pytest-duplicate-parametrize-test-cases'
PT015\t'pytest-assert-always-false'
PT016\t'pytest-fail-without-message'
PT017\t'pytest-assert-in-except'
PT018\t'pytest-composite-assertion'
PT019\t'pytest-fixture-param-without-value'
PT020\t'pytest-deprecated-yield-fixture'
PT021\t'pytest-fixture-finalizer-callback'
PT022\t'pytest-useless-yield-fixture'
PT023\t'pytest-incorrect-mark-parentheses-style'
PT024\t'pytest-unnecessary-asyncio-mark-on-fixture'
PT025\t'pytest-erroneous-use-fixtures-on-fixture'
PT026\t'pytest-use-fixtures-without-parameters'
PT027\t'pytest-unittest-raises-assertion'
PT028\t'pytest-parameter-with-default-argument'
PT029\t'pytest-warns-without-warning'
PT030\t'pytest-warns-too-broad'
PT031\t'pytest-warns-with-multiple-statements'
Q000\t'bad-quotes-inline-string'
Q001\t'bad-quotes-multiline-string'
Q002\t'bad-quotes-docstring'
Q003\t'avoidable-escaped-quote'
Q004\t'unnecessary-escaped-quote'
RSE102\t'unnecessary-paren-on-raise-exception'
RET501\t'unnecessary-return-none'
RET502\t'implicit-return-value'
RET503\t'implicit-return'
RET504\t'unnecessary-assign'
RET505\t'superfluous-else-return'
RET506\t'superfluous-else-raise'
RET507\t'superfluous-else-continue'
RET508\t'superfluous-else-break'
SLF001\t'private-member-access'
SIM101\t'duplicate-isinstance-call'
SIM102\t'collapsible-if'
SIM103\t'needless-bool'
SIM105\t'suppressible-exception'
SIM107\t'return-in-try-except-finally'
SIM108\t'if-else-block-instead-of-if-exp'
SIM109\t'compare-with-tuple'
SIM110\t'reimplemented-builtin'
SIM112\t'uncapitalized-environment-variables'
SIM113\t'enumerate-for-loop'
SIM114\t'if-with-same-arms'
SIM115\t'open-file-with-context-handler'
SIM116\t'if-else-block-instead-of-dict-lookup'
SIM117\t'multiple-with-statements'
SIM118\t'in-dict-keys'
SIM201\t'negate-equal-op'
SIM202\t'negate-not-equal-op'
SIM208\t'double-negation'
SIM210\t'if-expr-with-true-false'
SIM211\t'if-expr-with-false-true'
SIM212\t'if-expr-with-twisted-arms'
SIM220\t'expr-and-not-expr'
SIM221\t'expr-or-not-expr'
SIM222\t'expr-or-true'
SIM223\t'expr-and-false'
SIM300\t'yoda-conditions'
SIM401\t'if-else-block-instead-of-dict-get'
SIM905\t'split-static-string'
SIM910\t'dict-get-with-none-default'
SIM911\t'zip-dict-keys-and-values'
SLOT000\t'no-slots-in-str-subclass'
SLOT001\t'no-slots-in-tuple-subclass'
SLOT002\t'no-slots-in-namedtuple-subclass'
TID251\t'banned-api'
TID252\t'relative-imports'
TID253\t'banned-module-level-imports'
TD001\t'invalid-todo-tag'
TD002\t'missing-todo-author'
TD003\t'missing-todo-link'
TD004\t'missing-todo-colon'
TD005\t'missing-todo-description'
TD006\t'invalid-todo-capitalization'
TD007\t'missing-space-after-todo-colon'
TC001\t'typing-only-first-party-import'
TC002\t'typing-only-third-party-import'
TC003\t'typing-only-standard-library-import'
TC004\t'runtime-import-in-type-checking-block'
TC005\t'empty-type-checking-block'
TC006\t'runtime-cast-value'
TC007\t'unquoted-type-alias'
TC008\t'quoted-type-alias'
TC010\t'runtime-string-union'
ARG001\t'unused-function-argument'
ARG002\t'unused-method-argument'
ARG003\t'unused-class-method-argument'
ARG004\t'unused-static-method-argument'
ARG005\t'unused-lambda-argument'
PTH100\t'os-path-abspath'
PTH101\t'os-chmod'
PTH102\t'os-mkdir'
PTH103\t'os-makedirs'
PTH104\t'os-rename'
PTH105\t'os-replace'
PTH106\t'os-rmdir'
PTH107\t'os-remove'
PTH108\t'os-unlink'
PTH109\t'os-getcwd'
PTH110\t'os-path-exists'
PTH111\t'os-path-expanduser'
PTH112\t'os-path-isdir'
PTH113\t'os-path-isfile'
PTH114\t'os-path-islink'
PTH115\t'os-readlink'
PTH116\t'os-stat'
PTH117\t'os-path-isabs'
PTH118\t'os-path-join'
PTH119\t'os-path-basename'
PTH120\t'os-path-dirname'
PTH121\t'os-path-samefile'
PTH122\t'os-path-splitext'
PTH123\t'builtin-open'
PTH124\t'py-path'
PTH201\t'path-constructor-current-directory'
PTH202\t'os-path-getsize'
PTH203\t'os-path-getatime'
PTH204\t'os-path-getmtime'
PTH205\t'os-path-getctime'
PTH206\t'os-sep-split'
PTH207\t'glob'
PTH208\t'os-listdir'
PTH210\t'invalid-pathlib-with-suffix'
PTH211\t'os-symlink'
FLY002\t'static-join-to-f-string'
I001\t'unsorted-imports'
I002\t'missing-required-import'
C901\t'complex-structure'
NPY001\t'numpy-deprecated-type-alias'
NPY002\t'numpy-legacy-random'
NPY003\t'numpy-deprecated-function'
NPY201\t'numpy2-deprecation'
N801\t'invalid-class-name'
N802\t'invalid-function-name'
N803\t'invalid-argument-name'
N804\t'invalid-first-argument-name-for-class-method'
N805\t'invalid-first-argument-name-for-method'
N806\t'non-lowercase-variable-in-function'
N807\t'dunder-function-name'
N811\t'constant-imported-as-non-constant'
N812\t'lowercase-imported-as-non-lowercase'
N813\t'camelcase-imported-as-lowercase'
N814\t'camelcase-imported-as-constant'
N815\t'mixed-case-variable-in-class-scope'
N816\t'mixed-case-variable-in-global-scope'
N817\t'camelcase-imported-as-acronym'
N818\t'error-suffix-on-exception-name'
N999\t'invalid-module-name'
PD002\t'pandas-use-of-inplace-argument'
PD003\t'pandas-use-of-dot-is-null'
PD004\t'pandas-use-of-dot-not-null'
PD007\t'pandas-use-of-dot-ix'
PD008\t'pandas-use-of-dot-at'
PD009\t'pandas-use-of-dot-iat'
PD010\t'pandas-use-of-dot-pivot-or-unstack'
PD011\t'pandas-use-of-dot-values'
PD012\t'pandas-use-of-dot-read-table'
PD013\t'pandas-use-of-dot-stack'
PD015\t'pandas-use-of-pd-merge'
PD101\t'pandas-nunique-constant-series-check'
PD901\t'pandas-df-variable-name'
PERF101\t'unnecessary-list-cast'
PERF102\t'incorrect-dict-iterator'
PERF203\t'try-except-in-loop'
PERF401\t'manual-list-comprehension'
PERF402\t'manual-list-copy'
PERF403\t'manual-dict-comprehension'
E101\t'mixed-spaces-and-tabs'
E111\t'indentation-with-invalid-multiple'
E112\t'no-indented-block'
E113\t'unexpected-indentation'
E114\t'indentation-with-invalid-multiple-comment'
E115\t'no-indented-block-comment'
E116\t'unexpected-indentation-comment'
E117\t'over-indented'
E201\t'whitespace-after-open-bracket'
E202\t'whitespace-before-close-bracket'
E203\t'whitespace-before-punctuation'
E204\t'whitespace-after-decorator'
E211\t'whitespace-before-parameters'
E221\t'multiple-spaces-before-operator'
E222\t'multiple-spaces-after-operator'
E223\t'tab-before-operator'
E224\t'tab-after-operator'
E225\t'missing-whitespace-around-operator'
E226\t'missing-whitespace-around-arithmetic-operator'
E227\t'missing-whitespace-around-bitwise-or-shift-operator'
E228\t'missing-whitespace-around-modulo-operator'
E231\t'missing-whitespace'
E241\t'multiple-spaces-after-comma'
E242\t'tab-after-comma'
E251\t'unexpected-spaces-around-keyword-parameter-equals'
E252\t'missing-whitespace-around-parameter-equals'
E261\t'too-few-spaces-before-inline-comment'
E262\t'no-space-after-inline-comment'
E265\t'no-space-after-block-comment'
E266\t'multiple-leading-hashes-for-block-comment'
E271\t'multiple-spaces-after-keyword'
E272\t'multiple-spaces-before-keyword'
E273\t'tab-after-keyword'
E274\t'tab-before-keyword'
E275\t'missing-whitespace-after-keyword'
E301\t'blank-line-between-methods'
E302\t'blank-lines-top-level'
E303\t'too-many-blank-lines'
E304\t'blank-line-after-decorator'
E305\t'blank-lines-after-function-or-class'
E306\t'blank-lines-before-nested-definition'
E401\t'multiple-imports-on-one-line'
E402\t'module-import-not-at-top-of-file'
E501\t'line-too-long'
E502\t'redundant-backslash'
E701\t'multiple-statements-on-one-line-colon'
E702\t'multiple-statements-on-one-line-semicolon'
E703\t'useless-semicolon'
E711\t'none-comparison'
E712\t'true-false-comparison'
E713\t'not-in-test'
E714\t'not-is-test'
E721\t'type-comparison'
E722\t'bare-except'
E731\t'lambda-assignment'
E741\t'ambiguous-variable-name'
E742\t'ambiguous-class-name'
E743\t'ambiguous-function-name'
E902\t'io-error'
E999\t'syntax-error'
W191\t'tab-indentation'
W291\t'trailing-whitespace'
W292\t'missing-newline-at-end-of-file'
W293\t'blank-line-with-whitespace'
W391\t'too-many-newlines-at-end-of-file'
W505\t'doc-line-too-long'
W605\t'invalid-escape-sequence'
DOC102\t'docstring-extraneous-parameter'
DOC201\t'docstring-missing-returns'
DOC202\t'docstring-extraneous-returns'
DOC402\t'docstring-missing-yields'
DOC403\t'docstring-extraneous-yields'
DOC501\t'docstring-missing-exception'
DOC502\t'docstring-extraneous-exception'
D100\t'undocumented-public-module'
D101\t'undocumented-public-class'
D102\t'undocumented-public-method'
D103\t'undocumented-public-function'
D104\t'undocumented-public-package'
D105\t'undocumented-magic-method'
D106\t'undocumented-public-nested-class'
D107\t'undocumented-public-init'
D200\t'unnecessary-multiline-docstring'
D201\t'blank-line-before-function'
D202\t'blank-line-after-function'
D203\t'incorrect-blank-line-before-class'
D204\t'incorrect-blank-line-after-class'
D205\t'missing-blank-line-after-summary'
D206\t'docstring-tab-indentation'
D207\t'under-indentation'
D208\t'over-indentation'
D209\t'new-line-after-last-paragraph'
D210\t'surrounding-whitespace'
D211\t'blank-line-before-class'
D212\t'multi-line-summary-first-line'
D213\t'multi-line-summary-second-line'
D214\t'overindented-section'
D215\t'overindented-section-underline'
D300\t'triple-single-quotes'
D301\t'escape-sequence-in-docstring'
D400\t'missing-trailing-period'
D401\t'non-imperative-mood'
D402\t'signature-in-docstring'
D403\t'first-word-uncapitalized'
D404\t'docstring-starts-with-this'
D405\t'non-capitalized-section-name'
D406\t'missing-new-line-after-section-name'
D407\t'missing-dashed-underline-after-section'
D408\t'missing-section-underline-after-name'
D409\t'mismatched-section-underline-length'
D410\t'no-blank-line-after-section'
D411\t'no-blank-line-before-section'
D412\t'blank-lines-between-header-and-content'
D413\t'missing-blank-line-after-last-section'
D414\t'empty-docstring-section'
D415\t'missing-terminal-punctuation'
D416\t'missing-section-name-colon'
D417\t'undocumented-param'
D418\t'overload-with-docstring'
D419\t'empty-docstring'
F401\t'unused-import'
F402\t'import-shadowed-by-loop-var'
F403\t'undefined-local-with-import-star'
F404\t'late-future-import'
F405\t'undefined-local-with-import-star-usage'
F406\t'undefined-local-with-nested-import-star-usage'
F407\t'future-feature-not-defined'
F501\t'percent-format-invalid-format'
F502\t'percent-format-expected-mapping'
F503\t'percent-format-expected-sequence'
F504\t'percent-format-extra-named-arguments'
F505\t'percent-format-missing-argument'
F506\t'percent-format-mixed-positional-and-named'
F507\t'percent-format-positional-count-mismatch'
F508\t'percent-format-star-requires-sequence'
F509\t'percent-format-unsupported-format-character'
F521\t'string-dot-format-invalid-format'
F522\t'string-dot-format-extra-named-arguments'
F523\t'string-dot-format-extra-positional-arguments'
F524\t'string-dot-format-missing-arguments'
F525\t'string-dot-format-mixing-automatic'
F541\t'f-string-missing-placeholders'
F601\t'multi-value-repeated-key-literal'
F602\t'multi-value-repeated-key-variable'
F621\t'expressions-in-star-assignment'
F622\t'multiple-starred-expressions'
F631\t'assert-tuple'
F632\t'is-literal'
F633\t'invalid-print-syntax'
F634\t'if-tuple'
F701\t'break-outside-loop'
F702\t'continue-outside-loop'
F704\t'yield-outside-function'
F706\t'return-outside-function'
F707\t'default-except-not-last'
F722\t'forward-annotation-syntax-error'
F811\t'redefined-while-unused'
F821\t'undefined-name'
F822\t'undefined-export'
F823\t'undefined-local'
F841\t'unused-variable'
F842\t'unused-annotation'
F901\t'raise-not-implemented'
PGH001\t'eval'
PGH002\t'deprecated-log-warn'
PGH003\t'blanket-type-ignore'
PGH004\t'blanket-noqa'
PGH005\t'invalid-mock-access'
PLC0105\t'type-name-incorrect-variance'
PLC0131\t'type-bivariance'
PLC0132\t'type-param-name-mismatch'
PLC0205\t'single-string-slots'
PLC0206\t'dict-index-missing-items'
PLC0207\t'missing-maxsplit-arg'
PLC0208\t'iteration-over-set'
PLC0414\t'useless-import-alias'
PLC0415\t'import-outside-top-level'
PLC1802\t'len-test'
PLC1901\t'compare-to-empty-string'
PLC2401\t'non-ascii-name'
PLC2403\t'non-ascii-import-name'
PLC2701\t'import-private-name'
PLC2801\t'unnecessary-dunder-call'
PLC3002\t'unnecessary-direct-lambda-call'
PLE0100\t'yield-in-init'
PLE0101\t'return-in-init'
PLE0115\t'nonlocal-and-global'
PLE0116\t'continue-in-finally'
PLE0117\t'nonlocal-without-binding'
PLE0118\t'load-before-global-declaration'
PLE0237\t'non-slot-assignment'
PLE0241\t'duplicate-bases'
PLE0302\t'unexpected-special-method-signature'
PLE0303\t'invalid-length-return-type'
PLE0304\t'invalid-bool-return-type'
PLE0305\t'invalid-index-return-type'
PLE0307\t'invalid-str-return-type'
PLE0308\t'invalid-bytes-return-type'
PLE0309\t'invalid-hash-return-type'
PLE0604\t'invalid-all-object'
PLE0605\t'invalid-all-format'
PLE0643\t'potential-index-error'
PLE0704\t'misplaced-bare-raise'
PLE1132\t'repeated-keyword-argument'
PLE1141\t'dict-iter-missing-items'
PLE1142\t'await-outside-async'
PLE1205\t'logging-too-many-args'
PLE1206\t'logging-too-few-args'
PLE1300\t'bad-string-format-character'
PLE1307\t'bad-string-format-type'
PLE1310\t'bad-str-strip-call'
PLE1507\t'invalid-envvar-value'
PLE1519\t'singledispatch-method'
PLE1520\t'singledispatchmethod-function'
PLE1700\t'yield-from-in-async-function'
PLE2502\t'bidirectional-unicode'
PLE2510\t'invalid-character-backspace'
PLE2512\t'invalid-character-sub'
PLE2513\t'invalid-character-esc'
PLE2514\t'invalid-character-nul'
PLE2515\t'invalid-character-zero-width-space'
PLE4703\t'modified-iterating-set'
PLR0124\t'comparison-with-itself'
PLR0133\t'comparison-of-constant'
PLR0202\t'no-classmethod-decorator'
PLR0203\t'no-staticmethod-decorator'
PLR0206\t'property-with-parameters'
PLR0402\t'manual-from-import'
PLR0904\t'too-many-public-methods'
PLR0911\t'too-many-return-statements'
PLR0912\t'too-many-branches'
PLR0913\t'too-many-arguments'
PLR0914\t'too-many-locals'
PLR0915\t'too-many-statements'
PLR0916\t'too-many-boolean-expressions'
PLR0917\t'too-many-positional-arguments'
PLR1701\t'repeated-isinstance-calls'
PLR1702\t'too-many-nested-blocks'
PLR1704\t'redefined-argument-from-local'
PLR1706\t'and-or-ternary'
PLR1711\t'useless-return'
PLR1714\t'repeated-equality-comparison'
PLR1716\t'boolean-chained-comparison'
PLR1722\t'sys-exit-alias'
PLR1730\t'if-stmt-min-max'
PLR1733\t'unnecessary-dict-index-lookup'
PLR1736\t'unnecessary-list-index-lookup'
PLR2004\t'magic-value-comparison'
PLR2044\t'empty-comment'
PLR5501\t'collapsible-else-if'
PLR6104\t'non-augmented-assignment'
PLR6201\t'literal-membership'
PLR6301\t'no-self-use'
PLW0108\t'unnecessary-lambda'
PLW0120\t'useless-else-on-loop'
PLW0127\t'self-assigning-variable'
PLW0128\t'redeclared-assigned-name'
PLW0129\t'assert-on-string-literal'
PLW0131\t'named-expr-without-context'
PLW0133\t'useless-exception-statement'
PLW0177\t'nan-comparison'
PLW0211\t'bad-staticmethod-argument'
PLW0244\t'redefined-slots-in-subclass'
PLW0245\t'super-without-brackets'
PLW0406\t'import-self'
PLW0602\t'global-variable-not-assigned'
PLW0603\t'global-statement'
PLW0604\t'global-at-module-level'
PLW0642\t'self-or-cls-assignment'
PLW0711\t'binary-op-exception'
PLW1501\t'bad-open-mode'
PLW1507\t'shallow-copy-environ'
PLW1508\t'invalid-envvar-default'
PLW1509\t'subprocess-popen-preexec-fn'
PLW1510\t'subprocess-run-without-check'
PLW1514\t'unspecified-encoding'
PLW1641\t'eq-without-hash'
PLW2101\t'useless-with-lock'
PLW2901\t'redefined-loop-name'
PLW3201\t'bad-dunder-method-name'
PLW3301\t'nested-min-max'
UP001\t'useless-metaclass-type'
UP003\t'type-of-primitive'
UP004\t'useless-object-inheritance'
UP005\t'deprecated-unittest-alias'
UP006\t'non-pep585-annotation'
UP007\t'non-pep604-annotation-union'
UP008\t'super-call-with-parameters'
UP009\t'utf8-encoding-declaration'
UP010\t'unnecessary-future-import'
UP011\t'lru-cache-without-parameters'
UP012\t'unnecessary-encode-utf8'
UP013\t'convert-typed-dict-functional-to-class'
UP014\t'convert-named-tuple-functional-to-class'
UP015\t'redundant-open-modes'
UP017\t'datetime-timezone-utc'
UP018\t'native-literals'
UP019\t'typing-text-str-alias'
UP020\t'open-alias'
UP021\t'replace-universal-newlines'
UP022\t'replace-stdout-stderr'
UP023\t'deprecated-c-element-tree'
UP024\t'os-error-alias'
UP025\t'unicode-kind-prefix'
UP026\t'deprecated-mock-import'
UP027\t'unpacked-list-comprehension'
UP028\t'yield-in-for-loop'
UP029\t'unnecessary-builtin-import'
UP030\t'format-literals'
UP031\t'printf-string-formatting'
UP032\t'f-string'
UP033\t'lru-cache-with-maxsize-none'
UP034\t'extraneous-parentheses'
UP035\t'deprecated-import'
UP036\t'outdated-version-block'
UP037\t'quoted-annotation'
UP038\t'non-pep604-isinstance'
UP039\t'unnecessary-class-parentheses'
UP040\t'non-pep695-type-alias'
UP041\t'timeout-error-alias'
UP042\t'replace-str-enum'
UP043\t'unnecessary-default-type-args'
UP044\t'non-pep646-unpack'
UP045\t'non-pep604-annotation-optional'
UP046\t'non-pep695-generic-class'
UP047\t'non-pep695-generic-function'
UP049\t'private-type-parameter'
UP050\t'useless-class-metaclass-type'
FURB101\t'read-whole-file'
FURB103\t'write-whole-file'
FURB105\t'print-empty-string'
FURB110\t'if-exp-instead-of-or-operator'
FURB113\t'repeated-append'
FURB116\t'f-string-number-format'
FURB118\t'reimplemented-operator'
FURB122\t'for-loop-writes'
FURB129\t'readlines-in-for'
FURB131\t'delete-full-slice'
FURB132\t'check-and-remove-from-set'
FURB136\t'if-expr-min-max'
FURB140\t'reimplemented-starmap'
FURB142\t'for-loop-set-mutations'
FURB145\t'slice-copy'
FURB148\t'unnecessary-enumerate'
FURB152\t'math-constant'
FURB154\t'repeated-global'
FURB156\t'hardcoded-string-charset'
FURB157\t'verbose-decimal-constructor'
FURB161\t'bit-count'
FURB162\t'fromisoformat-replace-z'
FURB163\t'redundant-log-base'
FURB164\t'unnecessary-from-float'
FURB166\t'int-on-sliced-str'
FURB167\t'regex-flag-alias'
FURB168\t'isinstance-type-none'
FURB169\t'type-none-comparison'
FURB171\t'single-item-membership-test'
FURB177\t'implicit-cwd'
FURB180\t'meta-class-abc-meta'
FURB181\t'hashlib-digest-hex'
FURB187\t'list-reverse-copy'
FURB188\t'slice-to-remove-prefix-or-suffix'
FURB189\t'subclass-builtin'
FURB192\t'sorted-min-max'
RUF001\t'ambiguous-unicode-character-string'
RUF002\t'ambiguous-unicode-character-docstring'
RUF003\t'ambiguous-unicode-character-comment'
RUF005\t'collection-literal-concatenation'
RUF006\t'asyncio-dangling-task'
RUF007\t'zip-instead-of-pairwise'
RUF008\t'mutable-dataclass-default'
RUF009\t'function-call-in-dataclass-default-argument'
RUF010\t'explicit-f-string-type-conversion'
RUF011\t'ruff-static-key-dict-comprehension'
RUF012\t'mutable-class-default'
RUF013\t'implicit-optional'
RUF015\t'unnecessary-iterable-allocation-for-first-element'
RUF016\t'invalid-index-type'
RUF017\t'quadratic-list-summation'
RUF018\t'assignment-in-assert'
RUF019\t'unnecessary-key-check'
RUF020\t'never-union'
RUF021\t'parenthesize-chained-operators'
RUF022\t'unsorted-dunder-all'
RUF023\t'unsorted-dunder-slots'
RUF024\t'mutable-fromkeys-value'
RUF026\t'default-factory-kwarg'
RUF027\t'missing-f-string-syntax'
RUF028\t'invalid-formatter-suppression-comment'
RUF029\t'unused-async'
RUF030\t'assert-with-print-message'
RUF031\t'incorrectly-parenthesized-tuple-in-subscript'
RUF032\t'decimal-from-float-literal'
RUF033\t'post-init-default'
RUF034\t'useless-if-else'
RUF035\t'ruff-unsafe-markup-use'
RUF036\t'none-not-at-end-of-union'
RUF037\t'unnecessary-empty-iterable-within-deque-call'
RUF038\t'redundant-bool-literal'
RUF039\t'unraw-re-pattern'
RUF040\t'invalid-assert-message-literal-argument'
RUF041\t'unnecessary-nested-literal'
RUF043\t'pytest-raises-ambiguous-pattern'
RUF045\t'implicit-class-var-in-dataclass'
RUF046\t'unnecessary-cast-to-int'
RUF047\t'needless-else'
RUF048\t'map-int-version-parsing'
RUF049\t'dataclass-enum'
RUF051\t'if-key-in-dict-del'
RUF052\t'used-dummy-variable'
RUF053\t'class-with-mixed-type-vars'
RUF054\t'indented-form-feed'
RUF055\t'unnecessary-regular-expression'
RUF056\t'falsy-dict-get-fallback'
RUF057\t'unnecessary-round'
RUF058\t'starmap-zip'
RUF059\t'unused-unpacked-variable'
RUF060\t'in-empty-collection'
RUF061\t'legacy-form-pytest-raises'
RUF063\t'access-annotations-from-class-dict'
RUF064\t'non-octal-permissions'
RUF065\t'logging-eager-conversion'
RUF100\t'unused-noqa'
RUF101\t'redirected-noqa'
RUF102\t'invalid-rule-code'
RUF200\t'invalid-pyproject-toml'
TRY002\t'raise-vanilla-class'
TRY003\t'raise-vanilla-args'
TRY004\t'type-check-without-type-error'
TRY200\t'reraise-no-cause'
TRY201\t'verbose-raise'
TRY203\t'useless-try-except'
TRY300\t'try-consider-else'
TRY301\t'raise-within-try'
TRY400\t'error-instead-of-exception'
TRY401\t'verbose-log-message'"
complete -c ruff -n "__fish_ruff_using_subcommand check" -l extend-ignore -d 'Like --ignore. (Deprecated: You can just use --ignore instead.)' -r -f -a "ALL\t'all rules'
AIR\t'Airflow'
ERA\t'eradicate'
FAST\t'FastAPI'
YTT\t'flake8-2020'
ANN\t'flake8-annotations'
ASYNC\t'flake8-async'
S\t'flake8-bandit'
BLE\t'flake8-blind-except'
FBT\t'flake8-boolean-trap'
B\t'flake8-bugbear'
A\t'flake8-builtins'
COM\t'flake8-commas'
C4\t'flake8-comprehensions'
CPY\t'flake8-copyright'
DTZ\t'flake8-datetimez'
T10\t'flake8-debugger'
DJ\t'flake8-django'
EM\t'flake8-errmsg'
EXE\t'flake8-executable'
FIX\t'flake8-fixme'
FA\t'flake8-future-annotations'
INT\t'flake8-gettext'
ISC\t'flake8-implicit-str-concat'
ICN\t'flake8-import-conventions'
LOG\t'flake8-logging'
G\t'flake8-logging-format'
INP\t'flake8-no-pep420'
PIE\t'flake8-pie'
T20\t'flake8-print'
PYI\t'flake8-pyi'
PT\t'flake8-pytest-style'
Q\t'flake8-quotes'
RSE\t'flake8-raise'
RET\t'flake8-return'
SLF\t'flake8-self'
SIM\t'flake8-simplify'
SLOT\t'flake8-slots'
TID\t'flake8-tidy-imports'
TD\t'flake8-todos'
TC\t'flake8-type-checking'
ARG\t'flake8-unused-arguments'
PTH\t'flake8-use-pathlib'
FLY\t'flynt'
I\t'isort'
C90\t'mccabe'
NPY\t'NumPy-specific rules'
PD\t'pandas-vet'
N\t'pep8-naming'
PERF\t'Perflint'
DOC\t'pydoclint'
D\t'pydocstyle'
F\t'Pyflakes'
PGH\t'pygrep-hooks'
PL\t'Pylint'
UP\t'pyupgrade'
FURB\t'refurb'
RUF\t'Ruff-specific rules'
TRY\t'tryceratops'
AIR001\t'airflow-variable-name-task-id-mismatch'
AIR002\t'airflow-dag-no-schedule-argument'
AIR301\t'airflow3-removal'
AIR302\t'airflow3-moved-to-provider'
AIR311\t'airflow3-suggested-update'
AIR312\t'airflow3-suggested-to-move-to-provider'
ERA001\t'commented-out-code'
FAST001\t'fast-api-redundant-response-model'
FAST002\t'fast-api-non-annotated-dependency'
FAST003\t'fast-api-unused-path-parameter'
YTT101\t'sys-version-slice3'
YTT102\t'sys-version2'
YTT103\t'sys-version-cmp-str3'
YTT201\t'sys-version-info0-eq3'
YTT202\t'six-py3'
YTT203\t'sys-version-info1-cmp-int'
YTT204\t'sys-version-info-minor-cmp-int'
YTT301\t'sys-version0'
YTT302\t'sys-version-cmp-str10'
YTT303\t'sys-version-slice1'
ANN001\t'missing-type-function-argument'
ANN002\t'missing-type-args'
ANN003\t'missing-type-kwargs'
ANN101\t'missing-type-self'
ANN102\t'missing-type-cls'
ANN201\t'missing-return-type-undocumented-public-function'
ANN202\t'missing-return-type-private-function'
ANN204\t'missing-return-type-special-method'
ANN205\t'missing-return-type-static-method'
ANN206\t'missing-return-type-class-method'
ANN401\t'any-type'
ASYNC100\t'cancel-scope-no-checkpoint'
ASYNC105\t'trio-sync-call'
ASYNC109\t'async-function-with-timeout'
ASYNC110\t'async-busy-wait'
ASYNC115\t'async-zero-sleep'
ASYNC116\t'long-sleep-not-forever'
ASYNC210\t'blocking-http-call-in-async-function'
ASYNC212\t'blocking-http-call-httpx-in-async-function'
ASYNC220\t'create-subprocess-in-async-function'
ASYNC221\t'run-process-in-async-function'
ASYNC222\t'wait-for-process-in-async-function'
ASYNC230\t'blocking-open-call-in-async-function'
ASYNC240\t'blocking-path-method-in-async-function'
ASYNC250\t'blocking-input-in-async-function'
ASYNC251\t'blocking-sleep-in-async-function'
S101\t'assert'
S102\t'exec-builtin'
S103\t'bad-file-permissions'
S104\t'hardcoded-bind-all-interfaces'
S105\t'hardcoded-password-string'
S106\t'hardcoded-password-func-arg'
S107\t'hardcoded-password-default'
S108\t'hardcoded-temp-file'
S110\t'try-except-pass'
S112\t'try-except-continue'
S113\t'request-without-timeout'
S201\t'flask-debug-true'
S202\t'tarfile-unsafe-members'
S301\t'suspicious-pickle-usage'
S302\t'suspicious-marshal-usage'
S303\t'suspicious-insecure-hash-usage'
S304\t'suspicious-insecure-cipher-usage'
S305\t'suspicious-insecure-cipher-mode-usage'
S306\t'suspicious-mktemp-usage'
S307\t'suspicious-eval-usage'
S308\t'suspicious-mark-safe-usage'
S310\t'suspicious-url-open-usage'
S311\t'suspicious-non-cryptographic-random-usage'
S312\t'suspicious-telnet-usage'
S313\t'suspicious-xmlc-element-tree-usage'
S314\t'suspicious-xml-element-tree-usage'
S315\t'suspicious-xml-expat-reader-usage'
S316\t'suspicious-xml-expat-builder-usage'
S317\t'suspicious-xml-sax-usage'
S318\t'suspicious-xml-mini-dom-usage'
S319\t'suspicious-xml-pull-dom-usage'
S320\t'suspicious-xmle-tree-usage'
S321\t'suspicious-ftp-lib-usage'
S323\t'suspicious-unverified-context-usage'
S324\t'hashlib-insecure-hash-function'
S401\t'suspicious-telnetlib-import'
S402\t'suspicious-ftplib-import'
S403\t'suspicious-pickle-import'
S404\t'suspicious-subprocess-import'
S405\t'suspicious-xml-etree-import'
S406\t'suspicious-xml-sax-import'
S407\t'suspicious-xml-expat-import'
S408\t'suspicious-xml-minidom-import'
S409\t'suspicious-xml-pulldom-import'
S410\t'suspicious-lxml-import'
S411\t'suspicious-xmlrpc-import'
S412\t'suspicious-httpoxy-import'
S413\t'suspicious-pycrypto-import'
S415\t'suspicious-pyghmi-import'
S501\t'request-with-no-cert-validation'
S502\t'ssl-insecure-version'
S503\t'ssl-with-bad-defaults'
S504\t'ssl-with-no-version'
S505\t'weak-cryptographic-key'
S506\t'unsafe-yaml-load'
S507\t'ssh-no-host-key-verification'
S508\t'snmp-insecure-version'
S509\t'snmp-weak-cryptography'
S601\t'paramiko-call'
S602\t'subprocess-popen-with-shell-equals-true'
S603\t'subprocess-without-shell-equals-true'
S604\t'call-with-shell-equals-true'
S605\t'start-process-with-a-shell'
S606\t'start-process-with-no-shell'
S607\t'start-process-with-partial-path'
S608\t'hardcoded-sql-expression'
S609\t'unix-command-wildcard-injection'
S610\t'django-extra'
S611\t'django-raw-sql'
S612\t'logging-config-insecure-listen'
S701\t'jinja2-autoescape-false'
S702\t'mako-templates'
S704\t'unsafe-markup-use'
BLE001\t'blind-except'
FBT001\t'boolean-type-hint-positional-argument'
FBT002\t'boolean-default-value-positional-argument'
FBT003\t'boolean-positional-value-in-call'
B002\t'unary-prefix-increment-decrement'
B003\t'assignment-to-os-environ'
B004\t'unreliable-callable-check'
B005\t'strip-with-multi-characters'
B006\t'mutable-argument-default'
B007\t'unused-loop-control-variable'
B008\t'function-call-in-default-argument'
B009\t'get-attr-with-constant'
B010\t'set-attr-with-constant'
B011\t'assert-false'
B012\t'jump-statement-in-finally'
B013\t'redundant-tuple-in-exception-handler'
B014\t'duplicate-handler-exception'
B015\t'useless-comparison'
B016\t'raise-literal'
B017\t'assert-raises-exception'
B018\t'useless-expression'
B019\t'cached-instance-method'
B020\t'loop-variable-overrides-iterator'
B021\t'f-string-docstring'
B022\t'useless-contextlib-suppress'
B023\t'function-uses-loop-variable'
B024\t'abstract-base-class-without-abstract-method'
B025\t'duplicate-try-block-exception'
B026\t'star-arg-unpacking-after-keyword-arg'
B027\t'empty-method-without-abstract-decorator'
B028\t'no-explicit-stacklevel'
B029\t'except-with-empty-tuple'
B030\t'except-with-non-exception-classes'
B031\t'reuse-of-groupby-generator'
B032\t'unintentional-type-annotation'
B033\t'duplicate-value'
B034\t're-sub-positional-args'
B035\t'static-key-dict-comprehension'
B039\t'mutable-contextvar-default'
B901\t'return-in-generator'
B903\t'class-as-data-structure'
B904\t'raise-without-from-inside-except'
B905\t'zip-without-explicit-strict'
B909\t'loop-iterator-mutation'
B911\t'batched-without-explicit-strict'
B912\t'map-without-explicit-strict'
A001\t'builtin-variable-shadowing'
A002\t'builtin-argument-shadowing'
A003\t'builtin-attribute-shadowing'
A004\t'builtin-import-shadowing'
A005\t'stdlib-module-shadowing'
A006\t'builtin-lambda-argument-shadowing'
COM812\t'missing-trailing-comma'
COM818\t'trailing-comma-on-bare-tuple'
COM819\t'prohibited-trailing-comma'
C400\t'unnecessary-generator-list'
C401\t'unnecessary-generator-set'
C402\t'unnecessary-generator-dict'
C403\t'unnecessary-list-comprehension-set'
C404\t'unnecessary-list-comprehension-dict'
C405\t'unnecessary-literal-set'
C406\t'unnecessary-literal-dict'
C408\t'unnecessary-collection-call'
C409\t'unnecessary-literal-within-tuple-call'
C410\t'unnecessary-literal-within-list-call'
C411\t'unnecessary-list-call'
C413\t'unnecessary-call-around-sorted'
C414\t'unnecessary-double-cast-or-process'
C415\t'unnecessary-subscript-reversal'
C416\t'unnecessary-comprehension'
C417\t'unnecessary-map'
C418\t'unnecessary-literal-within-dict-call'
C419\t'unnecessary-comprehension-in-call'
C420\t'unnecessary-dict-comprehension-for-iterable'
CPY001\t'missing-copyright-notice'
DTZ001\t'call-datetime-without-tzinfo'
DTZ002\t'call-datetime-today'
DTZ003\t'call-datetime-utcnow'
DTZ004\t'call-datetime-utcfromtimestamp'
DTZ005\t'call-datetime-now-without-tzinfo'
DTZ006\t'call-datetime-fromtimestamp'
DTZ007\t'call-datetime-strptime-without-zone'
DTZ011\t'call-date-today'
DTZ012\t'call-date-fromtimestamp'
DTZ901\t'datetime-min-max'
T100\t'debugger'
DJ001\t'django-nullable-model-string-field'
DJ003\t'django-locals-in-render-function'
DJ006\t'django-exclude-with-model-form'
DJ007\t'django-all-with-model-form'
DJ008\t'django-model-without-dunder-str'
DJ012\t'django-unordered-body-content-in-model'
DJ013\t'django-non-leading-receiver-decorator'
EM101\t'raw-string-in-exception'
EM102\t'f-string-in-exception'
EM103\t'dot-format-in-exception'
EXE001\t'shebang-not-executable'
EXE002\t'shebang-missing-executable-file'
EXE003\t'shebang-missing-python'
EXE004\t'shebang-leading-whitespace'
EXE005\t'shebang-not-first-line'
FIX001\t'line-contains-fixme'
FIX002\t'line-contains-todo'
FIX003\t'line-contains-xxx'
FIX004\t'line-contains-hack'
FA100\t'future-rewritable-type-annotation'
FA102\t'future-required-type-annotation'
INT001\t'f-string-in-get-text-func-call'
INT002\t'format-in-get-text-func-call'
INT003\t'printf-in-get-text-func-call'
ISC001\t'single-line-implicit-string-concatenation'
ISC002\t'multi-line-implicit-string-concatenation'
ISC003\t'explicit-string-concatenation'
ICN001\t'unconventional-import-alias'
ICN002\t'banned-import-alias'
ICN003\t'banned-import-from'
LOG001\t'direct-logger-instantiation'
LOG002\t'invalid-get-logger-argument'
LOG004\t'log-exception-outside-except-handler'
LOG007\t'exception-without-exc-info'
LOG009\t'undocumented-warn'
LOG014\t'exc-info-outside-except-handler'
LOG015\t'root-logger-call'
G001\t'logging-string-format'
G002\t'logging-percent-format'
G003\t'logging-string-concat'
G004\t'logging-f-string'
G010\t'logging-warn'
G101\t'logging-extra-attr-clash'
G201\t'logging-exc-info'
G202\t'logging-redundant-exc-info'
INP001\t'implicit-namespace-package'
PIE790\t'unnecessary-placeholder'
PIE794\t'duplicate-class-field-definition'
PIE796\t'non-unique-enums'
PIE800\t'unnecessary-spread'
PIE804\t'unnecessary-dict-kwargs'
PIE807\t'reimplemented-container-builtin'
PIE808\t'unnecessary-range-start'
PIE810\t'multiple-starts-ends-with'
T201\t'print'
T203\t'p-print'
PYI001\t'unprefixed-type-param'
PYI002\t'complex-if-statement-in-stub'
PYI003\t'unrecognized-version-info-check'
PYI004\t'patch-version-comparison'
PYI005\t'wrong-tuple-length-version-comparison'
PYI006\t'bad-version-info-comparison'
PYI007\t'unrecognized-platform-check'
PYI008\t'unrecognized-platform-name'
PYI009\t'pass-statement-stub-body'
PYI010\t'non-empty-stub-body'
PYI011\t'typed-argument-default-in-stub'
PYI012\t'pass-in-class-body'
PYI013\t'ellipsis-in-non-empty-class-body'
PYI014\t'argument-default-in-stub'
PYI015\t'assignment-default-in-stub'
PYI016\t'duplicate-union-member'
PYI017\t'complex-assignment-in-stub'
PYI018\t'unused-private-type-var'
PYI019\t'custom-type-var-for-self'
PYI020\t'quoted-annotation-in-stub'
PYI021\t'docstring-in-stub'
PYI024\t'collections-named-tuple'
PYI025\t'unaliased-collections-abc-set-import'
PYI026\t'type-alias-without-annotation'
PYI029\t'str-or-repr-defined-in-stub'
PYI030\t'unnecessary-literal-union'
PYI032\t'any-eq-ne-annotation'
PYI033\t'type-comment-in-stub'
PYI034\t'non-self-return-type'
PYI035\t'unassigned-special-variable-in-stub'
PYI036\t'bad-exit-annotation'
PYI041\t'redundant-numeric-union'
PYI042\t'snake-case-type-alias'
PYI043\t't-suffixed-type-alias'
PYI044\t'future-annotations-in-stub'
PYI045\t'iter-method-return-iterable'
PYI046\t'unused-private-protocol'
PYI047\t'unused-private-type-alias'
PYI048\t'stub-body-multiple-statements'
PYI049\t'unused-private-typed-dict'
PYI050\t'no-return-argument-annotation-in-stub'
PYI051\t'redundant-literal-union'
PYI052\t'unannotated-assignment-in-stub'
PYI053\t'string-or-bytes-too-long'
PYI054\t'numeric-literal-too-long'
PYI055\t'unnecessary-type-union'
PYI056\t'unsupported-method-call-on-all'
PYI057\t'byte-string-usage'
PYI058\t'generator-return-from-iter-method'
PYI059\t'generic-not-last-base-class'
PYI061\t'redundant-none-literal'
PYI062\t'duplicate-literal-member'
PYI063\t'pep484-style-positional-only-parameter'
PYI064\t'redundant-final-literal'
PYI066\t'bad-version-info-order'
PT001\t'pytest-fixture-incorrect-parentheses-style'
PT002\t'pytest-fixture-positional-args'
PT003\t'pytest-extraneous-scope-function'
PT004\t'pytest-missing-fixture-name-underscore'
PT005\t'pytest-incorrect-fixture-name-underscore'
PT006\t'pytest-parametrize-names-wrong-type'
PT007\t'pytest-parametrize-values-wrong-type'
PT008\t'pytest-patch-with-lambda'
PT009\t'pytest-unittest-assertion'
PT010\t'pytest-raises-without-exception'
PT011\t'pytest-raises-too-broad'
PT012\t'pytest-raises-with-multiple-statements'
PT013\t'pytest-incorrect-pytest-import'
PT014\t'pytest-duplicate-parametrize-test-cases'
PT015\t'pytest-assert-always-false'
PT016\t'pytest-fail-without-message'
PT017\t'pytest-assert-in-except'
PT018\t'pytest-composite-assertion'
PT019\t'pytest-fixture-param-without-value'
PT020\t'pytest-deprecated-yield-fixture'
PT021\t'pytest-fixture-finalizer-callback'
PT022\t'pytest-useless-yield-fixture'
PT023\t'pytest-incorrect-mark-parentheses-style'
PT024\t'pytest-unnecessary-asyncio-mark-on-fixture'
PT025\t'pytest-erroneous-use-fixtures-on-fixture'
PT026\t'pytest-use-fixtures-without-parameters'
PT027\t'pytest-unittest-raises-assertion'
PT028\t'pytest-parameter-with-default-argument'
PT029\t'pytest-warns-without-warning'
PT030\t'pytest-warns-too-broad'
PT031\t'pytest-warns-with-multiple-statements'
Q000\t'bad-quotes-inline-string'
Q001\t'bad-quotes-multiline-string'
Q002\t'bad-quotes-docstring'
Q003\t'avoidable-escaped-quote'
Q004\t'unnecessary-escaped-quote'
RSE102\t'unnecessary-paren-on-raise-exception'
RET501\t'unnecessary-return-none'
RET502\t'implicit-return-value'
RET503\t'implicit-return'
RET504\t'unnecessary-assign'
RET505\t'superfluous-else-return'
RET506\t'superfluous-else-raise'
RET507\t'superfluous-else-continue'
RET508\t'superfluous-else-break'
SLF001\t'private-member-access'
SIM101\t'duplicate-isinstance-call'
SIM102\t'collapsible-if'
SIM103\t'needless-bool'
SIM105\t'suppressible-exception'
SIM107\t'return-in-try-except-finally'
SIM108\t'if-else-block-instead-of-if-exp'
SIM109\t'compare-with-tuple'
SIM110\t'reimplemented-builtin'
SIM112\t'uncapitalized-environment-variables'
SIM113\t'enumerate-for-loop'
SIM114\t'if-with-same-arms'
SIM115\t'open-file-with-context-handler'
SIM116\t'if-else-block-instead-of-dict-lookup'
SIM117\t'multiple-with-statements'
SIM118\t'in-dict-keys'
SIM201\t'negate-equal-op'
SIM202\t'negate-not-equal-op'
SIM208\t'double-negation'
SIM210\t'if-expr-with-true-false'
SIM211\t'if-expr-with-false-true'
SIM212\t'if-expr-with-twisted-arms'
SIM220\t'expr-and-not-expr'
SIM221\t'expr-or-not-expr'
SIM222\t'expr-or-true'
SIM223\t'expr-and-false'
SIM300\t'yoda-conditions'
SIM401\t'if-else-block-instead-of-dict-get'
SIM905\t'split-static-string'
SIM910\t'dict-get-with-none-default'
SIM911\t'zip-dict-keys-and-values'
SLOT000\t'no-slots-in-str-subclass'
SLOT001\t'no-slots-in-tuple-subclass'
SLOT002\t'no-slots-in-namedtuple-subclass'
TID251\t'banned-api'
TID252\t'relative-imports'
TID253\t'banned-module-level-imports'
TD001\t'invalid-todo-tag'
TD002\t'missing-todo-author'
TD003\t'missing-todo-link'
TD004\t'missing-todo-colon'
TD005\t'missing-todo-description'
TD006\t'invalid-todo-capitalization'
TD007\t'missing-space-after-todo-colon'
TC001\t'typing-only-first-party-import'
TC002\t'typing-only-third-party-import'
TC003\t'typing-only-standard-library-import'
TC004\t'runtime-import-in-type-checking-block'
TC005\t'empty-type-checking-block'
TC006\t'runtime-cast-value'
TC007\t'unquoted-type-alias'
TC008\t'quoted-type-alias'
TC010\t'runtime-string-union'
ARG001\t'unused-function-argument'
ARG002\t'unused-method-argument'
ARG003\t'unused-class-method-argument'
ARG004\t'unused-static-method-argument'
ARG005\t'unused-lambda-argument'
PTH100\t'os-path-abspath'
PTH101\t'os-chmod'
PTH102\t'os-mkdir'
PTH103\t'os-makedirs'
PTH104\t'os-rename'
PTH105\t'os-replace'
PTH106\t'os-rmdir'
PTH107\t'os-remove'
PTH108\t'os-unlink'
PTH109\t'os-getcwd'
PTH110\t'os-path-exists'
PTH111\t'os-path-expanduser'
PTH112\t'os-path-isdir'
PTH113\t'os-path-isfile'
PTH114\t'os-path-islink'
PTH115\t'os-readlink'
PTH116\t'os-stat'
PTH117\t'os-path-isabs'
PTH118\t'os-path-join'
PTH119\t'os-path-basename'
PTH120\t'os-path-dirname'
PTH121\t'os-path-samefile'
PTH122\t'os-path-splitext'
PTH123\t'builtin-open'
PTH124\t'py-path'
PTH201\t'path-constructor-current-directory'
PTH202\t'os-path-getsize'
PTH203\t'os-path-getatime'
PTH204\t'os-path-getmtime'
PTH205\t'os-path-getctime'
PTH206\t'os-sep-split'
PTH207\t'glob'
PTH208\t'os-listdir'
PTH210\t'invalid-pathlib-with-suffix'
PTH211\t'os-symlink'
FLY002\t'static-join-to-f-string'
I001\t'unsorted-imports'
I002\t'missing-required-import'
C901\t'complex-structure'
NPY001\t'numpy-deprecated-type-alias'
NPY002\t'numpy-legacy-random'
NPY003\t'numpy-deprecated-function'
NPY201\t'numpy2-deprecation'
N801\t'invalid-class-name'
N802\t'invalid-function-name'
N803\t'invalid-argument-name'
N804\t'invalid-first-argument-name-for-class-method'
N805\t'invalid-first-argument-name-for-method'
N806\t'non-lowercase-variable-in-function'
N807\t'dunder-function-name'
N811\t'constant-imported-as-non-constant'
N812\t'lowercase-imported-as-non-lowercase'
N813\t'camelcase-imported-as-lowercase'
N814\t'camelcase-imported-as-constant'
N815\t'mixed-case-variable-in-class-scope'
N816\t'mixed-case-variable-in-global-scope'
N817\t'camelcase-imported-as-acronym'
N818\t'error-suffix-on-exception-name'
N999\t'invalid-module-name'
PD002\t'pandas-use-of-inplace-argument'
PD003\t'pandas-use-of-dot-is-null'
PD004\t'pandas-use-of-dot-not-null'
PD007\t'pandas-use-of-dot-ix'
PD008\t'pandas-use-of-dot-at'
PD009\t'pandas-use-of-dot-iat'
PD010\t'pandas-use-of-dot-pivot-or-unstack'
PD011\t'pandas-use-of-dot-values'
PD012\t'pandas-use-of-dot-read-table'
PD013\t'pandas-use-of-dot-stack'
PD015\t'pandas-use-of-pd-merge'
PD101\t'pandas-nunique-constant-series-check'
PD901\t'pandas-df-variable-name'
PERF101\t'unnecessary-list-cast'
PERF102\t'incorrect-dict-iterator'
PERF203\t'try-except-in-loop'
PERF401\t'manual-list-comprehension'
PERF402\t'manual-list-copy'
PERF403\t'manual-dict-comprehension'
E101\t'mixed-spaces-and-tabs'
E111\t'indentation-with-invalid-multiple'
E112\t'no-indented-block'
E113\t'unexpected-indentation'
E114\t'indentation-with-invalid-multiple-comment'
E115\t'no-indented-block-comment'
E116\t'unexpected-indentation-comment'
E117\t'over-indented'
E201\t'whitespace-after-open-bracket'
E202\t'whitespace-before-close-bracket'
E203\t'whitespace-before-punctuation'
E204\t'whitespace-after-decorator'
E211\t'whitespace-before-parameters'
E221\t'multiple-spaces-before-operator'
E222\t'multiple-spaces-after-operator'
E223\t'tab-before-operator'
E224\t'tab-after-operator'
E225\t'missing-whitespace-around-operator'
E226\t'missing-whitespace-around-arithmetic-operator'
E227\t'missing-whitespace-around-bitwise-or-shift-operator'
E228\t'missing-whitespace-around-modulo-operator'
E231\t'missing-whitespace'
E241\t'multiple-spaces-after-comma'
E242\t'tab-after-comma'
E251\t'unexpected-spaces-around-keyword-parameter-equals'
E252\t'missing-whitespace-around-parameter-equals'
E261\t'too-few-spaces-before-inline-comment'
E262\t'no-space-after-inline-comment'
E265\t'no-space-after-block-comment'
E266\t'multiple-leading-hashes-for-block-comment'
E271\t'multiple-spaces-after-keyword'
E272\t'multiple-spaces-before-keyword'
E273\t'tab-after-keyword'
E274\t'tab-before-keyword'
E275\t'missing-whitespace-after-keyword'
E301\t'blank-line-between-methods'
E302\t'blank-lines-top-level'
E303\t'too-many-blank-lines'
E304\t'blank-line-after-decorator'
E305\t'blank-lines-after-function-or-class'
E306\t'blank-lines-before-nested-definition'
E401\t'multiple-imports-on-one-line'
E402\t'module-import-not-at-top-of-file'
E501\t'line-too-long'
E502\t'redundant-backslash'
E701\t'multiple-statements-on-one-line-colon'
E702\t'multiple-statements-on-one-line-semicolon'
E703\t'useless-semicolon'
E711\t'none-comparison'
E712\t'true-false-comparison'
E713\t'not-in-test'
E714\t'not-is-test'
E721\t'type-comparison'
E722\t'bare-except'
E731\t'lambda-assignment'
E741\t'ambiguous-variable-name'
E742\t'ambiguous-class-name'
E743\t'ambiguous-function-name'
E902\t'io-error'
E999\t'syntax-error'
W191\t'tab-indentation'
W291\t'trailing-whitespace'
W292\t'missing-newline-at-end-of-file'
W293\t'blank-line-with-whitespace'
W391\t'too-many-newlines-at-end-of-file'
W505\t'doc-line-too-long'
W605\t'invalid-escape-sequence'
DOC102\t'docstring-extraneous-parameter'
DOC201\t'docstring-missing-returns'
DOC202\t'docstring-extraneous-returns'
DOC402\t'docstring-missing-yields'
DOC403\t'docstring-extraneous-yields'
DOC501\t'docstring-missing-exception'
DOC502\t'docstring-extraneous-exception'
D100\t'undocumented-public-module'
D101\t'undocumented-public-class'
D102\t'undocumented-public-method'
D103\t'undocumented-public-function'
D104\t'undocumented-public-package'
D105\t'undocumented-magic-method'
D106\t'undocumented-public-nested-class'
D107\t'undocumented-public-init'
D200\t'unnecessary-multiline-docstring'
D201\t'blank-line-before-function'
D202\t'blank-line-after-function'
D203\t'incorrect-blank-line-before-class'
D204\t'incorrect-blank-line-after-class'
D205\t'missing-blank-line-after-summary'
D206\t'docstring-tab-indentation'
D207\t'under-indentation'
D208\t'over-indentation'
D209\t'new-line-after-last-paragraph'
D210\t'surrounding-whitespace'
D211\t'blank-line-before-class'
D212\t'multi-line-summary-first-line'
D213\t'multi-line-summary-second-line'
D214\t'overindented-section'
D215\t'overindented-section-underline'
D300\t'triple-single-quotes'
D301\t'escape-sequence-in-docstring'
D400\t'missing-trailing-period'
D401\t'non-imperative-mood'
D402\t'signature-in-docstring'
D403\t'first-word-uncapitalized'
D404\t'docstring-starts-with-this'
D405\t'non-capitalized-section-name'
D406\t'missing-new-line-after-section-name'
D407\t'missing-dashed-underline-after-section'
D408\t'missing-section-underline-after-name'
D409\t'mismatched-section-underline-length'
D410\t'no-blank-line-after-section'
D411\t'no-blank-line-before-section'
D412\t'blank-lines-between-header-and-content'
D413\t'missing-blank-line-after-last-section'
D414\t'empty-docstring-section'
D415\t'missing-terminal-punctuation'
D416\t'missing-section-name-colon'
D417\t'undocumented-param'
D418\t'overload-with-docstring'
D419\t'empty-docstring'
F401\t'unused-import'
F402\t'import-shadowed-by-loop-var'
F403\t'undefined-local-with-import-star'
F404\t'late-future-import'
F405\t'undefined-local-with-import-star-usage'
F406\t'undefined-local-with-nested-import-star-usage'
F407\t'future-feature-not-defined'
F501\t'percent-format-invalid-format'
F502\t'percent-format-expected-mapping'
F503\t'percent-format-expected-sequence'
F504\t'percent-format-extra-named-arguments'
F505\t'percent-format-missing-argument'
F506\t'percent-format-mixed-positional-and-named'
F507\t'percent-format-positional-count-mismatch'
F508\t'percent-format-star-requires-sequence'
F509\t'percent-format-unsupported-format-character'
F521\t'string-dot-format-invalid-format'
F522\t'string-dot-format-extra-named-arguments'
F523\t'string-dot-format-extra-positional-arguments'
F524\t'string-dot-format-missing-arguments'
F525\t'string-dot-format-mixing-automatic'
F541\t'f-string-missing-placeholders'
F601\t'multi-value-repeated-key-literal'
F602\t'multi-value-repeated-key-variable'
F621\t'expressions-in-star-assignment'
F622\t'multiple-starred-expressions'
F631\t'assert-tuple'
F632\t'is-literal'
F633\t'invalid-print-syntax'
F634\t'if-tuple'
F701\t'break-outside-loop'
F702\t'continue-outside-loop'
F704\t'yield-outside-function'
F706\t'return-outside-function'
F707\t'default-except-not-last'
F722\t'forward-annotation-syntax-error'
F811\t'redefined-while-unused'
F821\t'undefined-name'
F822\t'undefined-export'
F823\t'undefined-local'
F841\t'unused-variable'
F842\t'unused-annotation'
F901\t'raise-not-implemented'
PGH001\t'eval'
PGH002\t'deprecated-log-warn'
PGH003\t'blanket-type-ignore'
PGH004\t'blanket-noqa'
PGH005\t'invalid-mock-access'
PLC0105\t'type-name-incorrect-variance'
PLC0131\t'type-bivariance'
PLC0132\t'type-param-name-mismatch'
PLC0205\t'single-string-slots'
PLC0206\t'dict-index-missing-items'
PLC0207\t'missing-maxsplit-arg'
PLC0208\t'iteration-over-set'
PLC0414\t'useless-import-alias'
PLC0415\t'import-outside-top-level'
PLC1802\t'len-test'
PLC1901\t'compare-to-empty-string'
PLC2401\t'non-ascii-name'
PLC2403\t'non-ascii-import-name'
PLC2701\t'import-private-name'
PLC2801\t'unnecessary-dunder-call'
PLC3002\t'unnecessary-direct-lambda-call'
PLE0100\t'yield-in-init'
PLE0101\t'return-in-init'
PLE0115\t'nonlocal-and-global'
PLE0116\t'continue-in-finally'
PLE0117\t'nonlocal-without-binding'
PLE0118\t'load-before-global-declaration'
PLE0237\t'non-slot-assignment'
PLE0241\t'duplicate-bases'
PLE0302\t'unexpected-special-method-signature'
PLE0303\t'invalid-length-return-type'
PLE0304\t'invalid-bool-return-type'
PLE0305\t'invalid-index-return-type'
PLE0307\t'invalid-str-return-type'
PLE0308\t'invalid-bytes-return-type'
PLE0309\t'invalid-hash-return-type'
PLE0604\t'invalid-all-object'
PLE0605\t'invalid-all-format'
PLE0643\t'potential-index-error'
PLE0704\t'misplaced-bare-raise'
PLE1132\t'repeated-keyword-argument'
PLE1141\t'dict-iter-missing-items'
PLE1142\t'await-outside-async'
PLE1205\t'logging-too-many-args'
PLE1206\t'logging-too-few-args'
PLE1300\t'bad-string-format-character'
PLE1307\t'bad-string-format-type'
PLE1310\t'bad-str-strip-call'
PLE1507\t'invalid-envvar-value'
PLE1519\t'singledispatch-method'
PLE1520\t'singledispatchmethod-function'
PLE1700\t'yield-from-in-async-function'
PLE2502\t'bidirectional-unicode'
PLE2510\t'invalid-character-backspace'
PLE2512\t'invalid-character-sub'
PLE2513\t'invalid-character-esc'
PLE2514\t'invalid-character-nul'
PLE2515\t'invalid-character-zero-width-space'
PLE4703\t'modified-iterating-set'
PLR0124\t'comparison-with-itself'
PLR0133\t'comparison-of-constant'
PLR0202\t'no-classmethod-decorator'
PLR0203\t'no-staticmethod-decorator'
PLR0206\t'property-with-parameters'
PLR0402\t'manual-from-import'
PLR0904\t'too-many-public-methods'
PLR0911\t'too-many-return-statements'
PLR0912\t'too-many-branches'
PLR0913\t'too-many-arguments'
PLR0914\t'too-many-locals'
PLR0915\t'too-many-statements'
PLR0916\t'too-many-boolean-expressions'
PLR0917\t'too-many-positional-arguments'
PLR1701\t'repeated-isinstance-calls'
PLR1702\t'too-many-nested-blocks'
PLR1704\t'redefined-argument-from-local'
PLR1706\t'and-or-ternary'
PLR1711\t'useless-return'
PLR1714\t'repeated-equality-comparison'
PLR1716\t'boolean-chained-comparison'
PLR1722\t'sys-exit-alias'
PLR1730\t'if-stmt-min-max'
PLR1733\t'unnecessary-dict-index-lookup'
PLR1736\t'unnecessary-list-index-lookup'
PLR2004\t'magic-value-comparison'
PLR2044\t'empty-comment'
PLR5501\t'collapsible-else-if'
PLR6104\t'non-augmented-assignment'
PLR6201\t'literal-membership'
PLR6301\t'no-self-use'
PLW0108\t'unnecessary-lambda'
PLW0120\t'useless-else-on-loop'
PLW0127\t'self-assigning-variable'
PLW0128\t'redeclared-assigned-name'
PLW0129\t'assert-on-string-literal'
PLW0131\t'named-expr-without-context'
PLW0133\t'useless-exception-statement'
PLW0177\t'nan-comparison'
PLW0211\t'bad-staticmethod-argument'
PLW0244\t'redefined-slots-in-subclass'
PLW0245\t'super-without-brackets'
PLW0406\t'import-self'
PLW0602\t'global-variable-not-assigned'
PLW0603\t'global-statement'
PLW0604\t'global-at-module-level'
PLW0642\t'self-or-cls-assignment'
PLW0711\t'binary-op-exception'
PLW1501\t'bad-open-mode'
PLW1507\t'shallow-copy-environ'
PLW1508\t'invalid-envvar-default'
PLW1509\t'subprocess-popen-preexec-fn'
PLW1510\t'subprocess-run-without-check'
PLW1514\t'unspecified-encoding'
PLW1641\t'eq-without-hash'
PLW2101\t'useless-with-lock'
PLW2901\t'redefined-loop-name'
PLW3201\t'bad-dunder-method-name'
PLW3301\t'nested-min-max'
UP001\t'useless-metaclass-type'
UP003\t'type-of-primitive'
UP004\t'useless-object-inheritance'
UP005\t'deprecated-unittest-alias'
UP006\t'non-pep585-annotation'
UP007\t'non-pep604-annotation-union'
UP008\t'super-call-with-parameters'
UP009\t'utf8-encoding-declaration'
UP010\t'unnecessary-future-import'
UP011\t'lru-cache-without-parameters'
UP012\t'unnecessary-encode-utf8'
UP013\t'convert-typed-dict-functional-to-class'
UP014\t'convert-named-tuple-functional-to-class'
UP015\t'redundant-open-modes'
UP017\t'datetime-timezone-utc'
UP018\t'native-literals'
UP019\t'typing-text-str-alias'
UP020\t'open-alias'
UP021\t'replace-universal-newlines'
UP022\t'replace-stdout-stderr'
UP023\t'deprecated-c-element-tree'
UP024\t'os-error-alias'
UP025\t'unicode-kind-prefix'
UP026\t'deprecated-mock-import'
UP027\t'unpacked-list-comprehension'
UP028\t'yield-in-for-loop'
UP029\t'unnecessary-builtin-import'
UP030\t'format-literals'
UP031\t'printf-string-formatting'
UP032\t'f-string'
UP033\t'lru-cache-with-maxsize-none'
UP034\t'extraneous-parentheses'
UP035\t'deprecated-import'
UP036\t'outdated-version-block'
UP037\t'quoted-annotation'
UP038\t'non-pep604-isinstance'
UP039\t'unnecessary-class-parentheses'
UP040\t'non-pep695-type-alias'
UP041\t'timeout-error-alias'
UP042\t'replace-str-enum'
UP043\t'unnecessary-default-type-args'
UP044\t'non-pep646-unpack'
UP045\t'non-pep604-annotation-optional'
UP046\t'non-pep695-generic-class'
UP047\t'non-pep695-generic-function'
UP049\t'private-type-parameter'
UP050\t'useless-class-metaclass-type'
FURB101\t'read-whole-file'
FURB103\t'write-whole-file'
FURB105\t'print-empty-string'
FURB110\t'if-exp-instead-of-or-operator'
FURB113\t'repeated-append'
FURB116\t'f-string-number-format'
FURB118\t'reimplemented-operator'
FURB122\t'for-loop-writes'
FURB129\t'readlines-in-for'
FURB131\t'delete-full-slice'
FURB132\t'check-and-remove-from-set'
FURB136\t'if-expr-min-max'
FURB140\t'reimplemented-starmap'
FURB142\t'for-loop-set-mutations'
FURB145\t'slice-copy'
FURB148\t'unnecessary-enumerate'
FURB152\t'math-constant'
FURB154\t'repeated-global'
FURB156\t'hardcoded-string-charset'
FURB157\t'verbose-decimal-constructor'
FURB161\t'bit-count'
FURB162\t'fromisoformat-replace-z'
FURB163\t'redundant-log-base'
FURB164\t'unnecessary-from-float'
FURB166\t'int-on-sliced-str'
FURB167\t'regex-flag-alias'
FURB168\t'isinstance-type-none'
FURB169\t'type-none-comparison'
FURB171\t'single-item-membership-test'
FURB177\t'implicit-cwd'
FURB180\t'meta-class-abc-meta'
FURB181\t'hashlib-digest-hex'
FURB187\t'list-reverse-copy'
FURB188\t'slice-to-remove-prefix-or-suffix'
FURB189\t'subclass-builtin'
FURB192\t'sorted-min-max'
RUF001\t'ambiguous-unicode-character-string'
RUF002\t'ambiguous-unicode-character-docstring'
RUF003\t'ambiguous-unicode-character-comment'
RUF005\t'collection-literal-concatenation'
RUF006\t'asyncio-dangling-task'
RUF007\t'zip-instead-of-pairwise'
RUF008\t'mutable-dataclass-default'
RUF009\t'function-call-in-dataclass-default-argument'
RUF010\t'explicit-f-string-type-conversion'
RUF011\t'ruff-static-key-dict-comprehension'
RUF012\t'mutable-class-default'
RUF013\t'implicit-optional'
RUF015\t'unnecessary-iterable-allocation-for-first-element'
RUF016\t'invalid-index-type'
RUF017\t'quadratic-list-summation'
RUF018\t'assignment-in-assert'
RUF019\t'unnecessary-key-check'
RUF020\t'never-union'
RUF021\t'parenthesize-chained-operators'
RUF022\t'unsorted-dunder-all'
RUF023\t'unsorted-dunder-slots'
RUF024\t'mutable-fromkeys-value'
RUF026\t'default-factory-kwarg'
RUF027\t'missing-f-string-syntax'
RUF028\t'invalid-formatter-suppression-comment'
RUF029\t'unused-async'
RUF030\t'assert-with-print-message'
RUF031\t'incorrectly-parenthesized-tuple-in-subscript'
RUF032\t'decimal-from-float-literal'
RUF033\t'post-init-default'
RUF034\t'useless-if-else'
RUF035\t'ruff-unsafe-markup-use'
RUF036\t'none-not-at-end-of-union'
RUF037\t'unnecessary-empty-iterable-within-deque-call'
RUF038\t'redundant-bool-literal'
RUF039\t'unraw-re-pattern'
RUF040\t'invalid-assert-message-literal-argument'
RUF041\t'unnecessary-nested-literal'
RUF043\t'pytest-raises-ambiguous-pattern'
RUF045\t'implicit-class-var-in-dataclass'
RUF046\t'unnecessary-cast-to-int'
RUF047\t'needless-else'
RUF048\t'map-int-version-parsing'
RUF049\t'dataclass-enum'
RUF051\t'if-key-in-dict-del'
RUF052\t'used-dummy-variable'
RUF053\t'class-with-mixed-type-vars'
RUF054\t'indented-form-feed'
RUF055\t'unnecessary-regular-expression'
RUF056\t'falsy-dict-get-fallback'
RUF057\t'unnecessary-round'
RUF058\t'starmap-zip'
RUF059\t'unused-unpacked-variable'
RUF060\t'in-empty-collection'
RUF061\t'legacy-form-pytest-raises'
RUF063\t'access-annotations-from-class-dict'
RUF064\t'non-octal-permissions'
RUF065\t'logging-eager-conversion'
RUF100\t'unused-noqa'
RUF101\t'redirected-noqa'
RUF102\t'invalid-rule-code'
RUF200\t'invalid-pyproject-toml'
TRY002\t'raise-vanilla-class'
TRY003\t'raise-vanilla-args'
TRY004\t'type-check-without-type-error'
TRY200\t'reraise-no-cause'
TRY201\t'verbose-raise'
TRY203\t'useless-try-except'
TRY300\t'try-consider-else'
TRY301\t'raise-within-try'
TRY400\t'error-instead-of-exception'
TRY401\t'verbose-log-message'"
complete -c ruff -n "__fish_ruff_using_subcommand check" -l per-file-ignores -d 'List of mappings from file pattern to code to exclude' -r
complete -c ruff -n "__fish_ruff_using_subcommand check" -l extend-per-file-ignores -d 'Like `--per-file-ignores`, but adds additional ignores on top of those already specified' -r
complete -c ruff -n "__fish_ruff_using_subcommand check" -l exclude -d 'List of paths, used to omit files and/or directories from analysis' -r
complete -c ruff -n "__fish_ruff_using_subcommand check" -l extend-exclude -d 'Like --exclude, but adds additional files and directories on top of those already excluded' -r
complete -c ruff -n "__fish_ruff_using_subcommand check" -l fixable -d 'List of rule codes to treat as eligible for fix. Only applicable when fix itself is enabled (e.g., via `--fix`)' -r -f -a "ALL\t'all rules'
AIR\t'Airflow'
ERA\t'eradicate'
FAST\t'FastAPI'
YTT\t'flake8-2020'
ANN\t'flake8-annotations'
ASYNC\t'flake8-async'
S\t'flake8-bandit'
BLE\t'flake8-blind-except'
FBT\t'flake8-boolean-trap'
B\t'flake8-bugbear'
A\t'flake8-builtins'
COM\t'flake8-commas'
C4\t'flake8-comprehensions'
CPY\t'flake8-copyright'
DTZ\t'flake8-datetimez'
T10\t'flake8-debugger'
DJ\t'flake8-django'
EM\t'flake8-errmsg'
EXE\t'flake8-executable'
FIX\t'flake8-fixme'
FA\t'flake8-future-annotations'
INT\t'flake8-gettext'
ISC\t'flake8-implicit-str-concat'
ICN\t'flake8-import-conventions'
LOG\t'flake8-logging'
G\t'flake8-logging-format'
INP\t'flake8-no-pep420'
PIE\t'flake8-pie'
T20\t'flake8-print'
PYI\t'flake8-pyi'
PT\t'flake8-pytest-style'
Q\t'flake8-quotes'
RSE\t'flake8-raise'
RET\t'flake8-return'
SLF\t'flake8-self'
SIM\t'flake8-simplify'
SLOT\t'flake8-slots'
TID\t'flake8-tidy-imports'
TD\t'flake8-todos'
TC\t'flake8-type-checking'
ARG\t'flake8-unused-arguments'
PTH\t'flake8-use-pathlib'
FLY\t'flynt'
I\t'isort'
C90\t'mccabe'
NPY\t'NumPy-specific rules'
PD\t'pandas-vet'
N\t'pep8-naming'
PERF\t'Perflint'
DOC\t'pydoclint'
D\t'pydocstyle'
F\t'Pyflakes'
PGH\t'pygrep-hooks'
PL\t'Pylint'
UP\t'pyupgrade'
FURB\t'refurb'
RUF\t'Ruff-specific rules'
TRY\t'tryceratops'
AIR001\t'airflow-variable-name-task-id-mismatch'
AIR002\t'airflow-dag-no-schedule-argument'
AIR301\t'airflow3-removal'
AIR302\t'airflow3-moved-to-provider'
AIR311\t'airflow3-suggested-update'
AIR312\t'airflow3-suggested-to-move-to-provider'
ERA001\t'commented-out-code'
FAST001\t'fast-api-redundant-response-model'
FAST002\t'fast-api-non-annotated-dependency'
FAST003\t'fast-api-unused-path-parameter'
YTT101\t'sys-version-slice3'
YTT102\t'sys-version2'
YTT103\t'sys-version-cmp-str3'
YTT201\t'sys-version-info0-eq3'
YTT202\t'six-py3'
YTT203\t'sys-version-info1-cmp-int'
YTT204\t'sys-version-info-minor-cmp-int'
YTT301\t'sys-version0'
YTT302\t'sys-version-cmp-str10'
YTT303\t'sys-version-slice1'
ANN001\t'missing-type-function-argument'
ANN002\t'missing-type-args'
ANN003\t'missing-type-kwargs'
ANN101\t'missing-type-self'
ANN102\t'missing-type-cls'
ANN201\t'missing-return-type-undocumented-public-function'
ANN202\t'missing-return-type-private-function'
ANN204\t'missing-return-type-special-method'
ANN205\t'missing-return-type-static-method'
ANN206\t'missing-return-type-class-method'
ANN401\t'any-type'
ASYNC100\t'cancel-scope-no-checkpoint'
ASYNC105\t'trio-sync-call'
ASYNC109\t'async-function-with-timeout'
ASYNC110\t'async-busy-wait'
ASYNC115\t'async-zero-sleep'
ASYNC116\t'long-sleep-not-forever'
ASYNC210\t'blocking-http-call-in-async-function'
ASYNC212\t'blocking-http-call-httpx-in-async-function'
ASYNC220\t'create-subprocess-in-async-function'
ASYNC221\t'run-process-in-async-function'
ASYNC222\t'wait-for-process-in-async-function'
ASYNC230\t'blocking-open-call-in-async-function'
ASYNC240\t'blocking-path-method-in-async-function'
ASYNC250\t'blocking-input-in-async-function'
ASYNC251\t'blocking-sleep-in-async-function'
S101\t'assert'
S102\t'exec-builtin'
S103\t'bad-file-permissions'
S104\t'hardcoded-bind-all-interfaces'
S105\t'hardcoded-password-string'
S106\t'hardcoded-password-func-arg'
S107\t'hardcoded-password-default'
S108\t'hardcoded-temp-file'
S110\t'try-except-pass'
S112\t'try-except-continue'
S113\t'request-without-timeout'
S201\t'flask-debug-true'
S202\t'tarfile-unsafe-members'
S301\t'suspicious-pickle-usage'
S302\t'suspicious-marshal-usage'
S303\t'suspicious-insecure-hash-usage'
S304\t'suspicious-insecure-cipher-usage'
S305\t'suspicious-insecure-cipher-mode-usage'
S306\t'suspicious-mktemp-usage'
S307\t'suspicious-eval-usage'
S308\t'suspicious-mark-safe-usage'
S310\t'suspicious-url-open-usage'
S311\t'suspicious-non-cryptographic-random-usage'
S312\t'suspicious-telnet-usage'
S313\t'suspicious-xmlc-element-tree-usage'
S314\t'suspicious-xml-element-tree-usage'
S315\t'suspicious-xml-expat-reader-usage'
S316\t'suspicious-xml-expat-builder-usage'
S317\t'suspicious-xml-sax-usage'
S318\t'suspicious-xml-mini-dom-usage'
S319\t'suspicious-xml-pull-dom-usage'
S320\t'suspicious-xmle-tree-usage'
S321\t'suspicious-ftp-lib-usage'
S323\t'suspicious-unverified-context-usage'
S324\t'hashlib-insecure-hash-function'
S401\t'suspicious-telnetlib-import'
S402\t'suspicious-ftplib-import'
S403\t'suspicious-pickle-import'
S404\t'suspicious-subprocess-import'
S405\t'suspicious-xml-etree-import'
S406\t'suspicious-xml-sax-import'
S407\t'suspicious-xml-expat-import'
S408\t'suspicious-xml-minidom-import'
S409\t'suspicious-xml-pulldom-import'
S410\t'suspicious-lxml-import'
S411\t'suspicious-xmlrpc-import'
S412\t'suspicious-httpoxy-import'
S413\t'suspicious-pycrypto-import'
S415\t'suspicious-pyghmi-import'
S501\t'request-with-no-cert-validation'
S502\t'ssl-insecure-version'
S503\t'ssl-with-bad-defaults'
S504\t'ssl-with-no-version'
S505\t'weak-cryptographic-key'
S506\t'unsafe-yaml-load'
S507\t'ssh-no-host-key-verification'
S508\t'snmp-insecure-version'
S509\t'snmp-weak-cryptography'
S601\t'paramiko-call'
S602\t'subprocess-popen-with-shell-equals-true'
S603\t'subprocess-without-shell-equals-true'
S604\t'call-with-shell-equals-true'
S605\t'start-process-with-a-shell'
S606\t'start-process-with-no-shell'
S607\t'start-process-with-partial-path'
S608\t'hardcoded-sql-expression'
S609\t'unix-command-wildcard-injection'
S610\t'django-extra'
S611\t'django-raw-sql'
S612\t'logging-config-insecure-listen'
S701\t'jinja2-autoescape-false'
S702\t'mako-templates'
S704\t'unsafe-markup-use'
BLE001\t'blind-except'
FBT001\t'boolean-type-hint-positional-argument'
FBT002\t'boolean-default-value-positional-argument'
FBT003\t'boolean-positional-value-in-call'
B002\t'unary-prefix-increment-decrement'
B003\t'assignment-to-os-environ'
B004\t'unreliable-callable-check'
B005\t'strip-with-multi-characters'
B006\t'mutable-argument-default'
B007\t'unused-loop-control-variable'
B008\t'function-call-in-default-argument'
B009\t'get-attr-with-constant'
B010\t'set-attr-with-constant'
B011\t'assert-false'
B012\t'jump-statement-in-finally'
B013\t'redundant-tuple-in-exception-handler'
B014\t'duplicate-handler-exception'
B015\t'useless-comparison'
B016\t'raise-literal'
B017\t'assert-raises-exception'
B018\t'useless-expression'
B019\t'cached-instance-method'
B020\t'loop-variable-overrides-iterator'
B021\t'f-string-docstring'
B022\t'useless-contextlib-suppress'
B023\t'function-uses-loop-variable'
B024\t'abstract-base-class-without-abstract-method'
B025\t'duplicate-try-block-exception'
B026\t'star-arg-unpacking-after-keyword-arg'
B027\t'empty-method-without-abstract-decorator'
B028\t'no-explicit-stacklevel'
B029\t'except-with-empty-tuple'
B030\t'except-with-non-exception-classes'
B031\t'reuse-of-groupby-generator'
B032\t'unintentional-type-annotation'
B033\t'duplicate-value'
B034\t're-sub-positional-args'
B035\t'static-key-dict-comprehension'
B039\t'mutable-contextvar-default'
B901\t'return-in-generator'
B903\t'class-as-data-structure'
B904\t'raise-without-from-inside-except'
B905\t'zip-without-explicit-strict'
B909\t'loop-iterator-mutation'
B911\t'batched-without-explicit-strict'
B912\t'map-without-explicit-strict'
A001\t'builtin-variable-shadowing'
A002\t'builtin-argument-shadowing'
A003\t'builtin-attribute-shadowing'
A004\t'builtin-import-shadowing'
A005\t'stdlib-module-shadowing'
A006\t'builtin-lambda-argument-shadowing'
COM812\t'missing-trailing-comma'
COM818\t'trailing-comma-on-bare-tuple'
COM819\t'prohibited-trailing-comma'
C400\t'unnecessary-generator-list'
C401\t'unnecessary-generator-set'
C402\t'unnecessary-generator-dict'
C403\t'unnecessary-list-comprehension-set'
C404\t'unnecessary-list-comprehension-dict'
C405\t'unnecessary-literal-set'
C406\t'unnecessary-literal-dict'
C408\t'unnecessary-collection-call'
C409\t'unnecessary-literal-within-tuple-call'
C410\t'unnecessary-literal-within-list-call'
C411\t'unnecessary-list-call'
C413\t'unnecessary-call-around-sorted'
C414\t'unnecessary-double-cast-or-process'
C415\t'unnecessary-subscript-reversal'
C416\t'unnecessary-comprehension'
C417\t'unnecessary-map'
C418\t'unnecessary-literal-within-dict-call'
C419\t'unnecessary-comprehension-in-call'
C420\t'unnecessary-dict-comprehension-for-iterable'
CPY001\t'missing-copyright-notice'
DTZ001\t'call-datetime-without-tzinfo'
DTZ002\t'call-datetime-today'
DTZ003\t'call-datetime-utcnow'
DTZ004\t'call-datetime-utcfromtimestamp'
DTZ005\t'call-datetime-now-without-tzinfo'
DTZ006\t'call-datetime-fromtimestamp'
DTZ007\t'call-datetime-strptime-without-zone'
DTZ011\t'call-date-today'
DTZ012\t'call-date-fromtimestamp'
DTZ901\t'datetime-min-max'
T100\t'debugger'
DJ001\t'django-nullable-model-string-field'
DJ003\t'django-locals-in-render-function'
DJ006\t'django-exclude-with-model-form'
DJ007\t'django-all-with-model-form'
DJ008\t'django-model-without-dunder-str'
DJ012\t'django-unordered-body-content-in-model'
DJ013\t'django-non-leading-receiver-decorator'
EM101\t'raw-string-in-exception'
EM102\t'f-string-in-exception'
EM103\t'dot-format-in-exception'
EXE001\t'shebang-not-executable'
EXE002\t'shebang-missing-executable-file'
EXE003\t'shebang-missing-python'
EXE004\t'shebang-leading-whitespace'
EXE005\t'shebang-not-first-line'
FIX001\t'line-contains-fixme'
FIX002\t'line-contains-todo'
FIX003\t'line-contains-xxx'
FIX004\t'line-contains-hack'
FA100\t'future-rewritable-type-annotation'
FA102\t'future-required-type-annotation'
INT001\t'f-string-in-get-text-func-call'
INT002\t'format-in-get-text-func-call'
INT003\t'printf-in-get-text-func-call'
ISC001\t'single-line-implicit-string-concatenation'
ISC002\t'multi-line-implicit-string-concatenation'
ISC003\t'explicit-string-concatenation'
ICN001\t'unconventional-import-alias'
ICN002\t'banned-import-alias'
ICN003\t'banned-import-from'
LOG001\t'direct-logger-instantiation'
LOG002\t'invalid-get-logger-argument'
LOG004\t'log-exception-outside-except-handler'
LOG007\t'exception-without-exc-info'
LOG009\t'undocumented-warn'
LOG014\t'exc-info-outside-except-handler'
LOG015\t'root-logger-call'
G001\t'logging-string-format'
G002\t'logging-percent-format'
G003\t'logging-string-concat'
G004\t'logging-f-string'
G010\t'logging-warn'
G101\t'logging-extra-attr-clash'
G201\t'logging-exc-info'
G202\t'logging-redundant-exc-info'
INP001\t'implicit-namespace-package'
PIE790\t'unnecessary-placeholder'
PIE794\t'duplicate-class-field-definition'
PIE796\t'non-unique-enums'
PIE800\t'unnecessary-spread'
PIE804\t'unnecessary-dict-kwargs'
PIE807\t'reimplemented-container-builtin'
PIE808\t'unnecessary-range-start'
PIE810\t'multiple-starts-ends-with'
T201\t'print'
T203\t'p-print'
PYI001\t'unprefixed-type-param'
PYI002\t'complex-if-statement-in-stub'
PYI003\t'unrecognized-version-info-check'
PYI004\t'patch-version-comparison'
PYI005\t'wrong-tuple-length-version-comparison'
PYI006\t'bad-version-info-comparison'
PYI007\t'unrecognized-platform-check'
PYI008\t'unrecognized-platform-name'
PYI009\t'pass-statement-stub-body'
PYI010\t'non-empty-stub-body'
PYI011\t'typed-argument-default-in-stub'
PYI012\t'pass-in-class-body'
PYI013\t'ellipsis-in-non-empty-class-body'
PYI014\t'argument-default-in-stub'
PYI015\t'assignment-default-in-stub'
PYI016\t'duplicate-union-member'
PYI017\t'complex-assignment-in-stub'
PYI018\t'unused-private-type-var'
PYI019\t'custom-type-var-for-self'
PYI020\t'quoted-annotation-in-stub'
PYI021\t'docstring-in-stub'
PYI024\t'collections-named-tuple'
PYI025\t'unaliased-collections-abc-set-import'
PYI026\t'type-alias-without-annotation'
PYI029\t'str-or-repr-defined-in-stub'
PYI030\t'unnecessary-literal-union'
PYI032\t'any-eq-ne-annotation'
PYI033\t'type-comment-in-stub'
PYI034\t'non-self-return-type'
PYI035\t'unassigned-special-variable-in-stub'
PYI036\t'bad-exit-annotation'
PYI041\t'redundant-numeric-union'
PYI042\t'snake-case-type-alias'
PYI043\t't-suffixed-type-alias'
PYI044\t'future-annotations-in-stub'
PYI045\t'iter-method-return-iterable'
PYI046\t'unused-private-protocol'
PYI047\t'unused-private-type-alias'
PYI048\t'stub-body-multiple-statements'
PYI049\t'unused-private-typed-dict'
PYI050\t'no-return-argument-annotation-in-stub'
PYI051\t'redundant-literal-union'
PYI052\t'unannotated-assignment-in-stub'
PYI053\t'string-or-bytes-too-long'
PYI054\t'numeric-literal-too-long'
PYI055\t'unnecessary-type-union'
PYI056\t'unsupported-method-call-on-all'
PYI057\t'byte-string-usage'
PYI058\t'generator-return-from-iter-method'
PYI059\t'generic-not-last-base-class'
PYI061\t'redundant-none-literal'
PYI062\t'duplicate-literal-member'
PYI063\t'pep484-style-positional-only-parameter'
PYI064\t'redundant-final-literal'
PYI066\t'bad-version-info-order'
PT001\t'pytest-fixture-incorrect-parentheses-style'
PT002\t'pytest-fixture-positional-args'
PT003\t'pytest-extraneous-scope-function'
PT004\t'pytest-missing-fixture-name-underscore'
PT005\t'pytest-incorrect-fixture-name-underscore'
PT006\t'pytest-parametrize-names-wrong-type'
PT007\t'pytest-parametrize-values-wrong-type'
PT008\t'pytest-patch-with-lambda'
PT009\t'pytest-unittest-assertion'
PT010\t'pytest-raises-without-exception'
PT011\t'pytest-raises-too-broad'
PT012\t'pytest-raises-with-multiple-statements'
PT013\t'pytest-incorrect-pytest-import'
PT014\t'pytest-duplicate-parametrize-test-cases'
PT015\t'pytest-assert-always-false'
PT016\t'pytest-fail-without-message'
PT017\t'pytest-assert-in-except'
PT018\t'pytest-composite-assertion'
PT019\t'pytest-fixture-param-without-value'
PT020\t'pytest-deprecated-yield-fixture'
PT021\t'pytest-fixture-finalizer-callback'
PT022\t'pytest-useless-yield-fixture'
PT023\t'pytest-incorrect-mark-parentheses-style'
PT024\t'pytest-unnecessary-asyncio-mark-on-fixture'
PT025\t'pytest-erroneous-use-fixtures-on-fixture'
PT026\t'pytest-use-fixtures-without-parameters'
PT027\t'pytest-unittest-raises-assertion'
PT028\t'pytest-parameter-with-default-argument'
PT029\t'pytest-warns-without-warning'
PT030\t'pytest-warns-too-broad'
PT031\t'pytest-warns-with-multiple-statements'
Q000\t'bad-quotes-inline-string'
Q001\t'bad-quotes-multiline-string'
Q002\t'bad-quotes-docstring'
Q003\t'avoidable-escaped-quote'
Q004\t'unnecessary-escaped-quote'
RSE102\t'unnecessary-paren-on-raise-exception'
RET501\t'unnecessary-return-none'
RET502\t'implicit-return-value'
RET503\t'implicit-return'
RET504\t'unnecessary-assign'
RET505\t'superfluous-else-return'
RET506\t'superfluous-else-raise'
RET507\t'superfluous-else-continue'
RET508\t'superfluous-else-break'
SLF001\t'private-member-access'
SIM101\t'duplicate-isinstance-call'
SIM102\t'collapsible-if'
SIM103\t'needless-bool'
SIM105\t'suppressible-exception'
SIM107\t'return-in-try-except-finally'
SIM108\t'if-else-block-instead-of-if-exp'
SIM109\t'compare-with-tuple'
SIM110\t'reimplemented-builtin'
SIM112\t'uncapitalized-environment-variables'
SIM113\t'enumerate-for-loop'
SIM114\t'if-with-same-arms'
SIM115\t'open-file-with-context-handler'
SIM116\t'if-else-block-instead-of-dict-lookup'
SIM117\t'multiple-with-statements'
SIM118\t'in-dict-keys'
SIM201\t'negate-equal-op'
SIM202\t'negate-not-equal-op'
SIM208\t'double-negation'
SIM210\t'if-expr-with-true-false'
SIM211\t'if-expr-with-false-true'
SIM212\t'if-expr-with-twisted-arms'
SIM220\t'expr-and-not-expr'
SIM221\t'expr-or-not-expr'
SIM222\t'expr-or-true'
SIM223\t'expr-and-false'
SIM300\t'yoda-conditions'
SIM401\t'if-else-block-instead-of-dict-get'
SIM905\t'split-static-string'
SIM910\t'dict-get-with-none-default'
SIM911\t'zip-dict-keys-and-values'
SLOT000\t'no-slots-in-str-subclass'
SLOT001\t'no-slots-in-tuple-subclass'
SLOT002\t'no-slots-in-namedtuple-subclass'
TID251\t'banned-api'
TID252\t'relative-imports'
TID253\t'banned-module-level-imports'
TD001\t'invalid-todo-tag'
TD002\t'missing-todo-author'
TD003\t'missing-todo-link'
TD004\t'missing-todo-colon'
TD005\t'missing-todo-description'
TD006\t'invalid-todo-capitalization'
TD007\t'missing-space-after-todo-colon'
TC001\t'typing-only-first-party-import'
TC002\t'typing-only-third-party-import'
TC003\t'typing-only-standard-library-import'
TC004\t'runtime-import-in-type-checking-block'
TC005\t'empty-type-checking-block'
TC006\t'runtime-cast-value'
TC007\t'unquoted-type-alias'
TC008\t'quoted-type-alias'
TC010\t'runtime-string-union'
ARG001\t'unused-function-argument'
ARG002\t'unused-method-argument'
ARG003\t'unused-class-method-argument'
ARG004\t'unused-static-method-argument'
ARG005\t'unused-lambda-argument'
PTH100\t'os-path-abspath'
PTH101\t'os-chmod'
PTH102\t'os-mkdir'
PTH103\t'os-makedirs'
PTH104\t'os-rename'
PTH105\t'os-replace'
PTH106\t'os-rmdir'
PTH107\t'os-remove'
PTH108\t'os-unlink'
PTH109\t'os-getcwd'
PTH110\t'os-path-exists'
PTH111\t'os-path-expanduser'
PTH112\t'os-path-isdir'
PTH113\t'os-path-isfile'
PTH114\t'os-path-islink'
PTH115\t'os-readlink'
PTH116\t'os-stat'
PTH117\t'os-path-isabs'
PTH118\t'os-path-join'
PTH119\t'os-path-basename'
PTH120\t'os-path-dirname'
PTH121\t'os-path-samefile'
PTH122\t'os-path-splitext'
PTH123\t'builtin-open'
PTH124\t'py-path'
PTH201\t'path-constructor-current-directory'
PTH202\t'os-path-getsize'
PTH203\t'os-path-getatime'
PTH204\t'os-path-getmtime'
PTH205\t'os-path-getctime'
PTH206\t'os-sep-split'
PTH207\t'glob'
PTH208\t'os-listdir'
PTH210\t'invalid-pathlib-with-suffix'
PTH211\t'os-symlink'
FLY002\t'static-join-to-f-string'
I001\t'unsorted-imports'
I002\t'missing-required-import'
C901\t'complex-structure'
NPY001\t'numpy-deprecated-type-alias'
NPY002\t'numpy-legacy-random'
NPY003\t'numpy-deprecated-function'
NPY201\t'numpy2-deprecation'
N801\t'invalid-class-name'
N802\t'invalid-function-name'
N803\t'invalid-argument-name'
N804\t'invalid-first-argument-name-for-class-method'
N805\t'invalid-first-argument-name-for-method'
N806\t'non-lowercase-variable-in-function'
N807\t'dunder-function-name'
N811\t'constant-imported-as-non-constant'
N812\t'lowercase-imported-as-non-lowercase'
N813\t'camelcase-imported-as-lowercase'
N814\t'camelcase-imported-as-constant'
N815\t'mixed-case-variable-in-class-scope'
N816\t'mixed-case-variable-in-global-scope'
N817\t'camelcase-imported-as-acronym'
N818\t'error-suffix-on-exception-name'
N999\t'invalid-module-name'
PD002\t'pandas-use-of-inplace-argument'
PD003\t'pandas-use-of-dot-is-null'
PD004\t'pandas-use-of-dot-not-null'
PD007\t'pandas-use-of-dot-ix'
PD008\t'pandas-use-of-dot-at'
PD009\t'pandas-use-of-dot-iat'
PD010\t'pandas-use-of-dot-pivot-or-unstack'
PD011\t'pandas-use-of-dot-values'
PD012\t'pandas-use-of-dot-read-table'
PD013\t'pandas-use-of-dot-stack'
PD015\t'pandas-use-of-pd-merge'
PD101\t'pandas-nunique-constant-series-check'
PD901\t'pandas-df-variable-name'
PERF101\t'unnecessary-list-cast'
PERF102\t'incorrect-dict-iterator'
PERF203\t'try-except-in-loop'
PERF401\t'manual-list-comprehension'
PERF402\t'manual-list-copy'
PERF403\t'manual-dict-comprehension'
E101\t'mixed-spaces-and-tabs'
E111\t'indentation-with-invalid-multiple'
E112\t'no-indented-block'
E113\t'unexpected-indentation'
E114\t'indentation-with-invalid-multiple-comment'
E115\t'no-indented-block-comment'
E116\t'unexpected-indentation-comment'
E117\t'over-indented'
E201\t'whitespace-after-open-bracket'
E202\t'whitespace-before-close-bracket'
E203\t'whitespace-before-punctuation'
E204\t'whitespace-after-decorator'
E211\t'whitespace-before-parameters'
E221\t'multiple-spaces-before-operator'
E222\t'multiple-spaces-after-operator'
E223\t'tab-before-operator'
E224\t'tab-after-operator'
E225\t'missing-whitespace-around-operator'
E226\t'missing-whitespace-around-arithmetic-operator'
E227\t'missing-whitespace-around-bitwise-or-shift-operator'
E228\t'missing-whitespace-around-modulo-operator'
E231\t'missing-whitespace'
E241\t'multiple-spaces-after-comma'
E242\t'tab-after-comma'
E251\t'unexpected-spaces-around-keyword-parameter-equals'
E252\t'missing-whitespace-around-parameter-equals'
E261\t'too-few-spaces-before-inline-comment'
E262\t'no-space-after-inline-comment'
E265\t'no-space-after-block-comment'
E266\t'multiple-leading-hashes-for-block-comment'
E271\t'multiple-spaces-after-keyword'
E272\t'multiple-spaces-before-keyword'
E273\t'tab-after-keyword'
E274\t'tab-before-keyword'
E275\t'missing-whitespace-after-keyword'
E301\t'blank-line-between-methods'
E302\t'blank-lines-top-level'
E303\t'too-many-blank-lines'
E304\t'blank-line-after-decorator'
E305\t'blank-lines-after-function-or-class'
E306\t'blank-lines-before-nested-definition'
E401\t'multiple-imports-on-one-line'
E402\t'module-import-not-at-top-of-file'
E501\t'line-too-long'
E502\t'redundant-backslash'
E701\t'multiple-statements-on-one-line-colon'
E702\t'multiple-statements-on-one-line-semicolon'
E703\t'useless-semicolon'
E711\t'none-comparison'
E712\t'true-false-comparison'
E713\t'not-in-test'
E714\t'not-is-test'
E721\t'type-comparison'
E722\t'bare-except'
E731\t'lambda-assignment'
E741\t'ambiguous-variable-name'
E742\t'ambiguous-class-name'
E743\t'ambiguous-function-name'
E902\t'io-error'
E999\t'syntax-error'
W191\t'tab-indentation'
W291\t'trailing-whitespace'
W292\t'missing-newline-at-end-of-file'
W293\t'blank-line-with-whitespace'
W391\t'too-many-newlines-at-end-of-file'
W505\t'doc-line-too-long'
W605\t'invalid-escape-sequence'
DOC102\t'docstring-extraneous-parameter'
DOC201\t'docstring-missing-returns'
DOC202\t'docstring-extraneous-returns'
DOC402\t'docstring-missing-yields'
DOC403\t'docstring-extraneous-yields'
DOC501\t'docstring-missing-exception'
DOC502\t'docstring-extraneous-exception'
D100\t'undocumented-public-module'
D101\t'undocumented-public-class'
D102\t'undocumented-public-method'
D103\t'undocumented-public-function'
D104\t'undocumented-public-package'
D105\t'undocumented-magic-method'
D106\t'undocumented-public-nested-class'
D107\t'undocumented-public-init'
D200\t'unnecessary-multiline-docstring'
D201\t'blank-line-before-function'
D202\t'blank-line-after-function'
D203\t'incorrect-blank-line-before-class'
D204\t'incorrect-blank-line-after-class'
D205\t'missing-blank-line-after-summary'
D206\t'docstring-tab-indentation'
D207\t'under-indentation'
D208\t'over-indentation'
D209\t'new-line-after-last-paragraph'
D210\t'surrounding-whitespace'
D211\t'blank-line-before-class'
D212\t'multi-line-summary-first-line'
D213\t'multi-line-summary-second-line'
D214\t'overindented-section'
D215\t'overindented-section-underline'
D300\t'triple-single-quotes'
D301\t'escape-sequence-in-docstring'
D400\t'missing-trailing-period'
D401\t'non-imperative-mood'
D402\t'signature-in-docstring'
D403\t'first-word-uncapitalized'
D404\t'docstring-starts-with-this'
D405\t'non-capitalized-section-name'
D406\t'missing-new-line-after-section-name'
D407\t'missing-dashed-underline-after-section'
D408\t'missing-section-underline-after-name'
D409\t'mismatched-section-underline-length'
D410\t'no-blank-line-after-section'
D411\t'no-blank-line-before-section'
D412\t'blank-lines-between-header-and-content'
D413\t'missing-blank-line-after-last-section'
D414\t'empty-docstring-section'
D415\t'missing-terminal-punctuation'
D416\t'missing-section-name-colon'
D417\t'undocumented-param'
D418\t'overload-with-docstring'
D419\t'empty-docstring'
F401\t'unused-import'
F402\t'import-shadowed-by-loop-var'
F403\t'undefined-local-with-import-star'
F404\t'late-future-import'
F405\t'undefined-local-with-import-star-usage'
F406\t'undefined-local-with-nested-import-star-usage'
F407\t'future-feature-not-defined'
F501\t'percent-format-invalid-format'
F502\t'percent-format-expected-mapping'
F503\t'percent-format-expected-sequence'
F504\t'percent-format-extra-named-arguments'
F505\t'percent-format-missing-argument'
F506\t'percent-format-mixed-positional-and-named'
F507\t'percent-format-positional-count-mismatch'
F508\t'percent-format-star-requires-sequence'
F509\t'percent-format-unsupported-format-character'
F521\t'string-dot-format-invalid-format'
F522\t'string-dot-format-extra-named-arguments'
F523\t'string-dot-format-extra-positional-arguments'
F524\t'string-dot-format-missing-arguments'
F525\t'string-dot-format-mixing-automatic'
F541\t'f-string-missing-placeholders'
F601\t'multi-value-repeated-key-literal'
F602\t'multi-value-repeated-key-variable'
F621\t'expressions-in-star-assignment'
F622\t'multiple-starred-expressions'
F631\t'assert-tuple'
F632\t'is-literal'
F633\t'invalid-print-syntax'
F634\t'if-tuple'
F701\t'break-outside-loop'
F702\t'continue-outside-loop'
F704\t'yield-outside-function'
F706\t'return-outside-function'
F707\t'default-except-not-last'
F722\t'forward-annotation-syntax-error'
F811\t'redefined-while-unused'
F821\t'undefined-name'
F822\t'undefined-export'
F823\t'undefined-local'
F841\t'unused-variable'
F842\t'unused-annotation'
F901\t'raise-not-implemented'
PGH001\t'eval'
PGH002\t'deprecated-log-warn'
PGH003\t'blanket-type-ignore'
PGH004\t'blanket-noqa'
PGH005\t'invalid-mock-access'
PLC0105\t'type-name-incorrect-variance'
PLC0131\t'type-bivariance'
PLC0132\t'type-param-name-mismatch'
PLC0205\t'single-string-slots'
PLC0206\t'dict-index-missing-items'
PLC0207\t'missing-maxsplit-arg'
PLC0208\t'iteration-over-set'
PLC0414\t'useless-import-alias'
PLC0415\t'import-outside-top-level'
PLC1802\t'len-test'
PLC1901\t'compare-to-empty-string'
PLC2401\t'non-ascii-name'
PLC2403\t'non-ascii-import-name'
PLC2701\t'import-private-name'
PLC2801\t'unnecessary-dunder-call'
PLC3002\t'unnecessary-direct-lambda-call'
PLE0100\t'yield-in-init'
PLE0101\t'return-in-init'
PLE0115\t'nonlocal-and-global'
PLE0116\t'continue-in-finally'
PLE0117\t'nonlocal-without-binding'
PLE0118\t'load-before-global-declaration'
PLE0237\t'non-slot-assignment'
PLE0241\t'duplicate-bases'
PLE0302\t'unexpected-special-method-signature'
PLE0303\t'invalid-length-return-type'
PLE0304\t'invalid-bool-return-type'
PLE0305\t'invalid-index-return-type'
PLE0307\t'invalid-str-return-type'
PLE0308\t'invalid-bytes-return-type'
PLE0309\t'invalid-hash-return-type'
PLE0604\t'invalid-all-object'
PLE0605\t'invalid-all-format'
PLE0643\t'potential-index-error'
PLE0704\t'misplaced-bare-raise'
PLE1132\t'repeated-keyword-argument'
PLE1141\t'dict-iter-missing-items'
PLE1142\t'await-outside-async'
PLE1205\t'logging-too-many-args'
PLE1206\t'logging-too-few-args'
PLE1300\t'bad-string-format-character'
PLE1307\t'bad-string-format-type'
PLE1310\t'bad-str-strip-call'
PLE1507\t'invalid-envvar-value'
PLE1519\t'singledispatch-method'
PLE1520\t'singledispatchmethod-function'
PLE1700\t'yield-from-in-async-function'
PLE2502\t'bidirectional-unicode'
PLE2510\t'invalid-character-backspace'
PLE2512\t'invalid-character-sub'
PLE2513\t'invalid-character-esc'
PLE2514\t'invalid-character-nul'
PLE2515\t'invalid-character-zero-width-space'
PLE4703\t'modified-iterating-set'
PLR0124\t'comparison-with-itself'
PLR0133\t'comparison-of-constant'
PLR0202\t'no-classmethod-decorator'
PLR0203\t'no-staticmethod-decorator'
PLR0206\t'property-with-parameters'
PLR0402\t'manual-from-import'
PLR0904\t'too-many-public-methods'
PLR0911\t'too-many-return-statements'
PLR0912\t'too-many-branches'
PLR0913\t'too-many-arguments'
PLR0914\t'too-many-locals'
PLR0915\t'too-many-statements'
PLR0916\t'too-many-boolean-expressions'
PLR0917\t'too-many-positional-arguments'
PLR1701\t'repeated-isinstance-calls'
PLR1702\t'too-many-nested-blocks'
PLR1704\t'redefined-argument-from-local'
PLR1706\t'and-or-ternary'
PLR1711\t'useless-return'
PLR1714\t'repeated-equality-comparison'
PLR1716\t'boolean-chained-comparison'
PLR1722\t'sys-exit-alias'
PLR1730\t'if-stmt-min-max'
PLR1733\t'unnecessary-dict-index-lookup'
PLR1736\t'unnecessary-list-index-lookup'
PLR2004\t'magic-value-comparison'
PLR2044\t'empty-comment'
PLR5501\t'collapsible-else-if'
PLR6104\t'non-augmented-assignment'
PLR6201\t'literal-membership'
PLR6301\t'no-self-use'
PLW0108\t'unnecessary-lambda'
PLW0120\t'useless-else-on-loop'
PLW0127\t'self-assigning-variable'
PLW0128\t'redeclared-assigned-name'
PLW0129\t'assert-on-string-literal'
PLW0131\t'named-expr-without-context'
PLW0133\t'useless-exception-statement'
PLW0177\t'nan-comparison'
PLW0211\t'bad-staticmethod-argument'
PLW0244\t'redefined-slots-in-subclass'
PLW0245\t'super-without-brackets'
PLW0406\t'import-self'
PLW0602\t'global-variable-not-assigned'
PLW0603\t'global-statement'
PLW0604\t'global-at-module-level'
PLW0642\t'self-or-cls-assignment'
PLW0711\t'binary-op-exception'
PLW1501\t'bad-open-mode'
PLW1507\t'shallow-copy-environ'
PLW1508\t'invalid-envvar-default'
PLW1509\t'subprocess-popen-preexec-fn'
PLW1510\t'subprocess-run-without-check'
PLW1514\t'unspecified-encoding'
PLW1641\t'eq-without-hash'
PLW2101\t'useless-with-lock'
PLW2901\t'redefined-loop-name'
PLW3201\t'bad-dunder-method-name'
PLW3301\t'nested-min-max'
UP001\t'useless-metaclass-type'
UP003\t'type-of-primitive'
UP004\t'useless-object-inheritance'
UP005\t'deprecated-unittest-alias'
UP006\t'non-pep585-annotation'
UP007\t'non-pep604-annotation-union'
UP008\t'super-call-with-parameters'
UP009\t'utf8-encoding-declaration'
UP010\t'unnecessary-future-import'
UP011\t'lru-cache-without-parameters'
UP012\t'unnecessary-encode-utf8'
UP013\t'convert-typed-dict-functional-to-class'
UP014\t'convert-named-tuple-functional-to-class'
UP015\t'redundant-open-modes'
UP017\t'datetime-timezone-utc'
UP018\t'native-literals'
UP019\t'typing-text-str-alias'
UP020\t'open-alias'
UP021\t'replace-universal-newlines'
UP022\t'replace-stdout-stderr'
UP023\t'deprecated-c-element-tree'
UP024\t'os-error-alias'
UP025\t'unicode-kind-prefix'
UP026\t'deprecated-mock-import'
UP027\t'unpacked-list-comprehension'
UP028\t'yield-in-for-loop'
UP029\t'unnecessary-builtin-import'
UP030\t'format-literals'
UP031\t'printf-string-formatting'
UP032\t'f-string'
UP033\t'lru-cache-with-maxsize-none'
UP034\t'extraneous-parentheses'
UP035\t'deprecated-import'
UP036\t'outdated-version-block'
UP037\t'quoted-annotation'
UP038\t'non-pep604-isinstance'
UP039\t'unnecessary-class-parentheses'
UP040\t'non-pep695-type-alias'
UP041\t'timeout-error-alias'
UP042\t'replace-str-enum'
UP043\t'unnecessary-default-type-args'
UP044\t'non-pep646-unpack'
UP045\t'non-pep604-annotation-optional'
UP046\t'non-pep695-generic-class'
UP047\t'non-pep695-generic-function'
UP049\t'private-type-parameter'
UP050\t'useless-class-metaclass-type'
FURB101\t'read-whole-file'
FURB103\t'write-whole-file'
FURB105\t'print-empty-string'
FURB110\t'if-exp-instead-of-or-operator'
FURB113\t'repeated-append'
FURB116\t'f-string-number-format'
FURB118\t'reimplemented-operator'
FURB122\t'for-loop-writes'
FURB129\t'readlines-in-for'
FURB131\t'delete-full-slice'
FURB132\t'check-and-remove-from-set'
FURB136\t'if-expr-min-max'
FURB140\t'reimplemented-starmap'
FURB142\t'for-loop-set-mutations'
FURB145\t'slice-copy'
FURB148\t'unnecessary-enumerate'
FURB152\t'math-constant'
FURB154\t'repeated-global'
FURB156\t'hardcoded-string-charset'
FURB157\t'verbose-decimal-constructor'
FURB161\t'bit-count'
FURB162\t'fromisoformat-replace-z'
FURB163\t'redundant-log-base'
FURB164\t'unnecessary-from-float'
FURB166\t'int-on-sliced-str'
FURB167\t'regex-flag-alias'
FURB168\t'isinstance-type-none'
FURB169\t'type-none-comparison'
FURB171\t'single-item-membership-test'
FURB177\t'implicit-cwd'
FURB180\t'meta-class-abc-meta'
FURB181\t'hashlib-digest-hex'
FURB187\t'list-reverse-copy'
FURB188\t'slice-to-remove-prefix-or-suffix'
FURB189\t'subclass-builtin'
FURB192\t'sorted-min-max'
RUF001\t'ambiguous-unicode-character-string'
RUF002\t'ambiguous-unicode-character-docstring'
RUF003\t'ambiguous-unicode-character-comment'
RUF005\t'collection-literal-concatenation'
RUF006\t'asyncio-dangling-task'
RUF007\t'zip-instead-of-pairwise'
RUF008\t'mutable-dataclass-default'
RUF009\t'function-call-in-dataclass-default-argument'
RUF010\t'explicit-f-string-type-conversion'
RUF011\t'ruff-static-key-dict-comprehension'
RUF012\t'mutable-class-default'
RUF013\t'implicit-optional'
RUF015\t'unnecessary-iterable-allocation-for-first-element'
RUF016\t'invalid-index-type'
RUF017\t'quadratic-list-summation'
RUF018\t'assignment-in-assert'
RUF019\t'unnecessary-key-check'
RUF020\t'never-union'
RUF021\t'parenthesize-chained-operators'
RUF022\t'unsorted-dunder-all'
RUF023\t'unsorted-dunder-slots'
RUF024\t'mutable-fromkeys-value'
RUF026\t'default-factory-kwarg'
RUF027\t'missing-f-string-syntax'
RUF028\t'invalid-formatter-suppression-comment'
RUF029\t'unused-async'
RUF030\t'assert-with-print-message'
RUF031\t'incorrectly-parenthesized-tuple-in-subscript'
RUF032\t'decimal-from-float-literal'
RUF033\t'post-init-default'
RUF034\t'useless-if-else'
RUF035\t'ruff-unsafe-markup-use'
RUF036\t'none-not-at-end-of-union'
RUF037\t'unnecessary-empty-iterable-within-deque-call'
RUF038\t'redundant-bool-literal'
RUF039\t'unraw-re-pattern'
RUF040\t'invalid-assert-message-literal-argument'
RUF041\t'unnecessary-nested-literal'
RUF043\t'pytest-raises-ambiguous-pattern'
RUF045\t'implicit-class-var-in-dataclass'
RUF046\t'unnecessary-cast-to-int'
RUF047\t'needless-else'
RUF048\t'map-int-version-parsing'
RUF049\t'dataclass-enum'
RUF051\t'if-key-in-dict-del'
RUF052\t'used-dummy-variable'
RUF053\t'class-with-mixed-type-vars'
RUF054\t'indented-form-feed'
RUF055\t'unnecessary-regular-expression'
RUF056\t'falsy-dict-get-fallback'
RUF057\t'unnecessary-round'
RUF058\t'starmap-zip'
RUF059\t'unused-unpacked-variable'
RUF060\t'in-empty-collection'
RUF061\t'legacy-form-pytest-raises'
RUF063\t'access-annotations-from-class-dict'
RUF064\t'non-octal-permissions'
RUF065\t'logging-eager-conversion'
RUF100\t'unused-noqa'
RUF101\t'redirected-noqa'
RUF102\t'invalid-rule-code'
RUF200\t'invalid-pyproject-toml'
TRY002\t'raise-vanilla-class'
TRY003\t'raise-vanilla-args'
TRY004\t'type-check-without-type-error'
TRY200\t'reraise-no-cause'
TRY201\t'verbose-raise'
TRY203\t'useless-try-except'
TRY300\t'try-consider-else'
TRY301\t'raise-within-try'
TRY400\t'error-instead-of-exception'
TRY401\t'verbose-log-message'"
complete -c ruff -n "__fish_ruff_using_subcommand check" -l unfixable -d 'List of rule codes to treat as ineligible for fix. Only applicable when fix itself is enabled (e.g., via `--fix`)' -r -f -a "ALL\t'all rules'
AIR\t'Airflow'
ERA\t'eradicate'
FAST\t'FastAPI'
YTT\t'flake8-2020'
ANN\t'flake8-annotations'
ASYNC\t'flake8-async'
S\t'flake8-bandit'
BLE\t'flake8-blind-except'
FBT\t'flake8-boolean-trap'
B\t'flake8-bugbear'
A\t'flake8-builtins'
COM\t'flake8-commas'
C4\t'flake8-comprehensions'
CPY\t'flake8-copyright'
DTZ\t'flake8-datetimez'
T10\t'flake8-debugger'
DJ\t'flake8-django'
EM\t'flake8-errmsg'
EXE\t'flake8-executable'
FIX\t'flake8-fixme'
FA\t'flake8-future-annotations'
INT\t'flake8-gettext'
ISC\t'flake8-implicit-str-concat'
ICN\t'flake8-import-conventions'
LOG\t'flake8-logging'
G\t'flake8-logging-format'
INP\t'flake8-no-pep420'
PIE\t'flake8-pie'
T20\t'flake8-print'
PYI\t'flake8-pyi'
PT\t'flake8-pytest-style'
Q\t'flake8-quotes'
RSE\t'flake8-raise'
RET\t'flake8-return'
SLF\t'flake8-self'
SIM\t'flake8-simplify'
SLOT\t'flake8-slots'
TID\t'flake8-tidy-imports'
TD\t'flake8-todos'
TC\t'flake8-type-checking'
ARG\t'flake8-unused-arguments'
PTH\t'flake8-use-pathlib'
FLY\t'flynt'
I\t'isort'
C90\t'mccabe'
NPY\t'NumPy-specific rules'
PD\t'pandas-vet'
N\t'pep8-naming'
PERF\t'Perflint'
DOC\t'pydoclint'
D\t'pydocstyle'
F\t'Pyflakes'
PGH\t'pygrep-hooks'
PL\t'Pylint'
UP\t'pyupgrade'
FURB\t'refurb'
RUF\t'Ruff-specific rules'
TRY\t'tryceratops'
AIR001\t'airflow-variable-name-task-id-mismatch'
AIR002\t'airflow-dag-no-schedule-argument'
AIR301\t'airflow3-removal'
AIR302\t'airflow3-moved-to-provider'
AIR311\t'airflow3-suggested-update'
AIR312\t'airflow3-suggested-to-move-to-provider'
ERA001\t'commented-out-code'
FAST001\t'fast-api-redundant-response-model'
FAST002\t'fast-api-non-annotated-dependency'
FAST003\t'fast-api-unused-path-parameter'
YTT101\t'sys-version-slice3'
YTT102\t'sys-version2'
YTT103\t'sys-version-cmp-str3'
YTT201\t'sys-version-info0-eq3'
YTT202\t'six-py3'
YTT203\t'sys-version-info1-cmp-int'
YTT204\t'sys-version-info-minor-cmp-int'
YTT301\t'sys-version0'
YTT302\t'sys-version-cmp-str10'
YTT303\t'sys-version-slice1'
ANN001\t'missing-type-function-argument'
ANN002\t'missing-type-args'
ANN003\t'missing-type-kwargs'
ANN101\t'missing-type-self'
ANN102\t'missing-type-cls'
ANN201\t'missing-return-type-undocumented-public-function'
ANN202\t'missing-return-type-private-function'
ANN204\t'missing-return-type-special-method'
ANN205\t'missing-return-type-static-method'
ANN206\t'missing-return-type-class-method'
ANN401\t'any-type'
ASYNC100\t'cancel-scope-no-checkpoint'
ASYNC105\t'trio-sync-call'
ASYNC109\t'async-function-with-timeout'
ASYNC110\t'async-busy-wait'
ASYNC115\t'async-zero-sleep'
ASYNC116\t'long-sleep-not-forever'
ASYNC210\t'blocking-http-call-in-async-function'
ASYNC212\t'blocking-http-call-httpx-in-async-function'
ASYNC220\t'create-subprocess-in-async-function'
ASYNC221\t'run-process-in-async-function'
ASYNC222\t'wait-for-process-in-async-function'
ASYNC230\t'blocking-open-call-in-async-function'
ASYNC240\t'blocking-path-method-in-async-function'
ASYNC250\t'blocking-input-in-async-function'
ASYNC251\t'blocking-sleep-in-async-function'
S101\t'assert'
S102\t'exec-builtin'
S103\t'bad-file-permissions'
S104\t'hardcoded-bind-all-interfaces'
S105\t'hardcoded-password-string'
S106\t'hardcoded-password-func-arg'
S107\t'hardcoded-password-default'
S108\t'hardcoded-temp-file'
S110\t'try-except-pass'
S112\t'try-except-continue'
S113\t'request-without-timeout'
S201\t'flask-debug-true'
S202\t'tarfile-unsafe-members'
S301\t'suspicious-pickle-usage'
S302\t'suspicious-marshal-usage'
S303\t'suspicious-insecure-hash-usage'
S304\t'suspicious-insecure-cipher-usage'
S305\t'suspicious-insecure-cipher-mode-usage'
S306\t'suspicious-mktemp-usage'
S307\t'suspicious-eval-usage'
S308\t'suspicious-mark-safe-usage'
S310\t'suspicious-url-open-usage'
S311\t'suspicious-non-cryptographic-random-usage'
S312\t'suspicious-telnet-usage'
S313\t'suspicious-xmlc-element-tree-usage'
S314\t'suspicious-xml-element-tree-usage'
S315\t'suspicious-xml-expat-reader-usage'
S316\t'suspicious-xml-expat-builder-usage'
S317\t'suspicious-xml-sax-usage'
S318\t'suspicious-xml-mini-dom-usage'
S319\t'suspicious-xml-pull-dom-usage'
S320\t'suspicious-xmle-tree-usage'
S321\t'suspicious-ftp-lib-usage'
S323\t'suspicious-unverified-context-usage'
S324\t'hashlib-insecure-hash-function'
S401\t'suspicious-telnetlib-import'
S402\t'suspicious-ftplib-import'
S403\t'suspicious-pickle-import'
S404\t'suspicious-subprocess-import'
S405\t'suspicious-xml-etree-import'
S406\t'suspicious-xml-sax-import'
S407\t'suspicious-xml-expat-import'
S408\t'suspicious-xml-minidom-import'
S409\t'suspicious-xml-pulldom-import'
S410\t'suspicious-lxml-import'
S411\t'suspicious-xmlrpc-import'
S412\t'suspicious-httpoxy-import'
S413\t'suspicious-pycrypto-import'
S415\t'suspicious-pyghmi-import'
S501\t'request-with-no-cert-validation'
S502\t'ssl-insecure-version'
S503\t'ssl-with-bad-defaults'
S504\t'ssl-with-no-version'
S505\t'weak-cryptographic-key'
S506\t'unsafe-yaml-load'
S507\t'ssh-no-host-key-verification'
S508\t'snmp-insecure-version'
S509\t'snmp-weak-cryptography'
S601\t'paramiko-call'
S602\t'subprocess-popen-with-shell-equals-true'
S603\t'subprocess-without-shell-equals-true'
S604\t'call-with-shell-equals-true'
S605\t'start-process-with-a-shell'
S606\t'start-process-with-no-shell'
S607\t'start-process-with-partial-path'
S608\t'hardcoded-sql-expression'
S609\t'unix-command-wildcard-injection'
S610\t'django-extra'
S611\t'django-raw-sql'
S612\t'logging-config-insecure-listen'
S701\t'jinja2-autoescape-false'
S702\t'mako-templates'
S704\t'unsafe-markup-use'
BLE001\t'blind-except'
FBT001\t'boolean-type-hint-positional-argument'
FBT002\t'boolean-default-value-positional-argument'
FBT003\t'boolean-positional-value-in-call'
B002\t'unary-prefix-increment-decrement'
B003\t'assignment-to-os-environ'
B004\t'unreliable-callable-check'
B005\t'strip-with-multi-characters'
B006\t'mutable-argument-default'
B007\t'unused-loop-control-variable'
B008\t'function-call-in-default-argument'
B009\t'get-attr-with-constant'
B010\t'set-attr-with-constant'
B011\t'assert-false'
B012\t'jump-statement-in-finally'
B013\t'redundant-tuple-in-exception-handler'
B014\t'duplicate-handler-exception'
B015\t'useless-comparison'
B016\t'raise-literal'
B017\t'assert-raises-exception'
B018\t'useless-expression'
B019\t'cached-instance-method'
B020\t'loop-variable-overrides-iterator'
B021\t'f-string-docstring'
B022\t'useless-contextlib-suppress'
B023\t'function-uses-loop-variable'
B024\t'abstract-base-class-without-abstract-method'
B025\t'duplicate-try-block-exception'
B026\t'star-arg-unpacking-after-keyword-arg'
B027\t'empty-method-without-abstract-decorator'
B028\t'no-explicit-stacklevel'
B029\t'except-with-empty-tuple'
B030\t'except-with-non-exception-classes'
B031\t'reuse-of-groupby-generator'
B032\t'unintentional-type-annotation'
B033\t'duplicate-value'
B034\t're-sub-positional-args'
B035\t'static-key-dict-comprehension'
B039\t'mutable-contextvar-default'
B901\t'return-in-generator'
B903\t'class-as-data-structure'
B904\t'raise-without-from-inside-except'
B905\t'zip-without-explicit-strict'
B909\t'loop-iterator-mutation'
B911\t'batched-without-explicit-strict'
B912\t'map-without-explicit-strict'
A001\t'builtin-variable-shadowing'
A002\t'builtin-argument-shadowing'
A003\t'builtin-attribute-shadowing'
A004\t'builtin-import-shadowing'
A005\t'stdlib-module-shadowing'
A006\t'builtin-lambda-argument-shadowing'
COM812\t'missing-trailing-comma'
COM818\t'trailing-comma-on-bare-tuple'
COM819\t'prohibited-trailing-comma'
C400\t'unnecessary-generator-list'
C401\t'unnecessary-generator-set'
C402\t'unnecessary-generator-dict'
C403\t'unnecessary-list-comprehension-set'
C404\t'unnecessary-list-comprehension-dict'
C405\t'unnecessary-literal-set'
C406\t'unnecessary-literal-dict'
C408\t'unnecessary-collection-call'
C409\t'unnecessary-literal-within-tuple-call'
C410\t'unnecessary-literal-within-list-call'
C411\t'unnecessary-list-call'
C413\t'unnecessary-call-around-sorted'
C414\t'unnecessary-double-cast-or-process'
C415\t'unnecessary-subscript-reversal'
C416\t'unnecessary-comprehension'
C417\t'unnecessary-map'
C418\t'unnecessary-literal-within-dict-call'
C419\t'unnecessary-comprehension-in-call'
C420\t'unnecessary-dict-comprehension-for-iterable'
CPY001\t'missing-copyright-notice'
DTZ001\t'call-datetime-without-tzinfo'
DTZ002\t'call-datetime-today'
DTZ003\t'call-datetime-utcnow'
DTZ004\t'call-datetime-utcfromtimestamp'
DTZ005\t'call-datetime-now-without-tzinfo'
DTZ006\t'call-datetime-fromtimestamp'
DTZ007\t'call-datetime-strptime-without-zone'
DTZ011\t'call-date-today'
DTZ012\t'call-date-fromtimestamp'
DTZ901\t'datetime-min-max'
T100\t'debugger'
DJ001\t'django-nullable-model-string-field'
DJ003\t'django-locals-in-render-function'
DJ006\t'django-exclude-with-model-form'
DJ007\t'django-all-with-model-form'
DJ008\t'django-model-without-dunder-str'
DJ012\t'django-unordered-body-content-in-model'
DJ013\t'django-non-leading-receiver-decorator'
EM101\t'raw-string-in-exception'
EM102\t'f-string-in-exception'
EM103\t'dot-format-in-exception'
EXE001\t'shebang-not-executable'
EXE002\t'shebang-missing-executable-file'
EXE003\t'shebang-missing-python'
EXE004\t'shebang-leading-whitespace'
EXE005\t'shebang-not-first-line'
FIX001\t'line-contains-fixme'
FIX002\t'line-contains-todo'
FIX003\t'line-contains-xxx'
FIX004\t'line-contains-hack'
FA100\t'future-rewritable-type-annotation'
FA102\t'future-required-type-annotation'
INT001\t'f-string-in-get-text-func-call'
INT002\t'format-in-get-text-func-call'
INT003\t'printf-in-get-text-func-call'
ISC001\t'single-line-implicit-string-concatenation'
ISC002\t'multi-line-implicit-string-concatenation'
ISC003\t'explicit-string-concatenation'
ICN001\t'unconventional-import-alias'
ICN002\t'banned-import-alias'
ICN003\t'banned-import-from'
LOG001\t'direct-logger-instantiation'
LOG002\t'invalid-get-logger-argument'
LOG004\t'log-exception-outside-except-handler'
LOG007\t'exception-without-exc-info'
LOG009\t'undocumented-warn'
LOG014\t'exc-info-outside-except-handler'
LOG015\t'root-logger-call'
G001\t'logging-string-format'
G002\t'logging-percent-format'
G003\t'logging-string-concat'
G004\t'logging-f-string'
G010\t'logging-warn'
G101\t'logging-extra-attr-clash'
G201\t'logging-exc-info'
G202\t'logging-redundant-exc-info'
INP001\t'implicit-namespace-package'
PIE790\t'unnecessary-placeholder'
PIE794\t'duplicate-class-field-definition'
PIE796\t'non-unique-enums'
PIE800\t'unnecessary-spread'
PIE804\t'unnecessary-dict-kwargs'
PIE807\t'reimplemented-container-builtin'
PIE808\t'unnecessary-range-start'
PIE810\t'multiple-starts-ends-with'
T201\t'print'
T203\t'p-print'
PYI001\t'unprefixed-type-param'
PYI002\t'complex-if-statement-in-stub'
PYI003\t'unrecognized-version-info-check'
PYI004\t'patch-version-comparison'
PYI005\t'wrong-tuple-length-version-comparison'
PYI006\t'bad-version-info-comparison'
PYI007\t'unrecognized-platform-check'
PYI008\t'unrecognized-platform-name'
PYI009\t'pass-statement-stub-body'
PYI010\t'non-empty-stub-body'
PYI011\t'typed-argument-default-in-stub'
PYI012\t'pass-in-class-body'
PYI013\t'ellipsis-in-non-empty-class-body'
PYI014\t'argument-default-in-stub'
PYI015\t'assignment-default-in-stub'
PYI016\t'duplicate-union-member'
PYI017\t'complex-assignment-in-stub'
PYI018\t'unused-private-type-var'
PYI019\t'custom-type-var-for-self'
PYI020\t'quoted-annotation-in-stub'
PYI021\t'docstring-in-stub'
PYI024\t'collections-named-tuple'
PYI025\t'unaliased-collections-abc-set-import'
PYI026\t'type-alias-without-annotation'
PYI029\t'str-or-repr-defined-in-stub'
PYI030\t'unnecessary-literal-union'
PYI032\t'any-eq-ne-annotation'
PYI033\t'type-comment-in-stub'
PYI034\t'non-self-return-type'
PYI035\t'unassigned-special-variable-in-stub'
PYI036\t'bad-exit-annotation'
PYI041\t'redundant-numeric-union'
PYI042\t'snake-case-type-alias'
PYI043\t't-suffixed-type-alias'
PYI044\t'future-annotations-in-stub'
PYI045\t'iter-method-return-iterable'
PYI046\t'unused-private-protocol'
PYI047\t'unused-private-type-alias'
PYI048\t'stub-body-multiple-statements'
PYI049\t'unused-private-typed-dict'
PYI050\t'no-return-argument-annotation-in-stub'
PYI051\t'redundant-literal-union'
PYI052\t'unannotated-assignment-in-stub'
PYI053\t'string-or-bytes-too-long'
PYI054\t'numeric-literal-too-long'
PYI055\t'unnecessary-type-union'
PYI056\t'unsupported-method-call-on-all'
PYI057\t'byte-string-usage'
PYI058\t'generator-return-from-iter-method'
PYI059\t'generic-not-last-base-class'
PYI061\t'redundant-none-literal'
PYI062\t'duplicate-literal-member'
PYI063\t'pep484-style-positional-only-parameter'
PYI064\t'redundant-final-literal'
PYI066\t'bad-version-info-order'
PT001\t'pytest-fixture-incorrect-parentheses-style'
PT002\t'pytest-fixture-positional-args'
PT003\t'pytest-extraneous-scope-function'
PT004\t'pytest-missing-fixture-name-underscore'
PT005\t'pytest-incorrect-fixture-name-underscore'
PT006\t'pytest-parametrize-names-wrong-type'
PT007\t'pytest-parametrize-values-wrong-type'
PT008\t'pytest-patch-with-lambda'
PT009\t'pytest-unittest-assertion'
PT010\t'pytest-raises-without-exception'
PT011\t'pytest-raises-too-broad'
PT012\t'pytest-raises-with-multiple-statements'
PT013\t'pytest-incorrect-pytest-import'
PT014\t'pytest-duplicate-parametrize-test-cases'
PT015\t'pytest-assert-always-false'
PT016\t'pytest-fail-without-message'
PT017\t'pytest-assert-in-except'
PT018\t'pytest-composite-assertion'
PT019\t'pytest-fixture-param-without-value'
PT020\t'pytest-deprecated-yield-fixture'
PT021\t'pytest-fixture-finalizer-callback'
PT022\t'pytest-useless-yield-fixture'
PT023\t'pytest-incorrect-mark-parentheses-style'
PT024\t'pytest-unnecessary-asyncio-mark-on-fixture'
PT025\t'pytest-erroneous-use-fixtures-on-fixture'
PT026\t'pytest-use-fixtures-without-parameters'
PT027\t'pytest-unittest-raises-assertion'
PT028\t'pytest-parameter-with-default-argument'
PT029\t'pytest-warns-without-warning'
PT030\t'pytest-warns-too-broad'
PT031\t'pytest-warns-with-multiple-statements'
Q000\t'bad-quotes-inline-string'
Q001\t'bad-quotes-multiline-string'
Q002\t'bad-quotes-docstring'
Q003\t'avoidable-escaped-quote'
Q004\t'unnecessary-escaped-quote'
RSE102\t'unnecessary-paren-on-raise-exception'
RET501\t'unnecessary-return-none'
RET502\t'implicit-return-value'
RET503\t'implicit-return'
RET504\t'unnecessary-assign'
RET505\t'superfluous-else-return'
RET506\t'superfluous-else-raise'
RET507\t'superfluous-else-continue'
RET508\t'superfluous-else-break'
SLF001\t'private-member-access'
SIM101\t'duplicate-isinstance-call'
SIM102\t'collapsible-if'
SIM103\t'needless-bool'
SIM105\t'suppressible-exception'
SIM107\t'return-in-try-except-finally'
SIM108\t'if-else-block-instead-of-if-exp'
SIM109\t'compare-with-tuple'
SIM110\t'reimplemented-builtin'
SIM112\t'uncapitalized-environment-variables'
SIM113\t'enumerate-for-loop'
SIM114\t'if-with-same-arms'
SIM115\t'open-file-with-context-handler'
SIM116\t'if-else-block-instead-of-dict-lookup'
SIM117\t'multiple-with-statements'
SIM118\t'in-dict-keys'
SIM201\t'negate-equal-op'
SIM202\t'negate-not-equal-op'
SIM208\t'double-negation'
SIM210\t'if-expr-with-true-false'
SIM211\t'if-expr-with-false-true'
SIM212\t'if-expr-with-twisted-arms'
SIM220\t'expr-and-not-expr'
SIM221\t'expr-or-not-expr'
SIM222\t'expr-or-true'
SIM223\t'expr-and-false'
SIM300\t'yoda-conditions'
SIM401\t'if-else-block-instead-of-dict-get'
SIM905\t'split-static-string'
SIM910\t'dict-get-with-none-default'
SIM911\t'zip-dict-keys-and-values'
SLOT000\t'no-slots-in-str-subclass'
SLOT001\t'no-slots-in-tuple-subclass'
SLOT002\t'no-slots-in-namedtuple-subclass'
TID251\t'banned-api'
TID252\t'relative-imports'
TID253\t'banned-module-level-imports'
TD001\t'invalid-todo-tag'
TD002\t'missing-todo-author'
TD003\t'missing-todo-link'
TD004\t'missing-todo-colon'
TD005\t'missing-todo-description'
TD006\t'invalid-todo-capitalization'
TD007\t'missing-space-after-todo-colon'
TC001\t'typing-only-first-party-import'
TC002\t'typing-only-third-party-import'
TC003\t'typing-only-standard-library-import'
TC004\t'runtime-import-in-type-checking-block'
TC005\t'empty-type-checking-block'
TC006\t'runtime-cast-value'
TC007\t'unquoted-type-alias'
TC008\t'quoted-type-alias'
TC010\t'runtime-string-union'
ARG001\t'unused-function-argument'
ARG002\t'unused-method-argument'
ARG003\t'unused-class-method-argument'
ARG004\t'unused-static-method-argument'
ARG005\t'unused-lambda-argument'
PTH100\t'os-path-abspath'
PTH101\t'os-chmod'
PTH102\t'os-mkdir'
PTH103\t'os-makedirs'
PTH104\t'os-rename'
PTH105\t'os-replace'
PTH106\t'os-rmdir'
PTH107\t'os-remove'
PTH108\t'os-unlink'
PTH109\t'os-getcwd'
PTH110\t'os-path-exists'
PTH111\t'os-path-expanduser'
PTH112\t'os-path-isdir'
PTH113\t'os-path-isfile'
PTH114\t'os-path-islink'
PTH115\t'os-readlink'
PTH116\t'os-stat'
PTH117\t'os-path-isabs'
PTH118\t'os-path-join'
PTH119\t'os-path-basename'
PTH120\t'os-path-dirname'
PTH121\t'os-path-samefile'
PTH122\t'os-path-splitext'
PTH123\t'builtin-open'
PTH124\t'py-path'
PTH201\t'path-constructor-current-directory'
PTH202\t'os-path-getsize'
PTH203\t'os-path-getatime'
PTH204\t'os-path-getmtime'
PTH205\t'os-path-getctime'
PTH206\t'os-sep-split'
PTH207\t'glob'
PTH208\t'os-listdir'
PTH210\t'invalid-pathlib-with-suffix'
PTH211\t'os-symlink'
FLY002\t'static-join-to-f-string'
I001\t'unsorted-imports'
I002\t'missing-required-import'
C901\t'complex-structure'
NPY001\t'numpy-deprecated-type-alias'
NPY002\t'numpy-legacy-random'
NPY003\t'numpy-deprecated-function'
NPY201\t'numpy2-deprecation'
N801\t'invalid-class-name'
N802\t'invalid-function-name'
N803\t'invalid-argument-name'
N804\t'invalid-first-argument-name-for-class-method'
N805\t'invalid-first-argument-name-for-method'
N806\t'non-lowercase-variable-in-function'
N807\t'dunder-function-name'
N811\t'constant-imported-as-non-constant'
N812\t'lowercase-imported-as-non-lowercase'
N813\t'camelcase-imported-as-lowercase'
N814\t'camelcase-imported-as-constant'
N815\t'mixed-case-variable-in-class-scope'
N816\t'mixed-case-variable-in-global-scope'
N817\t'camelcase-imported-as-acronym'
N818\t'error-suffix-on-exception-name'
N999\t'invalid-module-name'
PD002\t'pandas-use-of-inplace-argument'
PD003\t'pandas-use-of-dot-is-null'
PD004\t'pandas-use-of-dot-not-null'
PD007\t'pandas-use-of-dot-ix'
PD008\t'pandas-use-of-dot-at'
PD009\t'pandas-use-of-dot-iat'
PD010\t'pandas-use-of-dot-pivot-or-unstack'
PD011\t'pandas-use-of-dot-values'
PD012\t'pandas-use-of-dot-read-table'
PD013\t'pandas-use-of-dot-stack'
PD015\t'pandas-use-of-pd-merge'
PD101\t'pandas-nunique-constant-series-check'
PD901\t'pandas-df-variable-name'
PERF101\t'unnecessary-list-cast'
PERF102\t'incorrect-dict-iterator'
PERF203\t'try-except-in-loop'
PERF401\t'manual-list-comprehension'
PERF402\t'manual-list-copy'
PERF403\t'manual-dict-comprehension'
E101\t'mixed-spaces-and-tabs'
E111\t'indentation-with-invalid-multiple'
E112\t'no-indented-block'
E113\t'unexpected-indentation'
E114\t'indentation-with-invalid-multiple-comment'
E115\t'no-indented-block-comment'
E116\t'unexpected-indentation-comment'
E117\t'over-indented'
E201\t'whitespace-after-open-bracket'
E202\t'whitespace-before-close-bracket'
E203\t'whitespace-before-punctuation'
E204\t'whitespace-after-decorator'
E211\t'whitespace-before-parameters'
E221\t'multiple-spaces-before-operator'
E222\t'multiple-spaces-after-operator'
E223\t'tab-before-operator'
E224\t'tab-after-operator'
E225\t'missing-whitespace-around-operator'
E226\t'missing-whitespace-around-arithmetic-operator'
E227\t'missing-whitespace-around-bitwise-or-shift-operator'
E228\t'missing-whitespace-around-modulo-operator'
E231\t'missing-whitespace'
E241\t'multiple-spaces-after-comma'
E242\t'tab-after-comma'
E251\t'unexpected-spaces-around-keyword-parameter-equals'
E252\t'missing-whitespace-around-parameter-equals'
E261\t'too-few-spaces-before-inline-comment'
E262\t'no-space-after-inline-comment'
E265\t'no-space-after-block-comment'
E266\t'multiple-leading-hashes-for-block-comment'
E271\t'multiple-spaces-after-keyword'
E272\t'multiple-spaces-before-keyword'
E273\t'tab-after-keyword'
E274\t'tab-before-keyword'
E275\t'missing-whitespace-after-keyword'
E301\t'blank-line-between-methods'
E302\t'blank-lines-top-level'
E303\t'too-many-blank-lines'
E304\t'blank-line-after-decorator'
E305\t'blank-lines-after-function-or-class'
E306\t'blank-lines-before-nested-definition'
E401\t'multiple-imports-on-one-line'
E402\t'module-import-not-at-top-of-file'
E501\t'line-too-long'
E502\t'redundant-backslash'
E701\t'multiple-statements-on-one-line-colon'
E702\t'multiple-statements-on-one-line-semicolon'
E703\t'useless-semicolon'
E711\t'none-comparison'
E712\t'true-false-comparison'
E713\t'not-in-test'
E714\t'not-is-test'
E721\t'type-comparison'
E722\t'bare-except'
E731\t'lambda-assignment'
E741\t'ambiguous-variable-name'
E742\t'ambiguous-class-name'
E743\t'ambiguous-function-name'
E902\t'io-error'
E999\t'syntax-error'
W191\t'tab-indentation'
W291\t'trailing-whitespace'
W292\t'missing-newline-at-end-of-file'
W293\t'blank-line-with-whitespace'
W391\t'too-many-newlines-at-end-of-file'
W505\t'doc-line-too-long'
W605\t'invalid-escape-sequence'
DOC102\t'docstring-extraneous-parameter'
DOC201\t'docstring-missing-returns'
DOC202\t'docstring-extraneous-returns'
DOC402\t'docstring-missing-yields'
DOC403\t'docstring-extraneous-yields'
DOC501\t'docstring-missing-exception'
DOC502\t'docstring-extraneous-exception'
D100\t'undocumented-public-module'
D101\t'undocumented-public-class'
D102\t'undocumented-public-method'
D103\t'undocumented-public-function'
D104\t'undocumented-public-package'
D105\t'undocumented-magic-method'
D106\t'undocumented-public-nested-class'
D107\t'undocumented-public-init'
D200\t'unnecessary-multiline-docstring'
D201\t'blank-line-before-function'
D202\t'blank-line-after-function'
D203\t'incorrect-blank-line-before-class'
D204\t'incorrect-blank-line-after-class'
D205\t'missing-blank-line-after-summary'
D206\t'docstring-tab-indentation'
D207\t'under-indentation'
D208\t'over-indentation'
D209\t'new-line-after-last-paragraph'
D210\t'surrounding-whitespace'
D211\t'blank-line-before-class'
D212\t'multi-line-summary-first-line'
D213\t'multi-line-summary-second-line'
D214\t'overindented-section'
D215\t'overindented-section-underline'
D300\t'triple-single-quotes'
D301\t'escape-sequence-in-docstring'
D400\t'missing-trailing-period'
D401\t'non-imperative-mood'
D402\t'signature-in-docstring'
D403\t'first-word-uncapitalized'
D404\t'docstring-starts-with-this'
D405\t'non-capitalized-section-name'
D406\t'missing-new-line-after-section-name'
D407\t'missing-dashed-underline-after-section'
D408\t'missing-section-underline-after-name'
D409\t'mismatched-section-underline-length'
D410\t'no-blank-line-after-section'
D411\t'no-blank-line-before-section'
D412\t'blank-lines-between-header-and-content'
D413\t'missing-blank-line-after-last-section'
D414\t'empty-docstring-section'
D415\t'missing-terminal-punctuation'
D416\t'missing-section-name-colon'
D417\t'undocumented-param'
D418\t'overload-with-docstring'
D419\t'empty-docstring'
F401\t'unused-import'
F402\t'import-shadowed-by-loop-var'
F403\t'undefined-local-with-import-star'
F404\t'late-future-import'
F405\t'undefined-local-with-import-star-usage'
F406\t'undefined-local-with-nested-import-star-usage'
F407\t'future-feature-not-defined'
F501\t'percent-format-invalid-format'
F502\t'percent-format-expected-mapping'
F503\t'percent-format-expected-sequence'
F504\t'percent-format-extra-named-arguments'
F505\t'percent-format-missing-argument'
F506\t'percent-format-mixed-positional-and-named'
F507\t'percent-format-positional-count-mismatch'
F508\t'percent-format-star-requires-sequence'
F509\t'percent-format-unsupported-format-character'
F521\t'string-dot-format-invalid-format'
F522\t'string-dot-format-extra-named-arguments'
F523\t'string-dot-format-extra-positional-arguments'
F524\t'string-dot-format-missing-arguments'
F525\t'string-dot-format-mixing-automatic'
F541\t'f-string-missing-placeholders'
F601\t'multi-value-repeated-key-literal'
F602\t'multi-value-repeated-key-variable'
F621\t'expressions-in-star-assignment'
F622\t'multiple-starred-expressions'
F631\t'assert-tuple'
F632\t'is-literal'
F633\t'invalid-print-syntax'
F634\t'if-tuple'
F701\t'break-outside-loop'
F702\t'continue-outside-loop'
F704\t'yield-outside-function'
F706\t'return-outside-function'
F707\t'default-except-not-last'
F722\t'forward-annotation-syntax-error'
F811\t'redefined-while-unused'
F821\t'undefined-name'
F822\t'undefined-export'
F823\t'undefined-local'
F841\t'unused-variable'
F842\t'unused-annotation'
F901\t'raise-not-implemented'
PGH001\t'eval'
PGH002\t'deprecated-log-warn'
PGH003\t'blanket-type-ignore'
PGH004\t'blanket-noqa'
PGH005\t'invalid-mock-access'
PLC0105\t'type-name-incorrect-variance'
PLC0131\t'type-bivariance'
PLC0132\t'type-param-name-mismatch'
PLC0205\t'single-string-slots'
PLC0206\t'dict-index-missing-items'
PLC0207\t'missing-maxsplit-arg'
PLC0208\t'iteration-over-set'
PLC0414\t'useless-import-alias'
PLC0415\t'import-outside-top-level'
PLC1802\t'len-test'
PLC1901\t'compare-to-empty-string'
PLC2401\t'non-ascii-name'
PLC2403\t'non-ascii-import-name'
PLC2701\t'import-private-name'
PLC2801\t'unnecessary-dunder-call'
PLC3002\t'unnecessary-direct-lambda-call'
PLE0100\t'yield-in-init'
PLE0101\t'return-in-init'
PLE0115\t'nonlocal-and-global'
PLE0116\t'continue-in-finally'
PLE0117\t'nonlocal-without-binding'
PLE0118\t'load-before-global-declaration'
PLE0237\t'non-slot-assignment'
PLE0241\t'duplicate-bases'
PLE0302\t'unexpected-special-method-signature'
PLE0303\t'invalid-length-return-type'
PLE0304\t'invalid-bool-return-type'
PLE0305\t'invalid-index-return-type'
PLE0307\t'invalid-str-return-type'
PLE0308\t'invalid-bytes-return-type'
PLE0309\t'invalid-hash-return-type'
PLE0604\t'invalid-all-object'
PLE0605\t'invalid-all-format'
PLE0643\t'potential-index-error'
PLE0704\t'misplaced-bare-raise'
PLE1132\t'repeated-keyword-argument'
PLE1141\t'dict-iter-missing-items'
PLE1142\t'await-outside-async'
PLE1205\t'logging-too-many-args'
PLE1206\t'logging-too-few-args'
PLE1300\t'bad-string-format-character'
PLE1307\t'bad-string-format-type'
PLE1310\t'bad-str-strip-call'
PLE1507\t'invalid-envvar-value'
PLE1519\t'singledispatch-method'
PLE1520\t'singledispatchmethod-function'
PLE1700\t'yield-from-in-async-function'
PLE2502\t'bidirectional-unicode'
PLE2510\t'invalid-character-backspace'
PLE2512\t'invalid-character-sub'
PLE2513\t'invalid-character-esc'
PLE2514\t'invalid-character-nul'
PLE2515\t'invalid-character-zero-width-space'
PLE4703\t'modified-iterating-set'
PLR0124\t'comparison-with-itself'
PLR0133\t'comparison-of-constant'
PLR0202\t'no-classmethod-decorator'
PLR0203\t'no-staticmethod-decorator'
PLR0206\t'property-with-parameters'
PLR0402\t'manual-from-import'
PLR0904\t'too-many-public-methods'
PLR0911\t'too-many-return-statements'
PLR0912\t'too-many-branches'
PLR0913\t'too-many-arguments'
PLR0914\t'too-many-locals'
PLR0915\t'too-many-statements'
PLR0916\t'too-many-boolean-expressions'
PLR0917\t'too-many-positional-arguments'
PLR1701\t'repeated-isinstance-calls'
PLR1702\t'too-many-nested-blocks'
PLR1704\t'redefined-argument-from-local'
PLR1706\t'and-or-ternary'
PLR1711\t'useless-return'
PLR1714\t'repeated-equality-comparison'
PLR1716\t'boolean-chained-comparison'
PLR1722\t'sys-exit-alias'
PLR1730\t'if-stmt-min-max'
PLR1733\t'unnecessary-dict-index-lookup'
PLR1736\t'unnecessary-list-index-lookup'
PLR2004\t'magic-value-comparison'
PLR2044\t'empty-comment'
PLR5501\t'collapsible-else-if'
PLR6104\t'non-augmented-assignment'
PLR6201\t'literal-membership'
PLR6301\t'no-self-use'
PLW0108\t'unnecessary-lambda'
PLW0120\t'useless-else-on-loop'
PLW0127\t'self-assigning-variable'
PLW0128\t'redeclared-assigned-name'
PLW0129\t'assert-on-string-literal'
PLW0131\t'named-expr-without-context'
PLW0133\t'useless-exception-statement'
PLW0177\t'nan-comparison'
PLW0211\t'bad-staticmethod-argument'
PLW0244\t'redefined-slots-in-subclass'
PLW0245\t'super-without-brackets'
PLW0406\t'import-self'
PLW0602\t'global-variable-not-assigned'
PLW0603\t'global-statement'
PLW0604\t'global-at-module-level'
PLW0642\t'self-or-cls-assignment'
PLW0711\t'binary-op-exception'
PLW1501\t'bad-open-mode'
PLW1507\t'shallow-copy-environ'
PLW1508\t'invalid-envvar-default'
PLW1509\t'subprocess-popen-preexec-fn'
PLW1510\t'subprocess-run-without-check'
PLW1514\t'unspecified-encoding'
PLW1641\t'eq-without-hash'
PLW2101\t'useless-with-lock'
PLW2901\t'redefined-loop-name'
PLW3201\t'bad-dunder-method-name'
PLW3301\t'nested-min-max'
UP001\t'useless-metaclass-type'
UP003\t'type-of-primitive'
UP004\t'useless-object-inheritance'
UP005\t'deprecated-unittest-alias'
UP006\t'non-pep585-annotation'
UP007\t'non-pep604-annotation-union'
UP008\t'super-call-with-parameters'
UP009\t'utf8-encoding-declaration'
UP010\t'unnecessary-future-import'
UP011\t'lru-cache-without-parameters'
UP012\t'unnecessary-encode-utf8'
UP013\t'convert-typed-dict-functional-to-class'
UP014\t'convert-named-tuple-functional-to-class'
UP015\t'redundant-open-modes'
UP017\t'datetime-timezone-utc'
UP018\t'native-literals'
UP019\t'typing-text-str-alias'
UP020\t'open-alias'
UP021\t'replace-universal-newlines'
UP022\t'replace-stdout-stderr'
UP023\t'deprecated-c-element-tree'
UP024\t'os-error-alias'
UP025\t'unicode-kind-prefix'
UP026\t'deprecated-mock-import'
UP027\t'unpacked-list-comprehension'
UP028\t'yield-in-for-loop'
UP029\t'unnecessary-builtin-import'
UP030\t'format-literals'
UP031\t'printf-string-formatting'
UP032\t'f-string'
UP033\t'lru-cache-with-maxsize-none'
UP034\t'extraneous-parentheses'
UP035\t'deprecated-import'
UP036\t'outdated-version-block'
UP037\t'quoted-annotation'
UP038\t'non-pep604-isinstance'
UP039\t'unnecessary-class-parentheses'
UP040\t'non-pep695-type-alias'
UP041\t'timeout-error-alias'
UP042\t'replace-str-enum'
UP043\t'unnecessary-default-type-args'
UP044\t'non-pep646-unpack'
UP045\t'non-pep604-annotation-optional'
UP046\t'non-pep695-generic-class'
UP047\t'non-pep695-generic-function'
UP049\t'private-type-parameter'
UP050\t'useless-class-metaclass-type'
FURB101\t'read-whole-file'
FURB103\t'write-whole-file'
FURB105\t'print-empty-string'
FURB110\t'if-exp-instead-of-or-operator'
FURB113\t'repeated-append'
FURB116\t'f-string-number-format'
FURB118\t'reimplemented-operator'
FURB122\t'for-loop-writes'
FURB129\t'readlines-in-for'
FURB131\t'delete-full-slice'
FURB132\t'check-and-remove-from-set'
FURB136\t'if-expr-min-max'
FURB140\t'reimplemented-starmap'
FURB142\t'for-loop-set-mutations'
FURB145\t'slice-copy'
FURB148\t'unnecessary-enumerate'
FURB152\t'math-constant'
FURB154\t'repeated-global'
FURB156\t'hardcoded-string-charset'
FURB157\t'verbose-decimal-constructor'
FURB161\t'bit-count'
FURB162\t'fromisoformat-replace-z'
FURB163\t'redundant-log-base'
FURB164\t'unnecessary-from-float'
FURB166\t'int-on-sliced-str'
FURB167\t'regex-flag-alias'
FURB168\t'isinstance-type-none'
FURB169\t'type-none-comparison'
FURB171\t'single-item-membership-test'
FURB177\t'implicit-cwd'
FURB180\t'meta-class-abc-meta'
FURB181\t'hashlib-digest-hex'
FURB187\t'list-reverse-copy'
FURB188\t'slice-to-remove-prefix-or-suffix'
FURB189\t'subclass-builtin'
FURB192\t'sorted-min-max'
RUF001\t'ambiguous-unicode-character-string'
RUF002\t'ambiguous-unicode-character-docstring'
RUF003\t'ambiguous-unicode-character-comment'
RUF005\t'collection-literal-concatenation'
RUF006\t'asyncio-dangling-task'
RUF007\t'zip-instead-of-pairwise'
RUF008\t'mutable-dataclass-default'
RUF009\t'function-call-in-dataclass-default-argument'
RUF010\t'explicit-f-string-type-conversion'
RUF011\t'ruff-static-key-dict-comprehension'
RUF012\t'mutable-class-default'
RUF013\t'implicit-optional'
RUF015\t'unnecessary-iterable-allocation-for-first-element'
RUF016\t'invalid-index-type'
RUF017\t'quadratic-list-summation'
RUF018\t'assignment-in-assert'
RUF019\t'unnecessary-key-check'
RUF020\t'never-union'
RUF021\t'parenthesize-chained-operators'
RUF022\t'unsorted-dunder-all'
RUF023\t'unsorted-dunder-slots'
RUF024\t'mutable-fromkeys-value'
RUF026\t'default-factory-kwarg'
RUF027\t'missing-f-string-syntax'
RUF028\t'invalid-formatter-suppression-comment'
RUF029\t'unused-async'
RUF030\t'assert-with-print-message'
RUF031\t'incorrectly-parenthesized-tuple-in-subscript'
RUF032\t'decimal-from-float-literal'
RUF033\t'post-init-default'
RUF034\t'useless-if-else'
RUF035\t'ruff-unsafe-markup-use'
RUF036\t'none-not-at-end-of-union'
RUF037\t'unnecessary-empty-iterable-within-deque-call'
RUF038\t'redundant-bool-literal'
RUF039\t'unraw-re-pattern'
RUF040\t'invalid-assert-message-literal-argument'
RUF041\t'unnecessary-nested-literal'
RUF043\t'pytest-raises-ambiguous-pattern'
RUF045\t'implicit-class-var-in-dataclass'
RUF046\t'unnecessary-cast-to-int'
RUF047\t'needless-else'
RUF048\t'map-int-version-parsing'
RUF049\t'dataclass-enum'
RUF051\t'if-key-in-dict-del'
RUF052\t'used-dummy-variable'
RUF053\t'class-with-mixed-type-vars'
RUF054\t'indented-form-feed'
RUF055\t'unnecessary-regular-expression'
RUF056\t'falsy-dict-get-fallback'
RUF057\t'unnecessary-round'
RUF058\t'starmap-zip'
RUF059\t'unused-unpacked-variable'
RUF060\t'in-empty-collection'
RUF061\t'legacy-form-pytest-raises'
RUF063\t'access-annotations-from-class-dict'
RUF064\t'non-octal-permissions'
RUF065\t'logging-eager-conversion'
RUF100\t'unused-noqa'
RUF101\t'redirected-noqa'
RUF102\t'invalid-rule-code'
RUF200\t'invalid-pyproject-toml'
TRY002\t'raise-vanilla-class'
TRY003\t'raise-vanilla-args'
TRY004\t'type-check-without-type-error'
TRY200\t'reraise-no-cause'
TRY201\t'verbose-raise'
TRY203\t'useless-try-except'
TRY300\t'try-consider-else'
TRY301\t'raise-within-try'
TRY400\t'error-instead-of-exception'
TRY401\t'verbose-log-message'"
complete -c ruff -n "__fish_ruff_using_subcommand check" -l extend-fixable -d 'Like --fixable, but adds additional rule codes on top of those already specified' -r -f -a "ALL\t'all rules'
AIR\t'Airflow'
ERA\t'eradicate'
FAST\t'FastAPI'
YTT\t'flake8-2020'
ANN\t'flake8-annotations'
ASYNC\t'flake8-async'
S\t'flake8-bandit'
BLE\t'flake8-blind-except'
FBT\t'flake8-boolean-trap'
B\t'flake8-bugbear'
A\t'flake8-builtins'
COM\t'flake8-commas'
C4\t'flake8-comprehensions'
CPY\t'flake8-copyright'
DTZ\t'flake8-datetimez'
T10\t'flake8-debugger'
DJ\t'flake8-django'
EM\t'flake8-errmsg'
EXE\t'flake8-executable'
FIX\t'flake8-fixme'
FA\t'flake8-future-annotations'
INT\t'flake8-gettext'
ISC\t'flake8-implicit-str-concat'
ICN\t'flake8-import-conventions'
LOG\t'flake8-logging'
G\t'flake8-logging-format'
INP\t'flake8-no-pep420'
PIE\t'flake8-pie'
T20\t'flake8-print'
PYI\t'flake8-pyi'
PT\t'flake8-pytest-style'
Q\t'flake8-quotes'
RSE\t'flake8-raise'
RET\t'flake8-return'
SLF\t'flake8-self'
SIM\t'flake8-simplify'
SLOT\t'flake8-slots'
TID\t'flake8-tidy-imports'
TD\t'flake8-todos'
TC\t'flake8-type-checking'
ARG\t'flake8-unused-arguments'
PTH\t'flake8-use-pathlib'
FLY\t'flynt'
I\t'isort'
C90\t'mccabe'
NPY\t'NumPy-specific rules'
PD\t'pandas-vet'
N\t'pep8-naming'
PERF\t'Perflint'
DOC\t'pydoclint'
D\t'pydocstyle'
F\t'Pyflakes'
PGH\t'pygrep-hooks'
PL\t'Pylint'
UP\t'pyupgrade'
FURB\t'refurb'
RUF\t'Ruff-specific rules'
TRY\t'tryceratops'
AIR001\t'airflow-variable-name-task-id-mismatch'
AIR002\t'airflow-dag-no-schedule-argument'
AIR301\t'airflow3-removal'
AIR302\t'airflow3-moved-to-provider'
AIR311\t'airflow3-suggested-update'
AIR312\t'airflow3-suggested-to-move-to-provider'
ERA001\t'commented-out-code'
FAST001\t'fast-api-redundant-response-model'
FAST002\t'fast-api-non-annotated-dependency'
FAST003\t'fast-api-unused-path-parameter'
YTT101\t'sys-version-slice3'
YTT102\t'sys-version2'
YTT103\t'sys-version-cmp-str3'
YTT201\t'sys-version-info0-eq3'
YTT202\t'six-py3'
YTT203\t'sys-version-info1-cmp-int'
YTT204\t'sys-version-info-minor-cmp-int'
YTT301\t'sys-version0'
YTT302\t'sys-version-cmp-str10'
YTT303\t'sys-version-slice1'
ANN001\t'missing-type-function-argument'
ANN002\t'missing-type-args'
ANN003\t'missing-type-kwargs'
ANN101\t'missing-type-self'
ANN102\t'missing-type-cls'
ANN201\t'missing-return-type-undocumented-public-function'
ANN202\t'missing-return-type-private-function'
ANN204\t'missing-return-type-special-method'
ANN205\t'missing-return-type-static-method'
ANN206\t'missing-return-type-class-method'
ANN401\t'any-type'
ASYNC100\t'cancel-scope-no-checkpoint'
ASYNC105\t'trio-sync-call'
ASYNC109\t'async-function-with-timeout'
ASYNC110\t'async-busy-wait'
ASYNC115\t'async-zero-sleep'
ASYNC116\t'long-sleep-not-forever'
ASYNC210\t'blocking-http-call-in-async-function'
ASYNC212\t'blocking-http-call-httpx-in-async-function'
ASYNC220\t'create-subprocess-in-async-function'
ASYNC221\t'run-process-in-async-function'
ASYNC222\t'wait-for-process-in-async-function'
ASYNC230\t'blocking-open-call-in-async-function'
ASYNC240\t'blocking-path-method-in-async-function'
ASYNC250\t'blocking-input-in-async-function'
ASYNC251\t'blocking-sleep-in-async-function'
S101\t'assert'
S102\t'exec-builtin'
S103\t'bad-file-permissions'
S104\t'hardcoded-bind-all-interfaces'
S105\t'hardcoded-password-string'
S106\t'hardcoded-password-func-arg'
S107\t'hardcoded-password-default'
S108\t'hardcoded-temp-file'
S110\t'try-except-pass'
S112\t'try-except-continue'
S113\t'request-without-timeout'
S201\t'flask-debug-true'
S202\t'tarfile-unsafe-members'
S301\t'suspicious-pickle-usage'
S302\t'suspicious-marshal-usage'
S303\t'suspicious-insecure-hash-usage'
S304\t'suspicious-insecure-cipher-usage'
S305\t'suspicious-insecure-cipher-mode-usage'
S306\t'suspicious-mktemp-usage'
S307\t'suspicious-eval-usage'
S308\t'suspicious-mark-safe-usage'
S310\t'suspicious-url-open-usage'
S311\t'suspicious-non-cryptographic-random-usage'
S312\t'suspicious-telnet-usage'
S313\t'suspicious-xmlc-element-tree-usage'
S314\t'suspicious-xml-element-tree-usage'
S315\t'suspicious-xml-expat-reader-usage'
S316\t'suspicious-xml-expat-builder-usage'
S317\t'suspicious-xml-sax-usage'
S318\t'suspicious-xml-mini-dom-usage'
S319\t'suspicious-xml-pull-dom-usage'
S320\t'suspicious-xmle-tree-usage'
S321\t'suspicious-ftp-lib-usage'
S323\t'suspicious-unverified-context-usage'
S324\t'hashlib-insecure-hash-function'
S401\t'suspicious-telnetlib-import'
S402\t'suspicious-ftplib-import'
S403\t'suspicious-pickle-import'
S404\t'suspicious-subprocess-import'
S405\t'suspicious-xml-etree-import'
S406\t'suspicious-xml-sax-import'
S407\t'suspicious-xml-expat-import'
S408\t'suspicious-xml-minidom-import'
S409\t'suspicious-xml-pulldom-import'
S410\t'suspicious-lxml-import'
S411\t'suspicious-xmlrpc-import'
S412\t'suspicious-httpoxy-import'
S413\t'suspicious-pycrypto-import'
S415\t'suspicious-pyghmi-import'
S501\t'request-with-no-cert-validation'
S502\t'ssl-insecure-version'
S503\t'ssl-with-bad-defaults'
S504\t'ssl-with-no-version'
S505\t'weak-cryptographic-key'
S506\t'unsafe-yaml-load'
S507\t'ssh-no-host-key-verification'
S508\t'snmp-insecure-version'
S509\t'snmp-weak-cryptography'
S601\t'paramiko-call'
S602\t'subprocess-popen-with-shell-equals-true'
S603\t'subprocess-without-shell-equals-true'
S604\t'call-with-shell-equals-true'
S605\t'start-process-with-a-shell'
S606\t'start-process-with-no-shell'
S607\t'start-process-with-partial-path'
S608\t'hardcoded-sql-expression'
S609\t'unix-command-wildcard-injection'
S610\t'django-extra'
S611\t'django-raw-sql'
S612\t'logging-config-insecure-listen'
S701\t'jinja2-autoescape-false'
S702\t'mako-templates'
S704\t'unsafe-markup-use'
BLE001\t'blind-except'
FBT001\t'boolean-type-hint-positional-argument'
FBT002\t'boolean-default-value-positional-argument'
FBT003\t'boolean-positional-value-in-call'
B002\t'unary-prefix-increment-decrement'
B003\t'assignment-to-os-environ'
B004\t'unreliable-callable-check'
B005\t'strip-with-multi-characters'
B006\t'mutable-argument-default'
B007\t'unused-loop-control-variable'
B008\t'function-call-in-default-argument'
B009\t'get-attr-with-constant'
B010\t'set-attr-with-constant'
B011\t'assert-false'
B012\t'jump-statement-in-finally'
B013\t'redundant-tuple-in-exception-handler'
B014\t'duplicate-handler-exception'
B015\t'useless-comparison'
B016\t'raise-literal'
B017\t'assert-raises-exception'
B018\t'useless-expression'
B019\t'cached-instance-method'
B020\t'loop-variable-overrides-iterator'
B021\t'f-string-docstring'
B022\t'useless-contextlib-suppress'
B023\t'function-uses-loop-variable'
B024\t'abstract-base-class-without-abstract-method'
B025\t'duplicate-try-block-exception'
B026\t'star-arg-unpacking-after-keyword-arg'
B027\t'empty-method-without-abstract-decorator'
B028\t'no-explicit-stacklevel'
B029\t'except-with-empty-tuple'
B030\t'except-with-non-exception-classes'
B031\t'reuse-of-groupby-generator'
B032\t'unintentional-type-annotation'
B033\t'duplicate-value'
B034\t're-sub-positional-args'
B035\t'static-key-dict-comprehension'
B039\t'mutable-contextvar-default'
B901\t'return-in-generator'
B903\t'class-as-data-structure'
B904\t'raise-without-from-inside-except'
B905\t'zip-without-explicit-strict'
B909\t'loop-iterator-mutation'
B911\t'batched-without-explicit-strict'
B912\t'map-without-explicit-strict'
A001\t'builtin-variable-shadowing'
A002\t'builtin-argument-shadowing'
A003\t'builtin-attribute-shadowing'
A004\t'builtin-import-shadowing'
A005\t'stdlib-module-shadowing'
A006\t'builtin-lambda-argument-shadowing'
COM812\t'missing-trailing-comma'
COM818\t'trailing-comma-on-bare-tuple'
COM819\t'prohibited-trailing-comma'
C400\t'unnecessary-generator-list'
C401\t'unnecessary-generator-set'
C402\t'unnecessary-generator-dict'
C403\t'unnecessary-list-comprehension-set'
C404\t'unnecessary-list-comprehension-dict'
C405\t'unnecessary-literal-set'
C406\t'unnecessary-literal-dict'
C408\t'unnecessary-collection-call'
C409\t'unnecessary-literal-within-tuple-call'
C410\t'unnecessary-literal-within-list-call'
C411\t'unnecessary-list-call'
C413\t'unnecessary-call-around-sorted'
C414\t'unnecessary-double-cast-or-process'
C415\t'unnecessary-subscript-reversal'
C416\t'unnecessary-comprehension'
C417\t'unnecessary-map'
C418\t'unnecessary-literal-within-dict-call'
C419\t'unnecessary-comprehension-in-call'
C420\t'unnecessary-dict-comprehension-for-iterable'
CPY001\t'missing-copyright-notice'
DTZ001\t'call-datetime-without-tzinfo'
DTZ002\t'call-datetime-today'
DTZ003\t'call-datetime-utcnow'
DTZ004\t'call-datetime-utcfromtimestamp'
DTZ005\t'call-datetime-now-without-tzinfo'
DTZ006\t'call-datetime-fromtimestamp'
DTZ007\t'call-datetime-strptime-without-zone'
DTZ011\t'call-date-today'
DTZ012\t'call-date-fromtimestamp'
DTZ901\t'datetime-min-max'
T100\t'debugger'
DJ001\t'django-nullable-model-string-field'
DJ003\t'django-locals-in-render-function'
DJ006\t'django-exclude-with-model-form'
DJ007\t'django-all-with-model-form'
DJ008\t'django-model-without-dunder-str'
DJ012\t'django-unordered-body-content-in-model'
DJ013\t'django-non-leading-receiver-decorator'
EM101\t'raw-string-in-exception'
EM102\t'f-string-in-exception'
EM103\t'dot-format-in-exception'
EXE001\t'shebang-not-executable'
EXE002\t'shebang-missing-executable-file'
EXE003\t'shebang-missing-python'
EXE004\t'shebang-leading-whitespace'
EXE005\t'shebang-not-first-line'
FIX001\t'line-contains-fixme'
FIX002\t'line-contains-todo'
FIX003\t'line-contains-xxx'
FIX004\t'line-contains-hack'
FA100\t'future-rewritable-type-annotation'
FA102\t'future-required-type-annotation'
INT001\t'f-string-in-get-text-func-call'
INT002\t'format-in-get-text-func-call'
INT003\t'printf-in-get-text-func-call'
ISC001\t'single-line-implicit-string-concatenation'
ISC002\t'multi-line-implicit-string-concatenation'
ISC003\t'explicit-string-concatenation'
ICN001\t'unconventional-import-alias'
ICN002\t'banned-import-alias'
ICN003\t'banned-import-from'
LOG001\t'direct-logger-instantiation'
LOG002\t'invalid-get-logger-argument'
LOG004\t'log-exception-outside-except-handler'
LOG007\t'exception-without-exc-info'
LOG009\t'undocumented-warn'
LOG014\t'exc-info-outside-except-handler'
LOG015\t'root-logger-call'
G001\t'logging-string-format'
G002\t'logging-percent-format'
G003\t'logging-string-concat'
G004\t'logging-f-string'
G010\t'logging-warn'
G101\t'logging-extra-attr-clash'
G201\t'logging-exc-info'
G202\t'logging-redundant-exc-info'
INP001\t'implicit-namespace-package'
PIE790\t'unnecessary-placeholder'
PIE794\t'duplicate-class-field-definition'
PIE796\t'non-unique-enums'
PIE800\t'unnecessary-spread'
PIE804\t'unnecessary-dict-kwargs'
PIE807\t'reimplemented-container-builtin'
PIE808\t'unnecessary-range-start'
PIE810\t'multiple-starts-ends-with'
T201\t'print'
T203\t'p-print'
PYI001\t'unprefixed-type-param'
PYI002\t'complex-if-statement-in-stub'
PYI003\t'unrecognized-version-info-check'
PYI004\t'patch-version-comparison'
PYI005\t'wrong-tuple-length-version-comparison'
PYI006\t'bad-version-info-comparison'
PYI007\t'unrecognized-platform-check'
PYI008\t'unrecognized-platform-name'
PYI009\t'pass-statement-stub-body'
PYI010\t'non-empty-stub-body'
PYI011\t'typed-argument-default-in-stub'
PYI012\t'pass-in-class-body'
PYI013\t'ellipsis-in-non-empty-class-body'
PYI014\t'argument-default-in-stub'
PYI015\t'assignment-default-in-stub'
PYI016\t'duplicate-union-member'
PYI017\t'complex-assignment-in-stub'
PYI018\t'unused-private-type-var'
PYI019\t'custom-type-var-for-self'
PYI020\t'quoted-annotation-in-stub'
PYI021\t'docstring-in-stub'
PYI024\t'collections-named-tuple'
PYI025\t'unaliased-collections-abc-set-import'
PYI026\t'type-alias-without-annotation'
PYI029\t'str-or-repr-defined-in-stub'
PYI030\t'unnecessary-literal-union'
PYI032\t'any-eq-ne-annotation'
PYI033\t'type-comment-in-stub'
PYI034\t'non-self-return-type'
PYI035\t'unassigned-special-variable-in-stub'
PYI036\t'bad-exit-annotation'
PYI041\t'redundant-numeric-union'
PYI042\t'snake-case-type-alias'
PYI043\t't-suffixed-type-alias'
PYI044\t'future-annotations-in-stub'
PYI045\t'iter-method-return-iterable'
PYI046\t'unused-private-protocol'
PYI047\t'unused-private-type-alias'
PYI048\t'stub-body-multiple-statements'
PYI049\t'unused-private-typed-dict'
PYI050\t'no-return-argument-annotation-in-stub'
PYI051\t'redundant-literal-union'
PYI052\t'unannotated-assignment-in-stub'
PYI053\t'string-or-bytes-too-long'
PYI054\t'numeric-literal-too-long'
PYI055\t'unnecessary-type-union'
PYI056\t'unsupported-method-call-on-all'
PYI057\t'byte-string-usage'
PYI058\t'generator-return-from-iter-method'
PYI059\t'generic-not-last-base-class'
PYI061\t'redundant-none-literal'
PYI062\t'duplicate-literal-member'
PYI063\t'pep484-style-positional-only-parameter'
PYI064\t'redundant-final-literal'
PYI066\t'bad-version-info-order'
PT001\t'pytest-fixture-incorrect-parentheses-style'
PT002\t'pytest-fixture-positional-args'
PT003\t'pytest-extraneous-scope-function'
PT004\t'pytest-missing-fixture-name-underscore'
PT005\t'pytest-incorrect-fixture-name-underscore'
PT006\t'pytest-parametrize-names-wrong-type'
PT007\t'pytest-parametrize-values-wrong-type'
PT008\t'pytest-patch-with-lambda'
PT009\t'pytest-unittest-assertion'
PT010\t'pytest-raises-without-exception'
PT011\t'pytest-raises-too-broad'
PT012\t'pytest-raises-with-multiple-statements'
PT013\t'pytest-incorrect-pytest-import'
PT014\t'pytest-duplicate-parametrize-test-cases'
PT015\t'pytest-assert-always-false'
PT016\t'pytest-fail-without-message'
PT017\t'pytest-assert-in-except'
PT018\t'pytest-composite-assertion'
PT019\t'pytest-fixture-param-without-value'
PT020\t'pytest-deprecated-yield-fixture'
PT021\t'pytest-fixture-finalizer-callback'
PT022\t'pytest-useless-yield-fixture'
PT023\t'pytest-incorrect-mark-parentheses-style'
PT024\t'pytest-unnecessary-asyncio-mark-on-fixture'
PT025\t'pytest-erroneous-use-fixtures-on-fixture'
PT026\t'pytest-use-fixtures-without-parameters'
PT027\t'pytest-unittest-raises-assertion'
PT028\t'pytest-parameter-with-default-argument'
PT029\t'pytest-warns-without-warning'
PT030\t'pytest-warns-too-broad'
PT031\t'pytest-warns-with-multiple-statements'
Q000\t'bad-quotes-inline-string'
Q001\t'bad-quotes-multiline-string'
Q002\t'bad-quotes-docstring'
Q003\t'avoidable-escaped-quote'
Q004\t'unnecessary-escaped-quote'
RSE102\t'unnecessary-paren-on-raise-exception'
RET501\t'unnecessary-return-none'
RET502\t'implicit-return-value'
RET503\t'implicit-return'
RET504\t'unnecessary-assign'
RET505\t'superfluous-else-return'
RET506\t'superfluous-else-raise'
RET507\t'superfluous-else-continue'
RET508\t'superfluous-else-break'
SLF001\t'private-member-access'
SIM101\t'duplicate-isinstance-call'
SIM102\t'collapsible-if'
SIM103\t'needless-bool'
SIM105\t'suppressible-exception'
SIM107\t'return-in-try-except-finally'
SIM108\t'if-else-block-instead-of-if-exp'
SIM109\t'compare-with-tuple'
SIM110\t'reimplemented-builtin'
SIM112\t'uncapitalized-environment-variables'
SIM113\t'enumerate-for-loop'
SIM114\t'if-with-same-arms'
SIM115\t'open-file-with-context-handler'
SIM116\t'if-else-block-instead-of-dict-lookup'
SIM117\t'multiple-with-statements'
SIM118\t'in-dict-keys'
SIM201\t'negate-equal-op'
SIM202\t'negate-not-equal-op'
SIM208\t'double-negation'
SIM210\t'if-expr-with-true-false'
SIM211\t'if-expr-with-false-true'
SIM212\t'if-expr-with-twisted-arms'
SIM220\t'expr-and-not-expr'
SIM221\t'expr-or-not-expr'
SIM222\t'expr-or-true'
SIM223\t'expr-and-false'
SIM300\t'yoda-conditions'
SIM401\t'if-else-block-instead-of-dict-get'
SIM905\t'split-static-string'
SIM910\t'dict-get-with-none-default'
SIM911\t'zip-dict-keys-and-values'
SLOT000\t'no-slots-in-str-subclass'
SLOT001\t'no-slots-in-tuple-subclass'
SLOT002\t'no-slots-in-namedtuple-subclass'
TID251\t'banned-api'
TID252\t'relative-imports'
TID253\t'banned-module-level-imports'
TD001\t'invalid-todo-tag'
TD002\t'missing-todo-author'
TD003\t'missing-todo-link'
TD004\t'missing-todo-colon'
TD005\t'missing-todo-description'
TD006\t'invalid-todo-capitalization'
TD007\t'missing-space-after-todo-colon'
TC001\t'typing-only-first-party-import'
TC002\t'typing-only-third-party-import'
TC003\t'typing-only-standard-library-import'
TC004\t'runtime-import-in-type-checking-block'
TC005\t'empty-type-checking-block'
TC006\t'runtime-cast-value'
TC007\t'unquoted-type-alias'
TC008\t'quoted-type-alias'
TC010\t'runtime-string-union'
ARG001\t'unused-function-argument'
ARG002\t'unused-method-argument'
ARG003\t'unused-class-method-argument'
ARG004\t'unused-static-method-argument'
ARG005\t'unused-lambda-argument'
PTH100\t'os-path-abspath'
PTH101\t'os-chmod'
PTH102\t'os-mkdir'
PTH103\t'os-makedirs'
PTH104\t'os-rename'
PTH105\t'os-replace'
PTH106\t'os-rmdir'
PTH107\t'os-remove'
PTH108\t'os-unlink'
PTH109\t'os-getcwd'
PTH110\t'os-path-exists'
PTH111\t'os-path-expanduser'
PTH112\t'os-path-isdir'
PTH113\t'os-path-isfile'
PTH114\t'os-path-islink'
PTH115\t'os-readlink'
PTH116\t'os-stat'
PTH117\t'os-path-isabs'
PTH118\t'os-path-join'
PTH119\t'os-path-basename'
PTH120\t'os-path-dirname'
PTH121\t'os-path-samefile'
PTH122\t'os-path-splitext'
PTH123\t'builtin-open'
PTH124\t'py-path'
PTH201\t'path-constructor-current-directory'
PTH202\t'os-path-getsize'
PTH203\t'os-path-getatime'
PTH204\t'os-path-getmtime'
PTH205\t'os-path-getctime'
PTH206\t'os-sep-split'
PTH207\t'glob'
PTH208\t'os-listdir'
PTH210\t'invalid-pathlib-with-suffix'
PTH211\t'os-symlink'
FLY002\t'static-join-to-f-string'
I001\t'unsorted-imports'
I002\t'missing-required-import'
C901\t'complex-structure'
NPY001\t'numpy-deprecated-type-alias'
NPY002\t'numpy-legacy-random'
NPY003\t'numpy-deprecated-function'
NPY201\t'numpy2-deprecation'
N801\t'invalid-class-name'
N802\t'invalid-function-name'
N803\t'invalid-argument-name'
N804\t'invalid-first-argument-name-for-class-method'
N805\t'invalid-first-argument-name-for-method'
N806\t'non-lowercase-variable-in-function'
N807\t'dunder-function-name'
N811\t'constant-imported-as-non-constant'
N812\t'lowercase-imported-as-non-lowercase'
N813\t'camelcase-imported-as-lowercase'
N814\t'camelcase-imported-as-constant'
N815\t'mixed-case-variable-in-class-scope'
N816\t'mixed-case-variable-in-global-scope'
N817\t'camelcase-imported-as-acronym'
N818\t'error-suffix-on-exception-name'
N999\t'invalid-module-name'
PD002\t'pandas-use-of-inplace-argument'
PD003\t'pandas-use-of-dot-is-null'
PD004\t'pandas-use-of-dot-not-null'
PD007\t'pandas-use-of-dot-ix'
PD008\t'pandas-use-of-dot-at'
PD009\t'pandas-use-of-dot-iat'
PD010\t'pandas-use-of-dot-pivot-or-unstack'
PD011\t'pandas-use-of-dot-values'
PD012\t'pandas-use-of-dot-read-table'
PD013\t'pandas-use-of-dot-stack'
PD015\t'pandas-use-of-pd-merge'
PD101\t'pandas-nunique-constant-series-check'
PD901\t'pandas-df-variable-name'
PERF101\t'unnecessary-list-cast'
PERF102\t'incorrect-dict-iterator'
PERF203\t'try-except-in-loop'
PERF401\t'manual-list-comprehension'
PERF402\t'manual-list-copy'
PERF403\t'manual-dict-comprehension'
E101\t'mixed-spaces-and-tabs'
E111\t'indentation-with-invalid-multiple'
E112\t'no-indented-block'
E113\t'unexpected-indentation'
E114\t'indentation-with-invalid-multiple-comment'
E115\t'no-indented-block-comment'
E116\t'unexpected-indentation-comment'
E117\t'over-indented'
E201\t'whitespace-after-open-bracket'
E202\t'whitespace-before-close-bracket'
E203\t'whitespace-before-punctuation'
E204\t'whitespace-after-decorator'
E211\t'whitespace-before-parameters'
E221\t'multiple-spaces-before-operator'
E222\t'multiple-spaces-after-operator'
E223\t'tab-before-operator'
E224\t'tab-after-operator'
E225\t'missing-whitespace-around-operator'
E226\t'missing-whitespace-around-arithmetic-operator'
E227\t'missing-whitespace-around-bitwise-or-shift-operator'
E228\t'missing-whitespace-around-modulo-operator'
E231\t'missing-whitespace'
E241\t'multiple-spaces-after-comma'
E242\t'tab-after-comma'
E251\t'unexpected-spaces-around-keyword-parameter-equals'
E252\t'missing-whitespace-around-parameter-equals'
E261\t'too-few-spaces-before-inline-comment'
E262\t'no-space-after-inline-comment'
E265\t'no-space-after-block-comment'
E266\t'multiple-leading-hashes-for-block-comment'
E271\t'multiple-spaces-after-keyword'
E272\t'multiple-spaces-before-keyword'
E273\t'tab-after-keyword'
E274\t'tab-before-keyword'
E275\t'missing-whitespace-after-keyword'
E301\t'blank-line-between-methods'
E302\t'blank-lines-top-level'
E303\t'too-many-blank-lines'
E304\t'blank-line-after-decorator'
E305\t'blank-lines-after-function-or-class'
E306\t'blank-lines-before-nested-definition'
E401\t'multiple-imports-on-one-line'
E402\t'module-import-not-at-top-of-file'
E501\t'line-too-long'
E502\t'redundant-backslash'
E701\t'multiple-statements-on-one-line-colon'
E702\t'multiple-statements-on-one-line-semicolon'
E703\t'useless-semicolon'
E711\t'none-comparison'
E712\t'true-false-comparison'
E713\t'not-in-test'
E714\t'not-is-test'
E721\t'type-comparison'
E722\t'bare-except'
E731\t'lambda-assignment'
E741\t'ambiguous-variable-name'
E742\t'ambiguous-class-name'
E743\t'ambiguous-function-name'
E902\t'io-error'
E999\t'syntax-error'
W191\t'tab-indentation'
W291\t'trailing-whitespace'
W292\t'missing-newline-at-end-of-file'
W293\t'blank-line-with-whitespace'
W391\t'too-many-newlines-at-end-of-file'
W505\t'doc-line-too-long'
W605\t'invalid-escape-sequence'
DOC102\t'docstring-extraneous-parameter'
DOC201\t'docstring-missing-returns'
DOC202\t'docstring-extraneous-returns'
DOC402\t'docstring-missing-yields'
DOC403\t'docstring-extraneous-yields'
DOC501\t'docstring-missing-exception'
DOC502\t'docstring-extraneous-exception'
D100\t'undocumented-public-module'
D101\t'undocumented-public-class'
D102\t'undocumented-public-method'
D103\t'undocumented-public-function'
D104\t'undocumented-public-package'
D105\t'undocumented-magic-method'
D106\t'undocumented-public-nested-class'
D107\t'undocumented-public-init'
D200\t'unnecessary-multiline-docstring'
D201\t'blank-line-before-function'
D202\t'blank-line-after-function'
D203\t'incorrect-blank-line-before-class'
D204\t'incorrect-blank-line-after-class'
D205\t'missing-blank-line-after-summary'
D206\t'docstring-tab-indentation'
D207\t'under-indentation'
D208\t'over-indentation'
D209\t'new-line-after-last-paragraph'
D210\t'surrounding-whitespace'
D211\t'blank-line-before-class'
D212\t'multi-line-summary-first-line'
D213\t'multi-line-summary-second-line'
D214\t'overindented-section'
D215\t'overindented-section-underline'
D300\t'triple-single-quotes'
D301\t'escape-sequence-in-docstring'
D400\t'missing-trailing-period'
D401\t'non-imperative-mood'
D402\t'signature-in-docstring'
D403\t'first-word-uncapitalized'
D404\t'docstring-starts-with-this'
D405\t'non-capitalized-section-name'
D406\t'missing-new-line-after-section-name'
D407\t'missing-dashed-underline-after-section'
D408\t'missing-section-underline-after-name'
D409\t'mismatched-section-underline-length'
D410\t'no-blank-line-after-section'
D411\t'no-blank-line-before-section'
D412\t'blank-lines-between-header-and-content'
D413\t'missing-blank-line-after-last-section'
D414\t'empty-docstring-section'
D415\t'missing-terminal-punctuation'
D416\t'missing-section-name-colon'
D417\t'undocumented-param'
D418\t'overload-with-docstring'
D419\t'empty-docstring'
F401\t'unused-import'
F402\t'import-shadowed-by-loop-var'
F403\t'undefined-local-with-import-star'
F404\t'late-future-import'
F405\t'undefined-local-with-import-star-usage'
F406\t'undefined-local-with-nested-import-star-usage'
F407\t'future-feature-not-defined'
F501\t'percent-format-invalid-format'
F502\t'percent-format-expected-mapping'
F503\t'percent-format-expected-sequence'
F504\t'percent-format-extra-named-arguments'
F505\t'percent-format-missing-argument'
F506\t'percent-format-mixed-positional-and-named'
F507\t'percent-format-positional-count-mismatch'
F508\t'percent-format-star-requires-sequence'
F509\t'percent-format-unsupported-format-character'
F521\t'string-dot-format-invalid-format'
F522\t'string-dot-format-extra-named-arguments'
F523\t'string-dot-format-extra-positional-arguments'
F524\t'string-dot-format-missing-arguments'
F525\t'string-dot-format-mixing-automatic'
F541\t'f-string-missing-placeholders'
F601\t'multi-value-repeated-key-literal'
F602\t'multi-value-repeated-key-variable'
F621\t'expressions-in-star-assignment'
F622\t'multiple-starred-expressions'
F631\t'assert-tuple'
F632\t'is-literal'
F633\t'invalid-print-syntax'
F634\t'if-tuple'
F701\t'break-outside-loop'
F702\t'continue-outside-loop'
F704\t'yield-outside-function'
F706\t'return-outside-function'
F707\t'default-except-not-last'
F722\t'forward-annotation-syntax-error'
F811\t'redefined-while-unused'
F821\t'undefined-name'
F822\t'undefined-export'
F823\t'undefined-local'
F841\t'unused-variable'
F842\t'unused-annotation'
F901\t'raise-not-implemented'
PGH001\t'eval'
PGH002\t'deprecated-log-warn'
PGH003\t'blanket-type-ignore'
PGH004\t'blanket-noqa'
PGH005\t'invalid-mock-access'
PLC0105\t'type-name-incorrect-variance'
PLC0131\t'type-bivariance'
PLC0132\t'type-param-name-mismatch'
PLC0205\t'single-string-slots'
PLC0206\t'dict-index-missing-items'
PLC0207\t'missing-maxsplit-arg'
PLC0208\t'iteration-over-set'
PLC0414\t'useless-import-alias'
PLC0415\t'import-outside-top-level'
PLC1802\t'len-test'
PLC1901\t'compare-to-empty-string'
PLC2401\t'non-ascii-name'
PLC2403\t'non-ascii-import-name'
PLC2701\t'import-private-name'
PLC2801\t'unnecessary-dunder-call'
PLC3002\t'unnecessary-direct-lambda-call'
PLE0100\t'yield-in-init'
PLE0101\t'return-in-init'
PLE0115\t'nonlocal-and-global'
PLE0116\t'continue-in-finally'
PLE0117\t'nonlocal-without-binding'
PLE0118\t'load-before-global-declaration'
PLE0237\t'non-slot-assignment'
PLE0241\t'duplicate-bases'
PLE0302\t'unexpected-special-method-signature'
PLE0303\t'invalid-length-return-type'
PLE0304\t'invalid-bool-return-type'
PLE0305\t'invalid-index-return-type'
PLE0307\t'invalid-str-return-type'
PLE0308\t'invalid-bytes-return-type'
PLE0309\t'invalid-hash-return-type'
PLE0604\t'invalid-all-object'
PLE0605\t'invalid-all-format'
PLE0643\t'potential-index-error'
PLE0704\t'misplaced-bare-raise'
PLE1132\t'repeated-keyword-argument'
PLE1141\t'dict-iter-missing-items'
PLE1142\t'await-outside-async'
PLE1205\t'logging-too-many-args'
PLE1206\t'logging-too-few-args'
PLE1300\t'bad-string-format-character'
PLE1307\t'bad-string-format-type'
PLE1310\t'bad-str-strip-call'
PLE1507\t'invalid-envvar-value'
PLE1519\t'singledispatch-method'
PLE1520\t'singledispatchmethod-function'
PLE1700\t'yield-from-in-async-function'
PLE2502\t'bidirectional-unicode'
PLE2510\t'invalid-character-backspace'
PLE2512\t'invalid-character-sub'
PLE2513\t'invalid-character-esc'
PLE2514\t'invalid-character-nul'
PLE2515\t'invalid-character-zero-width-space'
PLE4703\t'modified-iterating-set'
PLR0124\t'comparison-with-itself'
PLR0133\t'comparison-of-constant'
PLR0202\t'no-classmethod-decorator'
PLR0203\t'no-staticmethod-decorator'
PLR0206\t'property-with-parameters'
PLR0402\t'manual-from-import'
PLR0904\t'too-many-public-methods'
PLR0911\t'too-many-return-statements'
PLR0912\t'too-many-branches'
PLR0913\t'too-many-arguments'
PLR0914\t'too-many-locals'
PLR0915\t'too-many-statements'
PLR0916\t'too-many-boolean-expressions'
PLR0917\t'too-many-positional-arguments'
PLR1701\t'repeated-isinstance-calls'
PLR1702\t'too-many-nested-blocks'
PLR1704\t'redefined-argument-from-local'
PLR1706\t'and-or-ternary'
PLR1711\t'useless-return'
PLR1714\t'repeated-equality-comparison'
PLR1716\t'boolean-chained-comparison'
PLR1722\t'sys-exit-alias'
PLR1730\t'if-stmt-min-max'
PLR1733\t'unnecessary-dict-index-lookup'
PLR1736\t'unnecessary-list-index-lookup'
PLR2004\t'magic-value-comparison'
PLR2044\t'empty-comment'
PLR5501\t'collapsible-else-if'
PLR6104\t'non-augmented-assignment'
PLR6201\t'literal-membership'
PLR6301\t'no-self-use'
PLW0108\t'unnecessary-lambda'
PLW0120\t'useless-else-on-loop'
PLW0127\t'self-assigning-variable'
PLW0128\t'redeclared-assigned-name'
PLW0129\t'assert-on-string-literal'
PLW0131\t'named-expr-without-context'
PLW0133\t'useless-exception-statement'
PLW0177\t'nan-comparison'
PLW0211\t'bad-staticmethod-argument'
PLW0244\t'redefined-slots-in-subclass'
PLW0245\t'super-without-brackets'
PLW0406\t'import-self'
PLW0602\t'global-variable-not-assigned'
PLW0603\t'global-statement'
PLW0604\t'global-at-module-level'
PLW0642\t'self-or-cls-assignment'
PLW0711\t'binary-op-exception'
PLW1501\t'bad-open-mode'
PLW1507\t'shallow-copy-environ'
PLW1508\t'invalid-envvar-default'
PLW1509\t'subprocess-popen-preexec-fn'
PLW1510\t'subprocess-run-without-check'
PLW1514\t'unspecified-encoding'
PLW1641\t'eq-without-hash'
PLW2101\t'useless-with-lock'
PLW2901\t'redefined-loop-name'
PLW3201\t'bad-dunder-method-name'
PLW3301\t'nested-min-max'
UP001\t'useless-metaclass-type'
UP003\t'type-of-primitive'
UP004\t'useless-object-inheritance'
UP005\t'deprecated-unittest-alias'
UP006\t'non-pep585-annotation'
UP007\t'non-pep604-annotation-union'
UP008\t'super-call-with-parameters'
UP009\t'utf8-encoding-declaration'
UP010\t'unnecessary-future-import'
UP011\t'lru-cache-without-parameters'
UP012\t'unnecessary-encode-utf8'
UP013\t'convert-typed-dict-functional-to-class'
UP014\t'convert-named-tuple-functional-to-class'
UP015\t'redundant-open-modes'
UP017\t'datetime-timezone-utc'
UP018\t'native-literals'
UP019\t'typing-text-str-alias'
UP020\t'open-alias'
UP021\t'replace-universal-newlines'
UP022\t'replace-stdout-stderr'
UP023\t'deprecated-c-element-tree'
UP024\t'os-error-alias'
UP025\t'unicode-kind-prefix'
UP026\t'deprecated-mock-import'
UP027\t'unpacked-list-comprehension'
UP028\t'yield-in-for-loop'
UP029\t'unnecessary-builtin-import'
UP030\t'format-literals'
UP031\t'printf-string-formatting'
UP032\t'f-string'
UP033\t'lru-cache-with-maxsize-none'
UP034\t'extraneous-parentheses'
UP035\t'deprecated-import'
UP036\t'outdated-version-block'
UP037\t'quoted-annotation'
UP038\t'non-pep604-isinstance'
UP039\t'unnecessary-class-parentheses'
UP040\t'non-pep695-type-alias'
UP041\t'timeout-error-alias'
UP042\t'replace-str-enum'
UP043\t'unnecessary-default-type-args'
UP044\t'non-pep646-unpack'
UP045\t'non-pep604-annotation-optional'
UP046\t'non-pep695-generic-class'
UP047\t'non-pep695-generic-function'
UP049\t'private-type-parameter'
UP050\t'useless-class-metaclass-type'
FURB101\t'read-whole-file'
FURB103\t'write-whole-file'
FURB105\t'print-empty-string'
FURB110\t'if-exp-instead-of-or-operator'
FURB113\t'repeated-append'
FURB116\t'f-string-number-format'
FURB118\t'reimplemented-operator'
FURB122\t'for-loop-writes'
FURB129\t'readlines-in-for'
FURB131\t'delete-full-slice'
FURB132\t'check-and-remove-from-set'
FURB136\t'if-expr-min-max'
FURB140\t'reimplemented-starmap'
FURB142\t'for-loop-set-mutations'
FURB145\t'slice-copy'
FURB148\t'unnecessary-enumerate'
FURB152\t'math-constant'
FURB154\t'repeated-global'
FURB156\t'hardcoded-string-charset'
FURB157\t'verbose-decimal-constructor'
FURB161\t'bit-count'
FURB162\t'fromisoformat-replace-z'
FURB163\t'redundant-log-base'
FURB164\t'unnecessary-from-float'
FURB166\t'int-on-sliced-str'
FURB167\t'regex-flag-alias'
FURB168\t'isinstance-type-none'
FURB169\t'type-none-comparison'
FURB171\t'single-item-membership-test'
FURB177\t'implicit-cwd'
FURB180\t'meta-class-abc-meta'
FURB181\t'hashlib-digest-hex'
FURB187\t'list-reverse-copy'
FURB188\t'slice-to-remove-prefix-or-suffix'
FURB189\t'subclass-builtin'
FURB192\t'sorted-min-max'
RUF001\t'ambiguous-unicode-character-string'
RUF002\t'ambiguous-unicode-character-docstring'
RUF003\t'ambiguous-unicode-character-comment'
RUF005\t'collection-literal-concatenation'
RUF006\t'asyncio-dangling-task'
RUF007\t'zip-instead-of-pairwise'
RUF008\t'mutable-dataclass-default'
RUF009\t'function-call-in-dataclass-default-argument'
RUF010\t'explicit-f-string-type-conversion'
RUF011\t'ruff-static-key-dict-comprehension'
RUF012\t'mutable-class-default'
RUF013\t'implicit-optional'
RUF015\t'unnecessary-iterable-allocation-for-first-element'
RUF016\t'invalid-index-type'
RUF017\t'quadratic-list-summation'
RUF018\t'assignment-in-assert'
RUF019\t'unnecessary-key-check'
RUF020\t'never-union'
RUF021\t'parenthesize-chained-operators'
RUF022\t'unsorted-dunder-all'
RUF023\t'unsorted-dunder-slots'
RUF024\t'mutable-fromkeys-value'
RUF026\t'default-factory-kwarg'
RUF027\t'missing-f-string-syntax'
RUF028\t'invalid-formatter-suppression-comment'
RUF029\t'unused-async'
RUF030\t'assert-with-print-message'
RUF031\t'incorrectly-parenthesized-tuple-in-subscript'
RUF032\t'decimal-from-float-literal'
RUF033\t'post-init-default'
RUF034\t'useless-if-else'
RUF035\t'ruff-unsafe-markup-use'
RUF036\t'none-not-at-end-of-union'
RUF037\t'unnecessary-empty-iterable-within-deque-call'
RUF038\t'redundant-bool-literal'
RUF039\t'unraw-re-pattern'
RUF040\t'invalid-assert-message-literal-argument'
RUF041\t'unnecessary-nested-literal'
RUF043\t'pytest-raises-ambiguous-pattern'
RUF045\t'implicit-class-var-in-dataclass'
RUF046\t'unnecessary-cast-to-int'
RUF047\t'needless-else'
RUF048\t'map-int-version-parsing'
RUF049\t'dataclass-enum'
RUF051\t'if-key-in-dict-del'
RUF052\t'used-dummy-variable'
RUF053\t'class-with-mixed-type-vars'
RUF054\t'indented-form-feed'
RUF055\t'unnecessary-regular-expression'
RUF056\t'falsy-dict-get-fallback'
RUF057\t'unnecessary-round'
RUF058\t'starmap-zip'
RUF059\t'unused-unpacked-variable'
RUF060\t'in-empty-collection'
RUF061\t'legacy-form-pytest-raises'
RUF063\t'access-annotations-from-class-dict'
RUF064\t'non-octal-permissions'
RUF065\t'logging-eager-conversion'
RUF100\t'unused-noqa'
RUF101\t'redirected-noqa'
RUF102\t'invalid-rule-code'
RUF200\t'invalid-pyproject-toml'
TRY002\t'raise-vanilla-class'
TRY003\t'raise-vanilla-args'
TRY004\t'type-check-without-type-error'
TRY200\t'reraise-no-cause'
TRY201\t'verbose-raise'
TRY203\t'useless-try-except'
TRY300\t'try-consider-else'
TRY301\t'raise-within-try'
TRY400\t'error-instead-of-exception'
TRY401\t'verbose-log-message'"
complete -c ruff -n "__fish_ruff_using_subcommand check" -l extend-unfixable -d 'Like --unfixable. (Deprecated: You can just use --unfixable instead.)' -r -f -a "ALL\t'all rules'
AIR\t'Airflow'
ERA\t'eradicate'
FAST\t'FastAPI'
YTT\t'flake8-2020'
ANN\t'flake8-annotations'
ASYNC\t'flake8-async'
S\t'flake8-bandit'
BLE\t'flake8-blind-except'
FBT\t'flake8-boolean-trap'
B\t'flake8-bugbear'
A\t'flake8-builtins'
COM\t'flake8-commas'
C4\t'flake8-comprehensions'
CPY\t'flake8-copyright'
DTZ\t'flake8-datetimez'
T10\t'flake8-debugger'
DJ\t'flake8-django'
EM\t'flake8-errmsg'
EXE\t'flake8-executable'
FIX\t'flake8-fixme'
FA\t'flake8-future-annotations'
INT\t'flake8-gettext'
ISC\t'flake8-implicit-str-concat'
ICN\t'flake8-import-conventions'
LOG\t'flake8-logging'
G\t'flake8-logging-format'
INP\t'flake8-no-pep420'
PIE\t'flake8-pie'
T20\t'flake8-print'
PYI\t'flake8-pyi'
PT\t'flake8-pytest-style'
Q\t'flake8-quotes'
RSE\t'flake8-raise'
RET\t'flake8-return'
SLF\t'flake8-self'
SIM\t'flake8-simplify'
SLOT\t'flake8-slots'
TID\t'flake8-tidy-imports'
TD\t'flake8-todos'
TC\t'flake8-type-checking'
ARG\t'flake8-unused-arguments'
PTH\t'flake8-use-pathlib'
FLY\t'flynt'
I\t'isort'
C90\t'mccabe'
NPY\t'NumPy-specific rules'
PD\t'pandas-vet'
N\t'pep8-naming'
PERF\t'Perflint'
DOC\t'pydoclint'
D\t'pydocstyle'
F\t'Pyflakes'
PGH\t'pygrep-hooks'
PL\t'Pylint'
UP\t'pyupgrade'
FURB\t'refurb'
RUF\t'Ruff-specific rules'
TRY\t'tryceratops'
AIR001\t'airflow-variable-name-task-id-mismatch'
AIR002\t'airflow-dag-no-schedule-argument'
AIR301\t'airflow3-removal'
AIR302\t'airflow3-moved-to-provider'
AIR311\t'airflow3-suggested-update'
AIR312\t'airflow3-suggested-to-move-to-provider'
ERA001\t'commented-out-code'
FAST001\t'fast-api-redundant-response-model'
FAST002\t'fast-api-non-annotated-dependency'
FAST003\t'fast-api-unused-path-parameter'
YTT101\t'sys-version-slice3'
YTT102\t'sys-version2'
YTT103\t'sys-version-cmp-str3'
YTT201\t'sys-version-info0-eq3'
YTT202\t'six-py3'
YTT203\t'sys-version-info1-cmp-int'
YTT204\t'sys-version-info-minor-cmp-int'
YTT301\t'sys-version0'
YTT302\t'sys-version-cmp-str10'
YTT303\t'sys-version-slice1'
ANN001\t'missing-type-function-argument'
ANN002\t'missing-type-args'
ANN003\t'missing-type-kwargs'
ANN101\t'missing-type-self'
ANN102\t'missing-type-cls'
ANN201\t'missing-return-type-undocumented-public-function'
ANN202\t'missing-return-type-private-function'
ANN204\t'missing-return-type-special-method'
ANN205\t'missing-return-type-static-method'
ANN206\t'missing-return-type-class-method'
ANN401\t'any-type'
ASYNC100\t'cancel-scope-no-checkpoint'
ASYNC105\t'trio-sync-call'
ASYNC109\t'async-function-with-timeout'
ASYNC110\t'async-busy-wait'
ASYNC115\t'async-zero-sleep'
ASYNC116\t'long-sleep-not-forever'
ASYNC210\t'blocking-http-call-in-async-function'
ASYNC212\t'blocking-http-call-httpx-in-async-function'
ASYNC220\t'create-subprocess-in-async-function'
ASYNC221\t'run-process-in-async-function'
ASYNC222\t'wait-for-process-in-async-function'
ASYNC230\t'blocking-open-call-in-async-function'
ASYNC240\t'blocking-path-method-in-async-function'
ASYNC250\t'blocking-input-in-async-function'
ASYNC251\t'blocking-sleep-in-async-function'
S101\t'assert'
S102\t'exec-builtin'
S103\t'bad-file-permissions'
S104\t'hardcoded-bind-all-interfaces'
S105\t'hardcoded-password-string'
S106\t'hardcoded-password-func-arg'
S107\t'hardcoded-password-default'
S108\t'hardcoded-temp-file'
S110\t'try-except-pass'
S112\t'try-except-continue'
S113\t'request-without-timeout'
S201\t'flask-debug-true'
S202\t'tarfile-unsafe-members'
S301\t'suspicious-pickle-usage'
S302\t'suspicious-marshal-usage'
S303\t'suspicious-insecure-hash-usage'
S304\t'suspicious-insecure-cipher-usage'
S305\t'suspicious-insecure-cipher-mode-usage'
S306\t'suspicious-mktemp-usage'
S307\t'suspicious-eval-usage'
S308\t'suspicious-mark-safe-usage'
S310\t'suspicious-url-open-usage'
S311\t'suspicious-non-cryptographic-random-usage'
S312\t'suspicious-telnet-usage'
S313\t'suspicious-xmlc-element-tree-usage'
S314\t'suspicious-xml-element-tree-usage'
S315\t'suspicious-xml-expat-reader-usage'
S316\t'suspicious-xml-expat-builder-usage'
S317\t'suspicious-xml-sax-usage'
S318\t'suspicious-xml-mini-dom-usage'
S319\t'suspicious-xml-pull-dom-usage'
S320\t'suspicious-xmle-tree-usage'
S321\t'suspicious-ftp-lib-usage'
S323\t'suspicious-unverified-context-usage'
S324\t'hashlib-insecure-hash-function'
S401\t'suspicious-telnetlib-import'
S402\t'suspicious-ftplib-import'
S403\t'suspicious-pickle-import'
S404\t'suspicious-subprocess-import'
S405\t'suspicious-xml-etree-import'
S406\t'suspicious-xml-sax-import'
S407\t'suspicious-xml-expat-import'
S408\t'suspicious-xml-minidom-import'
S409\t'suspicious-xml-pulldom-import'
S410\t'suspicious-lxml-import'
S411\t'suspicious-xmlrpc-import'
S412\t'suspicious-httpoxy-import'
S413\t'suspicious-pycrypto-import'
S415\t'suspicious-pyghmi-import'
S501\t'request-with-no-cert-validation'
S502\t'ssl-insecure-version'
S503\t'ssl-with-bad-defaults'
S504\t'ssl-with-no-version'
S505\t'weak-cryptographic-key'
S506\t'unsafe-yaml-load'
S507\t'ssh-no-host-key-verification'
S508\t'snmp-insecure-version'
S509\t'snmp-weak-cryptography'
S601\t'paramiko-call'
S602\t'subprocess-popen-with-shell-equals-true'
S603\t'subprocess-without-shell-equals-true'
S604\t'call-with-shell-equals-true'
S605\t'start-process-with-a-shell'
S606\t'start-process-with-no-shell'
S607\t'start-process-with-partial-path'
S608\t'hardcoded-sql-expression'
S609\t'unix-command-wildcard-injection'
S610\t'django-extra'
S611\t'django-raw-sql'
S612\t'logging-config-insecure-listen'
S701\t'jinja2-autoescape-false'
S702\t'mako-templates'
S704\t'unsafe-markup-use'
BLE001\t'blind-except'
FBT001\t'boolean-type-hint-positional-argument'
FBT002\t'boolean-default-value-positional-argument'
FBT003\t'boolean-positional-value-in-call'
B002\t'unary-prefix-increment-decrement'
B003\t'assignment-to-os-environ'
B004\t'unreliable-callable-check'
B005\t'strip-with-multi-characters'
B006\t'mutable-argument-default'
B007\t'unused-loop-control-variable'
B008\t'function-call-in-default-argument'
B009\t'get-attr-with-constant'
B010\t'set-attr-with-constant'
B011\t'assert-false'
B012\t'jump-statement-in-finally'
B013\t'redundant-tuple-in-exception-handler'
B014\t'duplicate-handler-exception'
B015\t'useless-comparison'
B016\t'raise-literal'
B017\t'assert-raises-exception'
B018\t'useless-expression'
B019\t'cached-instance-method'
B020\t'loop-variable-overrides-iterator'
B021\t'f-string-docstring'
B022\t'useless-contextlib-suppress'
B023\t'function-uses-loop-variable'
B024\t'abstract-base-class-without-abstract-method'
B025\t'duplicate-try-block-exception'
B026\t'star-arg-unpacking-after-keyword-arg'
B027\t'empty-method-without-abstract-decorator'
B028\t'no-explicit-stacklevel'
B029\t'except-with-empty-tuple'
B030\t'except-with-non-exception-classes'
B031\t'reuse-of-groupby-generator'
B032\t'unintentional-type-annotation'
B033\t'duplicate-value'
B034\t're-sub-positional-args'
B035\t'static-key-dict-comprehension'
B039\t'mutable-contextvar-default'
B901\t'return-in-generator'
B903\t'class-as-data-structure'
B904\t'raise-without-from-inside-except'
B905\t'zip-without-explicit-strict'
B909\t'loop-iterator-mutation'
B911\t'batched-without-explicit-strict'
B912\t'map-without-explicit-strict'
A001\t'builtin-variable-shadowing'
A002\t'builtin-argument-shadowing'
A003\t'builtin-attribute-shadowing'
A004\t'builtin-import-shadowing'
A005\t'stdlib-module-shadowing'
A006\t'builtin-lambda-argument-shadowing'
COM812\t'missing-trailing-comma'
COM818\t'trailing-comma-on-bare-tuple'
COM819\t'prohibited-trailing-comma'
C400\t'unnecessary-generator-list'
C401\t'unnecessary-generator-set'
C402\t'unnecessary-generator-dict'
C403\t'unnecessary-list-comprehension-set'
C404\t'unnecessary-list-comprehension-dict'
C405\t'unnecessary-literal-set'
C406\t'unnecessary-literal-dict'
C408\t'unnecessary-collection-call'
C409\t'unnecessary-literal-within-tuple-call'
C410\t'unnecessary-literal-within-list-call'
C411\t'unnecessary-list-call'
C413\t'unnecessary-call-around-sorted'
C414\t'unnecessary-double-cast-or-process'
C415\t'unnecessary-subscript-reversal'
C416\t'unnecessary-comprehension'
C417\t'unnecessary-map'
C418\t'unnecessary-literal-within-dict-call'
C419\t'unnecessary-comprehension-in-call'
C420\t'unnecessary-dict-comprehension-for-iterable'
CPY001\t'missing-copyright-notice'
DTZ001\t'call-datetime-without-tzinfo'
DTZ002\t'call-datetime-today'
DTZ003\t'call-datetime-utcnow'
DTZ004\t'call-datetime-utcfromtimestamp'
DTZ005\t'call-datetime-now-without-tzinfo'
DTZ006\t'call-datetime-fromtimestamp'
DTZ007\t'call-datetime-strptime-without-zone'
DTZ011\t'call-date-today'
DTZ012\t'call-date-fromtimestamp'
DTZ901\t'datetime-min-max'
T100\t'debugger'
DJ001\t'django-nullable-model-string-field'
DJ003\t'django-locals-in-render-function'
DJ006\t'django-exclude-with-model-form'
DJ007\t'django-all-with-model-form'
DJ008\t'django-model-without-dunder-str'
DJ012\t'django-unordered-body-content-in-model'
DJ013\t'django-non-leading-receiver-decorator'
EM101\t'raw-string-in-exception'
EM102\t'f-string-in-exception'
EM103\t'dot-format-in-exception'
EXE001\t'shebang-not-executable'
EXE002\t'shebang-missing-executable-file'
EXE003\t'shebang-missing-python'
EXE004\t'shebang-leading-whitespace'
EXE005\t'shebang-not-first-line'
FIX001\t'line-contains-fixme'
FIX002\t'line-contains-todo'
FIX003\t'line-contains-xxx'
FIX004\t'line-contains-hack'
FA100\t'future-rewritable-type-annotation'
FA102\t'future-required-type-annotation'
INT001\t'f-string-in-get-text-func-call'
INT002\t'format-in-get-text-func-call'
INT003\t'printf-in-get-text-func-call'
ISC001\t'single-line-implicit-string-concatenation'
ISC002\t'multi-line-implicit-string-concatenation'
ISC003\t'explicit-string-concatenation'
ICN001\t'unconventional-import-alias'
ICN002\t'banned-import-alias'
ICN003\t'banned-import-from'
LOG001\t'direct-logger-instantiation'
LOG002\t'invalid-get-logger-argument'
LOG004\t'log-exception-outside-except-handler'
LOG007\t'exception-without-exc-info'
LOG009\t'undocumented-warn'
LOG014\t'exc-info-outside-except-handler'
LOG015\t'root-logger-call'
G001\t'logging-string-format'
G002\t'logging-percent-format'
G003\t'logging-string-concat'
G004\t'logging-f-string'
G010\t'logging-warn'
G101\t'logging-extra-attr-clash'
G201\t'logging-exc-info'
G202\t'logging-redundant-exc-info'
INP001\t'implicit-namespace-package'
PIE790\t'unnecessary-placeholder'
PIE794\t'duplicate-class-field-definition'
PIE796\t'non-unique-enums'
PIE800\t'unnecessary-spread'
PIE804\t'unnecessary-dict-kwargs'
PIE807\t'reimplemented-container-builtin'
PIE808\t'unnecessary-range-start'
PIE810\t'multiple-starts-ends-with'
T201\t'print'
T203\t'p-print'
PYI001\t'unprefixed-type-param'
PYI002\t'complex-if-statement-in-stub'
PYI003\t'unrecognized-version-info-check'
PYI004\t'patch-version-comparison'
PYI005\t'wrong-tuple-length-version-comparison'
PYI006\t'bad-version-info-comparison'
PYI007\t'unrecognized-platform-check'
PYI008\t'unrecognized-platform-name'
PYI009\t'pass-statement-stub-body'
PYI010\t'non-empty-stub-body'
PYI011\t'typed-argument-default-in-stub'
PYI012\t'pass-in-class-body'
PYI013\t'ellipsis-in-non-empty-class-body'
PYI014\t'argument-default-in-stub'
PYI015\t'assignment-default-in-stub'
PYI016\t'duplicate-union-member'
PYI017\t'complex-assignment-in-stub'
PYI018\t'unused-private-type-var'
PYI019\t'custom-type-var-for-self'
PYI020\t'quoted-annotation-in-stub'
PYI021\t'docstring-in-stub'
PYI024\t'collections-named-tuple'
PYI025\t'unaliased-collections-abc-set-import'
PYI026\t'type-alias-without-annotation'
PYI029\t'str-or-repr-defined-in-stub'
PYI030\t'unnecessary-literal-union'
PYI032\t'any-eq-ne-annotation'
PYI033\t'type-comment-in-stub'
PYI034\t'non-self-return-type'
PYI035\t'unassigned-special-variable-in-stub'
PYI036\t'bad-exit-annotation'
PYI041\t'redundant-numeric-union'
PYI042\t'snake-case-type-alias'
PYI043\t't-suffixed-type-alias'
PYI044\t'future-annotations-in-stub'
PYI045\t'iter-method-return-iterable'
PYI046\t'unused-private-protocol'
PYI047\t'unused-private-type-alias'
PYI048\t'stub-body-multiple-statements'
PYI049\t'unused-private-typed-dict'
PYI050\t'no-return-argument-annotation-in-stub'
PYI051\t'redundant-literal-union'
PYI052\t'unannotated-assignment-in-stub'
PYI053\t'string-or-bytes-too-long'
PYI054\t'numeric-literal-too-long'
PYI055\t'unnecessary-type-union'
PYI056\t'unsupported-method-call-on-all'
PYI057\t'byte-string-usage'
PYI058\t'generator-return-from-iter-method'
PYI059\t'generic-not-last-base-class'
PYI061\t'redundant-none-literal'
PYI062\t'duplicate-literal-member'
PYI063\t'pep484-style-positional-only-parameter'
PYI064\t'redundant-final-literal'
PYI066\t'bad-version-info-order'
PT001\t'pytest-fixture-incorrect-parentheses-style'
PT002\t'pytest-fixture-positional-args'
PT003\t'pytest-extraneous-scope-function'
PT004\t'pytest-missing-fixture-name-underscore'
PT005\t'pytest-incorrect-fixture-name-underscore'
PT006\t'pytest-parametrize-names-wrong-type'
PT007\t'pytest-parametrize-values-wrong-type'
PT008\t'pytest-patch-with-lambda'
PT009\t'pytest-unittest-assertion'
PT010\t'pytest-raises-without-exception'
PT011\t'pytest-raises-too-broad'
PT012\t'pytest-raises-with-multiple-statements'
PT013\t'pytest-incorrect-pytest-import'
PT014\t'pytest-duplicate-parametrize-test-cases'
PT015\t'pytest-assert-always-false'
PT016\t'pytest-fail-without-message'
PT017\t'pytest-assert-in-except'
PT018\t'pytest-composite-assertion'
PT019\t'pytest-fixture-param-without-value'
PT020\t'pytest-deprecated-yield-fixture'
PT021\t'pytest-fixture-finalizer-callback'
PT022\t'pytest-useless-yield-fixture'
PT023\t'pytest-incorrect-mark-parentheses-style'
PT024\t'pytest-unnecessary-asyncio-mark-on-fixture'
PT025\t'pytest-erroneous-use-fixtures-on-fixture'
PT026\t'pytest-use-fixtures-without-parameters'
PT027\t'pytest-unittest-raises-assertion'
PT028\t'pytest-parameter-with-default-argument'
PT029\t'pytest-warns-without-warning'
PT030\t'pytest-warns-too-broad'
PT031\t'pytest-warns-with-multiple-statements'
Q000\t'bad-quotes-inline-string'
Q001\t'bad-quotes-multiline-string'
Q002\t'bad-quotes-docstring'
Q003\t'avoidable-escaped-quote'
Q004\t'unnecessary-escaped-quote'
RSE102\t'unnecessary-paren-on-raise-exception'
RET501\t'unnecessary-return-none'
RET502\t'implicit-return-value'
RET503\t'implicit-return'
RET504\t'unnecessary-assign'
RET505\t'superfluous-else-return'
RET506\t'superfluous-else-raise'
RET507\t'superfluous-else-continue'
RET508\t'superfluous-else-break'
SLF001\t'private-member-access'
SIM101\t'duplicate-isinstance-call'
SIM102\t'collapsible-if'
SIM103\t'needless-bool'
SIM105\t'suppressible-exception'
SIM107\t'return-in-try-except-finally'
SIM108\t'if-else-block-instead-of-if-exp'
SIM109\t'compare-with-tuple'
SIM110\t'reimplemented-builtin'
SIM112\t'uncapitalized-environment-variables'
SIM113\t'enumerate-for-loop'
SIM114\t'if-with-same-arms'
SIM115\t'open-file-with-context-handler'
SIM116\t'if-else-block-instead-of-dict-lookup'
SIM117\t'multiple-with-statements'
SIM118\t'in-dict-keys'
SIM201\t'negate-equal-op'
SIM202\t'negate-not-equal-op'
SIM208\t'double-negation'
SIM210\t'if-expr-with-true-false'
SIM211\t'if-expr-with-false-true'
SIM212\t'if-expr-with-twisted-arms'
SIM220\t'expr-and-not-expr'
SIM221\t'expr-or-not-expr'
SIM222\t'expr-or-true'
SIM223\t'expr-and-false'
SIM300\t'yoda-conditions'
SIM401\t'if-else-block-instead-of-dict-get'
SIM905\t'split-static-string'
SIM910\t'dict-get-with-none-default'
SIM911\t'zip-dict-keys-and-values'
SLOT000\t'no-slots-in-str-subclass'
SLOT001\t'no-slots-in-tuple-subclass'
SLOT002\t'no-slots-in-namedtuple-subclass'
TID251\t'banned-api'
TID252\t'relative-imports'
TID253\t'banned-module-level-imports'
TD001\t'invalid-todo-tag'
TD002\t'missing-todo-author'
TD003\t'missing-todo-link'
TD004\t'missing-todo-colon'
TD005\t'missing-todo-description'
TD006\t'invalid-todo-capitalization'
TD007\t'missing-space-after-todo-colon'
TC001\t'typing-only-first-party-import'
TC002\t'typing-only-third-party-import'
TC003\t'typing-only-standard-library-import'
TC004\t'runtime-import-in-type-checking-block'
TC005\t'empty-type-checking-block'
TC006\t'runtime-cast-value'
TC007\t'unquoted-type-alias'
TC008\t'quoted-type-alias'
TC010\t'runtime-string-union'
ARG001\t'unused-function-argument'
ARG002\t'unused-method-argument'
ARG003\t'unused-class-method-argument'
ARG004\t'unused-static-method-argument'
ARG005\t'unused-lambda-argument'
PTH100\t'os-path-abspath'
PTH101\t'os-chmod'
PTH102\t'os-mkdir'
PTH103\t'os-makedirs'
PTH104\t'os-rename'
PTH105\t'os-replace'
PTH106\t'os-rmdir'
PTH107\t'os-remove'
PTH108\t'os-unlink'
PTH109\t'os-getcwd'
PTH110\t'os-path-exists'
PTH111\t'os-path-expanduser'
PTH112\t'os-path-isdir'
PTH113\t'os-path-isfile'
PTH114\t'os-path-islink'
PTH115\t'os-readlink'
PTH116\t'os-stat'
PTH117\t'os-path-isabs'
PTH118\t'os-path-join'
PTH119\t'os-path-basename'
PTH120\t'os-path-dirname'
PTH121\t'os-path-samefile'
PTH122\t'os-path-splitext'
PTH123\t'builtin-open'
PTH124\t'py-path'
PTH201\t'path-constructor-current-directory'
PTH202\t'os-path-getsize'
PTH203\t'os-path-getatime'
PTH204\t'os-path-getmtime'
PTH205\t'os-path-getctime'
PTH206\t'os-sep-split'
PTH207\t'glob'
PTH208\t'os-listdir'
PTH210\t'invalid-pathlib-with-suffix'
PTH211\t'os-symlink'
FLY002\t'static-join-to-f-string'
I001\t'unsorted-imports'
I002\t'missing-required-import'
C901\t'complex-structure'
NPY001\t'numpy-deprecated-type-alias'
NPY002\t'numpy-legacy-random'
NPY003\t'numpy-deprecated-function'
NPY201\t'numpy2-deprecation'
N801\t'invalid-class-name'
N802\t'invalid-function-name'
N803\t'invalid-argument-name'
N804\t'invalid-first-argument-name-for-class-method'
N805\t'invalid-first-argument-name-for-method'
N806\t'non-lowercase-variable-in-function'
N807\t'dunder-function-name'
N811\t'constant-imported-as-non-constant'
N812\t'lowercase-imported-as-non-lowercase'
N813\t'camelcase-imported-as-lowercase'
N814\t'camelcase-imported-as-constant'
N815\t'mixed-case-variable-in-class-scope'
N816\t'mixed-case-variable-in-global-scope'
N817\t'camelcase-imported-as-acronym'
N818\t'error-suffix-on-exception-name'
N999\t'invalid-module-name'
PD002\t'pandas-use-of-inplace-argument'
PD003\t'pandas-use-of-dot-is-null'
PD004\t'pandas-use-of-dot-not-null'
PD007\t'pandas-use-of-dot-ix'
PD008\t'pandas-use-of-dot-at'
PD009\t'pandas-use-of-dot-iat'
PD010\t'pandas-use-of-dot-pivot-or-unstack'
PD011\t'pandas-use-of-dot-values'
PD012\t'pandas-use-of-dot-read-table'
PD013\t'pandas-use-of-dot-stack'
PD015\t'pandas-use-of-pd-merge'
PD101\t'pandas-nunique-constant-series-check'
PD901\t'pandas-df-variable-name'
PERF101\t'unnecessary-list-cast'
PERF102\t'incorrect-dict-iterator'
PERF203\t'try-except-in-loop'
PERF401\t'manual-list-comprehension'
PERF402\t'manual-list-copy'
PERF403\t'manual-dict-comprehension'
E101\t'mixed-spaces-and-tabs'
E111\t'indentation-with-invalid-multiple'
E112\t'no-indented-block'
E113\t'unexpected-indentation'
E114\t'indentation-with-invalid-multiple-comment'
E115\t'no-indented-block-comment'
E116\t'unexpected-indentation-comment'
E117\t'over-indented'
E201\t'whitespace-after-open-bracket'
E202\t'whitespace-before-close-bracket'
E203\t'whitespace-before-punctuation'
E204\t'whitespace-after-decorator'
E211\t'whitespace-before-parameters'
E221\t'multiple-spaces-before-operator'
E222\t'multiple-spaces-after-operator'
E223\t'tab-before-operator'
E224\t'tab-after-operator'
E225\t'missing-whitespace-around-operator'
E226\t'missing-whitespace-around-arithmetic-operator'
E227\t'missing-whitespace-around-bitwise-or-shift-operator'
E228\t'missing-whitespace-around-modulo-operator'
E231\t'missing-whitespace'
E241\t'multiple-spaces-after-comma'
E242\t'tab-after-comma'
E251\t'unexpected-spaces-around-keyword-parameter-equals'
E252\t'missing-whitespace-around-parameter-equals'
E261\t'too-few-spaces-before-inline-comment'
E262\t'no-space-after-inline-comment'
E265\t'no-space-after-block-comment'
E266\t'multiple-leading-hashes-for-block-comment'
E271\t'multiple-spaces-after-keyword'
E272\t'multiple-spaces-before-keyword'
E273\t'tab-after-keyword'
E274\t'tab-before-keyword'
E275\t'missing-whitespace-after-keyword'
E301\t'blank-line-between-methods'
E302\t'blank-lines-top-level'
E303\t'too-many-blank-lines'
E304\t'blank-line-after-decorator'
E305\t'blank-lines-after-function-or-class'
E306\t'blank-lines-before-nested-definition'
E401\t'multiple-imports-on-one-line'
E402\t'module-import-not-at-top-of-file'
E501\t'line-too-long'
E502\t'redundant-backslash'
E701\t'multiple-statements-on-one-line-colon'
E702\t'multiple-statements-on-one-line-semicolon'
E703\t'useless-semicolon'
E711\t'none-comparison'
E712\t'true-false-comparison'
E713\t'not-in-test'
E714\t'not-is-test'
E721\t'type-comparison'
E722\t'bare-except'
E731\t'lambda-assignment'
E741\t'ambiguous-variable-name'
E742\t'ambiguous-class-name'
E743\t'ambiguous-function-name'
E902\t'io-error'
E999\t'syntax-error'
W191\t'tab-indentation'
W291\t'trailing-whitespace'
W292\t'missing-newline-at-end-of-file'
W293\t'blank-line-with-whitespace'
W391\t'too-many-newlines-at-end-of-file'
W505\t'doc-line-too-long'
W605\t'invalid-escape-sequence'
DOC102\t'docstring-extraneous-parameter'
DOC201\t'docstring-missing-returns'
DOC202\t'docstring-extraneous-returns'
DOC402\t'docstring-missing-yields'
DOC403\t'docstring-extraneous-yields'
DOC501\t'docstring-missing-exception'
DOC502\t'docstring-extraneous-exception'
D100\t'undocumented-public-module'
D101\t'undocumented-public-class'
D102\t'undocumented-public-method'
D103\t'undocumented-public-function'
D104\t'undocumented-public-package'
D105\t'undocumented-magic-method'
D106\t'undocumented-public-nested-class'
D107\t'undocumented-public-init'
D200\t'unnecessary-multiline-docstring'
D201\t'blank-line-before-function'
D202\t'blank-line-after-function'
D203\t'incorrect-blank-line-before-class'
D204\t'incorrect-blank-line-after-class'
D205\t'missing-blank-line-after-summary'
D206\t'docstring-tab-indentation'
D207\t'under-indentation'
D208\t'over-indentation'
D209\t'new-line-after-last-paragraph'
D210\t'surrounding-whitespace'
D211\t'blank-line-before-class'
D212\t'multi-line-summary-first-line'
D213\t'multi-line-summary-second-line'
D214\t'overindented-section'
D215\t'overindented-section-underline'
D300\t'triple-single-quotes'
D301\t'escape-sequence-in-docstring'
D400\t'missing-trailing-period'
D401\t'non-imperative-mood'
D402\t'signature-in-docstring'
D403\t'first-word-uncapitalized'
D404\t'docstring-starts-with-this'
D405\t'non-capitalized-section-name'
D406\t'missing-new-line-after-section-name'
D407\t'missing-dashed-underline-after-section'
D408\t'missing-section-underline-after-name'
D409\t'mismatched-section-underline-length'
D410\t'no-blank-line-after-section'
D411\t'no-blank-line-before-section'
D412\t'blank-lines-between-header-and-content'
D413\t'missing-blank-line-after-last-section'
D414\t'empty-docstring-section'
D415\t'missing-terminal-punctuation'
D416\t'missing-section-name-colon'
D417\t'undocumented-param'
D418\t'overload-with-docstring'
D419\t'empty-docstring'
F401\t'unused-import'
F402\t'import-shadowed-by-loop-var'
F403\t'undefined-local-with-import-star'
F404\t'late-future-import'
F405\t'undefined-local-with-import-star-usage'
F406\t'undefined-local-with-nested-import-star-usage'
F407\t'future-feature-not-defined'
F501\t'percent-format-invalid-format'
F502\t'percent-format-expected-mapping'
F503\t'percent-format-expected-sequence'
F504\t'percent-format-extra-named-arguments'
F505\t'percent-format-missing-argument'
F506\t'percent-format-mixed-positional-and-named'
F507\t'percent-format-positional-count-mismatch'
F508\t'percent-format-star-requires-sequence'
F509\t'percent-format-unsupported-format-character'
F521\t'string-dot-format-invalid-format'
F522\t'string-dot-format-extra-named-arguments'
F523\t'string-dot-format-extra-positional-arguments'
F524\t'string-dot-format-missing-arguments'
F525\t'string-dot-format-mixing-automatic'
F541\t'f-string-missing-placeholders'
F601\t'multi-value-repeated-key-literal'
F602\t'multi-value-repeated-key-variable'
F621\t'expressions-in-star-assignment'
F622\t'multiple-starred-expressions'
F631\t'assert-tuple'
F632\t'is-literal'
F633\t'invalid-print-syntax'
F634\t'if-tuple'
F701\t'break-outside-loop'
F702\t'continue-outside-loop'
F704\t'yield-outside-function'
F706\t'return-outside-function'
F707\t'default-except-not-last'
F722\t'forward-annotation-syntax-error'
F811\t'redefined-while-unused'
F821\t'undefined-name'
F822\t'undefined-export'
F823\t'undefined-local'
F841\t'unused-variable'
F842\t'unused-annotation'
F901\t'raise-not-implemented'
PGH001\t'eval'
PGH002\t'deprecated-log-warn'
PGH003\t'blanket-type-ignore'
PGH004\t'blanket-noqa'
PGH005\t'invalid-mock-access'
PLC0105\t'type-name-incorrect-variance'
PLC0131\t'type-bivariance'
PLC0132\t'type-param-name-mismatch'
PLC0205\t'single-string-slots'
PLC0206\t'dict-index-missing-items'
PLC0207\t'missing-maxsplit-arg'
PLC0208\t'iteration-over-set'
PLC0414\t'useless-import-alias'
PLC0415\t'import-outside-top-level'
PLC1802\t'len-test'
PLC1901\t'compare-to-empty-string'
PLC2401\t'non-ascii-name'
PLC2403\t'non-ascii-import-name'
PLC2701\t'import-private-name'
PLC2801\t'unnecessary-dunder-call'
PLC3002\t'unnecessary-direct-lambda-call'
PLE0100\t'yield-in-init'
PLE0101\t'return-in-init'
PLE0115\t'nonlocal-and-global'
PLE0116\t'continue-in-finally'
PLE0117\t'nonlocal-without-binding'
PLE0118\t'load-before-global-declaration'
PLE0237\t'non-slot-assignment'
PLE0241\t'duplicate-bases'
PLE0302\t'unexpected-special-method-signature'
PLE0303\t'invalid-length-return-type'
PLE0304\t'invalid-bool-return-type'
PLE0305\t'invalid-index-return-type'
PLE0307\t'invalid-str-return-type'
PLE0308\t'invalid-bytes-return-type'
PLE0309\t'invalid-hash-return-type'
PLE0604\t'invalid-all-object'
PLE0605\t'invalid-all-format'
PLE0643\t'potential-index-error'
PLE0704\t'misplaced-bare-raise'
PLE1132\t'repeated-keyword-argument'
PLE1141\t'dict-iter-missing-items'
PLE1142\t'await-outside-async'
PLE1205\t'logging-too-many-args'
PLE1206\t'logging-too-few-args'
PLE1300\t'bad-string-format-character'
PLE1307\t'bad-string-format-type'
PLE1310\t'bad-str-strip-call'
PLE1507\t'invalid-envvar-value'
PLE1519\t'singledispatch-method'
PLE1520\t'singledispatchmethod-function'
PLE1700\t'yield-from-in-async-function'
PLE2502\t'bidirectional-unicode'
PLE2510\t'invalid-character-backspace'
PLE2512\t'invalid-character-sub'
PLE2513\t'invalid-character-esc'
PLE2514\t'invalid-character-nul'
PLE2515\t'invalid-character-zero-width-space'
PLE4703\t'modified-iterating-set'
PLR0124\t'comparison-with-itself'
PLR0133\t'comparison-of-constant'
PLR0202\t'no-classmethod-decorator'
PLR0203\t'no-staticmethod-decorator'
PLR0206\t'property-with-parameters'
PLR0402\t'manual-from-import'
PLR0904\t'too-many-public-methods'
PLR0911\t'too-many-return-statements'
PLR0912\t'too-many-branches'
PLR0913\t'too-many-arguments'
PLR0914\t'too-many-locals'
PLR0915\t'too-many-statements'
PLR0916\t'too-many-boolean-expressions'
PLR0917\t'too-many-positional-arguments'
PLR1701\t'repeated-isinstance-calls'
PLR1702\t'too-many-nested-blocks'
PLR1704\t'redefined-argument-from-local'
PLR1706\t'and-or-ternary'
PLR1711\t'useless-return'
PLR1714\t'repeated-equality-comparison'
PLR1716\t'boolean-chained-comparison'
PLR1722\t'sys-exit-alias'
PLR1730\t'if-stmt-min-max'
PLR1733\t'unnecessary-dict-index-lookup'
PLR1736\t'unnecessary-list-index-lookup'
PLR2004\t'magic-value-comparison'
PLR2044\t'empty-comment'
PLR5501\t'collapsible-else-if'
PLR6104\t'non-augmented-assignment'
PLR6201\t'literal-membership'
PLR6301\t'no-self-use'
PLW0108\t'unnecessary-lambda'
PLW0120\t'useless-else-on-loop'
PLW0127\t'self-assigning-variable'
PLW0128\t'redeclared-assigned-name'
PLW0129\t'assert-on-string-literal'
PLW0131\t'named-expr-without-context'
PLW0133\t'useless-exception-statement'
PLW0177\t'nan-comparison'
PLW0211\t'bad-staticmethod-argument'
PLW0244\t'redefined-slots-in-subclass'
PLW0245\t'super-without-brackets'
PLW0406\t'import-self'
PLW0602\t'global-variable-not-assigned'
PLW0603\t'global-statement'
PLW0604\t'global-at-module-level'
PLW0642\t'self-or-cls-assignment'
PLW0711\t'binary-op-exception'
PLW1501\t'bad-open-mode'
PLW1507\t'shallow-copy-environ'
PLW1508\t'invalid-envvar-default'
PLW1509\t'subprocess-popen-preexec-fn'
PLW1510\t'subprocess-run-without-check'
PLW1514\t'unspecified-encoding'
PLW1641\t'eq-without-hash'
PLW2101\t'useless-with-lock'
PLW2901\t'redefined-loop-name'
PLW3201\t'bad-dunder-method-name'
PLW3301\t'nested-min-max'
UP001\t'useless-metaclass-type'
UP003\t'type-of-primitive'
UP004\t'useless-object-inheritance'
UP005\t'deprecated-unittest-alias'
UP006\t'non-pep585-annotation'
UP007\t'non-pep604-annotation-union'
UP008\t'super-call-with-parameters'
UP009\t'utf8-encoding-declaration'
UP010\t'unnecessary-future-import'
UP011\t'lru-cache-without-parameters'
UP012\t'unnecessary-encode-utf8'
UP013\t'convert-typed-dict-functional-to-class'
UP014\t'convert-named-tuple-functional-to-class'
UP015\t'redundant-open-modes'
UP017\t'datetime-timezone-utc'
UP018\t'native-literals'
UP019\t'typing-text-str-alias'
UP020\t'open-alias'
UP021\t'replace-universal-newlines'
UP022\t'replace-stdout-stderr'
UP023\t'deprecated-c-element-tree'
UP024\t'os-error-alias'
UP025\t'unicode-kind-prefix'
UP026\t'deprecated-mock-import'
UP027\t'unpacked-list-comprehension'
UP028\t'yield-in-for-loop'
UP029\t'unnecessary-builtin-import'
UP030\t'format-literals'
UP031\t'printf-string-formatting'
UP032\t'f-string'
UP033\t'lru-cache-with-maxsize-none'
UP034\t'extraneous-parentheses'
UP035\t'deprecated-import'
UP036\t'outdated-version-block'
UP037\t'quoted-annotation'
UP038\t'non-pep604-isinstance'
UP039\t'unnecessary-class-parentheses'
UP040\t'non-pep695-type-alias'
UP041\t'timeout-error-alias'
UP042\t'replace-str-enum'
UP043\t'unnecessary-default-type-args'
UP044\t'non-pep646-unpack'
UP045\t'non-pep604-annotation-optional'
UP046\t'non-pep695-generic-class'
UP047\t'non-pep695-generic-function'
UP049\t'private-type-parameter'
UP050\t'useless-class-metaclass-type'
FURB101\t'read-whole-file'
FURB103\t'write-whole-file'
FURB105\t'print-empty-string'
FURB110\t'if-exp-instead-of-or-operator'
FURB113\t'repeated-append'
FURB116\t'f-string-number-format'
FURB118\t'reimplemented-operator'
FURB122\t'for-loop-writes'
FURB129\t'readlines-in-for'
FURB131\t'delete-full-slice'
FURB132\t'check-and-remove-from-set'
FURB136\t'if-expr-min-max'
FURB140\t'reimplemented-starmap'
FURB142\t'for-loop-set-mutations'
FURB145\t'slice-copy'
FURB148\t'unnecessary-enumerate'
FURB152\t'math-constant'
FURB154\t'repeated-global'
FURB156\t'hardcoded-string-charset'
FURB157\t'verbose-decimal-constructor'
FURB161\t'bit-count'
FURB162\t'fromisoformat-replace-z'
FURB163\t'redundant-log-base'
FURB164\t'unnecessary-from-float'
FURB166\t'int-on-sliced-str'
FURB167\t'regex-flag-alias'
FURB168\t'isinstance-type-none'
FURB169\t'type-none-comparison'
FURB171\t'single-item-membership-test'
FURB177\t'implicit-cwd'
FURB180\t'meta-class-abc-meta'
FURB181\t'hashlib-digest-hex'
FURB187\t'list-reverse-copy'
FURB188\t'slice-to-remove-prefix-or-suffix'
FURB189\t'subclass-builtin'
FURB192\t'sorted-min-max'
RUF001\t'ambiguous-unicode-character-string'
RUF002\t'ambiguous-unicode-character-docstring'
RUF003\t'ambiguous-unicode-character-comment'
RUF005\t'collection-literal-concatenation'
RUF006\t'asyncio-dangling-task'
RUF007\t'zip-instead-of-pairwise'
RUF008\t'mutable-dataclass-default'
RUF009\t'function-call-in-dataclass-default-argument'
RUF010\t'explicit-f-string-type-conversion'
RUF011\t'ruff-static-key-dict-comprehension'
RUF012\t'mutable-class-default'
RUF013\t'implicit-optional'
RUF015\t'unnecessary-iterable-allocation-for-first-element'
RUF016\t'invalid-index-type'
RUF017\t'quadratic-list-summation'
RUF018\t'assignment-in-assert'
RUF019\t'unnecessary-key-check'
RUF020\t'never-union'
RUF021\t'parenthesize-chained-operators'
RUF022\t'unsorted-dunder-all'
RUF023\t'unsorted-dunder-slots'
RUF024\t'mutable-fromkeys-value'
RUF026\t'default-factory-kwarg'
RUF027\t'missing-f-string-syntax'
RUF028\t'invalid-formatter-suppression-comment'
RUF029\t'unused-async'
RUF030\t'assert-with-print-message'
RUF031\t'incorrectly-parenthesized-tuple-in-subscript'
RUF032\t'decimal-from-float-literal'
RUF033\t'post-init-default'
RUF034\t'useless-if-else'
RUF035\t'ruff-unsafe-markup-use'
RUF036\t'none-not-at-end-of-union'
RUF037\t'unnecessary-empty-iterable-within-deque-call'
RUF038\t'redundant-bool-literal'
RUF039\t'unraw-re-pattern'
RUF040\t'invalid-assert-message-literal-argument'
RUF041\t'unnecessary-nested-literal'
RUF043\t'pytest-raises-ambiguous-pattern'
RUF045\t'implicit-class-var-in-dataclass'
RUF046\t'unnecessary-cast-to-int'
RUF047\t'needless-else'
RUF048\t'map-int-version-parsing'
RUF049\t'dataclass-enum'
RUF051\t'if-key-in-dict-del'
RUF052\t'used-dummy-variable'
RUF053\t'class-with-mixed-type-vars'
RUF054\t'indented-form-feed'
RUF055\t'unnecessary-regular-expression'
RUF056\t'falsy-dict-get-fallback'
RUF057\t'unnecessary-round'
RUF058\t'starmap-zip'
RUF059\t'unused-unpacked-variable'
RUF060\t'in-empty-collection'
RUF061\t'legacy-form-pytest-raises'
RUF063\t'access-annotations-from-class-dict'
RUF064\t'non-octal-permissions'
RUF065\t'logging-eager-conversion'
RUF100\t'unused-noqa'
RUF101\t'redirected-noqa'
RUF102\t'invalid-rule-code'
RUF200\t'invalid-pyproject-toml'
TRY002\t'raise-vanilla-class'
TRY003\t'raise-vanilla-args'
TRY004\t'type-check-without-type-error'
TRY200\t'reraise-no-cause'
TRY201\t'verbose-raise'
TRY203\t'useless-try-except'
TRY300\t'try-consider-else'
TRY301\t'raise-within-try'
TRY400\t'error-instead-of-exception'
TRY401\t'verbose-log-message'"
complete -c ruff -n "__fish_ruff_using_subcommand check" -l line-length -d 'Set the line-length for length-associated rules and automatic formatting' -r
complete -c ruff -n "__fish_ruff_using_subcommand check" -l dummy-variable-rgx -d 'Regular expression matching the name of dummy variables' -r
complete -c ruff -n "__fish_ruff_using_subcommand check" -l cache-dir -d 'Path to the cache directory' -r -F
complete -c ruff -n "__fish_ruff_using_subcommand check" -l stdin-filename -d 'The name of the file when passing it through stdin' -r -F
complete -c ruff -n "__fish_ruff_using_subcommand check" -l extension -d 'List of mappings from file extension to language (one of `python`, `ipynb`, `pyi`). For example, to treat `.ipy` files as IPython notebooks, use `--extension ipy:ipynb`' -r
complete -c ruff -n "__fish_ruff_using_subcommand check" -l config -d 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`' -r
complete -c ruff -n "__fish_ruff_using_subcommand check" -l fix -d 'Apply fixes to resolve lint violations. Use `--no-fix` to disable or `--unsafe-fixes` to include unsafe fixes'
complete -c ruff -n "__fish_ruff_using_subcommand check" -l no-fix
complete -c ruff -n "__fish_ruff_using_subcommand check" -l unsafe-fixes -d 'Include fixes that may not retain the original intent of the code. Use `--no-unsafe-fixes` to disable'
complete -c ruff -n "__fish_ruff_using_subcommand check" -l no-unsafe-fixes
complete -c ruff -n "__fish_ruff_using_subcommand check" -l show-fixes -d 'Show an enumeration of all fixed lint violations. Use `--no-show-fixes` to disable'
complete -c ruff -n "__fish_ruff_using_subcommand check" -l no-show-fixes
complete -c ruff -n "__fish_ruff_using_subcommand check" -l diff -d 'Avoid writing any fixed files back; instead, output a diff for each changed file to stdout, and exit 0 if there are no diffs. Implies `--fix-only`'
complete -c ruff -n "__fish_ruff_using_subcommand check" -s w -l watch -d 'Run in watch mode by re-running whenever files change'
complete -c ruff -n "__fish_ruff_using_subcommand check" -l fix-only -d 'Apply fixes to resolve lint violations, but don\'t report on, or exit non-zero for, leftover violations. Implies `--fix`. Use `--no-fix-only` to disable or `--unsafe-fixes` to include unsafe fixes'
complete -c ruff -n "__fish_ruff_using_subcommand check" -l no-fix-only
complete -c ruff -n "__fish_ruff_using_subcommand check" -l ignore-noqa -d 'Ignore any `# noqa` comments'
complete -c ruff -n "__fish_ruff_using_subcommand check" -l preview -d 'Enable preview mode; checks will include unstable rules and fixes. Use `--no-preview` to disable'
complete -c ruff -n "__fish_ruff_using_subcommand check" -l no-preview
complete -c ruff -n "__fish_ruff_using_subcommand check" -l respect-gitignore -d 'Respect file exclusions via `.gitignore` and other standard ignore files. Use `--no-respect-gitignore` to disable'
complete -c ruff -n "__fish_ruff_using_subcommand check" -l no-respect-gitignore
complete -c ruff -n "__fish_ruff_using_subcommand check" -l force-exclude -d 'Enforce exclusions, even for paths passed to Ruff directly on the command-line. Use `--no-force-exclude` to disable'
complete -c ruff -n "__fish_ruff_using_subcommand check" -l no-force-exclude
complete -c ruff -n "__fish_ruff_using_subcommand check" -s n -l no-cache -d 'Disable cache reads'
complete -c ruff -n "__fish_ruff_using_subcommand check" -s e -l exit-zero -d 'Exit with status code "0", even upon detecting lint violations'
complete -c ruff -n "__fish_ruff_using_subcommand check" -l exit-non-zero-on-fix -d 'Exit with a non-zero status code if any files were modified via fix, even if no lint violations remain'
complete -c ruff -n "__fish_ruff_using_subcommand check" -l statistics -d 'Show counts for every rule with at least one violation'
complete -c ruff -n "__fish_ruff_using_subcommand check" -l add-noqa -d 'Enable automatic additions of `noqa` directives to failing lines'
complete -c ruff -n "__fish_ruff_using_subcommand check" -l show-files -d 'See the files Ruff will be run against with the current settings'
complete -c ruff -n "__fish_ruff_using_subcommand check" -l show-settings -d 'See the settings Ruff will use to lint a given Python file'
complete -c ruff -n "__fish_ruff_using_subcommand check" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_ruff_using_subcommand check" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_ruff_using_subcommand check" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_ruff_using_subcommand check" -l isolated -d 'Ignore all configuration files'
complete -c ruff -n "__fish_ruff_using_subcommand check" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_ruff_using_subcommand rule" -l output-format -d 'Output format' -r -f -a "text\t''
json\t''"
complete -c ruff -n "__fish_ruff_using_subcommand rule" -l config -d 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`' -r
complete -c ruff -n "__fish_ruff_using_subcommand rule" -l all -d 'Explain all rules'
complete -c ruff -n "__fish_ruff_using_subcommand rule" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_ruff_using_subcommand rule" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_ruff_using_subcommand rule" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_ruff_using_subcommand rule" -l isolated -d 'Ignore all configuration files'
complete -c ruff -n "__fish_ruff_using_subcommand rule" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_ruff_using_subcommand config" -l output-format -d 'Output format' -r -f -a "text\t''
json\t''"
complete -c ruff -n "__fish_ruff_using_subcommand config" -l config -d 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`' -r
complete -c ruff -n "__fish_ruff_using_subcommand config" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_ruff_using_subcommand config" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_ruff_using_subcommand config" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_ruff_using_subcommand config" -l isolated -d 'Ignore all configuration files'
complete -c ruff -n "__fish_ruff_using_subcommand config" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_ruff_using_subcommand linter" -l output-format -d 'Output format' -r -f -a "text\t''
json\t''"
complete -c ruff -n "__fish_ruff_using_subcommand linter" -l config -d 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`' -r
complete -c ruff -n "__fish_ruff_using_subcommand linter" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_ruff_using_subcommand linter" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_ruff_using_subcommand linter" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_ruff_using_subcommand linter" -l isolated -d 'Ignore all configuration files'
complete -c ruff -n "__fish_ruff_using_subcommand linter" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_ruff_using_subcommand clean" -l config -d 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`' -r
complete -c ruff -n "__fish_ruff_using_subcommand clean" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_ruff_using_subcommand clean" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_ruff_using_subcommand clean" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_ruff_using_subcommand clean" -l isolated -d 'Ignore all configuration files'
complete -c ruff -n "__fish_ruff_using_subcommand clean" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_ruff_using_subcommand generate-shell-completion" -l config -d 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`' -r
complete -c ruff -n "__fish_ruff_using_subcommand generate-shell-completion" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_ruff_using_subcommand generate-shell-completion" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_ruff_using_subcommand generate-shell-completion" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_ruff_using_subcommand generate-shell-completion" -l isolated -d 'Ignore all configuration files'
complete -c ruff -n "__fish_ruff_using_subcommand generate-shell-completion" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_ruff_using_subcommand format" -l cache-dir -d 'Path to the cache directory' -r -F
complete -c ruff -n "__fish_ruff_using_subcommand format" -l exclude -d 'List of paths, used to omit files and/or directories from analysis' -r
complete -c ruff -n "__fish_ruff_using_subcommand format" -l line-length -d 'Set the line-length' -r
complete -c ruff -n "__fish_ruff_using_subcommand format" -l stdin-filename -d 'The name of the file when passing it through stdin' -r -F
complete -c ruff -n "__fish_ruff_using_subcommand format" -l extension -d 'List of mappings from file extension to language (one of `python`, `ipynb`, `pyi`). For example, to treat `.ipy` files as IPython notebooks, use `--extension ipy:ipynb`' -r
complete -c ruff -n "__fish_ruff_using_subcommand format" -l target-version -d 'The minimum Python version that should be supported' -r -f -a "py37\t''
py38\t''
py39\t''
py310\t''
py311\t''
py312\t''
py313\t''
py314\t''"
complete -c ruff -n "__fish_ruff_using_subcommand format" -l range -d 'When specified, Ruff will try to only format the code in the given range. It might be necessary to extend the start backwards or the end forwards, to fully enclose a logical line. The `<RANGE>` uses the format `<start_line>:<start_column>-<end_line>:<end_column>`.' -r
complete -c ruff -n "__fish_ruff_using_subcommand format" -l output-format -d 'Output serialization format for violations, when used with `--check`. The default serialization format is "full"' -r -f -a "concise\t''
full\t''
json\t''
json-lines\t''
junit\t''
grouped\t''
github\t''
gitlab\t''
pylint\t''
rdjson\t''
azure\t''
sarif\t''"
complete -c ruff -n "__fish_ruff_using_subcommand format" -l config -d 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`' -r
complete -c ruff -n "__fish_ruff_using_subcommand format" -l check -d 'Avoid writing any formatted files back; instead, exit with a non-zero status code if any files would have been modified, and zero otherwise'
complete -c ruff -n "__fish_ruff_using_subcommand format" -l diff -d 'Avoid writing any formatted files back; instead, exit with a non-zero status code and the difference between the current file and how the formatted file would look like'
complete -c ruff -n "__fish_ruff_using_subcommand format" -s n -l no-cache -d 'Disable cache reads'
complete -c ruff -n "__fish_ruff_using_subcommand format" -l respect-gitignore -d 'Respect file exclusions via `.gitignore` and other standard ignore files. Use `--no-respect-gitignore` to disable'
complete -c ruff -n "__fish_ruff_using_subcommand format" -l no-respect-gitignore
complete -c ruff -n "__fish_ruff_using_subcommand format" -l force-exclude -d 'Enforce exclusions, even for paths passed to Ruff directly on the command-line. Use `--no-force-exclude` to disable'
complete -c ruff -n "__fish_ruff_using_subcommand format" -l no-force-exclude
complete -c ruff -n "__fish_ruff_using_subcommand format" -l preview -d 'Enable preview mode; enables unstable formatting. Use `--no-preview` to disable'
complete -c ruff -n "__fish_ruff_using_subcommand format" -l no-preview
complete -c ruff -n "__fish_ruff_using_subcommand format" -l exit-non-zero-on-format -d 'Exit with a non-zero status code if any files were modified via format, even if all files were formatted successfully'
complete -c ruff -n "__fish_ruff_using_subcommand format" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_ruff_using_subcommand format" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_ruff_using_subcommand format" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_ruff_using_subcommand format" -l isolated -d 'Ignore all configuration files'
complete -c ruff -n "__fish_ruff_using_subcommand format" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c ruff -n "__fish_ruff_using_subcommand server" -l config -d 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`' -r
complete -c ruff -n "__fish_ruff_using_subcommand server" -l preview -d 'Enable preview mode. Use `--no-preview` to disable'
complete -c ruff -n "__fish_ruff_using_subcommand server" -l no-preview
complete -c ruff -n "__fish_ruff_using_subcommand server" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_ruff_using_subcommand server" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_ruff_using_subcommand server" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_ruff_using_subcommand server" -l isolated -d 'Ignore all configuration files'
complete -c ruff -n "__fish_ruff_using_subcommand server" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and not __fish_seen_subcommand_from graph help" -l config -d 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`' -r
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and not __fish_seen_subcommand_from graph help" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and not __fish_seen_subcommand_from graph help" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and not __fish_seen_subcommand_from graph help" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and not __fish_seen_subcommand_from graph help" -l isolated -d 'Ignore all configuration files'
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and not __fish_seen_subcommand_from graph help" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and not __fish_seen_subcommand_from graph help" -f -a "graph" -d 'Generate a map of Python file dependencies or dependents'
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and not __fish_seen_subcommand_from graph help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and __fish_seen_subcommand_from graph" -l direction -d 'The direction of the import map. By default, generates a dependency map, i.e., a map from file to files that it depends on. Use `--direction dependents` to generate a map from file to files that depend on it' -r -f -a "dependencies\t'Construct a map from module to its dependencies (i.e., the modules that it imports)'
dependents\t'Construct a map from module to its dependents (i.e., the modules that import it)'"
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and __fish_seen_subcommand_from graph" -l min-dots -d 'The minimum number of dots in a string import to consider it a valid import' -r
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and __fish_seen_subcommand_from graph" -l target-version -d 'The minimum Python version that should be supported' -r -f -a "py37\t''
py38\t''
py39\t''
py310\t''
py311\t''
py312\t''
py313\t''
py314\t''"
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and __fish_seen_subcommand_from graph" -l python -d 'Path to a virtual environment to use for resolving additional dependencies' -r -F
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and __fish_seen_subcommand_from graph" -l config -d 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`' -r
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and __fish_seen_subcommand_from graph" -l detect-string-imports -d 'Attempt to detect imports from string literals'
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and __fish_seen_subcommand_from graph" -l preview -d 'Enable preview mode. Use `--no-preview` to disable'
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and __fish_seen_subcommand_from graph" -l no-preview
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and __fish_seen_subcommand_from graph" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and __fish_seen_subcommand_from graph" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and __fish_seen_subcommand_from graph" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and __fish_seen_subcommand_from graph" -l isolated -d 'Ignore all configuration files'
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and __fish_seen_subcommand_from graph" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and __fish_seen_subcommand_from help" -f -a "graph" -d 'Generate a map of Python file dependencies or dependents'
complete -c ruff -n "__fish_ruff_using_subcommand analyze; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ruff -n "__fish_ruff_using_subcommand version" -l output-format -r -f -a "text\t''
json\t''"
complete -c ruff -n "__fish_ruff_using_subcommand version" -l config -d 'Either a path to a TOML configuration file (`pyproject.toml` or `ruff.toml`), or a TOML `<KEY> = <VALUE>` pair (such as you might find in a `ruff.toml` configuration file) overriding a specific configuration option. Overrides of individual settings using this option always take precedence over all configuration files, including configuration files that were also specified using `--config`' -r
complete -c ruff -n "__fish_ruff_using_subcommand version" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_ruff_using_subcommand version" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_ruff_using_subcommand version" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_ruff_using_subcommand version" -l isolated -d 'Ignore all configuration files'
complete -c ruff -n "__fish_ruff_using_subcommand version" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_ruff_using_subcommand help; and not __fish_seen_subcommand_from check rule config linter clean generate-shell-completion format server analyze version help" -f -a "check" -d 'Run Ruff on the given files or directories'
complete -c ruff -n "__fish_ruff_using_subcommand help; and not __fish_seen_subcommand_from check rule config linter clean generate-shell-completion format server analyze version help" -f -a "rule" -d 'Explain a rule (or all rules)'
complete -c ruff -n "__fish_ruff_using_subcommand help; and not __fish_seen_subcommand_from check rule config linter clean generate-shell-completion format server analyze version help" -f -a "config" -d 'List or describe the available configuration options'
complete -c ruff -n "__fish_ruff_using_subcommand help; and not __fish_seen_subcommand_from check rule config linter clean generate-shell-completion format server analyze version help" -f -a "linter" -d 'List all supported upstream linters'
complete -c ruff -n "__fish_ruff_using_subcommand help; and not __fish_seen_subcommand_from check rule config linter clean generate-shell-completion format server analyze version help" -f -a "clean" -d 'Clear any caches in the current directory and any subdirectories'
complete -c ruff -n "__fish_ruff_using_subcommand help; and not __fish_seen_subcommand_from check rule config linter clean generate-shell-completion format server analyze version help" -f -a "generate-shell-completion" -d 'Generate shell completion'
complete -c ruff -n "__fish_ruff_using_subcommand help; and not __fish_seen_subcommand_from check rule config linter clean generate-shell-completion format server analyze version help" -f -a "format" -d 'Run the Ruff formatter on the given files or directories'
complete -c ruff -n "__fish_ruff_using_subcommand help; and not __fish_seen_subcommand_from check rule config linter clean generate-shell-completion format server analyze version help" -f -a "server" -d 'Run the language server'
complete -c ruff -n "__fish_ruff_using_subcommand help; and not __fish_seen_subcommand_from check rule config linter clean generate-shell-completion format server analyze version help" -f -a "analyze" -d 'Run analysis over Python source code'
complete -c ruff -n "__fish_ruff_using_subcommand help; and not __fish_seen_subcommand_from check rule config linter clean generate-shell-completion format server analyze version help" -f -a "version" -d 'Display Ruff\'s version'
complete -c ruff -n "__fish_ruff_using_subcommand help; and not __fish_seen_subcommand_from check rule config linter clean generate-shell-completion format server analyze version help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ruff -n "__fish_ruff_using_subcommand help; and __fish_seen_subcommand_from analyze" -f -a "graph" -d 'Generate a map of Python file dependencies or dependents'
