/*****************************************************************************
 * Project: RooFit                                                           *
 * Package: RooFitCore                                                       *
 *    File: $Id$
 * Authors:                                                                  *
 *   WV, Wouter Verkerke, UC Santa Barbara, verkerke@slac.stanford.edu       *
 *   DK, David Kirkby,    UC Irvine,         dkirkby@uci.edu                 *
 *                                                                           *
 * Copyright (c) 2000-2005, Regents of the University of California          *
 *                          and Stanford University. All rights reserved.    *
 *                                                                           *
 * Redistribution and use in source and binary forms,                        *
 * with or without modification, are permitted according to the terms        *
 * listed in LICENSE (http://roofit.sourceforge.net/license.txt)             *
 *****************************************************************************/
#ifndef ROO_ABS_MOMENT
#define ROO_ABS_MOMENT

#include "RooAbsReal.h"
#include "RooRealProxy.h"
#include "RooSetProxy.h"


class RooRealVar;
class RooArgList ;

class RooAbsMoment : public RooAbsReal {
public:

  RooAbsMoment() = default;
  RooAbsMoment(const char *name, const char *title, RooAbsReal& func, RooRealVar& x, Int_t order=1, bool takeRoot=false) ;
  RooAbsMoment(const RooAbsMoment& other, const char* name = nullptr);

  Int_t order() const { return _order ; }
  bool central() const { return _mean.absArg() ? true : false ; }
  RooAbsReal* mean() { return (RooAbsReal*) _mean.absArg() ; }


protected:

  Int_t _order = 1;                      ///< Moment order
  Int_t _takeRoot = false;               ///< Return n-order root of moment
  RooSetProxy  _nset ;                   ///< Normalization set (optional)
  RooRealProxy _func ;                   ///< Input function
  RooRealProxy _x     ;                  ///< Observable
  RooRealProxy _mean ;                   ///< Mean (if calculated for central moment)

  ClassDefOverride(RooAbsMoment,1) // Abstract representation of moment in a RooAbsReal in a given RooRealVar
};

#endif
