/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLCompoundValue;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

public abstract class YamlKeyCompletionInsertHandler<T extends LookupElement>
implements InsertHandler<T> {
    @NotNull
    protected abstract YAMLKeyValue createNewEntry(@NotNull YAMLDocument var1, T var2, @Nullable YAMLKeyValue var3);

    public void handleInsert(@NotNull InsertionContext context, @NotNull T item) {
        YAMLSequenceItem valueItem;
        YAMLKeyValue created;
        YAMLValue createdValue;
        YAMLValue oldValue;
        if (context == null) {
            YamlKeyCompletionInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            YamlKeyCompletionInsertHandler.$$$reportNull$$$0(1);
        }
        context.setAddCompletionChar(false);
        int startOffset = context.getStartOffset();
        PsiFile psiFile = context.getFile();
        YamlOffsetContext offsetContext = new YamlOffsetContext(psiFile, startOffset);
        YAMLValue yAMLValue = oldValue = offsetContext.holdingDocument.getTopLevelValue() instanceof YAMLCompoundValue ? this.deleteLookupTextAndRetrieveOldValue(context, offsetContext.currentElement) : null;
        if (oldValue instanceof YAMLSequence) {
            YamlKeyCompletionInsertHandler.trimSequenceItemIndents((YAMLSequence)oldValue);
        }
        if (oldValue == null && !offsetContext.holdingDocument.isValid()) {
            offsetContext = new YamlOffsetContext(psiFile, startOffset);
        }
        if ((createdValue = (created = this.createNewEntry(offsetContext.holdingDocument, item, offsetContext.getParentIfValid())).getValue()) != null) {
            context.getEditor().getCaretModel().moveToOffset(createdValue.getTextRange().getStartOffset() - 1);
        } else {
            context.getEditor().getCaretModel().moveToOffset(created.getTextRange().getEndOffset());
        }
        if (oldValue != null) {
            WriteCommandAction.runWriteCommandAction((Project)context.getProject(), (String)YAMLBundle.message((String)"YamlKeyCompletionInsertHandler.insert.value", (Object[])new Object[0]), null, () -> created.setValue(oldValue), (PsiFile[])new PsiFile[0]);
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
        createdValue = created.getValue();
        YAMLSequenceItem yAMLSequenceItem = valueItem = createdValue instanceof YAMLSequence ? (YAMLSequenceItem)ContainerUtil.getFirstItem((List)((YAMLSequence)createdValue).getItems()) : null;
        if (valueItem != null) {
            context.getEditor().getCaretModel().moveToOffset(valueItem.getTextOffset() + 1);
        }
        if (!YamlKeyCompletionInsertHandler.isCharAtCaret(context.getEditor(), ' ')) {
            EditorModificationUtilEx.insertStringAtCaret((Editor)context.getEditor(), (String)" ");
        } else {
            context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
        }
    }

    @Nullable
    protected YAMLValue deleteLookupTextAndRetrieveOldValue(InsertionContext context, @NotNull PsiElement elementAtCaret) {
        YAMLValue oldValue;
        if (elementAtCaret == null) {
            YamlKeyCompletionInsertHandler.$$$reportNull$$$0(2);
        }
        if (elementAtCaret.getNode().getElementType() != YAMLTokenTypes.SCALAR_KEY) {
            YamlKeyCompletionInsertHandler.deleteLookupPlain(context);
            return null;
        }
        YAMLKeyValue keyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, YAMLKeyValue.class);
        assert (keyValue != null);
        assert (keyValue.getParentMapping() != null || keyValue.getParent() instanceof YAMLCompoundValue);
        Document document = context.getDocument();
        String text = document.getText(TextRange.create((int)context.getStartOffset(), (int)context.getTailOffset()));
        if (!keyValue.getKeyText().equals(text)) {
            document.deleteString(context.getStartOffset(), context.getTailOffset());
            context.commitDocument();
            return null;
        }
        context.commitDocument();
        if (keyValue.getValue() != null) {
            YAMLKeyValue dummyKV = YAMLElementGenerator.getInstance((Project)context.getProject()).createYamlKeyValue("foo", "b");
            dummyKV.setValue(keyValue.getValue());
            oldValue = dummyKV.getValue();
        } else {
            oldValue = null;
        }
        context.setTailOffset(keyValue.getTextRange().getEndOffset());
        WriteCommandAction.runWriteCommandAction((Project)context.getProject(), (String)YAMLBundle.message((String)"YamlKeyCompletionInsertHandler.remove.key", (Object[])new Object[0]), null, () -> {
            PsiElement parent = keyValue.getParent();
            PsiElement substitute = null;
            if (parent instanceof YAMLMapping) {
                YAMLMapping parentMapping = (YAMLMapping)parent;
                parentMapping.deleteKeyValue(keyValue);
                Object[] children = parent.getNode().getChildren(null);
                if (children.length == 1 && children[0] instanceof LeafPsiElement) {
                    substitute = children[0].getPsi();
                } else if (children.length != 0 && ContainerUtil.find((Object[])children, node -> node.getElementType() == YAMLElementTypes.KEY_VALUE_PAIR) == null) {
                    List notSpaces = ContainerUtil.filter((Object[])children, child -> !YAMLElementTypes.SPACE_ELEMENTS.contains(child.getElementType()));
                    if (notSpaces.size() == 1) {
                        substitute = ((ASTNode)notSpaces.get(0)).getPsi();
                    } else {
                        String valueText = parent.getText();
                        YAMLFile file = YAMLElementGenerator.getInstance((Project)parent.getProject()).createDummyYamlWithText(valueText);
                        substitute = ((YAMLDocument)file.getDocuments().get(0)).getTopLevelValue();
                        if (substitute == null) {
                            PsiElement grandParent = parent.getParent();
                            PsiElement copy = parent.copy();
                            ASTNode[] copies = copy.getNode().getChildren(null);
                            PsiElement anchor = parent.replace(copies[0].getPsi());
                            for (int i = 1; i < copies.length; ++i) {
                                anchor = grandParent.addAfter(copies[i].getPsi(), anchor);
                            }
                            return;
                        }
                    }
                }
            } else {
                YAMLUtil.deleteSurroundingWhitespace((PsiElement)keyValue);
                keyValue.delete();
            }
            if (parent.getNode().getChildren(null).length == 0) {
                parent.delete();
            } else if (substitute != null) {
                parent.replace(substitute);
            }
        }, (PsiFile[])new PsiFile[0]);
        return oldValue;
    }

    private static void deleteLookupPlain(InsertionContext context) {
        int offset;
        Document document = context.getDocument();
        CharSequence sequence = document.getCharsSequence();
        for (offset = context.getStartOffset() - 1; offset >= 0; --offset) {
            char c = sequence.charAt(offset);
            if (c == ' ' || c == '\t') continue;
            if (c == '\n') {
                if (YamlKeyCompletionInsertHandler.hasDocumentSeparatorBefore(offset, sequence)) break;
                --offset;
                break;
            }
            offset = context.getStartOffset() - 1;
            break;
        }
        document.deleteString(offset + 1, context.getTailOffset());
        context.commitDocument();
    }

    private static boolean hasDocumentSeparatorBefore(int offset, CharSequence sequence) {
        if (offset < 3) {
            return false;
        }
        if (!sequence.subSequence(offset - 3, offset).equals("---")) {
            return false;
        }
        return offset == 3 || sequence.charAt(offset - 4) == '\n';
    }

    public static boolean isCharAtCaret(Editor editor, char ch) {
        int startOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        return document.getTextLength() > startOffset && document.getCharsSequence().charAt(startOffset) == ch;
    }

    public static void trimSequenceItemIndents(YAMLSequence yamlSequence) {
        List items = yamlSequence.getItems();
        if (items.size() > 1) {
            YAMLElementGenerator elementGenerator = YAMLElementGenerator.getInstance((Project)yamlSequence.getProject());
            for (int i = 1; i < items.size(); ++i) {
                PsiElement element = ((YAMLSequenceItem)items.get(i)).getPrevSibling();
                if (element == null || element.getNode().getElementType() != YAMLTokenTypes.INDENT) continue;
                PsiElement newIndent = elementGenerator.createIndent(0);
                element.replace(newIndent);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAtCaret";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/yaml/completion/YamlKeyCompletionInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteLookupTextAndRetrieveOldValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class YamlOffsetContext {
        final PsiElement currentElement;
        final YAMLKeyValue parent;
        final YAMLDocument holdingDocument;

        YamlOffsetContext(@NotNull PsiFile psiFile, int offset) {
            if (psiFile == null) {
                YamlOffsetContext.$$$reportNull$$$0(0);
            }
            this.currentElement = psiFile.findElementAt(offset);
            assert (this.currentElement != null) : "no element at " + offset;
            this.parent = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)this.currentElement, YAMLKeyValue.class);
            PsiElement psiElement = this.currentElement.getParent();
            if (psiElement instanceof YAMLFile) {
                YAMLFile yamlFile = (YAMLFile)psiElement;
                YAMLDocument document = (YAMLDocument)PsiTreeUtil.getPrevSiblingOfType((PsiElement)this.currentElement, YAMLDocument.class);
                this.holdingDocument = document == null ? (YAMLDocument)ContainerUtil.getFirstItem((List)yamlFile.getDocuments()) : document;
            } else {
                this.holdingDocument = (YAMLDocument)PsiTreeUtil.getParentOfType((PsiElement)this.currentElement, YAMLDocument.class);
            }
            assert (this.holdingDocument != null);
        }

        @Nullable
        YAMLKeyValue getParentIfValid() {
            return this.parent != null && this.parent.isValid() ? this.parent : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/yaml/completion/YamlKeyCompletionInsertHandler$YamlOffsetContext", "<init>"));
        }
    }
}

