/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.DateChecker;
import ai.grazie.rules.common.FormattingIssues;
import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.en.EnglishDateChecker;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import java.util.Objects;

class HyphenVsDash {
    private static final NodePattern tShirt = NodePattern.N.inFormSequence(0, "t", ".*", "shirt");
    private static final NodePattern joinsCompound = NodePattern.N.markAs("DashLike").andNot(CommonPatterns.DASH_NODE.spaceAround().directlyAfter(NodePattern.not(CommonPatterns.capitalized))).directlyAfter(NodePattern.N.markAs("BeforeDash").andOr(EnglishTreePatterns.compound.withHead(NodePattern.N.directlyAfter("DashLike")), NodePattern.N.pos("NNP?").withHead("obl:.*", NodePattern.N.pos("JJ")), NodePattern.N.withHeadRelation("obj").withDependent("compound", NodePattern.N.directlyBeforeHead()), CommonPatterns.capitalized.withHeadRelation("amod")).andOr(NodePattern.N.anyPos(), tShirt)).directlyBefore(NodePattern.N.withHead(NodePattern.N.noDependents("compound", NodePattern.N.before("BeforeDash"))).andOr(NodePattern.N.withHead("amod", NodePattern.or(NodePattern.N.pos("NNS"), NodePattern.N.pos("NN").withDependent("det"))), NodePattern.N.withHeadRelation("obj").and(NodePattern.markedNodeMatches("BeforeDash", tShirt))));
    private static final NodePattern separatesPhrases = NodePattern.or(CommonPatterns.separatesHeadDependent(NodePattern.N).andNot(NodePattern.N.noSpaceAround().withHead(NodePattern.N.pos("NN.?").andOr(NodePattern.N.withOnlyDependents(NodePattern.N.withHeadRelation("punct|amod").beforeHead()), NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.N.withHeadRelation("punct|amod"), NodePattern.N.withHeadRelation("parataxis").withOnlyDependents(NodePattern.N.withHeadRelation("amod").beforeHead()))).trace("misattached amod: Open source\u2013friendly licensing"))).trace("Have source code\u2013free laptops")), CommonPatterns.separatesDependentHead(NodePattern.N.withHeadRelation("obl|advcl")));
    private static final NodePattern doubleHyphen = NodePattern.N.form("--");
    static final String ENUMERATION_MSG = "Use an em dash for enumerations or dialogue turns";
    static final NodePattern toEnumerationEmDash = NodePattern.or(CommonPatterns.firstToken, NodePattern.N.directlyAfter(NodePattern.or(CommonPatterns.firstToken.and(Quotes.ANY), FormattingIssues.properlySpacedColon.and(CommonPatterns.reportWithPrevWord)))).markAs("FirstHyphenOrDash").andNot(NodePattern.N.inPhrase(NodePattern.ROOT.withDependent("punct", CommonPatterns.lastWord.sameWordAs("FirstHyphenOrDash")))).andNot(doubleHyphen).andOr(NodePattern.N.spaceAfter(), NodePattern.N.directlyBefore(CommonPatterns.capitalized).reportEverythingTouched()).includeIntoReport().directlyBefore(NodePattern.N.includeIntoReport()).and((node, match) -> match.withCorrector(CommonPatterns.replaceWithWhitespace(node, (node.prevNode() == null ? "" : (FormattingIssues.properlySpacedColon.matches(node.prevNode()) ? "\n" : " ")) + "\u2014 ").batchCapable("FrontHyphenToEmDash")).enableAutoFix().withReportedRange(CommonPatterns.includeSurroundingWhitespace(node), node.tree())).message("Use an em dash for enumerations or dialogue turns");
    private static final NodePattern toParentheticalEmDash = NodePattern.N.spaceBefore().directlyBefore(CommonPatterns.comma).andNot(NodePattern.N.directlyAfter(CommonPatterns.comma)).correct(NodeCorrector.replace("\u2014").batchCapable("ParentheticalHyphenToEmDash")).and(CommonPatterns.reportWithPrevWord).and(CommonPatterns.reportWithNext).and((node, match) -> match.withReportedRange(CommonPatterns.includeSurroundingWhitespace(node), node.tree()).enableAutoFix()).message("Use an em dash after parenthetical clauses");
    private static final NodePattern numberOrCount = NodePattern.N.form("\\d+.*").andNot(NodePattern.N.form(".*[=x\u00d7].*"));
    private static final NodePattern notRangeHead = NodePattern.or(NodePattern.N.lemma("ISO|aircraft|Boeing|Airbus|Bombardier|session"), NodePattern.N.label("GEO_POLITICAL_ENTITY|LOCATION|ORGANIZATION|NICKNAME|EVENT"));
    private static final NodePattern postalHyphen = CommonPatterns.HYPHEN_NODE.andOr(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("root").withDependent("appos")), NodePattern.N.withNeighbor(2, NodePattern.N.label("LOCATION")));
    static final NodePattern separatesRange = NodePattern.not(postalHyphen).andOr(CommonPatterns.beforeSkipping(NodePattern.N.form("BC|AD|[$\u00a3\u20ac\u00a5\u20bd]"), numberOrCount.andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE.andNot(NodePattern.N.directlyBefore(NodePattern.N.lemma("year")))))).and(CommonPatterns.afterSkipping(NodePattern.N.form("BC|AD|[ap]\\.?m\\.?|[$\u00a3\u20ac\u00a5\u20bd]"), numberOrCount.noHeadRelation("nsubj|<unk>").andNot(NodePattern.N.withHead("nummod|compound", notRangeHead)).andNot(NodePattern.N.directlyAfter(NodePattern.or(CommonPatterns.HYPHEN_NODE, notRangeHead))).andNot(NodePattern.or(NodePattern.N.inFormSequence(2, "[123][0-9]{3}", ":", "\\d+"), NodePattern.N.withHead(NodePattern.N.form("p\\.?"))).andNot(CommonPatterns.ascendingRange)))).andNot(NodePattern.N.directlyAfter(DateChecker.year).directlyBefore(NodePattern.N.form("\\d"))), NodePattern.N.inFormSequence(2, "[ap]\\.?m", "\\.", ".*", ".*", "[ap]\\.?m").withNeighbor(-3, numberOrCount).directlyBefore(numberOrCount).reportEverythingTouched(), NodePattern.N.directlyBefore(EnglishDateChecker.INSTANCE.month).directlyAfter(EnglishDateChecker.INSTANCE.month), NodePattern.N.directlyBefore(EnglishDateChecker.INSTANCE.dayOfWeek).directlyAfter(EnglishDateChecker.INSTANCE.dayOfWeek));
    private static final NodePattern variable = NodePattern.N.form("\\d+|[a-z]\\d*");
    private static final NodePattern seemsMinus = NodePattern.or(CommonPatterns.afterSkipping(CommonPatterns.closingParen, CommonPatterns.afterSkipping(CommonPatterns.openingParen, CommonPatterns.arithmetics)), CommonPatterns.beforeSkipping(CommonPatterns.openingParen, CommonPatterns.beforeSkipping(CommonPatterns.closingParen, CommonPatterns.arithmetics)), CommonPatterns.afterSkipping(CommonPatterns.closingParen, variable).and(CommonPatterns.beforeSkipping(CommonPatterns.openingParen, variable)));
    private static final String HYPHEN_TO_DASH_MSG = "Use a dash to separate phrases";
    private static final String RANGE_MSG = "Use an en dash in ranges and scores";
    private static final String COMPOUND_MSG = "Use a no-space hyphen in compound words";
    private static final NodePattern toEnInRange = separatesRange.and(CommonPatterns.reportWithNext).directlyAfter(NodePattern.N.includeIntoReport()).and((node, match) -> match.withCorrector(CommonPatterns.replaceWithWhitespace(node, "\u2013").batchCapable("RangeToEnDash"))).message("Use an en dash in ranges and scores");

    HyphenVsDash() {
    }

    static NodePattern hyphenToDash() {
        NodePattern allow2Hyphen = NodePattern.or(NodePattern.N.withDependent(".*", NodePattern.N.formCaseSensitive("#+|.*kmmacros|exec")), NodePattern.N.withPhraseStart(NodePattern.N.formCaseSensitive("end|draw.io")));
        return CommonPatterns.dashLikeHyphens.markAs("Hyphen").andNot(CommonPatterns.HYPHEN_NODE.directlyBefore(CommonPatterns.HYPHEN_NODE.spaceAfter())).andNot(CommonPatterns.HYPHEN_NODE.spaceAfter().directlyAfter(CommonPatterns.HYPHEN_NODE.spaceBefore())).andNot(doubleHyphen.directlyBefore(NodePattern.N.form("[\\[:-]"))).andNot(doubleHyphen.directlyAfter(NodePattern.N.form("[;\\]-]"))).andNot(doubleHyphen.withHead(NodePattern.N.form("#+"))).andNot(NodePattern.N.inPhrase(allow2Hyphen)).andNot(NodePattern.N.withNextSibling(allow2Hyphen)).andOr(toParentheticalEmDash, NodePattern.N.spaceAround().and(separatesPhrases).andNot(separatesRange).andNot(seemsMinus).andNot(NodePattern.N.directlyAfter(EnglishTreePatterns.dashes.spaceAround())).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.dashes.spaceAround())).directlyAfter(NodePattern.not(CommonPatterns.colon)).and(CommonPatterns.reportWithPrevWord).directlyBefore(NodePattern.N.includeIntoReport()).andOptionally(EnglishParameters.DASH_STYLE.withValue("|emDashNoSpace").and(NodePattern.custom((node, match) -> match.withCorrector(CommonPatterns.replaceWithWhitespace(node, "\u2014").batchCapable("PhraseHyphenToNoSpaceEmDash"))))).andOptionally(EnglishParameters.DASH_STYLE.withValue("|emDashSpaced").and(NodePattern.custom((node, match) -> match.withCorrector(CommonPatterns.replaceWithWhitespace(node, " \u2014 ").batchCapable("PhraseHyphenToSpacedEmDash"))))).andOptionally(EnglishParameters.DASH_STYLE.withValue("|enDash").correct(NodeCorrector.replace("\u2013").batchCapable("PhraseHyphenToEnDash"))).and((node, match) -> match.enableAutoFix()).message(HYPHEN_TO_DASH_MSG));
    }

    static NodePattern hyphenVsDash() {
        return NodePattern.or(NodePattern.N.form("\u2013").andOr(toEnumerationEmDash, toParentheticalEmDash), NodePattern.N.form("\u2013").andNot(NodePattern.N.spaceAround()).andNot(NodePattern.N.directlyBefore(numberOrCount)).andNot(NodePattern.N.directlyAfter(numberOrCount)).and(separatesPhrases).and(CommonPatterns.reportWithPrevWord).and(CommonPatterns.reportWithNext).and((node, match) -> match.withCorrector(CommonPatterns.replaceWithWhitespace(node, " \u2013 ").batchCapable("PhraseEnDashSpace"))).message("Surround en-dashes with spaces when separating phrases"), NodePattern.or(CommonPatterns.HYPHEN_NODE.spaceAround(), CommonPatterns.DASH_NODE).and(joinsCompound).and((dashLike, match) -> {
            NodeCorrector corrector = CommonPatterns.replaceWithWhitespace(dashLike, "-");
            for (Node compound : Objects.requireNonNull(dashLike.prevNode()).findDependents("compound")) {
                if (!compound.isBefore(dashLike)) continue;
                corrector = corrector.join(NodeCorrector.rawReplace(compound.endOffset(), Objects.requireNonNull(compound.nextNode()).startOffset(), "-"));
                match = match.withReportedNode(compound);
            }
            return match.withCorrector(corrector);
        }).and(CommonPatterns.reportWithPrevWord).message(COMPOUND_MSG));
    }

    static NodePattern hyphenInRanges() {
        return NodePattern.or(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("\u2014")).andOr(toEnInRange, NodePattern.not(CommonPatterns.noSpaceHyphen).directlyBefore(CommonPatterns.capitalizedMiddle.label("LOCATION|GEO_POLITICAL_ENTITY").andNot(CommonPatterns.skipUp("compound", NodePattern.N.withDependent("conj")))).directlyAfter(CommonPatterns.capitalized.label("LOCATION|GEO_POLITICAL_ENTITY")).and((node, match) -> match.withCorrector(CommonPatterns.replaceWithWhitespace(node, "\u2013").batchCapable("RangeToEnDash"))).reportEverythingTouched().message("The en dash usually replaces the word 'to' between place names"));
    }
}

