/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XNamedTreeNode;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.InlineDebuggerHelper;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.impl.PyCodeFragmentWithHiddenImports;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebuggerEditorsProvider
extends XDebuggerEditorsProvider {
    @NotNull
    public FileType getFileType() {
        PythonFileType pythonFileType = PythonFileType.INSTANCE;
        if (pythonFileType == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(0);
        }
        return pythonFileType;
    }

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull XExpression expression, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        if (project == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(2);
        }
        if (mode == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(3);
        }
        String text = expression.getExpression().trim();
        PyCodeFragmentWithHiddenImports fragment = new PyCodeFragmentWithHiddenImports(project, "fragment.py", (CharSequence)text, true);
        PsiElement element = PyDebuggerEditorsProvider.getContextElement(project, sourcePosition);
        fragment.setContext(element);
        if (expression.getCustomInfo() != null) {
            fragment.addImportsFromStrings(expression.getCustomInfo().lines().toList());
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
        if (document == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(4);
        }
        return document;
    }

    @NotNull
    public XExpression createExpression(@NotNull Project project, @NotNull Document document, @Nullable Language language, @NotNull EvaluationMode mode) {
        PsiFile file;
        if (project == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(5);
        }
        if (document == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(6);
        }
        if (mode == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(7);
        }
        if ((file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) instanceof PyCodeFragmentWithHiddenImports) {
            PyCodeFragmentWithHiddenImports fragment = (PyCodeFragmentWithHiddenImports)file;
            List pseudoImports = fragment.getPseudoImports();
            String customInfo = StringUtil.nullize((String)StringUtil.join((Collection)pseudoImports, PsiElement::getText, (String)"\n"));
            return new XExpressionImpl(fragment.getText(), language, customInfo, mode);
        }
        XExpression xExpression = super.createExpression(project, document, language, mode);
        if (xExpression == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(8);
        }
        return xExpression;
    }

    @VisibleForTesting
    @Nullable
    public static PsiElement getContextElement(Project project, XSourcePosition sourcePosition) {
        if (sourcePosition != null) {
            int offset;
            Document document = FileDocumentManager.getInstance().getDocument(sourcePosition.getFile());
            if (document == null) {
                return null;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile != null && (offset = sourcePosition.getOffset()) >= 0 && offset < document.getTextLength()) {
                PsiElement element;
                int lineEndOffset = document.getLineEndOffset(document.getLineNumber(offset));
                do {
                    if ((element = psiFile.findElementAt(offset)) != null && !(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment)) {
                        return PyPsiUtils.getStatement((PsiElement)element);
                    }
                    if (element != null) continue;
                    return null;
                } while ((offset = element.getTextRange().getEndOffset()) < lineEndOffset);
            }
        }
        return null;
    }

    @NotNull
    public InlineDebuggerHelper getInlineDebuggerHelper() {
        PyInlineDebuggerHelper pyInlineDebuggerHelper = PyInlineDebuggerHelper.INSTANCE;
        if (pyInlineDebuggerHelper == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(9);
        }
        return pyInlineDebuggerHelper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyDebuggerEditorsProvider";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyDebuggerEditorsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineDebuggerHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static final class PyInlineDebuggerHelper
    extends InlineDebuggerHelper {
        private static final PyInlineDebuggerHelper INSTANCE = new PyInlineDebuggerHelper();

        private PyInlineDebuggerHelper() {
        }

        public boolean shouldEvaluateChildrenByDefault(XNamedTreeNode node) {
            return false;
        }
    }
}

