/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitNewBranchOptions;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchCheckoutOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J.\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0017\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgit4idea/ui/branch/GitCheckoutAndRebaseRemoteBranchWorkflow;", "", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "brancher", "Lgit4idea/branch/GitBrancher;", "kotlin.jvm.PlatformType", "execute", "", "startPoint", "", "options", "Lgit4idea/branch/GitNewBranchOptions;", "doCreateNewBranch", "name", "reset", "", "createBranch", "force", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCheckoutAndRebaseRemoteBranchWorkflow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCheckoutAndRebaseRemoteBranchWorkflow.kt\ngit4idea/ui/branch/GitCheckoutAndRebaseRemoteBranchWorkflow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1761#2,3:102\n3301#2,10:105\n*S KotlinDebug\n*F\n+ 1 GitCheckoutAndRebaseRemoteBranchWorkflow.kt\ngit4idea/ui/branch/GitCheckoutAndRebaseRemoteBranchWorkflow\n*L\n30#1:102,3\n75#1:105,10\n*E\n"})
public final class GitCheckoutAndRebaseRemoteBranchWorkflow {
    @NotNull
    private final Project project;
    @NotNull
    private final List<GitRepository> repositories;
    private final GitBrancher brancher;

    public GitCheckoutAndRebaseRemoteBranchWorkflow(@NotNull Project project, @NotNull List<? extends GitRepository> repositories) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        this.project = project;
        this.repositories = repositories;
        this.brancher = GitBrancher.getInstance(this.project);
        boolean bl2 = bl = !((Collection)this.repositories).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final void execute(@NotNull String startPoint, @NotNull GitNewBranchOptions options) {
        Object[] objectArray;
        boolean bl;
        Object[] $this$any$iv;
        boolean reset;
        String name;
        block9: {
            Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            name = options.getName();
            reset = options.shouldReset();
            $this$any$iv = (Object[])this.repositories;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object objectArray2 : $this$any$iv) {
                    GitRepository it = (GitRepository)objectArray2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getCurrentBranchName(), (Object)name)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            $this$any$iv = new Object[]{name};
            VcsNotifier.getInstance((Project)this.project).notifyError("git.branch.operation.error", GitBundle.message("branches.checkout.and.rebase.failed", new Object[0]), GitBundle.message("branches.checkout.and.rebase.error.current.with.same.name", $this$any$iv));
            return;
        }
        boolean localHasMoreCommits = GitBranchCheckoutOperation.Companion.checkLocalHasMoreCommits$intellij_vcs_git(this.project, (Collection<? extends GitRepository>)this.repositories, name, startPoint);
        if (localHasMoreCommits) {
            if (reset) {
                objectArray = new Object[]{name, startPoint};
                result = Messages.showYesNoDialog((String)GitBundle.message("branches.create.with.reset.local.has.more.commits", objectArray), (String)GitBundle.message("checkout.0", objectArray = new Object[]{startPoint}), (String)GitBundle.message("branches.drop.local.commits", new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), null);
                if (result != 0) {
                    return;
                }
            } else {
                objectArray = new Object[]{name, startPoint};
                result = Messages.showYesNoDialog((String)GitBundle.message("branches.create.local.has.more.commits", objectArray), (String)GitBundle.message("checkout.0", objectArray = new Object[]{startPoint}), (String)GitBundle.message("new.branch.dialog.operation.create.name", new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), null);
                if (result != 0) {
                    return;
                }
            }
        }
        Project project = this.project;
        Object[] objectArray2 = new Object[]{startPoint};
        objectArray = GitBundle.message("branches.checkout.and.rebase.onto.current.process", objectArray2);
        new Task.Backgroundable(name, this, startPoint, reset, project, (String)objectArray){
            final /* synthetic */ String $name;
            final /* synthetic */ GitCheckoutAndRebaseRemoteBranchWorkflow this$0;
            final /* synthetic */ String $startPoint;
            final /* synthetic */ boolean $reset;
            {
                this.$name = $name;
                this.this$0 = $receiver;
                this.$startPoint = $startPoint;
                this.$reset = $reset;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public void run(ProgressIndicator indicator) {
                Object[] objectArray;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    objectArray = new Object[]{this.$name};
                    indicator.setText2(GitBundle.message("branch.creating.branch.process", objectArray));
                    GitCheckoutAndRebaseRemoteBranchWorkflow.access$doCreateNewBranch(this.this$0, this.$startPoint, this.$name, this.$reset);
                }
                catch (Exception e) {
                    GitBranchUiHandlerImpl gitBranchUiHandlerImpl = new GitBranchUiHandlerImpl(this.getProject(), indicator);
                    Object[] objectArray2 = new Object[]{this.$name};
                    String string = GitBundle.message("create.branch.operation.could.not.create.new.branch", objectArray2);
                    String string2 = e.getMessage();
                    Intrinsics.checkNotNull((Object)string2);
                    gitBranchUiHandlerImpl.notifyError(string, string2);
                }
                objectArray = new Object[]{this.$name};
                indicator.setText2(GitBundle.message("branch.rebasing.process", objectArray));
                GitCheckoutAndRebaseRemoteBranchWorkflow.access$getBrancher$p(this.this$0).rebaseOnCurrent(GitCheckoutAndRebaseRemoteBranchWorkflow.access$getRepositories$p(this.this$0), this.$name);
            }
        }.queue();
    }

    private final void doCreateNewBranch(String startPoint, String name, boolean reset) {
        Iterable $this$partition$iv = this.repositories;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            GitRepository it = (GitRepository)element$iv;
            boolean bl = false;
            boolean bl2 = it.getBranches().findLocalBranch(name) != null ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List reposWithLocalBranch = (List)pair.component1();
        List reposWithoutLocalBranch = (List)pair.component2();
        if (!((Collection)reposWithLocalBranch).isEmpty() && reset) {
            this.createBranch(name, startPoint, reposWithLocalBranch, true);
        }
        if (!((Collection)reposWithoutLocalBranch).isEmpty()) {
            this.createBranch(name, startPoint, reposWithoutLocalBranch, false);
        }
    }

    private final void createBranch(String name, String startPoint, List<? extends GitRepository> repositories, boolean force) {
        Git git = Git.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)git, (String)"getInstance(...)");
        Git git2 = git;
        for (GitRepository gitRepository : repositories) {
            GitCommandResult result2;
            Intrinsics.checkNotNullExpressionValue((Object)git2.branchCreate(gitRepository, name, startPoint, force), (String)"branchCreate(...)");
            if (result2.success()) {
                gitRepository.update();
                continue;
            }
            throw new IllegalStateException(result2.getErrorOutputAsHtmlString());
        }
    }

    public static final /* synthetic */ void access$doCreateNewBranch(GitCheckoutAndRebaseRemoteBranchWorkflow $this, String startPoint, String name, boolean reset) {
        $this.doCreateNewBranch(startPoint, name, reset);
    }

    public static final /* synthetic */ GitBrancher access$getBrancher$p(GitCheckoutAndRebaseRemoteBranchWorkflow $this) {
        return $this.brancher;
    }

    public static final /* synthetic */ List access$getRepositories$p(GitCheckoutAndRebaseRemoteBranchWorkflow $this) {
        return $this.repositories;
    }
}

