/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;

public class PyFunctionFixer
extends PyFixer<PyFunction> {
    public PyFunctionFixer() {
        super(PyFunction.class);
    }

    @Override
    public void doApply(@NotNull Editor editor2, @NotNull PySmartEnterProcessor processor, @NotNull PyFunction function) throws IncorrectOperationException {
        if (editor2 == null) {
            PyFunctionFixer.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            PyFunctionFixer.$$$reportNull$$$0(1);
        }
        if (function == null) {
            PyFunctionFixer.$$$reportNull$$$0(2);
        }
        PsiElement colon = PyPsiUtils.getFirstChildOfType((PsiElement)function, (PyElementType)PyTokenTypes.COLON);
        if (!PyFunctionFixer.isFakeFunction(function) && colon == null) {
            PyAnnotation annotation;
            PyParameterList parameterList = function.getParameterList();
            if (function.getNameNode() == null) {
                processor.registerUnresolvedError(parameterList.getTextOffset());
            }
            int colonOffset = (annotation = function.getAnnotation()) != null ? annotation.getTextRange().getEndOffset() : parameterList.getTextRange().getEndOffset();
            editor2.getDocument().insertString(colonOffset, (CharSequence)":");
        }
    }

    static boolean isFakeFunction(@NotNull PyFunction function) {
        if (function == null) {
            PyFunctionFixer.$$$reportNull$$$0(3);
        }
        return function.getNode().findChildByType((IElementType)PyTokenTypes.DEF_KEYWORD) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyFunctionFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doApply";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isFakeFunction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

