/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.util.textCompletion.ValuesCompletionProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class TwoStepCompletionProvider<T>
extends ValuesCompletionProvider<T> {
    private static final Logger LOG = Logger.getInstance(TwoStepCompletionProvider.class);
    private static final int TIMEOUT = 100;

    public TwoStepCompletionProvider(@NotNull TextCompletionValueDescriptor<T> presentation) {
        if (presentation == null) {
            TwoStepCompletionProvider.$$$reportNull$$$0(0);
        }
        super(presentation, Collections.emptyList());
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            TwoStepCompletionProvider.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            TwoStepCompletionProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            TwoStepCompletionProvider.$$$reportNull$$$0(3);
        }
        this.addValues(result, this.sortVariants(this.collectSync(result)));
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> this.sortVariants(this.collectAsync(result)));
        while (true) {
            try {
                List moreValues;
                do {
                    ProgressManager.checkCanceled();
                } while ((moreValues = (List)future.get(100L, TimeUnit.MILLISECONDS)) == null);
                this.addValues(result, moreValues);
            }
            catch (TimeoutException moreValues) {
                continue;
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
            catch (ProcessCanceledException e) {
                future.cancel(true);
                throw e;
            }
            catch (InterruptedException | CancellationException e) {
                // empty catch block
            }
            break;
        }
        result.stopHere();
    }

    @NotNull
    private List<? extends T> sortVariants(@NotNull Stream<? extends T> result) {
        if (result == null) {
            TwoStepCompletionProvider.$$$reportNull$$$0(4);
        }
        List list = result.sorted((Comparator<T>)this.myDescriptor).collect(Collectors.toList());
        if (list == null) {
            TwoStepCompletionProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    private void addValues(@NotNull CompletionResultSet result, @NotNull Collection<? extends T> values) {
        if (result == null) {
            TwoStepCompletionProvider.$$$reportNull$$$0(6);
        }
        if (values == null) {
            TwoStepCompletionProvider.$$$reportNull$$$0(7);
        }
        for (T completionVariant : values) {
            result.addElement(this.installInsertHandler(this.myDescriptor.createLookupBuilder(completionVariant)));
        }
    }

    @NotNull
    protected abstract Stream<? extends T> collectSync(@NotNull CompletionResultSet var1);

    @NotNull
    protected abstract Stream<? extends T> collectAsync(@NotNull CompletionResultSet var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/actions/TwoStepCompletionProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/actions/TwoStepCompletionProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sortVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sortVariants";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addValues";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

