/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard.splitApi.frontend;

import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewUIUtils;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class RunDashboardUiUtils {
    @NonNls
    public static final String RUN_DASHBOARD_CONTENT_TOOLBAR = "RunDashboardContentToolbar";

    private RunDashboardUiUtils() {
    }

    public static void updateContentToolbar(Content content, boolean visible) {
        RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent((Content)content);
        RunnerLayoutUiImpl ui = RunDashboardUiUtils.getRunnerLayoutUi(descriptor);
        if (ui != null) {
            if (!ServiceViewUIUtils.isNewServicesUIEnabled()) {
                ui.setLeftToolbarVisible(visible);
            }
            ui.setContentToolbarBefore(visible);
        } else {
            ActionToolbar toolbar = RunDashboardUiUtils.findActionToolbar(descriptor);
            if (toolbar != null) {
                toolbar.getComponent().setVisible(visible);
            }
        }
    }

    public static void setupToolbar(@NotNull JPanel mainPanel, @NotNull JComponent component, @NotNull Project project) {
        AnAction anAction;
        if (mainPanel == null) {
            RunDashboardUiUtils.$$$reportNull$$$0(0);
        }
        if (component == null) {
            RunDashboardUiUtils.$$$reportNull$$$0(1);
        }
        if (project == null) {
            RunDashboardUiUtils.$$$reportNull$$$0(2);
        }
        if (ServiceViewUIUtils.isNewServicesUIEnabled() && (anAction = ActionManager.getInstance().getAction(RUN_DASHBOARD_CONTENT_TOOLBAR)) instanceof ActionGroup) {
            ActionGroup group = (ActionGroup)anAction;
            group.registerCustomShortcutSet(component, (Disposable)project);
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ServicesToolbar", group, true);
            toolbar.setTargetComponent(component);
            mainPanel.add((Component)ServiceViewUIUtils.wrapServicesAligned((ActionToolbar)toolbar), "North");
            int left = 0;
            int right = 0;
            Border border = toolbar.getComponent().getBorder();
            if (border != null) {
                Insets insets = border.getBorderInsets(toolbar.getComponent());
                left = insets.left;
                right = insets.right;
            }
            toolbar.getComponent().setBorder((Border)JBUI.Borders.empty((int)1, (int)left, (int)0, (int)right));
            component.setBorder(IdeBorderFactory.createBorder((int)2));
        }
        ClientProperty.put((JComponent)mainPanel, (Key)ServiceViewDescriptor.ACTION_HOLDER_KEY, (Object)Boolean.TRUE);
    }

    @Nullable
    public static RunnerLayoutUiImpl getRunnerLayoutUi(@Nullable RunContentDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        RunnerLayoutUi layoutUi = descriptor.getRunnerLayoutUi();
        return layoutUi instanceof RunnerLayoutUiImpl ? (RunnerLayoutUiImpl)layoutUi : null;
    }

    @Nullable
    public static ActionToolbar findActionToolbar(@Nullable RunContentDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        JComponent descriptorComponent = descriptor.getComponent();
        if (descriptorComponent == null) {
            return null;
        }
        for (Component component : descriptorComponent.getComponents()) {
            if (!(component instanceof ActionToolbar)) continue;
            return (ActionToolbar)component;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "mainPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/platform/execution/dashboard/splitApi/frontend/RunDashboardUiUtils";
        objectArray[2] = "setupToolbar";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

