/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.restructuredtext.python.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.restructuredtext.RestBundle;
import com.intellij.restructuredtext.python.RestPythonPreviewProviderKt;
import com.intellij.restructuredtext.python.editor.RestJcefHtmlPanel;
import com.intellij.restructuredtext.python.editor.RestPreviewPanel;
import com.intellij.restructuredtext.python.editor.RestSettings;
import com.intellij.restructuredtext.python.editor.RestSwingHtmlPanel;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestPreviewFileEditor
extends UserDataHolderBase
implements FileEditor {
    private static final long PARSING_CALL_TIMEOUT_MS = 50L;
    private static final String NO_PREVIEW = "<h2>No preview available.</h2><br/><br/>";
    private static final long RENDERING_DELAY_MS = 20L;
    @NotNull
    private final RestPreviewPanel myPanel;
    @NotNull
    private final VirtualFile myFile;
    private final Project myProject;
    @Nullable
    private final Document myDocument;
    @NotNull
    private final Alarm myPooledAlarm;
    @NotNull
    private final Alarm mySwingAlarm;
    private final Object REQUESTS_LOCK;
    @Nullable
    private Runnable myLastRequest;
    @NotNull
    private String myLastRenderedHtml;

    public RestPreviewFileEditor(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            RestPreviewFileEditor.$$$reportNull$$$0(0);
        }
        this.myPooledAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.mySwingAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.REQUESTS_LOCK = new Object();
        this.myLastRequest = null;
        this.myLastRenderedHtml = "";
        this.myFile = file;
        this.myProject = project;
        this.myDocument = FileDocumentManager.getInstance().getDocument(this.myFile);
        RestPreviewPanel restPreviewPanel = this.myPanel = RestSettings.getInstance().getCurrentPanel().equals("JCEF") ? new RestJcefHtmlPanel(this.myProject) : new RestSwingHtmlPanel();
        if (this.myDocument != null) {
            this.myDocument.addDocumentListener(new DocumentListener(){

                public void beforeDocumentChange(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    RestPreviewFileEditor.this.myPooledAlarm.cancelAllRequests();
                }

                public void documentChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    RestPreviewFileEditor.this.myPooledAlarm.addRequest(() -> RestPreviewFileEditor.this.updateHtml(), 50L);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/restructuredtext/python/editor/RestPreviewFileEditor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeDocumentChange";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "documentChanged";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)this);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel.getComponent();
        if (jComponent == null) {
            RestPreviewFileEditor.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getComponent();
    }

    @NotNull
    public String getName() {
        String string = RestBundle.message((String)"restructuredtext.html.preview.editor.name", (Object[])new Object[0]);
        if (string == null) {
            RestPreviewFileEditor.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            RestPreviewFileEditor.$$$reportNull$$$0(3);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        this.myPooledAlarm.cancelAllRequests();
        this.myPooledAlarm.addRequest(() -> this.updateHtml(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHtml() {
        if (!this.myFile.isValid() || this.myDocument == null || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        Pair<String, String> htmlAndError = RestPythonPreviewProviderKt.toHtml(this.myDocument.getText(), this.myFile, this.myProject);
        if (htmlAndError == null) {
            return;
        }
        Object html = (String)htmlAndError.getFirst();
        if (((String)html).isEmpty()) {
            html = NO_PREVIEW + (String)htmlAndError.getSecond();
        }
        if (!this.myFile.isValid() || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        Object object = this.REQUESTS_LOCK;
        synchronized (object) {
            if (this.myLastRequest != null) {
                this.mySwingAlarm.cancelRequest(this.myLastRequest);
            }
            Object finalHtml = html;
            this.myLastRequest = () -> this.lambda$updateHtml$1((String)finalHtml);
            this.mySwingAlarm.addRequest(this.myLastRequest, 20L, ModalityState.stateForComponent((Component)this.getComponent()));
        }
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            RestPreviewFileEditor.$$$reportNull$$$0(4);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            RestPreviewFileEditor.$$$reportNull$$$0(5);
        }
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            RestPreviewFileEditor.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$updateHtml$1(String finalHtml) {
        if (!finalHtml.equals(this.myLastRenderedHtml)) {
            this.myLastRenderedHtml = finalHtml;
            this.myPanel.setHtml(this.myLastRenderedHtml);
        }
        this.myPanel.render();
        Object object = this.REQUESTS_LOCK;
        synchronized (object) {
            this.myLastRequest = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/restructuredtext/python/editor/RestPreviewFileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/restructuredtext/python/editor/RestPreviewFileEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6 -> new IllegalStateException(string);
        };
    }
}

