/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.internal.performanceTests.ProjectInitializationDiagnosticService;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.NlsSafe;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ProjectInitializationDiagnosticServiceImpl
implements ProjectInitializationDiagnosticService {
    private static final Logger LOG = Logger.getInstance(ProjectInitializationDiagnosticServiceImpl.class);
    private final boolean disabledOutsideIntegrationTests;
    private final ProjectInitializationDiagnosticService.ActivityTracker dumbTracker;
    private final Project myProject;
    private final Object LOCK;
    private final AtomicLong keyNumberCounter;
    private final Long2ObjectMap<Supplier<@NotNull @NlsSafe String>> activities;

    public ProjectInitializationDiagnosticServiceImpl(@NotNull Project project) {
        if (project == null) {
            ProjectInitializationDiagnosticServiceImpl.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.keyNumberCounter = new AtomicLong();
        this.activities = new Long2ObjectOpenHashMap();
        this.disabledOutsideIntegrationTests = !ApplicationManagerEx.isInIntegrationTest();
        this.myProject = this.disabledOutsideIntegrationTests ? null : project;
        this.dumbTracker = this.disabledOutsideIntegrationTests ? new ProjectInitializationDiagnosticService.ActivityTracker(this){

            public void activityFinished() {
            }
        } : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectInitializationDiagnosticService.ActivityTracker registerBeginningOfInitializationActivity(@NotNull @NotNull Supplier<@NotNull @NlsSafe String> debugMessageProducer) {
        if (debugMessageProducer == null) {
            ProjectInitializationDiagnosticServiceImpl.$$$reportNull$$$0(1);
        }
        if (this.disabledOutsideIntegrationTests) {
            return this.dumbTracker;
        }
        long keyNumber = this.keyNumberCounter.getAndIncrement();
        Object object = this.LOCK;
        synchronized (object) {
            this.activities.put(keyNumber, debugMessageProducer);
        }
        return new MyActivityTracker(keyNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProjectInitializationAndIndexingFinished() {
        Supplier nextMessage;
        if (this.disabledOutsideIntegrationTests) {
            return true;
        }
        if (!StartupManager.getInstance((Project)this.myProject).postStartupActivityPassed()) {
            LOG.info("Project startup activities are not finished yet.");
            return false;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.activities.isEmpty()) {
                return true;
            }
            nextMessage = (Supplier)this.activities.values().iterator().next();
        }
        LOG.info("Project initialization & indexing not finished. " + (String)nextMessage.get() + " is still running");
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugMessageProducer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/ProjectInitializationDiagnosticServiceImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBeginningOfInitializationActivity";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyActivityTracker
    implements ProjectInitializationDiagnosticService.ActivityTracker {
        private final long code;

        private MyActivityTracker(long code) {
            this.code = code;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activityFinished() {
            Object object = ProjectInitializationDiagnosticServiceImpl.this.LOCK;
            synchronized (object) {
                ProjectInitializationDiagnosticServiceImpl.this.activities.remove(this.code);
            }
        }
    }
}

