/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class Annotation
extends Expression {
    private boolean _hasArgumentList;

    public Annotation() {
        super(-34);
    }

    public final AstType getType() {
        return this.getChildByRole(Roles.TYPE);
    }

    public final void setType(AstType type) {
        this.setChildByRole(Roles.TYPE, type);
    }

    public final boolean hasArgumentList() {
        return this._hasArgumentList;
    }

    public final void setHasArgumentList(boolean hasArgumentList) {
        this.verifyNotFrozen();
        this._hasArgumentList = hasArgumentList;
    }

    public final AstNodeCollection<Expression> getArguments() {
        return this.getChildrenByRole(Roles.ARGUMENT);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.UNKNOWN;
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitAnnotation(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof Annotation) {
            Annotation otherAnnotation = (Annotation)other;
            return !otherAnnotation.isNull() && this.getType().matches(otherAnnotation.getType(), match) && this.getArguments().matches(otherAnnotation.getArguments(), match);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.isNull() ? "Null" : this.getText();
    }
}

