/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UGroup;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.Style;

public class ComponentRoseActiveLine
extends AbstractComponent {
    private final Fashion symbolContext = this.getSymbolContext();
    private final boolean closeUp;
    private final boolean closeDown;
    private final Display stringsToDisplay;

    public ComponentRoseActiveLine(Style style, boolean closeUp, boolean closeDown, Display stringsToDisplay, ISkinParam skinParam) {
        super(style, skinParam);
        this.closeUp = closeUp;
        this.closeDown = closeDown;
        this.stringsToDisplay = stringsToDisplay == null ? Display.NULL : stringsToDisplay;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        XDimension2D dimensionToUse = area.getDimensionToUse();
        StringBounder stringBounder = ug.getStringBounder();
        int x = (int)(dimensionToUse.getWidth() - this.getPreferredWidth(stringBounder)) / 2;
        if (dimensionToUse.getHeight() == 0.0) {
            return;
        }
        ug.startGroup(UGroup.singletonMap(UGroupType.TITLE, this.stringsToDisplay.toTooltipText()));
        URectangle rect = URectangle.build(this.getPreferredWidth(stringBounder), dimensionToUse.getHeight());
        if (this.symbolContext.isShadowing()) {
            rect.setDeltaShadow(1.0);
        }
        ug = ug.apply(this.symbolContext.getForeColor());
        if (this.closeUp && this.closeDown) {
            ug.apply(this.symbolContext.getBackColor().bg()).apply(UTranslate.dx(x)).draw(rect);
        } else {
            ug.apply(this.symbolContext.getBackColor().bg()).apply(this.symbolContext.getBackColor()).apply(UTranslate.dx(x)).draw(rect);
            ULine vline = ULine.vline(dimensionToUse.getHeight());
            ug.apply(UTranslate.dx(x)).draw(vline);
            ug.apply(UTranslate.dx((double)x + this.getPreferredWidth(stringBounder))).draw(vline);
            ULine hline = ULine.hline(this.getPreferredWidth(stringBounder));
            if (this.closeUp) {
                ug.apply(UTranslate.dx(x)).draw(hline);
            }
            if (this.closeDown) {
                ug.apply(new UTranslate(x, dimensionToUse.getHeight())).draw(hline);
            }
        }
        ug.closeGroup();
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return 10.0;
    }
}

