/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionInitializer;
import org.ldaptive.Credential;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.props.DefaultConnectionFactoryPropertySource;
import org.ldaptive.props.PropertySource;

public abstract class AbstractCli {
    protected static final String OPT_HELP = "help";
    protected static final String OPT_PROVIDER_PROPERTIES = "providerProperties";
    protected final Options options = new Options();
    protected boolean outputDsmlv1;

    public final int performAction(String[] args) {
        this.initOptions();
        int status = -1;
        try {
            if (args.length > 0) {
                DefaultParser parser = new DefaultParser();
                CommandLine line = parser.parse(this.options, args, false);
                status = this.dispatch(line);
            } else {
                this.printExamples();
            }
        }
        catch (ParseException pex) {
            System.err.println("Failed parsing command arguments: " + pex.getMessage());
        }
        catch (IllegalArgumentException iaex) {
            String msg = "Operation failed: " + iaex.getMessage();
            if (iaex.getCause() != null) {
                msg = msg + " Underlying reason: " + iaex.getCause().getMessage();
            }
            System.err.println(msg);
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (LdapException ex) {
            System.err.println("LDAP Operation failed:");
            ex.printStackTrace(System.err);
            if (ex.getResultCode() != null) {
                status = ex.getResultCode().value();
            }
        }
        catch (Exception ex) {
            System.err.println("Operation failed:");
            ex.printStackTrace(System.err);
        }
        return status;
    }

    protected void initOptions() {
        this.options.addOption(new Option(OPT_HELP, false, "display all options"));
        this.options.addOption(new Option(OPT_PROVIDER_PROPERTIES, true, "provider specific properties"));
    }

    protected ConnectionFactory initConnectionFactory(CommandLine line) {
        BindConnectionInitializer bci;
        DefaultConnectionFactory factory = new DefaultConnectionFactory();
        DefaultConnectionFactoryPropertySource cfSource = new DefaultConnectionFactoryPropertySource(factory, this.getPropertiesFromOptions(PropertySource.PropertyDomain.LDAP.value(), line));
        cfSource.initialize();
        ConnectionInitializer ci = factory.getConnectionConfig().getConnectionInitializer();
        if (ci instanceof BindConnectionInitializer && (bci = (BindConnectionInitializer)ci).getBindDn() != null && bci.getBindCredential() == null) {
            char[] pass = System.console().readPassword("[Enter password for %s]: ", bci.getBindDn());
            bci.setBindCredential(new Credential(pass));
        }
        return factory;
    }

    protected abstract String getCommandName();

    protected abstract int dispatch(CommandLine var1) throws Exception;

    protected void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.getCommandName(), this.options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printExamples() {
        String name = this.getClass().getSimpleName();
        InputStream in = this.getClass().getResourceAsStream(name + ".examples");
        if (in != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                String line;
                System.out.println();
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                System.err.println("Error reading examples from resource stream.");
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    System.err.println("Error closing example resource stream.");
                }
                System.out.println();
            }
        } else {
            System.out.println("No usage examples available for " + this.getCommandName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getArgDesc(Class<?> ... classes) {
        HashMap<String, String> args = new HashMap<String, String>();
        for (Class<?> c : classes) {
            String name = c.getSimpleName();
            InputStream in = this.getClass().getResourceAsStream(name + ".args");
            if (in == null) continue;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] s = line.split(":");
                    if (s.length <= 1) continue;
                    args.put(s[0], s[1]);
                }
            }
            catch (IOException e) {
                System.err.println("Error reading arguments from resource stream.");
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    System.err.println("Error closing arguments resource stream.");
                }
            }
        }
        if (args.isEmpty()) {
            System.err.println("No arguments available for " + this.getCommandName());
        }
        return args;
    }

    protected Properties getPropertiesFromOptions(String domain, CommandLine line) {
        Properties props = new Properties();
        for (Option o : line.getOptions()) {
            if (!o.hasArg()) continue;
            if (o.getOpt().equals(OPT_PROVIDER_PROPERTIES)) {
                String[] s = o.getValue().split("=");
                props.setProperty(s[0], s[1]);
                continue;
            }
            props.setProperty(domain + o.getOpt(), o.getValue());
        }
        return props;
    }
}

