/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.stats.metrics;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Locale;
import org.opensearch.neuralsearch.sparse.cache.ClusteredPostingCache;
import org.opensearch.neuralsearch.sparse.cache.ForwardIndexCache;
import org.opensearch.neuralsearch.stats.metrics.MemoryStatSnapshot;
import org.opensearch.neuralsearch.stats.metrics.MetricStat;
import org.opensearch.neuralsearch.stats.metrics.MetricStatName;

public class MemoryStat
implements MetricStat {
    public static final int BYTES_PER_KILOBYTES = 1024;
    private final MetricStatName statName;

    public MemoryStat(MetricStatName statName) {
        this.statName = statName;
    }

    private long getByteSize() {
        switch (this.statName) {
            case MEMORY_SPARSE_MEMORY_USAGE: 
            case MEMORY_SPARSE_MEMORY_USAGE_PERCENTAGE: {
                return ForwardIndexCache.getInstance().ramBytesUsed() + ClusteredPostingCache.getInstance().ramBytesUsed();
            }
            case MEMORY_SPARSE_FORWARD_INDEX_USAGE: {
                return ForwardIndexCache.getInstance().ramBytesUsed();
            }
            case MEMORY_SPARSE_CLUSTERED_POSTING_USAGE: {
                return ClusteredPostingCache.getInstance().ramBytesUsed();
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Metric stat not found: %s", this.statName));
    }

    public Double getValue() {
        long byteSize = this.getByteSize();
        if (this.statName == MetricStatName.MEMORY_SPARSE_MEMORY_USAGE_PERCENTAGE) {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            long heapMaxBytes = Math.max(0L, memoryMXBean.getHeapMemoryUsage().getMax());
            double percentage = (double)byteSize / (double)heapMaxBytes * 100.0;
            return (double)Math.round(percentage * 100.0) / 100.0;
        }
        double kbSize = (double)byteSize / 1024.0;
        return (double)Math.round(kbSize * 100.0) / 100.0;
    }

    public MemoryStatSnapshot getStatSnapshot() {
        return MemoryStatSnapshot.builder().statName(this.statName).value(this.getValue()).isAggregationMetric(this.statName != MetricStatName.MEMORY_SPARSE_MEMORY_USAGE_PERCENTAGE).build();
    }
}

