"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerVizRoute = registerVizRoute;
var _configSchema = require("@osd/config-schema");
var _notebooks = require("../../../common/constants/notebooks");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerVizRoute(router, dataSourceEnabled) {
  // Fetches available saved visualizations for current user
  router.get({
    path: `${_notebooks.NOTEBOOKS_API_PREFIX}/visualizations/{dataSourceMDSId?}`,
    validate: {
      params: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const params = {
      index: '.kibana',
      size: _notebooks.NOTEBOOKS_FETCH_SIZE,
      q: 'type:visualization'
    };
    try {
      let opensearchClientResponse;
      if (dataSourceEnabled && request.params.dataSourceMDSId) {
        const client = await context.dataSource.opensearch.legacy.getClient(request.params.dataSourceMDSId);
        opensearchClientResponse = await client.callAPI('search', params);
      } else {
        opensearchClientResponse = await context.core.opensearch.legacy.client.callAsCurrentUser('search', params);
      }
      const savedVisualizations = opensearchClientResponse.hits.hits;
      const vizResponse = savedVisualizations.map(vizDocument => ({
        label: vizDocument._source.visualization.title,
        key: vizDocument._id.split(':').pop()
      }));
      return response.ok({
        body: {
          savedVisualizations: vizResponse
        }
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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