/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.X25519PublicBCPGKey;
import org.bouncycastle.bcpg.X448PublicBCPGKey;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.encoders.Hex;

public class RFC6637Utils {
    private static final byte[] ANONYMOUS_SENDER = Hex.decode((String)"416E6F6E796D6F75732053656E64657220202020");

    private RFC6637Utils() {
    }

    public static String getXDHAlgorithm(PublicKeyPacket pubKeyData) {
        if (pubKeyData.getKey() instanceof X25519PublicBCPGKey) {
            return "X25519withSHA256CKDF";
        }
        if (pubKeyData.getKey() instanceof X448PublicBCPGKey) {
            return "X448withSHA512CKDF";
        }
        ECDHPublicBCPGKey ecKey = (ECDHPublicBCPGKey)pubKeyData.getKey();
        String curve = ecKey.getCurveOID().equals((ASN1Primitive)EdECObjectIdentifiers.id_X448) ? "X448" : "X25519";
        switch (ecKey.getHashAlgorithm()) {
            case 8: {
                return curve + "withSHA256CKDF";
            }
            case 9: {
                return curve + "withSHA384CKDF";
            }
            case 10: {
                return curve + "withSHA512CKDF";
            }
        }
        throw new IllegalArgumentException("Unknown hash algorithm specified: " + ecKey.getHashAlgorithm());
    }

    public static String getAgreementAlgorithm(PublicKeyPacket pubKeyData) {
        ECDHPublicBCPGKey ecKey = (ECDHPublicBCPGKey)pubKeyData.getKey();
        switch (ecKey.getHashAlgorithm()) {
            case 8: {
                return "ECCDHwithSHA256CKDF";
            }
            case 9: {
                return "ECCDHwithSHA384CKDF";
            }
            case 10: {
                return "ECCDHwithSHA512CKDF";
            }
        }
        throw new IllegalArgumentException("Unknown hash algorithm specified: " + ecKey.getHashAlgorithm());
    }

    public static ASN1ObjectIdentifier getKeyEncryptionOID(int algID) throws PGPException {
        switch (algID) {
            case 7: {
                return NISTObjectIdentifiers.id_aes128_wrap;
            }
            case 8: {
                return NISTObjectIdentifiers.id_aes192_wrap;
            }
            case 9: {
                return NISTObjectIdentifiers.id_aes256_wrap;
            }
            case 11: {
                return NTTObjectIdentifiers.id_camellia128_wrap;
            }
            case 12: {
                return NTTObjectIdentifiers.id_camellia192_wrap;
            }
            case 13: {
                return NTTObjectIdentifiers.id_camellia256_wrap;
            }
        }
        throw new PGPException("unknown symmetric algorithm ID: " + algID);
    }

    public static byte[] createUserKeyingMaterial(PublicKeyPacket pubKeyData, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        ByteArrayOutputStream pOut = new ByteArrayOutputStream();
        ECDHPublicBCPGKey ecKey = (ECDHPublicBCPGKey)pubKeyData.getKey();
        byte[] encOid = ecKey.getCurveOID().getEncoded();
        pOut.write(encOid, 1, encOid.length - 1);
        pOut.write(pubKeyData.getAlgorithm());
        pOut.write(3);
        pOut.write(1);
        pOut.write(ecKey.getHashAlgorithm());
        pOut.write(ecKey.getSymmetricKeyAlgorithm());
        pOut.write(ANONYMOUS_SENDER);
        byte[] fp = fingerPrintCalculator.calculateFingerprint(pubKeyData);
        if (pubKeyData.getVersion() == 5) {
            pOut.write(fp, 0, 20);
        } else {
            pOut.write(fp);
        }
        return pOut.toByteArray();
    }
}

