/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Filter;

public class BobChrisTreeNormalizer
extends TreeNormalizer {
    protected final TreebankLanguagePack tlp;
    protected Filter<Tree> emptyFilter = new EmptyFilter();
    protected Filter<Tree> aOverAFilter = new AOverAFilter();
    private static final long serialVersionUID = -1005188028979810143L;

    public BobChrisTreeNormalizer() {
        this(new PennTreebankLanguagePack());
    }

    public BobChrisTreeNormalizer(TreebankLanguagePack tlp) {
        this.tlp = tlp;
    }

    public String normalizeTerminal(String leaf) {
        return leaf.intern();
    }

    public String normalizeNonterminal(String category) {
        return this.cleanUpLabel(category).intern();
    }

    protected String cleanUpLabel(String label) {
        if (label == null || label.length() == 0) {
            return "ROOT";
        }
        return this.tlp.basicCategory(label);
    }

    public Tree normalizeWholeTree(Tree tree, TreeFactory tf) {
        return tree.prune(this.emptyFilter, tf).spliceOut(this.aOverAFilter, tf);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AOverAFilter
    implements Filter<Tree> {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean accept(Tree t) {
            if (t.isLeaf() || t.isPreTerminal()) {
                return true;
            }
            if ("EDITED".equals(t.label().value()) || "CODE".equals(t.label().value())) {
                return false;
            }
            if (t.numChildren() != 1) {
                return true;
            }
            return t.label() == null || t.label().value() == null || !t.label().value().equals(t.getChild(0).label().value());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EmptyFilter
    implements Filter<Tree> {
        private static final long serialVersionUID = 8914098359495987617L;

        @Override
        public boolean accept(Tree t) {
            Tree[] kids = t.children();
            Label l = t.label();
            return l == null || !"-NONE-".equals(l.value()) || t.isLeaf() || kids.length != 1 || !kids[0].isLeaf();
        }
    }
}

