# -*- coding: binary -*-

# Module with methods for commonly used splunk URLs
module Msf::Exploit::Remote::HTTP::Splunk::URIs
  # Returns the Splunk Login URL
  #
  # @return [String] Splunk Login URL
  def splunk_url_login
    normalize_uri(target_uri.path, 'en-US', 'account', 'login')
  end

  # Returns the Splunk URL for the user's page
  #
  # @param username [String] username of the account
  # @return [String] Splunk user URL
  def splunk_user_page(username = nil)
    username = datastore['USERNAME'] if username.nil?
    normalize_uri(target_uri.path, 'en-US', 'splunkd', '__raw', 'services', 'authentication', 'users', username)
  end

  # Returns the URL for splunk home page
  #
  # @return [String] Splunk home page URL
  def splunk_home
    normalize_uri(target_uri.path, 'en-US', 'app', 'launcher', 'home')
  end

  # Returns the URL for splunk upload page
  #
  # @return [String] Splunk upload page URL
  def splunk_upload_url
    normalize_uri(target_uri.path, 'en-US', 'manager', 'appinstall', '_upload')
  end
end
