/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JavaTypedExpressible;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public class JdbcLiteral<T>
implements Literal,
MappingModelExpressible<T>,
DomainResultProducer<T>,
JavaTypedExpressible<T> {
    private final T literalValue;
    private final JdbcMapping jdbcMapping;

    public JdbcLiteral(T literalValue, JdbcMapping jdbcMapping) {
        this.literalValue = literalValue;
        this.jdbcMapping = jdbcMapping;
    }

    @Override
    public Object getLiteralValue() {
        return this.literalValue;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitJdbcLiteral(this);
    }

    @Override
    public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) throws SQLException {
        this.jdbcMapping.getJdbcValueBinder().bind(statement, this.literalValue, startPosition, (WrapperOptions)executionContext.getSession());
    }

    @Override
    public MappingModelExpressible<?> getExpressionType() {
        return this;
    }

    @Override
    public int getJdbcTypeCount() {
        return 1;
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.jdbcMapping;
    }

    @Override
    public JdbcMapping getSingleJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return value;
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        if (value != null) {
            cacheKey.addValue(JdbcLiteral.disassemble(value, this.jdbcMapping.getJdbcJavaType().getMutabilityPlan(), session));
            cacheKey.addHashCode(JdbcLiteral.hashCode(value, this.jdbcMapping.getJavaTypeDescriptor()));
        }
    }

    private static <T> int hashCode(Object value, JavaType<T> javaTypeDescriptor) {
        return javaTypeDescriptor.extractHashCode(value);
    }

    private static <T> Serializable disassemble(Object value, MutabilityPlan<T> mutabilityPlan, SharedSessionContractImplementor session) {
        return mutabilityPlan.disassemble(value, session);
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, x, y, value, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public <X, Y> int forEachJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, x, y, value, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlSelection sqlSelection = sqlAstCreationState.getSqlExpressionResolver().resolveSqlSelection(this, this.jdbcMapping.getJdbcJavaType(), null, sqlAstCreationState.getCreationContext().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.jdbcMapping);
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        sqlAstCreationState.getSqlExpressionResolver().resolveSqlSelection(this, this.jdbcMapping.getJdbcJavaType(), null, sqlAstCreationState.getCreationContext().getTypeConfiguration());
    }

    @Override
    public JavaType<T> getExpressibleJavaType() {
        return this.jdbcMapping.getJavaTypeDescriptor();
    }
}

