/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.netty.buffer.ByteBuf;
import io.undertow.UndertowLogger;
import io.undertow.httpcore.HttpHeaderNames;
import io.undertow.httpcore.InputChannel;
import io.undertow.httpcore.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.SameThreadExecutor;
import io.undertow.util.URLUtils;
import java.io.IOException;
import java.util.function.BiConsumer;

public class FormEncodedDataDefinition
implements FormParserFactory.ParserDefinition<FormEncodedDataDefinition> {
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private String defaultEncoding = "ISO-8859-1";
    private boolean forceCreation = false;

    @Override
    public FormDataParser create(HttpServerExchange exchange) {
        String mimeType = exchange.getRequestHeader("Content-Type");
        if (this.forceCreation || mimeType != null && mimeType.startsWith(APPLICATION_X_WWW_FORM_URLENCODED)) {
            String cs;
            String charset = this.defaultEncoding;
            String contentType = exchange.getRequestHeader("Content-Type");
            if (contentType != null && (cs = HttpHeaderNames.extractQuotedValueFromHeader((String)contentType, (String)"charset")) != null) {
                charset = cs;
            }
            UndertowLogger.REQUEST_LOGGER.tracef("Created form encoded parser for %s", exchange);
            return new FormEncodedDataParser(charset, exchange);
        }
        return null;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public boolean isForceCreation() {
        return this.forceCreation;
    }

    public FormEncodedDataDefinition setForceCreation(boolean forceCreation) {
        this.forceCreation = forceCreation;
        return this;
    }

    @Override
    public FormEncodedDataDefinition setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        return this;
    }

    private static final class FormEncodedDataParser
    implements BiConsumer<InputChannel, HttpServerExchange>,
    FormDataParser {
        private final HttpServerExchange exchange;
        private final FormData data;
        private final StringBuilder builder = new StringBuilder();
        private String name = null;
        private String charset;
        private HttpHandler handler;
        private int state = 0;

        private FormEncodedDataParser(String charset, HttpServerExchange exchange) {
            this.exchange = exchange;
            this.charset = charset;
            this.data = new FormData((Integer)exchange.getUndertowOptions().get(UndertowOptions.MAX_PARAMETERS, (Object)1000));
        }

        private void doParse(ByteBuf buffer) {
            try {
                if (buffer != null) {
                    while (buffer.isReadable()) {
                        byte n = buffer.readByte();
                        switch (this.state) {
                            case 0: {
                                if (n == 61) {
                                    this.name = this.builder.toString();
                                    this.builder.setLength(0);
                                    this.state = 2;
                                    break;
                                }
                                if (n == 38) {
                                    this.data.add(this.builder.toString(), "");
                                    this.builder.setLength(0);
                                    this.state = 0;
                                    break;
                                }
                                if (n == 37 || n == 43) {
                                    this.state = 1;
                                    this.builder.append((char)n);
                                    break;
                                }
                                this.builder.append((char)n);
                                break;
                            }
                            case 1: {
                                if (n == 61) {
                                    this.name = URLUtils.decode(this.builder.toString(), this.charset, true, new StringBuilder());
                                    this.builder.setLength(0);
                                    this.state = 2;
                                    break;
                                }
                                if (n == 38) {
                                    this.data.add(URLUtils.decode(this.builder.toString(), this.charset, true, new StringBuilder()), "");
                                    this.builder.setLength(0);
                                    this.state = 0;
                                    break;
                                }
                                this.builder.append((char)n);
                                break;
                            }
                            case 2: {
                                if (n == 38) {
                                    this.data.add(this.name, this.builder.toString());
                                    this.builder.setLength(0);
                                    this.state = 0;
                                    break;
                                }
                                if (n == 37 || n == 43) {
                                    this.state = 3;
                                    this.builder.append((char)n);
                                    break;
                                }
                                this.builder.append((char)n);
                                break;
                            }
                            case 3: {
                                if (n == 38) {
                                    this.data.add(this.name, URLUtils.decode(this.builder.toString(), this.charset, true, new StringBuilder()));
                                    this.builder.setLength(0);
                                    this.state = 0;
                                    break;
                                }
                                this.builder.append((char)n);
                            }
                        }
                    }
                } else {
                    if (this.state == 2) {
                        this.data.add(this.name, this.builder.toString());
                    } else if (this.state == 3) {
                        this.data.add(this.name, URLUtils.decode(this.builder.toString(), this.charset, true, new StringBuilder()));
                    } else if (this.builder.length() > 0) {
                        if (this.state == 1) {
                            this.data.add(URLUtils.decode(this.builder.toString(), this.charset, true, new StringBuilder()), "");
                        } else {
                            this.data.add(this.builder.toString(), "");
                        }
                    }
                    this.state = 4;
                    this.exchange.putAttachment(FORM_DATA, this.data);
                }
            }
            finally {
                if (buffer != null) {
                    buffer.release();
                }
            }
        }

        @Override
        public void parse(HttpHandler handler) throws Exception {
            if (this.exchange.getAttachment(FORM_DATA) != null) {
                handler.handleRequest(this.exchange);
                return;
            }
            this.handler = handler;
            this.accept(this.exchange.getInputChannel(), this.exchange);
        }

        @Override
        public FormData parseBlocking() throws IOException {
            FormData existing = (FormData)this.exchange.getAttachment(FORM_DATA);
            if (existing != null) {
                return existing;
            }
            while (this.state != 4) {
                this.doParse(this.exchange.readBlocking());
            }
            return this.data;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void setCharacterEncoding(String encoding) {
            this.charset = encoding;
        }

        @Override
        public void accept(InputChannel inputChannel, HttpServerExchange exchange) {
            while (inputChannel.isReadable()) {
                try {
                    this.doParse(inputChannel.readAsync());
                    if (this.state != 4) continue;
                    exchange.dispatch(SameThreadExecutor.INSTANCE, this.handler);
                    return;
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioExceptionReadingFromChannel(e);
                    exchange.close();
                }
            }
            exchange.getInputChannel().setReadHandler((BiConsumer)this, (Object)exchange);
        }
    }
}

