/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.specification.internal;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQueryReference;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.hibernate.QueryException;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.StatelessSession;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.IllegalSelectQueryException;
import org.hibernate.query.Order;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaQueryPart;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.criteria.JpaSelectCriteria;
import org.hibernate.query.restriction.Path;
import org.hibernate.query.restriction.Restriction;
import org.hibernate.query.specification.SelectionSpecification;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.internal.SqmSelectionQueryImpl;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.AbstractSqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.type.descriptor.java.JavaType;

public class SelectionSpecificationImpl<T>
implements SelectionSpecification<T>,
TypedQueryReference<T> {
    private final Class<T> resultType;
    private final String hql;
    private final CriteriaQuery<T> criteriaQuery;
    private final List<BiConsumer<SqmSelectStatement<T>, SqmRoot<T>>> specifications = new ArrayList<BiConsumer<SqmSelectStatement<T>, SqmRoot<T>>>();

    public SelectionSpecificationImpl(Class<T> resultType) {
        this.resultType = resultType;
        this.hql = null;
        this.criteriaQuery = null;
    }

    public SelectionSpecificationImpl(String hql, Class<T> resultType) {
        this.resultType = resultType;
        this.hql = hql;
        this.criteriaQuery = null;
    }

    public SelectionSpecificationImpl(CriteriaQuery<T> criteriaQuery) {
        this.resultType = criteriaQuery.getResultType();
        this.hql = null;
        this.criteriaQuery = criteriaQuery;
    }

    public String getName() {
        return null;
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    public Map<String, Object> getHints() {
        return Collections.emptyMap();
    }

    @Override
    public TypedQueryReference<T> reference() {
        return this;
    }

    @Override
    public SelectionSpecification<T> restrict(Restriction<? super T> restriction) {
        this.specifications.add((sqmStatement, root) -> {
            SqmPredicate sqmPredicate = SqmUtil.restriction(sqmStatement, this.resultType, restriction);
            ((SqmQuerySpec)sqmStatement.getQuerySpec()).applyPredicate(sqmPredicate);
        });
        return this;
    }

    @Override
    public SelectionSpecification<T> augment(SelectionSpecification.Augmentation<T> augmentation) {
        this.specifications.add((sqmStatement, root) -> augmentation.augment(sqmStatement.nodeBuilder(), (CriteriaQuery)sqmStatement, (Root)root));
        return this;
    }

    @Override
    public SelectionSpecification<T> fetch(Path<T, ?> fetchPath) {
        this.specifications.add((sqmStatement, root) -> fetchPath.fetch((Root)root));
        return this;
    }

    @Override
    public SelectionSpecification<T> sort(Order<? super T> order) {
        this.specifications.add((sqmStatement, root) -> SelectionSpecificationImpl.addOrder(order, sqmStatement));
        return this;
    }

    @Override
    public final SelectionSpecification<T> resort(Order<? super T> order) {
        this.specifications.add((sqmStatement, root) -> {
            ((SqmQueryPart)((Object)sqmStatement.getQuerySpec())).setOrderByClause(new SqmOrderByClause());
            SelectionSpecificationImpl.addOrder(order, sqmStatement);
        });
        return this;
    }

    @Override
    public final SelectionSpecification<T> resort(List<? extends Order<? super T>> orders) {
        this.specifications.add((sqmStatement, root) -> {
            ((SqmQueryPart)((Object)sqmStatement.getQuerySpec())).setOrderByClause(new SqmOrderByClause());
            orders.forEach(order -> SelectionSpecificationImpl.addOrder(order, sqmStatement));
        });
        return this;
    }

    private static <T> void addOrder(Order<? super T> order, SqmSelectStatement<T> sqmStatement) {
        SqmSortSpecification sortSpecification = SqmUtil.sortSpecification(sqmStatement, order);
        JpaQueryStructure querySpec = sqmStatement.getQuerySpec();
        if (((SqmQueryPart)((Object)querySpec)).getOrderByClause() == null) {
            ((SqmQueryPart)((Object)querySpec)).setOrderByClause(new SqmOrderByClause());
        }
        ((SqmQueryPart)((Object)querySpec)).getOrderByClause().addSortSpecification(sortSpecification);
    }

    @Override
    public SelectionQuery<T> createQuery(Session session) {
        return this.createQuery((SharedSessionContract)session);
    }

    @Override
    public SelectionQuery<T> createQuery(StatelessSession session) {
        return this.createQuery((SharedSessionContract)session);
    }

    public SelectionQuery<T> createQuery(SharedSessionContract session) {
        SharedSessionContractImplementor sessionImpl = session.unwrap(SharedSessionContractImplementor.class);
        SqmSelectStatement<T> sqmStatement = this.build(sessionImpl.getFactory().getQueryEngine());
        return new SqmSelectionQueryImpl<T>(sqmStatement, false, this.resultType, sessionImpl);
    }

    private SqmSelectStatement<T> build(QueryEngine queryEngine) {
        JpaRoot<Object> sqmRoot;
        JpaSelectCriteria sqmStatement;
        if (this.hql != null) {
            sqmStatement = SelectionSpecificationImpl.resolveSqmTree(this.hql, this.resultType, queryEngine);
            sqmRoot = this.extractRoot((SqmSelectStatement<T>)sqmStatement, this.resultType, this.hql);
        } else if (this.criteriaQuery != null) {
            sqmStatement = ((SqmSelectStatement)this.criteriaQuery).copy(SqmCopyContext.simpleContext());
            sqmRoot = this.extractRoot((SqmSelectStatement<T>)sqmStatement, this.resultType, "criteria query");
        } else {
            NodeBuilder builder = queryEngine.getCriteriaBuilder();
            JpaCriteriaQuery query = builder.createQuery((Class)this.resultType);
            JpaRoot root = ((AbstractSqmSelectQuery)((Object)query)).from(this.resultType);
            ((SqmSelectStatement)query).select(root);
            sqmRoot = root;
            sqmStatement = query;
        }
        this.specifications.forEach(consumer -> consumer.accept(sqmStatement, sqmRoot));
        return sqmStatement;
    }

    @Override
    public SelectionQuery<T> createQuery(EntityManager entityManager) {
        return this.createQuery((SharedSessionContract)entityManager);
    }

    @Override
    public CriteriaQuery<T> buildCriteria(CriteriaBuilder builder) {
        NodeBuilder nodeBuilder = (NodeBuilder)builder;
        return this.build(nodeBuilder.getQueryEngine());
    }

    @Override
    public SelectionSpecification<T> validate(CriteriaBuilder builder) {
        NodeBuilder nodeBuilder = (NodeBuilder)builder;
        SqmSelectStatement<T> statement = this.build(nodeBuilder.getQueryEngine());
        JpaQueryPart queryPart = statement.getQueryPart();
        ((SqmQueryPart)queryPart).validateQueryStructureAndFetchOwners();
        SqmUtil.validateCriteriaQuery(queryPart);
        statement.validateResultType(this.resultType);
        return this;
    }

    private static <T> SqmSelectStatement<T> resolveSqmTree(String hql, Class<T> resultType, QueryEngine queryEngine) {
        HqlInterpretation<T> hqlInterpretation = queryEngine.getInterpretationCache().resolveHqlInterpretation(hql, resultType, queryEngine.getHqlTranslator());
        if (!SqmUtil.isSelect(hqlInterpretation.getSqmStatement())) {
            throw new IllegalSelectQueryException("Expecting a selection query, but found '" + hql + "'", hql);
        }
        hqlInterpretation.validateResultType(resultType);
        return (SqmSelectStatement)hqlInterpretation.getSqmStatement().copy(SqmCopyContext.noParamCopyContext(SqmQuerySource.CRITERIA));
    }

    private SqmRoot<T> extractRoot(SqmSelectStatement<T> sqmStatement, Class<T> resultType, String hql) {
        Set<SqmRoot<?>> sqmRoots = ((SqmQuerySpec)sqmStatement.getQuerySpec()).getRoots();
        if (sqmRoots.isEmpty()) {
            throw new QueryException("Query did not define any roots", hql);
        }
        if (sqmRoots.size() > 1) {
            throw new QueryException("Query defined multiple roots", hql);
        }
        SqmRoot<?> sqmRoot = sqmRoots.iterator().next();
        this.validateRoot(sqmRoot, resultType, hql);
        return sqmRoot;
    }

    private void validateRoot(SqmRoot<?> sqmRoot, Class<T> resultType, String hql) {
        if (sqmRoot.getJavaType() != null && !Map.class.isAssignableFrom(sqmRoot.getJavaType()) && !resultType.isAssignableFrom(sqmRoot.getJavaType())) {
            throw new QueryException(String.format(Locale.ROOT, "Query root [%s] and result type [%s] are not compatible", sqmRoot.getJavaType().getName(), resultType.getName()), hql);
        }
    }

    private void validateResultType(SqmSelectStatement<T> sqmStatement, SqmRoot<?> sqmRoot, Class<T> resultType, String hql) {
        if (resultType == null || Object.class.equals(resultType) || resultType.isArray()) {
            return;
        }
        Class rootJavaType = sqmRoot.getJavaType();
        assert (rootJavaType != null);
        if (Map.class.isAssignableFrom(rootJavaType) && Map.class.isAssignableFrom(resultType)) {
            return;
        }
        SqmSelectClause sqmSelectClause = ((SqmQuerySpec)sqmStatement.getQuerySpec()).getSelectClause();
        List<SqmSelection<?>> sqmSelections = sqmSelectClause.getSelections();
        if (CollectionHelper.isEmpty(sqmSelections)) {
            if (resultType.isAssignableFrom(rootJavaType)) {
                return;
            }
        } else {
            if (sqmSelections.size() > 1) {
                return;
            }
            assert (sqmSelections.size() == 1);
            JavaType<?> nodeJavaType = sqmSelections.get(0).getNodeJavaType();
            if (nodeJavaType == null) {
                return;
            }
            if (resultType.isAssignableFrom(nodeJavaType.getJavaTypeClass())) {
                return;
            }
        }
        throw new QueryException(String.format(Locale.ROOT, "Specified result-type [%s] is not valid for this SelectionSpecification", resultType.getName()), hql);
    }
}

