/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import jakarta.persistence.criteria.Nulls;
import jakarta.persistence.metamodel.SingularAttribute;
import org.hibernate.query.Order;
import org.hibernate.query.SortDirection;

record AttributeOrder<X>(SortDirection direction, Nulls nullPrecedence, SingularAttribute<X, ?> attribute, boolean caseSensitive) implements Order<X>
{
    AttributeOrder(SortDirection order, Nulls nullPrecedence, SingularAttribute<X, ?> attribute) {
        this(order, nullPrecedence, attribute, true);
    }

    private AttributeOrder(AttributeOrder<X> that, Nulls nullPrecedence) {
        this(that.direction, nullPrecedence, that.attribute, that.caseSensitive);
    }

    private AttributeOrder(AttributeOrder<X> that, SortDirection direction) {
        this(direction, that.nullPrecedence, that.attribute, that.caseSensitive);
    }

    private AttributeOrder(AttributeOrder<X> that, boolean caseSensitive) {
        this(that.direction, that.nullPrecedence, that.attribute, caseSensitive);
    }

    @Override
    public Class<X> entityClass() {
        return this.attribute.getDeclaringType().getJavaType();
    }

    @Override
    public int element() {
        return 1;
    }

    @Override
    public String attributeName() {
        return this.attribute.getName();
    }

    @Override
    public Order<X> ignoringCase() {
        return new AttributeOrder<X>(this, true);
    }

    @Override
    public Order<X> reverse() {
        return new AttributeOrder<X>(this, this.direction.reverse());
    }

    @Override
    public Order<X> withNullsFirst() {
        return new AttributeOrder<X>(this, Nulls.FIRST);
    }

    @Override
    public Order<X> withNullsLast() {
        return new AttributeOrder<X>(this, Nulls.LAST);
    }

    @Override
    public String toString() {
        return this.attribute.getName() + " " + String.valueOf((Object)this.direction);
    }
}

