/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.consistent;

import com.dynatrace.hash4j.consistent.ConsistentBucketHasher;
import com.dynatrace.hash4j.consistent.ConsistentHashingUtil;
import com.dynatrace.hash4j.random.PseudoRandomGenerator;
import com.dynatrace.hash4j.random.PseudoRandomGeneratorProvider;
import java.util.Objects;

class ConsistentJumpBucketHasher
implements ConsistentBucketHasher {
    private final PseudoRandomGenerator pseudoRandomGenerator;

    ConsistentJumpBucketHasher(PseudoRandomGeneratorProvider pseudoRandomGeneratorProvider) {
        Objects.requireNonNull(pseudoRandomGeneratorProvider);
        this.pseudoRandomGenerator = pseudoRandomGeneratorProvider.create();
    }

    @Override
    public strictfp int getBucket(long hash, int numBuckets) {
        if (numBuckets <= 1) {
            ConsistentHashingUtil.checkNumberOfBuckets(numBuckets);
            return 0;
        }
        this.pseudoRandomGenerator.reset(hash);
        int candidate = 0;
        int next;
        while ((next = (int)((double)(candidate + 1) / this.pseudoRandomGenerator.nextDouble())) < numBuckets && next > candidate) {
            candidate = next;
        }
        return candidate;
    }
}

