/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.apksig.internal.asn1.ber;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import shadow.bundletool.com.android.apksig.internal.asn1.ber.BerDataValue;
import shadow.bundletool.com.android.apksig.internal.asn1.ber.BerDataValueFormatException;
import shadow.bundletool.com.android.apksig.internal.asn1.ber.BerDataValueReader;
import shadow.bundletool.com.android.apksig.internal.asn1.ber.BerEncoding;

public class InputStreamBerDataValueReader
implements BerDataValueReader {
    private final InputStream mIn;

    public InputStreamBerDataValueReader(InputStream in4) {
        if (in4 == null) {
            throw new NullPointerException("in == null");
        }
        this.mIn = in4;
    }

    @Override
    public BerDataValue readDataValue() throws BerDataValueFormatException {
        return InputStreamBerDataValueReader.readDataValue(this.mIn);
    }

    private static BerDataValue readDataValue(InputStream input) throws BerDataValueFormatException {
        RecordingInputStream in4 = new RecordingInputStream(input);
        try {
            int contentsOffsetInDataValue;
            int contentsLength;
            int firstIdentifierByte = in4.read();
            if (firstIdentifierByte == -1) {
                return null;
            }
            int tagNumber = InputStreamBerDataValueReader.readTagNumber(in4, firstIdentifierByte);
            int firstLengthByte = in4.read();
            if (firstLengthByte == -1) {
                throw new BerDataValueFormatException("Missing length");
            }
            boolean constructed = BerEncoding.isConstructed((byte)firstIdentifierByte);
            if ((firstLengthByte & 0x80) == 0) {
                contentsLength = InputStreamBerDataValueReader.readShortFormLength(firstLengthByte);
                contentsOffsetInDataValue = in4.getReadByteCount();
                InputStreamBerDataValueReader.skipDefiniteLengthContents(in4, contentsLength);
            } else if ((firstLengthByte & 0xFF) != 128) {
                contentsLength = InputStreamBerDataValueReader.readLongFormLength(in4, firstLengthByte);
                contentsOffsetInDataValue = in4.getReadByteCount();
                InputStreamBerDataValueReader.skipDefiniteLengthContents(in4, contentsLength);
            } else {
                contentsOffsetInDataValue = in4.getReadByteCount();
                contentsLength = constructed ? InputStreamBerDataValueReader.skipConstructedIndefiniteLengthContents(in4) : InputStreamBerDataValueReader.skipPrimitiveIndefiniteLengthContents(in4);
            }
            byte[] encoded = in4.getReadBytes();
            ByteBuffer encodedContents = ByteBuffer.wrap(encoded, contentsOffsetInDataValue, contentsLength);
            return new BerDataValue(ByteBuffer.wrap(encoded), encodedContents, BerEncoding.getTagClass((byte)firstIdentifierByte), constructed, tagNumber);
        }
        catch (IOException e15) {
            throw new BerDataValueFormatException("Failed to read data value", e15);
        }
    }

    private static int readTagNumber(InputStream in4, int firstIdentifierByte) throws IOException, BerDataValueFormatException {
        int tagNumber = BerEncoding.getTagNumber((byte)firstIdentifierByte);
        if (tagNumber == 31) {
            return InputStreamBerDataValueReader.readHighTagNumber(in4);
        }
        return tagNumber;
    }

    private static int readHighTagNumber(InputStream in4) throws IOException, BerDataValueFormatException {
        int b15;
        int result = 0;
        do {
            if ((b15 = in4.read()) == -1) {
                throw new BerDataValueFormatException("Truncated tag number");
            }
            if (result > 0xFFFFFF) {
                throw new BerDataValueFormatException("Tag number too large");
            }
            result <<= 7;
            result |= b15 & 0x7F;
        } while ((b15 & 0x80) != 0);
        return result;
    }

    private static int readShortFormLength(int firstLengthByte) {
        return firstLengthByte & 0x7F;
    }

    private static int readLongFormLength(InputStream in4, int firstLengthByte) throws IOException, BerDataValueFormatException {
        int byteCount = firstLengthByte & 0x7F;
        if (byteCount > 4) {
            throw new BerDataValueFormatException("Length too large: " + byteCount + " bytes");
        }
        int result = 0;
        for (int i15 = 0; i15 < byteCount; ++i15) {
            int b15 = in4.read();
            if (b15 == -1) {
                throw new BerDataValueFormatException("Truncated length");
            }
            if (result > 0x7FFFFF) {
                throw new BerDataValueFormatException("Length too large");
            }
            result <<= 8;
            result |= b15 & 0xFF;
        }
        return result;
    }

    private static void skipDefiniteLengthContents(InputStream in4, int len) throws IOException, BerDataValueFormatException {
        long bytesRead = 0L;
        while (len > 0) {
            int skipped = (int)in4.skip(len);
            if (skipped <= 0) {
                throw new BerDataValueFormatException("Truncated definite-length contents: " + bytesRead + " bytes read, " + len + " missing");
            }
            len -= skipped;
            bytesRead += (long)skipped;
        }
    }

    private static int skipPrimitiveIndefiniteLengthContents(InputStream in4) throws IOException, BerDataValueFormatException {
        boolean prevZeroByte = false;
        int bytesRead = 0;
        while (true) {
            int b15;
            if ((b15 = in4.read()) == -1) {
                throw new BerDataValueFormatException("Truncated indefinite-length contents: " + bytesRead + " bytes read");
            }
            if (++bytesRead < 0) {
                throw new BerDataValueFormatException("Indefinite-length contents too long");
            }
            if (b15 == 0) {
                if (prevZeroByte) {
                    return bytesRead - 2;
                }
                prevZeroByte = true;
                continue;
            }
            prevZeroByte = false;
        }
    }

    private static int skipConstructedIndefiniteLengthContents(RecordingInputStream in4) throws BerDataValueFormatException {
        BerDataValue dataValue;
        ByteBuffer encoded;
        int readByteCountBefore = in4.getReadByteCount();
        do {
            if ((dataValue = InputStreamBerDataValueReader.readDataValue(in4)) == null) {
                throw new BerDataValueFormatException("Truncated indefinite-length contents: " + (in4.getReadByteCount() - readByteCountBefore) + " bytes read");
            }
            if (in4.getReadByteCount() > 0) continue;
            throw new BerDataValueFormatException("Indefinite-length contents too long");
        } while ((encoded = dataValue.getEncoded()).remaining() != 2 || encoded.get(0) != 0 || encoded.get(1) != 0);
        return in4.getReadByteCount() - readByteCountBefore - 2;
    }

    private static class RecordingInputStream
    extends InputStream {
        private final InputStream mIn;
        private final ByteArrayOutputStream mBuf;

        private RecordingInputStream(InputStream in4) {
            this.mIn = in4;
            this.mBuf = new ByteArrayOutputStream();
        }

        public byte[] getReadBytes() {
            return this.mBuf.toByteArray();
        }

        public int getReadByteCount() {
            return this.mBuf.size();
        }

        @Override
        public int read() throws IOException {
            int b15 = this.mIn.read();
            if (b15 != -1) {
                this.mBuf.write(b15);
            }
            return b15;
        }

        @Override
        public int read(byte[] b15) throws IOException {
            int len = this.mIn.read(b15);
            if (len > 0) {
                this.mBuf.write(b15, 0, len);
            }
            return len;
        }

        @Override
        public int read(byte[] b15, int off, int len) throws IOException {
            if ((len = this.mIn.read(b15, off, len)) > 0) {
                this.mBuf.write(b15, off, len);
            }
            return len;
        }

        @Override
        public long skip(long n15) throws IOException {
            if (n15 <= 0L) {
                return this.mIn.skip(n15);
            }
            byte[] buf = new byte[4096];
            int len = this.mIn.read(buf, 0, (int)Math.min((long)buf.length, n15));
            if (len > 0) {
                this.mBuf.write(buf, 0, len);
            }
            return len < 0 ? 0L : (long)len;
        }

        @Override
        public int available() throws IOException {
            return super.available();
        }

        @Override
        public void close() throws IOException {
            super.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

