/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.compiler;

import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.compiler.Bytecode;
import org.stringtemplate.v4.compiler.BytecodeDisassembler;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.compiler.Compiler;
import org.stringtemplate.v4.compiler.FormalArgument;
import org.stringtemplate.v4.compiler.StringTable;
import org.stringtemplate.v4.misc.ErrorManager;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.Interval;
import org.stringtemplate.v4.misc.Misc;

public class CompilationState {
    CompiledST impl = new CompiledST();
    StringTable stringtable = new StringTable();
    int ip = 0;
    TokenStream tokens;
    ErrorManager errMgr;

    public CompilationState(ErrorManager errMgr, String name, TokenStream tokens) {
        this.errMgr = errMgr;
        this.tokens = tokens;
        this.impl.name = name;
        this.impl.prefix = Misc.getPrefix(name);
    }

    public int defineString(String s15) {
        return this.stringtable.add(s15);
    }

    public void refAttr(Token templateToken, CommonTree id5) {
        String name = id5.getText();
        if (this.impl.formalArguments != null && this.impl.formalArguments.get(name) != null) {
            FormalArgument arg = this.impl.formalArguments.get(name);
            int index = arg.index;
            this.emit1(id5, (short)3, index);
        } else if (Interpreter.predefinedAnonSubtemplateAttributes.contains(name)) {
            this.errMgr.compileTimeError(ErrorType.REF_TO_IMPLICIT_ATTRIBUTE_OUT_OF_SCOPE, templateToken, id5.token);
            this.emit(id5, (short)44);
        } else {
            this.emit1(id5, (short)2, name);
        }
    }

    public void setOption(CommonTree id5) {
        Interpreter.Option O11 = Compiler.supportedOptions.get(id5.getText());
        this.emit1(id5, (short)6, O11.ordinal());
    }

    public void func(Token templateToken, CommonTree id5) {
        Short funcBytecode = Compiler.funcs.get(id5.getText());
        if (funcBytecode == null) {
            this.errMgr.compileTimeError(ErrorType.NO_SUCH_FUNCTION, templateToken, id5.token);
            this.emit(id5, (short)43);
        } else {
            this.emit(id5, funcBytecode);
        }
    }

    public void emit(short opcode) {
        this.emit(null, opcode);
    }

    public void emit(CommonTree opAST, short opcode) {
        this.ensureCapacity(1);
        if (opAST != null) {
            int i15 = opAST.getTokenStartIndex();
            int j15 = opAST.getTokenStopIndex();
            int p15 = ((CommonToken)this.tokens.get(i15)).getStartIndex();
            int q15 = ((CommonToken)this.tokens.get(j15)).getStopIndex();
            if (p15 >= 0 && q15 >= 0) {
                this.impl.sourceMap[this.ip] = new Interval(p15, q15);
            }
        }
        this.impl.instrs[this.ip++] = (byte)opcode;
    }

    public void emit1(CommonTree opAST, short opcode, int arg) {
        this.emit(opAST, opcode);
        this.ensureCapacity(2);
        CompilationState.writeShort(this.impl.instrs, this.ip, (short)arg);
        this.ip += 2;
    }

    public void emit2(CommonTree opAST, short opcode, int arg, int arg2) {
        this.emit(opAST, opcode);
        this.ensureCapacity(4);
        CompilationState.writeShort(this.impl.instrs, this.ip, (short)arg);
        this.ip += 2;
        CompilationState.writeShort(this.impl.instrs, this.ip, (short)arg2);
        this.ip += 2;
    }

    public void emit2(CommonTree opAST, short opcode, String s15, int arg2) {
        int i15 = this.defineString(s15);
        this.emit2(opAST, opcode, i15, arg2);
    }

    public void emit1(CommonTree opAST, short opcode, String s15) {
        int i15 = this.defineString(s15);
        this.emit1(opAST, opcode, i15);
    }

    public void insert(int addr, short opcode, String s15) {
        Bytecode.Instruction I11;
        this.ensureCapacity(3);
        int instrSize = 3;
        System.arraycopy(this.impl.instrs, addr, this.impl.instrs, addr + instrSize, this.ip - addr);
        int save = this.ip;
        this.ip = addr;
        this.emit1(null, opcode, s15);
        this.ip = save + instrSize;
        for (int a15 = addr + instrSize; a15 < this.ip; a15 += I11.nopnds * 2 + 1) {
            byte op4 = this.impl.instrs[a15];
            I11 = Bytecode.instructions[op4];
            if (op4 != 18 && op4 != 19) continue;
            int opnd = BytecodeDisassembler.getShort(this.impl.instrs, a15 + 1);
            CompilationState.writeShort(this.impl.instrs, a15 + 1, (short)(opnd + instrSize));
        }
    }

    public void write(int addr, short value) {
        CompilationState.writeShort(this.impl.instrs, addr, value);
    }

    protected void ensureCapacity(int n15) {
        if (this.ip + n15 >= this.impl.instrs.length) {
            byte[] c15 = new byte[this.impl.instrs.length * 2];
            System.arraycopy(this.impl.instrs, 0, c15, 0, this.impl.instrs.length);
            this.impl.instrs = c15;
            Interval[] sm4 = new Interval[this.impl.sourceMap.length * 2];
            System.arraycopy(this.impl.sourceMap, 0, sm4, 0, this.impl.sourceMap.length);
            this.impl.sourceMap = sm4;
        }
    }

    public void indent(CommonTree indent) {
        this.emit1(indent, (short)39, indent.getText());
    }

    public static void writeShort(byte[] memory, int index, short value) {
        memory[index + 0] = (byte)(value >> 8 & 0xFF);
        memory[index + 1] = (byte)(value & 0xFF);
    }
}

