/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rtextarea.AbstractGutterComponent;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.IconRowEvent;
import org.fife.ui.rtextarea.IconRowListener;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaUI;

public class IconRowHeader
extends AbstractGutterComponent
implements MouseListener {
    protected List<GutterIconImpl> trackingIcons;
    protected int width;
    private boolean bookmarkingEnabled;
    private Icon bookmarkIcon;
    protected Rectangle visibleRect;
    protected Insets textAreaInsets;
    protected int activeLineRangeStart;
    protected int activeLineRangeEnd;
    private Color activeLineRangeColor;
    private boolean inheritsGutterBackground;

    public IconRowHeader(RTextArea textArea) {
        super(textArea);
    }

    public GutterIconInfo addOffsetTrackingIcon(int offs, Icon icon) throws BadLocationException {
        return this.addOffsetTrackingIcon(offs, icon, null);
    }

    public GutterIconInfo addOffsetTrackingIcon(int offs, Icon icon, String tip) throws BadLocationException {
        int index;
        if (offs < 0 || offs > this.textArea.getDocument().getLength()) {
            throw new BadLocationException("Offset " + offs + " not in required range of 0-" + this.textArea.getDocument().getLength(), offs);
        }
        Position pos = this.textArea.getDocument().createPosition(offs);
        GutterIconImpl ti4 = new GutterIconImpl(icon, pos, tip);
        if (this.trackingIcons == null) {
            this.trackingIcons = new ArrayList<GutterIconImpl>(1);
        }
        if ((index = Collections.binarySearch(this.trackingIcons, ti4)) < 0) {
            index = -(index + 1);
        }
        this.trackingIcons.add(index, ti4);
        this.repaint();
        return ti4;
    }

    public void clearActiveLineRange() {
        if (this.activeLineRangeStart != -1 || this.activeLineRangeEnd != -1) {
            this.activeLineRangeEnd = -1;
            this.activeLineRangeStart = -1;
            this.repaint();
        }
    }

    public Color getActiveLineRangeColor() {
        return this.activeLineRangeColor;
    }

    public Icon getBookmarkIcon() {
        return this.bookmarkIcon;
    }

    public GutterIconInfo[] getBookmarks() {
        ArrayList<GutterIconImpl> retVal = new ArrayList<GutterIconImpl>(1);
        if (this.trackingIcons != null) {
            for (int i15 = 0; i15 < this.trackingIcons.size(); ++i15) {
                GutterIconImpl ti4 = this.getTrackingIcon(i15);
                if (ti4.getIcon() != this.bookmarkIcon) continue;
                retVal.add(ti4);
            }
        }
        GutterIconInfo[] array = new GutterIconInfo[retVal.size()];
        return retVal.toArray(array);
    }

    @Override
    void handleDocumentEvent(DocumentEvent e15) {
        int newLineCount = this.textArea.getLineCount();
        if (newLineCount != this.currentLineCount) {
            this.currentLineCount = newLineCount;
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int h15 = this.textArea != null ? this.textArea.getHeight() : 100;
        return new Dimension(this.width, h15);
    }

    @Override
    public String getToolTipText(MouseEvent e15) {
        try {
            GutterIconInfo[] infos;
            int line = this.viewToModelLine(e15.getPoint());
            if (line > -1 && (infos = this.getTrackingIcons(line)).length > 0) {
                return infos[infos.length - 1].getToolTip();
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return null;
    }

    protected GutterIconImpl getTrackingIcon(int index) {
        return this.trackingIcons.get(index);
    }

    public GutterIconInfo[] getTrackingIcons(int line) throws BadLocationException {
        ArrayList<GutterIconImpl> retVal = new ArrayList<GutterIconImpl>(1);
        if (this.trackingIcons != null) {
            int start = this.textArea.getLineStartOffset(line);
            int end = this.textArea.getLineEndOffset(line);
            if (line == this.textArea.getLineCount() - 1) {
                ++end;
            }
            for (int i15 = 0; i15 < this.trackingIcons.size(); ++i15) {
                GutterIconImpl ti4 = this.getTrackingIcon(i15);
                int offs = ti4.getMarkedOffset();
                if (offs >= start && offs < end) {
                    retVal.add(ti4);
                    continue;
                }
                if (offs >= end) break;
            }
        }
        GutterIconInfo[] array = new GutterIconInfo[retVal.size()];
        return retVal.toArray(array);
    }

    @Override
    protected void init() {
        super.init();
        this.visibleRect = new Rectangle();
        this.width = 16;
        this.addMouseListener(this);
        this.activeLineRangeEnd = -1;
        this.activeLineRangeStart = -1;
        this.setActiveLineRangeColor(null);
        this.updateBackground();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public boolean isBookmarkingEnabled() {
        return this.bookmarkingEnabled;
    }

    @Override
    void lineHeightsChanged() {
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e15) {
    }

    @Override
    public void mouseEntered(MouseEvent e15) {
    }

    @Override
    public void mouseExited(MouseEvent e15) {
    }

    @Override
    public void mousePressed(MouseEvent e15) {
        if (this.bookmarkingEnabled && this.bookmarkIcon != null) {
            try {
                int line = this.viewToModelLine(e15.getPoint());
                if (line > -1) {
                    this.toggleBookmark(line);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e15) {
    }

    @Override
    protected void paintComponent(Graphics g15) {
        if (this.textArea == null) {
            return;
        }
        this.visibleRect = g15.getClipBounds(this.visibleRect);
        if (this.visibleRect == null) {
            this.visibleRect = this.getVisibleRect();
        }
        if (this.visibleRect == null) {
            return;
        }
        this.paintBackgroundImpl(g15, this.visibleRect);
        if (this.textArea.getLineWrap()) {
            this.paintComponentWrapped(g15);
            return;
        }
        Document doc = this.textArea.getDocument();
        Element root = doc.getDefaultRootElement();
        this.textAreaInsets = this.textArea.getInsets(this.textAreaInsets);
        if (this.visibleRect.y < this.textAreaInsets.top) {
            this.visibleRect.height -= this.textAreaInsets.top - this.visibleRect.y;
            this.visibleRect.y = this.textAreaInsets.top;
        }
        int cellHeight = this.textArea.getLineHeight();
        int topLine = (this.visibleRect.y - this.textAreaInsets.top) / cellHeight;
        int bottomLine = Math.min(topLine + this.visibleRect.height / cellHeight + 1, root.getElementCount());
        int y15 = topLine * cellHeight + this.textAreaInsets.top;
        if (this.activeLineRangeStart >= topLine && this.activeLineRangeStart <= bottomLine || this.activeLineRangeEnd >= topLine && this.activeLineRangeEnd <= bottomLine || this.activeLineRangeStart <= topLine && this.activeLineRangeEnd >= bottomLine) {
            g15.setColor(this.activeLineRangeColor);
            int firstLine = Math.max(this.activeLineRangeStart, topLine);
            int y16 = firstLine * cellHeight + this.textAreaInsets.top;
            int lastLine = Math.min(this.activeLineRangeEnd, bottomLine);
            int y25 = (lastLine + 1) * cellHeight + this.textAreaInsets.top - 1;
            for (int j15 = y16; j15 <= y25; j15 += 2) {
                int yEnd = Math.min(y25, j15 + this.getWidth());
                int xEnd = yEnd - j15;
                g15.drawLine(0, j15, xEnd, yEnd);
            }
            for (int i15 = 2; i15 < this.getWidth(); i15 += 2) {
                int yEnd = y16 + this.getWidth() - i15;
                g15.drawLine(i15, y16, this.getWidth(), yEnd);
            }
            if (firstLine == this.activeLineRangeStart) {
                g15.drawLine(0, y16, this.getWidth(), y16);
            }
            if (lastLine == this.activeLineRangeEnd) {
                g15.drawLine(0, y25, this.getWidth(), y25);
            }
        }
        if (this.trackingIcons != null) {
            int lastLine = bottomLine;
            for (int i16 = this.trackingIcons.size() - 1; i16 >= 0; --i16) {
                GutterIconImpl ti4 = this.getTrackingIcon(i16);
                int offs = ti4.getMarkedOffset();
                if (offs < 0 || offs > doc.getLength()) continue;
                int line = root.getElementIndex(offs);
                if (line <= lastLine && line >= topLine) {
                    Icon icon = ti4.getIcon();
                    if (icon == null) continue;
                    int y26 = y15 + (line - topLine) * cellHeight;
                    ti4.getIcon().paintIcon(this, g15, 0, y26 += (cellHeight - icon.getIconHeight()) / 2);
                    lastLine = line - 1;
                    continue;
                }
                if (line < topLine) break;
            }
        }
    }

    protected void paintBackgroundImpl(Graphics g15, Rectangle visibleRect) {
        Color bg5 = this.getBackground();
        if (this.inheritsGutterBackground && this.getGutter() != null) {
            bg5 = this.getGutter().getBackground();
        }
        g15.setColor(bg5);
        g15.fillRect(0, visibleRect.y, this.width, visibleRect.height);
    }

    private void paintComponentWrapped(Graphics g15) {
        RTextAreaUI ui4 = (RTextAreaUI)this.textArea.getUI();
        View v15 = ui4.getRootView(this.textArea).getView(0);
        Document doc = this.textArea.getDocument();
        Element root = doc.getDefaultRootElement();
        int lineCount = root.getElementCount();
        int topPosition = this.textArea.viewToModel(new Point(this.visibleRect.x, this.visibleRect.y));
        int topLine = root.getElementIndex(topPosition);
        Rectangle visibleEditorRect = ui4.getVisibleEditorRect();
        Rectangle r15 = IconRowHeader.getChildViewBounds(v15, topLine, visibleEditorRect);
        int y15 = r15.y;
        int visibleBottom = this.visibleRect.y + this.visibleRect.height;
        int currentIcon = -1;
        if (this.trackingIcons != null) {
            for (int i15 = 0; i15 < this.trackingIcons.size(); ++i15) {
                int line;
                GutterIconImpl icon = this.getTrackingIcon(i15);
                int offs = icon.getMarkedOffset();
                if (offs < 0 || offs > doc.getLength() || (line = root.getElementIndex(offs)) < topLine) continue;
                currentIcon = i15;
                break;
            }
        }
        g15.setColor(this.getForeground());
        int cellHeight = this.textArea.getLineHeight();
        while (y15 < visibleBottom) {
            r15 = IconRowHeader.getChildViewBounds(v15, topLine, visibleEditorRect);
            if (currentIcon > -1) {
                Icon icon;
                GutterIconImpl toPaint = null;
                while (currentIcon < this.trackingIcons.size()) {
                    GutterIconImpl ti4 = this.getTrackingIcon(currentIcon);
                    int offs = ti4.getMarkedOffset();
                    if (offs >= 0 && offs <= doc.getLength()) {
                        int line = root.getElementIndex(offs);
                        if (line == topLine) {
                            toPaint = ti4;
                        } else if (line > topLine) break;
                    }
                    ++currentIcon;
                }
                if (toPaint != null && (icon = toPaint.getIcon()) != null) {
                    int y25 = y15 + (cellHeight - icon.getIconHeight()) / 2;
                    icon.paintIcon(this, g15, 0, y25);
                }
            }
            y15 += r15.height;
            if (++topLine < lineCount) continue;
            break;
        }
    }

    public void removeTrackingIcon(GutterIconInfo tag) {
        if (this.trackingIcons != null && this.trackingIcons.remove(tag)) {
            this.repaint();
        }
    }

    public void removeAllTrackingIcons() {
        if (this.trackingIcons != null && !this.trackingIcons.isEmpty()) {
            this.trackingIcons.clear();
            this.repaint();
        }
    }

    private void removeBookmarkTrackingIcons() {
        if (this.trackingIcons != null) {
            this.trackingIcons.removeIf(ti4 -> ti4.getIcon() == this.bookmarkIcon);
        }
    }

    public void setActiveLineRange(int startLine, int endLine) {
        if (startLine != this.activeLineRangeStart || endLine != this.activeLineRangeEnd) {
            this.activeLineRangeStart = startLine;
            this.activeLineRangeEnd = endLine;
            this.repaint();
        }
    }

    public void setActiveLineRangeColor(Color color) {
        if (color == null) {
            color = Gutter.DEFAULT_ACTIVE_LINE_RANGE_COLOR;
        }
        if (!color.equals(this.activeLineRangeColor)) {
            this.activeLineRangeColor = color;
            this.repaint();
        }
    }

    public void setBookmarkIcon(Icon icon) {
        this.removeBookmarkTrackingIcons();
        this.bookmarkIcon = icon;
        this.repaint();
    }

    public void setBookmarkingEnabled(boolean enabled) {
        if (enabled != this.bookmarkingEnabled) {
            this.bookmarkingEnabled = enabled;
            if (!enabled) {
                this.removeBookmarkTrackingIcons();
            }
            this.repaint();
        }
    }

    public void setInheritsGutterBackground(boolean inherits) {
        if (inherits != this.inheritsGutterBackground) {
            this.inheritsGutterBackground = inherits;
            this.repaint();
        }
    }

    @Override
    public void setTextArea(RTextArea textArea) {
        this.removeAllTrackingIcons();
        super.setTextArea(textArea);
    }

    public boolean toggleBookmark(int line) throws BadLocationException {
        if (!this.isBookmarkingEnabled() || this.getBookmarkIcon() == null) {
            return false;
        }
        GutterIconInfo[] icons = this.getTrackingIcons(line);
        if (icons.length == 0) {
            int offs = this.textArea.getLineStartOffset(line);
            this.fireBookmarkAdded(this, this.addOffsetTrackingIcon(offs, this.bookmarkIcon), line);
            return true;
        }
        boolean found = false;
        for (GutterIconInfo icon : icons) {
            if (icon.getIcon() != this.bookmarkIcon) continue;
            this.removeTrackingIcon(icon);
            found = true;
            this.fireBookmarkRemoved(this, icon, line);
        }
        if (!found) {
            int offs = this.textArea.getLineStartOffset(line);
            this.fireBookmarkAdded(this, this.addOffsetTrackingIcon(offs, this.bookmarkIcon), line);
        }
        return !found;
    }

    private void updateBackground() {
        Color bg5 = UIManager.getColor("Panel.background");
        if (bg5 == null) {
            bg5 = new JPanel().getBackground();
        }
        this.setBackground(bg5);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateBackground();
    }

    private int viewToModelLine(Point p15) throws BadLocationException {
        int offs = this.textArea.viewToModel(p15);
        return offs > -1 ? this.textArea.getLineOfOffset(offs) : -1;
    }

    protected void fireBookmarkRemoved(Object source, GutterIconInfo iconInfo, int line) {
        Object[] listeners = this.listenerList.getListenerList();
        IconRowEvent e15 = null;
        for (int i15 = listeners.length - 2; i15 >= 0; i15 -= 2) {
            if (listeners[i15] != IconRowListener.class) continue;
            if (e15 == null) {
                e15 = new IconRowEvent(source, iconInfo, line);
            }
            ((IconRowListener)listeners[i15 + 1]).bookmarkRemoved(e15);
        }
    }

    protected void fireBookmarkAdded(Object source, GutterIconInfo iconInfo, int line) {
        Object[] listeners = this.listenerList.getListenerList();
        IconRowEvent e15 = null;
        for (int i15 = listeners.length - 2; i15 >= 0; i15 -= 2) {
            if (listeners[i15] != IconRowListener.class) continue;
            if (e15 == null) {
                e15 = new IconRowEvent(source, iconInfo, line);
            }
            ((IconRowListener)listeners[i15 + 1]).bookmarkAdded(e15);
        }
    }

    public void addIconRowListener(IconRowListener l15) {
        this.listenerList.add(IconRowListener.class, l15);
    }

    public void removeIconRowListener(IconRowListener l15) {
        this.listenerList.remove(IconRowListener.class, l15);
    }

    private static class GutterIconImpl
    implements GutterIconInfo,
    Comparable<GutterIconInfo> {
        private Icon icon;
        private Position pos;
        private String toolTip;

        GutterIconImpl(Icon icon, Position pos, String toolTip) {
            this.icon = icon;
            this.pos = pos;
            this.toolTip = toolTip;
        }

        @Override
        public int compareTo(GutterIconInfo other) {
            if (other != null) {
                return this.pos.getOffset() - other.getMarkedOffset();
            }
            return -1;
        }

        public boolean equals(Object o15) {
            return o15 == this;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public int getMarkedOffset() {
            return this.pos.getOffset();
        }

        @Override
        public String getToolTip() {
            return this.toolTip;
        }

        public int hashCode() {
            return this.icon.hashCode();
        }
    }
}

