/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import org.fife.ui.rtextarea.ImageBackgroundPainterStrategy;
import org.fife.ui.rtextarea.RTextAreaBase;

public class BufferedImageBackgroundPainterStrategy
extends ImageBackgroundPainterStrategy {
    private BufferedImage bgImage;

    public BufferedImageBackgroundPainterStrategy(RTextAreaBase ta5) {
        super(ta5);
    }

    @Override
    protected void paintImage(Graphics g15, int x15, int y15) {
        if (this.bgImage != null) {
            g15.drawImage(this.bgImage, x15, y15, null);
        }
    }

    @Override
    protected void rescaleImage(int width, int height, int hint) {
        Image master = this.getMasterImage();
        if (master != null) {
            HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
            switch (hint) {
                default: 
            }
            hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.bgImage = this.createAcceleratedImage(width, height);
            Graphics2D g15 = this.bgImage.createGraphics();
            g15.addRenderingHints(hints);
            g15.drawImage(master, 0, 0, width, height, null);
            g15.dispose();
        } else {
            this.bgImage = null;
        }
    }

    private BufferedImage createAcceleratedImage(int width, int height) {
        GraphicsConfiguration gc5 = this.getRTextAreaBase().getGraphicsConfiguration();
        if (gc5 != null) {
            return gc5.createCompatibleImage(width, height);
        }
        if (!GraphicsEnvironment.isHeadless()) {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(width, height);
        }
        return new BufferedImage(width, height, 2);
    }
}

