/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.templates;

import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.templates.AbstractCodeTemplate;

public class StaticCodeTemplate
extends AbstractCodeTemplate {
    private static final long serialVersionUID = 1L;
    private String beforeCaret;
    private String afterCaret;
    private transient int firstBeforeNewline;
    private transient int firstAfterNewline;
    private static final String EMPTY_STRING = "";

    public StaticCodeTemplate() {
    }

    public StaticCodeTemplate(String id5, String beforeCaret, String afterCaret) {
        super(id5);
        this.setBeforeCaretText(beforeCaret);
        this.setAfterCaretText(afterCaret);
    }

    public String getAfterCaretText() {
        return this.afterCaret;
    }

    public String getBeforeCaretText() {
        return this.beforeCaret;
    }

    private String getAfterTextIndented(String indent) {
        return this.getTextIndented(this.getAfterCaretText(), this.firstAfterNewline, indent);
    }

    private String getBeforeTextIndented(String indent) {
        return this.getTextIndented(this.getBeforeCaretText(), this.firstBeforeNewline, indent);
    }

    private String getTextIndented(String text, int firstNewline, String indent) {
        int pos;
        if (firstNewline == -1) {
            return text;
        }
        int old = firstNewline + 1;
        StringBuilder sb5 = new StringBuilder(text.substring(0, old));
        sb5.append(indent);
        while ((pos = text.indexOf(10, old)) > -1) {
            sb5.append(text, old, pos + 1);
            sb5.append(indent);
            old = pos + 1;
        }
        if (old < text.length()) {
            sb5.append(text.substring(old));
        }
        return sb5.toString();
    }

    @Override
    public void invoke(RSyntaxTextArea textArea) throws BadLocationException {
        int endWS;
        Caret c15 = textArea.getCaret();
        int dot = c15.getDot();
        int mark = c15.getMark();
        int p05 = Math.min(dot, mark);
        int p15 = Math.max(dot, mark);
        RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
        Element map = doc.getDefaultRootElement();
        int lineNum = map.getElementIndex(dot);
        Element line = map.getElement(lineNum);
        int start = line.getStartOffset();
        int end = line.getEndOffset() - 1;
        String s15 = textArea.getText(start, end - start);
        int len = s15.length();
        for (endWS = 0; endWS < len && RSyntaxUtilities.isWhitespace(s15.charAt(endWS)); ++endWS) {
        }
        s15 = s15.substring(0, endWS);
        String beforeText = this.getBeforeTextIndented(s15);
        String afterText = this.getAfterTextIndented(s15);
        doc.replace(p05 -= this.getID().length(), p15 - p05, beforeText + afterText, null);
        textArea.setCaretPosition(p05 + beforeText.length());
    }

    private void readObject(ObjectInputStream in4) throws ClassNotFoundException, IOException {
        in4.defaultReadObject();
        this.setBeforeCaretText(this.beforeCaret);
        this.setAfterCaretText(this.afterCaret);
    }

    public void setAfterCaretText(String afterCaret) {
        this.afterCaret = afterCaret == null ? EMPTY_STRING : afterCaret;
        this.firstAfterNewline = this.afterCaret.indexOf(10);
    }

    public void setBeforeCaretText(String beforeCaret) {
        this.beforeCaret = beforeCaret == null ? EMPTY_STRING : beforeCaret;
        this.firstBeforeNewline = this.beforeCaret.indexOf(10);
    }

    public String toString() {
        return "[StaticCodeTemplate: id=" + this.getID() + ", text=" + this.getBeforeCaretText() + "|" + this.getAfterCaretText() + "]";
    }
}

