/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.parser;

import java.io.IOException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fife.io.DocumentReader;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser
extends AbstractParser {
    private SAXParserFactory spf;
    private DefaultParseResult result;
    private EntityResolver entityResolver;

    public XmlParser() {
        this(null);
    }

    public XmlParser(EntityResolver resolver) {
        this.entityResolver = resolver;
        this.result = new DefaultParseResult(this);
        try {
            this.spf = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError fce) {
            fce.printStackTrace();
        }
    }

    public boolean isValidating() {
        return this.spf.isValidating();
    }

    @Override
    public ParseResult parse(RSyntaxDocument doc, String style) {
        this.result.clearNotices();
        Element root = doc.getDefaultRootElement();
        this.result.setParsedLines(0, root.getElementCount() - 1);
        if (this.spf == null || doc.getLength() == 0) {
            return this.result;
        }
        try {
            SAXParser sp4 = this.spf.newSAXParser();
            Handler handler = new Handler(doc);
            DocumentReader r15 = new DocumentReader(doc);
            InputSource input = new InputSource(r15);
            sp4.parse(input, (DefaultHandler)handler);
            r15.close();
        }
        catch (SAXParseException sp4) {
        }
        catch (Exception e15) {
            this.result.addNotice(new DefaultParserNotice(this, "Error parsing XML: " + e15.getMessage(), 0, -1, -1));
        }
        return this.result;
    }

    public void setValidating(boolean validating) {
        this.spf.setValidating(validating);
    }

    private final class Handler
    extends DefaultHandler {
        private Document doc;

        private Handler(Document doc) {
            this.doc = doc;
        }

        private void doError(SAXParseException e15, ParserNotice.Level level) {
            int line = e15.getLineNumber() - 1;
            Element root = this.doc.getDefaultRootElement();
            Element elem = root.getElement(line);
            int offs = elem.getStartOffset();
            int len = elem.getEndOffset() - offs;
            if (line == root.getElementCount() - 1) {
                ++len;
            }
            DefaultParserNotice pn4 = new DefaultParserNotice(XmlParser.this, e15.getMessage(), line, offs, len);
            pn4.setLevel(level);
            XmlParser.this.result.addNotice(pn4);
        }

        @Override
        public void error(SAXParseException e15) {
            this.doError(e15, ParserNotice.Level.ERROR);
        }

        @Override
        public void fatalError(SAXParseException e15) {
            this.doError(e15, ParserNotice.Level.ERROR);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            if (XmlParser.this.entityResolver != null) {
                return XmlParser.this.entityResolver.resolveEntity(publicId, systemId);
            }
            return super.resolveEntity(publicId, systemId);
        }

        @Override
        public void warning(SAXParseException e15) {
            this.doError(e15, ParserNotice.Level.WARNING);
        }
    }
}

