/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.DefaultTokenPainter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;

public class VisibleWhitespaceTokenPainter
extends DefaultTokenPainter {
    @Override
    protected float paintImpl(Token token, Graphics2D g15, float x15, float y15, RSyntaxTextArea host, TabExpander e15, float clipStart, boolean selected, boolean useSTC) {
        int origX = (int)x15;
        int textOffs = token.getTextOffset();
        char[] text = token.getTextArray();
        int end = textOffs + token.length();
        float nextX = x15;
        int flushLen = 0;
        int flushIndex = textOffs;
        Color fg5 = useSTC ? host.getSelectedTextColor() : host.getForegroundForToken(token);
        Color bg5 = selected ? null : host.getBackgroundForToken(token);
        g15.setFont(host.getFontForToken(token));
        FontMetrics fm4 = host.getFontMetricsForToken(token);
        int ascent = fm4.getAscent();
        int height = fm4.getHeight();
        block4: for (int i15 = textOffs; i15 < end; ++i15) {
            switch (text[i15]) {
                case '\t': {
                    nextX = x15 + (float)fm4.charsWidth(text, flushIndex, flushLen);
                    float nextTabStop = e15.nextTabStop(nextX, 0);
                    if (bg5 != null) {
                        this.paintBackground(x15, y15, nextTabStop - x15, height, g15, ascent, host, bg5);
                    }
                    g15.setColor(fg5);
                    if (flushLen > 0) {
                        g15.drawChars(text, flushIndex, flushLen, (int)x15, (int)y15);
                        flushLen = 0;
                    }
                    flushIndex = i15 + 1;
                    this.paintTabText(g15, nextX, y15, nextTabStop, ascent, height);
                    x15 = nextTabStop;
                    continue block4;
                }
                case ' ': {
                    nextX = x15 + (float)fm4.charsWidth(text, flushIndex, flushLen + 1);
                    int width = fm4.charWidth(' ');
                    if (bg5 != null) {
                        this.paintBackground(x15, y15, nextX - x15, height, g15, ascent, host, bg5);
                    }
                    g15.setColor(fg5);
                    if (flushLen > 0) {
                        g15.drawChars(text, flushIndex, flushLen, (int)x15, (int)y15);
                        flushLen = 0;
                    }
                    this.paintSpaceText(g15, nextX, y15, ascent, width, height);
                    flushIndex = i15 + 1;
                    x15 = nextX;
                    continue block4;
                }
                default: {
                    ++flushLen;
                }
            }
        }
        nextX = x15 + (float)fm4.charsWidth(text, flushIndex, flushLen);
        if (flushLen > 0 && nextX >= clipStart) {
            if (bg5 != null) {
                this.paintBackground(x15, y15, nextX - x15, height, g15, ascent, host, bg5);
            }
            g15.setColor(fg5);
            g15.drawChars(text, flushIndex, flushLen, (int)x15, (int)y15);
        }
        if (host.getUnderlineForToken(token)) {
            g15.setColor(fg5);
            int y25 = (int)(y15 + 1.0f);
            g15.drawLine(origX, y25, (int)nextX, y25);
        }
        if (host.getPaintTabLines() && origX == host.getMargin().left) {
            this.paintTabLines(token, origX, (int)y15, (int)nextX, g15, e15, host);
        }
        return nextX;
    }

    protected void paintSpaceText(Graphics2D g15, float x15, float y15, int ascent, int width, int height) {
        int dotX = (int)(x15 - (float)width / 2.0f);
        int dotY = (int)(y15 - (float)ascent + (float)height / 2.0f);
        g15.drawLine(dotX, dotY, dotX, dotY);
    }

    protected void paintTabText(Graphics2D g15, float x15, float y15, float nextTabStop, int ascent, int height) {
        int x25 = (int)nextTabStop - 3;
        if (x25 >= (int)x15) {
            int halfHeight = height / 2;
            int ymid = (int)y15 - ascent + halfHeight;
            g15.drawLine((int)x15, ymid, x25, ymid);
        }
    }
}

