/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.fife.ui.rsyntaxtextarea.HtmlUtil;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Token;

public class TokenImpl
implements Token {
    public char[] text = null;
    public int textOffset = -1;
    public int textCount = -1;
    private int offset;
    private int type;
    private boolean hyperlink;
    private Token nextToken;
    private int languageIndex;

    public TokenImpl() {
        this.setType(0);
        this.setOffset(-1);
        this.hyperlink = false;
        this.nextToken = null;
    }

    public TokenImpl(Segment line, int beg, int end, int startOffset, int type, int languageIndex) {
        this(line.array, beg, end, startOffset, type, languageIndex);
    }

    public TokenImpl(char[] line, int beg, int end, int startOffset, int type, int languageIndex) {
        this();
        this.set(line, beg, end, startOffset, type);
        this.setLanguageIndex(languageIndex);
    }

    public TokenImpl(Token t25) {
        this();
        this.copyFrom(t25);
    }

    @Override
    public StringBuilder appendHTMLRepresentation(StringBuilder sb5, RSyntaxTextArea textArea, boolean fontFamily) {
        return this.appendHTMLRepresentation(sb5, textArea, fontFamily, false);
    }

    @Override
    public StringBuilder appendHTMLRepresentation(StringBuilder sb5, RSyntaxTextArea textArea, boolean fontFamily, boolean tabsToSpaces) {
        boolean needsFontTag;
        SyntaxScheme colorScheme = textArea.getSyntaxScheme();
        Style scheme = colorScheme.getStyle(this.getType());
        Font font = textArea.getFontForTokenType(this.getType());
        if (font.isBold()) {
            sb5.append("<b>");
        }
        if (font.isItalic()) {
            sb5.append("<em>");
        }
        if (scheme.underline || this.isHyperlink()) {
            sb5.append("<u>");
        }
        boolean bl4 = needsFontTag = fontFamily || !this.isWhitespace();
        if (needsFontTag) {
            sb5.append("<font");
            if (fontFamily) {
                sb5.append(" face=\"").append(font.getFamily()).append('\"');
            }
            if (!this.isWhitespace()) {
                Color fg5 = scheme.foreground != null ? scheme.foreground : textArea.getForeground();
                sb5.append(" color=\"").append(HtmlUtil.getHexString(fg5)).append('\"');
            }
            sb5.append('>');
        }
        this.appendHtmlLexeme(textArea, sb5, tabsToSpaces);
        if (needsFontTag) {
            sb5.append("</font>");
        }
        if (scheme.underline || this.isHyperlink()) {
            sb5.append("</u>");
        }
        if (font.isItalic()) {
            sb5.append("</em>");
        }
        if (font.isBold()) {
            sb5.append("</b>");
        }
        return sb5;
    }

    private StringBuilder appendHtmlLexeme(RSyntaxTextArea textArea, StringBuilder sb5, boolean tabsToSpaces) {
        int i15;
        boolean lastWasSpace = false;
        int lastI = i15 = this.textOffset;
        String tabStr = null;
        while (i15 < this.textOffset + this.textCount) {
            char ch4 = this.text[i15];
            switch (ch4) {
                case ' ': {
                    sb5.append(this.text, lastI, i15 - lastI);
                    lastI = i15 + 1;
                    sb5.append(lastWasSpace ? "&nbsp;" : " ");
                    lastWasSpace = true;
                    break;
                }
                case '\t': {
                    sb5.append(this.text, lastI, i15 - lastI);
                    lastI = i15 + 1;
                    if (tabsToSpaces && tabStr == null) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int j15 = 0; j15 < textArea.getTabSize(); ++j15) {
                            stringBuilder.append("&nbsp;");
                        }
                        tabStr = stringBuilder.toString();
                    }
                    sb5.append(tabsToSpaces ? tabStr : "&#09;");
                    lastWasSpace = false;
                    break;
                }
                case '&': {
                    sb5.append(this.text, lastI, i15 - lastI);
                    lastI = i15 + 1;
                    sb5.append("&amp;");
                    lastWasSpace = false;
                    break;
                }
                case '<': {
                    sb5.append(this.text, lastI, i15 - lastI);
                    lastI = i15 + 1;
                    sb5.append("&lt;");
                    lastWasSpace = false;
                    break;
                }
                case '>': {
                    sb5.append(this.text, lastI, i15 - lastI);
                    lastI = i15 + 1;
                    sb5.append("&gt;");
                    lastWasSpace = false;
                    break;
                }
                case '\'': {
                    sb5.append(this.text, lastI, i15 - lastI);
                    lastI = i15 + 1;
                    sb5.append("&#39;");
                    lastWasSpace = false;
                    break;
                }
                case '\"': {
                    sb5.append(this.text, lastI, i15 - lastI);
                    lastI = i15 + 1;
                    sb5.append("&#34;");
                    lastWasSpace = false;
                    break;
                }
                case '/': {
                    sb5.append(this.text, lastI, i15 - lastI);
                    lastI = i15 + 1;
                    sb5.append("&#47;");
                    lastWasSpace = false;
                    break;
                }
                default: {
                    lastWasSpace = false;
                }
            }
            ++i15;
        }
        if (lastI < this.textOffset + this.textCount) {
            sb5.append(this.text, lastI, this.textOffset + this.textCount - lastI);
        }
        return sb5;
    }

    @Override
    public char charAt(int index) {
        return this.text[this.textOffset + index];
    }

    @Override
    public boolean containsPosition(int pos) {
        return pos >= this.getOffset() && pos < this.getOffset() + this.textCount;
    }

    public void copyFrom(Token t25) {
        this.text = t25.getTextArray();
        this.textOffset = t25.getTextOffset();
        this.textCount = t25.length();
        this.setOffset(t25.getOffset());
        this.setType(t25.getType());
        this.hyperlink = t25.isHyperlink();
        this.languageIndex = t25.getLanguageIndex();
        this.nextToken = t25.getNextToken();
    }

    @Override
    public int documentToToken(int pos) {
        return pos + (this.textOffset - this.getOffset());
    }

    @Override
    public boolean endsWith(char ch4) {
        return this.textCount > 0 && this.text[this.textOffset + this.textCount - 1] == ch4;
    }

    @Override
    public boolean endsWith(char[] ch4) {
        if (ch4 == null || ch4.length > this.textCount) {
            return false;
        }
        int start = this.textOffset + this.textCount - ch4.length;
        for (int i15 = 0; i15 < ch4.length; ++i15) {
            if (this.text[start + i15] == ch4[i15]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Token)) {
            return false;
        }
        Token t25 = (Token)obj;
        return this.offset == t25.getOffset() && this.type == t25.getType() && this.languageIndex == t25.getLanguageIndex() && this.hyperlink == t25.isHyperlink() && (this.getLexeme() == null && t25.getLexeme() == null || this.getLexeme() != null && this.getLexeme().equals(t25.getLexeme()));
    }

    @Override
    public int getEndOffset() {
        return this.offset + this.textCount;
    }

    @Override
    public String getHTMLRepresentation(RSyntaxTextArea textArea) {
        StringBuilder buf = new StringBuilder();
        this.appendHTMLRepresentation(buf, textArea, true);
        return buf.toString();
    }

    @Override
    public int getLanguageIndex() {
        return this.languageIndex;
    }

    @Override
    public Token getLastNonCommentNonWhitespaceToken() {
        TokenImpl last = null;
        block3: for (Token t15 = this; t15 != null && t15.isPaintable(); t15 = t15.getNextToken()) {
            switch (t15.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 21: {
                    continue block3;
                }
                default: {
                    last = t15;
                }
            }
        }
        return last;
    }

    @Override
    public Token getLastPaintableToken() {
        Token t15 = this;
        while (t15.isPaintable()) {
            Token next = t15.getNextToken();
            if (next == null || !next.isPaintable()) {
                return t15;
            }
            t15 = next;
        }
        return null;
    }

    @Override
    public String getLexeme() {
        if (this.text == null) {
            return null;
        }
        return this.isPaintable() ? new String(this.text, this.textOffset, this.textCount) : null;
    }

    @Override
    public int getListOffset(RSyntaxTextArea textArea, TabExpander e15, float x05, float x15) {
        if (x05 >= x15) {
            return this.getOffset();
        }
        float currX = x05;
        float nextX = x05;
        float stableX = x05;
        int last = this.getOffset();
        for (TokenImpl token = this; token != null && token.isPaintable(); token = (TokenImpl)token.getNextToken()) {
            FontMetrics fm4 = textArea.getFontMetricsForToken(token);
            char[] text = token.text;
            int start = token.textOffset;
            int end = start + token.textCount;
            for (int i15 = start; i15 < end; ++i15) {
                currX = nextX;
                if (text[i15] == '\t') {
                    stableX = nextX = e15.nextTabStop(nextX, 0);
                    start = i15 + 1;
                } else {
                    nextX = stableX + (float)fm4.charsWidth(text, start, i15 - start + 1);
                }
                if (!(x15 >= currX) || !(x15 < nextX)) continue;
                if (x15 - currX < nextX - x15) {
                    return last + i15 - token.textOffset;
                }
                return last + i15 + 1 - token.textOffset;
            }
            stableX = nextX;
            last += token.textCount;
        }
        return last;
    }

    @Override
    public Token getNextToken() {
        return this.nextToken;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getOffsetBeforeX(RSyntaxTextArea textArea, TabExpander e15, float startX, float endBeforeX) {
        int i15;
        FontMetrics fm4 = textArea.getFontMetricsForToken(this);
        int stop = i15 + this.textCount;
        float x15 = startX;
        for (i15 = this.textOffset; i15 < stop; ++i15) {
            x15 = this.text[i15] == '\t' ? e15.nextTabStop(x15, 0) : (x15 += (float)fm4.charWidth(this.text[i15]));
            if (!(x15 > endBeforeX)) continue;
            int intoToken = Math.max(i15 - this.textOffset, 1);
            return this.getOffset() + intoToken;
        }
        return this.getOffset() + this.textCount - 1;
    }

    @Override
    public char[] getTextArray() {
        return this.text;
    }

    @Override
    public int getTextOffset() {
        return this.textOffset;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public float getWidth(RSyntaxTextArea textArea, TabExpander e15, float x05) {
        return this.getWidthUpTo(this.textCount, textArea, e15, x05);
    }

    @Override
    public float getWidthUpTo(int numChars, RSyntaxTextArea textArea, TabExpander e15, float x05) {
        float width = x05;
        FontMetrics fm4 = textArea.getFontMetricsForToken(this);
        if (fm4 != null) {
            int w15;
            int currentStart = this.textOffset;
            int endBefore = this.textOffset + numChars;
            for (int i15 = currentStart; i15 < endBefore; ++i15) {
                if (this.text[i15] != '\t') continue;
                w15 = i15 - currentStart;
                if (w15 > 0) {
                    width += (float)fm4.charsWidth(this.text, currentStart, w15);
                }
                currentStart = i15 + 1;
                width = e15.nextTabStop(width, 0);
            }
            w15 = endBefore - currentStart;
            width += (float)fm4.charsWidth(this.text, currentStart, w15);
        }
        return width - x05;
    }

    public int hashCode() {
        return this.offset + (this.getLexeme() == null ? 0 : this.getLexeme().hashCode());
    }

    @Override
    public boolean is(char[] lexeme) {
        if (this.textCount == lexeme.length) {
            for (int i15 = 0; i15 < this.textCount; ++i15) {
                if (this.text[this.textOffset + i15] == lexeme[i15]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean is(int type, char[] lexeme) {
        if (this.getType() == type && this.textCount == lexeme.length) {
            for (int i15 = 0; i15 < this.textCount; ++i15) {
                if (this.text[this.textOffset + i15] == lexeme[i15]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean is(int type, String lexeme) {
        return this.getType() == type && this.textCount == lexeme.length() && lexeme.equals(this.getLexeme());
    }

    @Override
    public boolean isComment() {
        int type = this.getType();
        return type >= 1 && type <= 5 || type == 29;
    }

    @Override
    public boolean isCommentOrWhitespace() {
        return this.isComment() || this.isWhitespace();
    }

    @Override
    public boolean isHyperlink() {
        return this.hyperlink;
    }

    @Override
    public boolean isIdentifier() {
        return this.getType() == 20;
    }

    @Override
    public boolean isLeftCurly() {
        return this.getType() == 22 && this.isSingleChar('{');
    }

    @Override
    public boolean isRightCurly() {
        return this.getType() == 22 && this.isSingleChar('}');
    }

    @Override
    public boolean isPaintable() {
        return this.getType() > 0;
    }

    @Override
    public boolean isSingleChar(char ch4) {
        return this.textCount == 1 && this.text[this.textOffset] == ch4;
    }

    @Override
    public boolean isSingleChar(int type, char ch4) {
        return this.getType() == type && this.isSingleChar(ch4);
    }

    @Override
    public boolean isWhitespace() {
        return this.getType() == 21;
    }

    @Override
    public int length() {
        return this.textCount;
    }

    @Override
    public Rectangle listOffsetToView(RSyntaxTextArea textArea, TabExpander e15, int pos, int x05, Rectangle rect) {
        int stableX = x05;
        Segment s15 = new Segment();
        for (TokenImpl token = this; token != null && token.isPaintable(); token = (TokenImpl)token.getNextToken()) {
            FontMetrics fm4 = textArea.getFontMetricsForToken(token);
            if (fm4 == null) {
                return rect;
            }
            char[] text = token.text;
            int start = token.textOffset;
            int end = start + token.textCount;
            if (token.containsPosition(pos)) {
                s15.array = token.text;
                s15.offset = token.textOffset;
                s15.count = pos - token.getOffset();
                int w15 = Utilities.getTabbedTextWidth(s15, fm4, stableX, e15, token.getOffset());
                rect.x = stableX + w15;
                end = token.documentToToken(pos);
                rect.width = text[end] == '\t' ? fm4.charWidth(' ') : fm4.charWidth(text[end]);
                return rect;
            }
            s15.array = token.text;
            s15.offset = token.textOffset;
            s15.count = token.textCount;
            stableX += Utilities.getTabbedTextWidth(s15, fm4, stableX, e15, token.getOffset());
        }
        rect.x = stableX;
        rect.width = 1;
        return rect;
    }

    public void makeStartAt(int pos) {
        if (pos < this.getOffset() || pos >= this.getOffset() + this.textCount) {
            throw new IllegalArgumentException("pos " + pos + " is not in range " + this.getOffset() + "-" + (this.getOffset() + this.textCount - 1));
        }
        int shift = pos - this.getOffset();
        this.setOffset(pos);
        this.textOffset += shift;
        this.textCount -= shift;
    }

    public void moveOffset(int amt) {
        if (amt < 0 || amt > this.textCount) {
            throw new IllegalArgumentException("amt " + amt + " is not in range 0-" + this.textCount);
        }
        this.setOffset(this.getOffset() + amt);
        this.textOffset += amt;
        this.textCount -= amt;
    }

    public void set(char[] line, int beg, int end, int offset, int type) {
        this.text = line;
        this.textOffset = beg;
        this.textCount = end - beg + 1;
        this.setType(type);
        this.setOffset(offset);
        this.nextToken = null;
    }

    @Override
    public void setHyperlink(boolean hyperlink) {
        this.hyperlink = hyperlink;
    }

    @Override
    public void setLanguageIndex(int languageIndex) {
        this.languageIndex = languageIndex;
    }

    public void setNextToken(Token nextToken) {
        this.nextToken = nextToken;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public boolean startsWith(char[] chars) {
        if (chars.length <= this.textCount) {
            for (int i15 = 0; i15 < chars.length; ++i15) {
                if (this.text[this.textOffset + i15] == chars[i15]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int tokenToDocument(int pos) {
        return pos + (this.getOffset() - this.textOffset);
    }

    public String toString() {
        return "[Token: " + (this.getType() == 0 ? "<null token>" : "text: '" + (this.text == null ? "<null>" : this.getLexeme() + "'; offset: " + this.getOffset() + "; type: " + this.getType() + "; isPaintable: " + this.isPaintable() + "; nextToken==null: " + (this.nextToken == null))) + "]";
    }
}

