/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenUtils;

public final class HtmlUtil {
    private HtmlUtil() {
    }

    public static String escapeForHtml(String s15, String newlineReplacement, boolean inPreBlock) {
        if (s15 == null) {
            return null;
        }
        if (newlineReplacement == null) {
            newlineReplacement = "";
        }
        String tabString = inPreBlock ? "    " : "&nbsp;&nbsp;&nbsp;&nbsp;";
        boolean lastWasSpace = false;
        StringBuilder sb5 = new StringBuilder();
        block11: for (int i15 = 0; i15 < s15.length(); ++i15) {
            char ch4 = s15.charAt(i15);
            switch (ch4) {
                case ' ': {
                    if (inPreBlock || !lastWasSpace) {
                        sb5.append(' ');
                    } else {
                        sb5.append("&nbsp;");
                    }
                    lastWasSpace = true;
                    continue block11;
                }
                case '\n': {
                    sb5.append(newlineReplacement);
                    lastWasSpace = false;
                    continue block11;
                }
                case '&': {
                    sb5.append("&amp;");
                    lastWasSpace = false;
                    continue block11;
                }
                case '\t': {
                    sb5.append(tabString);
                    lastWasSpace = true;
                    continue block11;
                }
                case '<': {
                    sb5.append("&lt;");
                    lastWasSpace = false;
                    continue block11;
                }
                case '>': {
                    sb5.append("&gt;");
                    lastWasSpace = false;
                    continue block11;
                }
                case '\'': {
                    sb5.append("&#39;");
                    lastWasSpace = false;
                    continue block11;
                }
                case '\"': {
                    sb5.append("&#34;");
                    lastWasSpace = false;
                    continue block11;
                }
                case '/': {
                    sb5.append("&#47;");
                    lastWasSpace = false;
                    continue block11;
                }
                default: {
                    sb5.append(ch4);
                    lastWasSpace = false;
                }
            }
        }
        return sb5.toString();
    }

    public static String getHexString(Color c15) {
        if (c15 == null) {
            return null;
        }
        StringBuilder sb5 = new StringBuilder("#");
        int r15 = c15.getRed();
        if (r15 < 16) {
            sb5.append('0');
        }
        sb5.append(Integer.toHexString(r15));
        int g15 = c15.getGreen();
        if (g15 < 16) {
            sb5.append('0');
        }
        sb5.append(Integer.toHexString(g15));
        int b15 = c15.getBlue();
        if (b15 < 16) {
            sb5.append('0');
        }
        sb5.append(Integer.toHexString(b15));
        return sb5.toString();
    }

    public static String getTextAsHtml(RSyntaxTextArea textArea, int start, int end) {
        Token token;
        StringBuilder sb5 = new StringBuilder("<pre style=\"").append("font-family: '").append(textArea.getFont().getFamily()).append("', courier;");
        if (textArea.getBackground() != null) {
            sb5.append(" background: ").append(HtmlUtil.getHexString(textArea.getBackground()));
        }
        sb5.append("\">");
        for (Token t15 = token = textArea.getTokenListFor(start, end); t15 != null; t15 = t15.getNextToken()) {
            if (!t15.isPaintable()) continue;
            if (t15.isSingleChar('\n')) {
                sb5.append("<br>");
                continue;
            }
            sb5.append(TokenUtils.tokenToHtml(textArea, t15));
        }
        sb5.append("</pre>");
        return sb5.toString();
    }
}

