/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.templates.CodeTemplate;

public class CodeTemplateManager {
    private int maxTemplateIDLength;
    private List<CodeTemplate> templates;
    private Segment s = new Segment();
    private TemplateComparator comparator = new TemplateComparator();
    private File directory;

    public CodeTemplateManager() {
        this.templates = new ArrayList<CodeTemplate>();
    }

    public synchronized void addTemplate(CodeTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("template cannot be null");
        }
        this.templates.add(template);
        this.sortTemplates();
    }

    public synchronized CodeTemplate getTemplate(RSyntaxTextArea textArea) {
        int caretPos = textArea.getCaretPosition();
        int charsToGet = Math.min(caretPos, this.maxTemplateIDLength);
        try {
            Document doc = textArea.getDocument();
            doc.getText(caretPos - charsToGet, charsToGet, this.s);
            int index = Collections.binarySearch(this.templates, this.s, this.comparator);
            return index >= 0 ? this.templates.get(index) : null;
        }
        catch (BadLocationException ble) {
            throw new InternalError("Error in CodeTemplateManager", ble);
        }
    }

    private synchronized int getTemplateCount() {
        return this.templates.size();
    }

    public synchronized CodeTemplate[] getTemplates() {
        CodeTemplate[] temp = new CodeTemplate[this.templates.size()];
        return this.templates.toArray(temp);
    }

    private static boolean isValidChar(char ch4) {
        return RSyntaxUtilities.isLetterOrDigit(ch4) || ch4 == '_';
    }

    public synchronized boolean removeTemplate(CodeTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("template cannot be null");
        }
        return this.templates.remove(template);
    }

    public synchronized CodeTemplate removeTemplate(String id5) {
        if (id5 == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        Iterator<CodeTemplate> i15 = this.templates.iterator();
        while (i15.hasNext()) {
            CodeTemplate template = i15.next();
            if (!id5.equals(template.getID())) continue;
            i15.remove();
            return template;
        }
        return null;
    }

    public synchronized void replaceTemplates(CodeTemplate[] newTemplates) {
        this.templates.clear();
        if (newTemplates != null) {
            Collections.addAll(this.templates, newTemplates);
        }
        this.sortTemplates();
    }

    public synchronized boolean saveTemplates() {
        if (this.directory == null || !this.directory.isDirectory()) {
            return false;
        }
        File[] oldXMLFiles = this.directory.listFiles(new XMLFileFilter());
        if (oldXMLFiles == null) {
            return false;
        }
        for (File oldXMLFile : oldXMLFiles) {
            oldXMLFile.delete();
        }
        boolean wasSuccessful = true;
        for (CodeTemplate template : this.templates) {
            File xmlFile = new File(this.directory, template.getID() + ".xml");
            try {
                XMLEncoder e15 = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(xmlFile)));
                e15.writeObject(template);
                e15.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                wasSuccessful = false;
            }
        }
        return wasSuccessful;
    }

    public synchronized int setTemplateDirectory(File dir) {
        if (dir != null && dir.isDirectory()) {
            this.directory = dir;
            File[] files = dir.listFiles(new XMLFileFilter());
            int newCount = files == null ? 0 : files.length;
            int oldCount = this.templates.size();
            ArrayList<CodeTemplate> temp = new ArrayList<CodeTemplate>(oldCount + newCount);
            temp.addAll(this.templates);
            for (int i15 = 0; i15 < newCount; ++i15) {
                try {
                    XMLDecoder d15 = new XMLDecoder(new BufferedInputStream(new FileInputStream(files[i15])));
                    Object obj = d15.readObject();
                    if (!(obj instanceof CodeTemplate)) {
                        d15.close();
                        throw new IOException("Not a CodeTemplate: " + files[i15].getAbsolutePath());
                    }
                    temp.add((CodeTemplate)obj);
                    d15.close();
                    continue;
                }
                catch (IOException | ArrayIndexOutOfBoundsException | NoSuchElementException e15) {
                    e15.printStackTrace();
                }
            }
            this.templates = temp;
            this.sortTemplates();
            return this.getTemplateCount();
        }
        return -1;
    }

    private synchronized void sortTemplates() {
        this.maxTemplateIDLength = 0;
        Iterator<CodeTemplate> i15 = this.templates.iterator();
        while (i15.hasNext()) {
            CodeTemplate temp = i15.next();
            if (temp == null || temp.getID() == null) {
                i15.remove();
                continue;
            }
            this.maxTemplateIDLength = Math.max(this.maxTemplateIDLength, temp.getID().length());
        }
        Collections.sort(this.templates);
    }

    private static final class TemplateComparator
    implements Comparator<Object>,
    Serializable {
        private TemplateComparator() {
        }

        @Override
        public int compare(Object template, Object segment) {
            int j15;
            CodeTemplate t15 = (CodeTemplate)template;
            char[] templateArray = t15.getID().toCharArray();
            int i15 = 0;
            int len1 = templateArray.length;
            Segment s15 = (Segment)segment;
            char[] segArray = s15.array;
            int len2 = s15.count;
            for (j15 = s15.offset + len2 - 1; j15 >= s15.offset && CodeTemplateManager.isValidChar(segArray[j15]); --j15) {
            }
            int segShift = ++j15 - s15.offset;
            int n15 = Math.min(len1, len2 -= segShift);
            while (n15-- != 0) {
                char c25;
                char c15;
                if ((c15 = templateArray[i15++]) == (c25 = segArray[j15++])) continue;
                return c15 - c25;
            }
            return len1 - len2;
        }
    }

    private static final class XMLFileFilter
    implements FileFilter {
        private XMLFileFilter() {
        }

        @Override
        public boolean accept(File f15) {
            return f15.getName().toLowerCase().endsWith(".xml");
        }
    }
}

