/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionContext;
import org.fife.ui.autocomplete.TipUtil;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.rsyntaxtextarea.HtmlUtil;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;

class ParameterizedCompletionDescriptionToolTip {
    private AutoCompletion ac;
    private JWindow tooltip;
    private JLabel descLabel;
    private ParameterizedCompletion pc;
    private boolean overflow;

    ParameterizedCompletionDescriptionToolTip(Window owner, ParameterizedCompletionContext context, AutoCompletion ac5, ParameterizedCompletion pc5) {
        this.tooltip = new JWindow(owner);
        this.ac = ac5;
        this.pc = pc5;
        this.descLabel = new JLabel();
        this.descLabel.setBorder(BorderFactory.createCompoundBorder(TipUtil.getToolTipBorder(), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.descLabel.setOpaque(true);
        this.descLabel.setBackground(TipUtil.getToolTipBackground());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.descLabel);
        this.tooltip.setContentPane(panel);
        PopupWindowDecorator decorator = PopupWindowDecorator.get();
        if (decorator != null) {
            decorator.decorate(this.tooltip);
        }
        this.updateText(0);
        this.tooltip.setFocusableWindowState(false);
    }

    public boolean isVisible() {
        return this.tooltip.isVisible();
    }

    public void setLocationRelativeTo(Rectangle r15) {
        int x15;
        Rectangle screenBounds = Util.getScreenBoundsForPoint(r15.x, r15.y);
        int y15 = r15.y - 5 - this.tooltip.getHeight();
        if (y15 < 0) {
            y15 = r15.y + r15.height + 5;
        }
        if ((x15 = r15.x) < screenBounds.x) {
            x15 = screenBounds.x;
        } else if (x15 + this.tooltip.getWidth() > screenBounds.x + screenBounds.width) {
            x15 = screenBounds.x + screenBounds.width - this.tooltip.getWidth();
        }
        this.tooltip.setLocation(x15, y15);
        EventQueue.invokeLater(this.tooltip::pack);
    }

    public void setVisible(boolean visible) {
        this.tooltip.setVisible(visible);
    }

    public boolean updateText(int selectedParam) {
        ParameterizedCompletion.Parameter param;
        String desc;
        StringBuilder sb5 = new StringBuilder("<html>");
        int paramCount = this.pc.getParamCount();
        if (this.overflow) {
            if (selectedParam < paramCount) {
                String temp = this.pc.getParam(Math.min(paramCount - 1, selectedParam)).toString();
                sb5.append("...<b>").append(HtmlUtil.escapeForHtml(temp, "<br>", false)).append("</b>...");
                if (!this.isVisible()) {
                    this.setVisible(true);
                }
            } else {
                this.setVisible(false);
            }
        } else {
            for (int i15 = 0; i15 < paramCount; ++i15) {
                if (i15 == selectedParam) {
                    sb5.append("<b>");
                }
                String temp = this.pc.getParam(i15).toString();
                sb5.append(HtmlUtil.escapeForHtml(temp, "<br>", false));
                if (i15 == selectedParam) {
                    sb5.append("</b>");
                }
                if (i15 >= paramCount - 1) continue;
                sb5.append(this.pc.getProvider().getParameterListSeparator());
            }
        }
        if (selectedParam >= 0 && selectedParam < paramCount && (desc = (param = this.pc.getParam(selectedParam)).getDescription()) != null) {
            sb5.append("<br>");
            sb5.append(desc);
        }
        this.descLabel.setText(sb5.toString());
        if (!this.overflow && sb5.length() > this.ac.getParameterDescriptionTruncateThreshold()) {
            this.overflow = true;
            this.updateText(selectedParam);
        } else {
            this.overflow = false;
            this.tooltip.pack();
        }
        return true;
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.tooltip);
    }
}

