/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.text.View;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.EmptyIcon;
import org.fife.ui.autocomplete.FunctionCompletion;
import org.fife.ui.autocomplete.MarkupTagCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.TemplateCompletion;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.autocomplete.VariableCompletion;
import org.fife.ui.rsyntaxtextarea.HtmlUtil;

public class CompletionCellRenderer
extends DefaultListCellRenderer {
    private static Color altBG;
    private Font font;
    private boolean showTypes;
    private String typeColor;
    private boolean selected;
    private Color realBG;
    private String paramColor;
    private Icon emptyIcon;
    private Rectangle paintTextR;
    private DefaultListCellRenderer delegate;
    private static final String SUBSTANCE_RENDERER_CLASS_NAME = "org.pushingpixels.substance.api.renderer.SubstanceDefaultListCellRenderer";
    private static final String PREFIX = "<html><nobr>";

    public CompletionCellRenderer() {
        this.init();
    }

    public CompletionCellRenderer(DefaultListCellRenderer delegate2) {
        this.setDelegateRenderer(delegate2);
        this.init();
    }

    protected void appendShortDescription(StringBuilder sb5, String definition) {
        sb5.append(" - ");
        if (!this.selected) {
            sb5.append("<font color='").append(this.typeColor).append("'>");
        }
        sb5.append(definition);
        if (!this.selected) {
            sb5.append("</font>");
        }
    }

    protected void appendTypeIfNecessary(StringBuilder sb5, VariableCompletion varOrFunctionCompletion) {
        if (this.getShowTypes() && varOrFunctionCompletion.getType() != null) {
            sb5.append(" : ");
            if (!this.selected) {
                sb5.append("<font color='").append(this.typeColor).append("'>");
            }
            sb5.append(varOrFunctionCompletion.getType());
            if (!this.selected) {
                sb5.append("</font>");
            }
        }
    }

    protected Icon createEmptyIcon() {
        return new EmptyIcon(16);
    }

    private String createParamColor() {
        return Util.isLightForeground(this.getForeground()) ? HtmlUtil.getHexString(Util.getHyperlinkForeground()) : "#aa0077";
    }

    private String createTypeColor() {
        return "#808080";
    }

    public void delegateToSubstanceRenderer() throws Exception {
        Class<?> clazz = Class.forName(SUBSTANCE_RENDERER_CLASS_NAME);
        DefaultListCellRenderer delegate2 = (DefaultListCellRenderer)clazz.newInstance();
        this.setDelegateRenderer(delegate2);
    }

    public static Color getAlternateBackground() {
        return altBG;
    }

    public DefaultListCellRenderer getDelegateRenderer() {
        return this.delegate;
    }

    public Font getDisplayFont() {
        return this.font;
    }

    protected Icon getEmptyIcon() {
        if (this.emptyIcon == null) {
            this.emptyIcon = this.createEmptyIcon();
        }
        return this.emptyIcon;
    }

    protected Icon getIcon(String resource) {
        URL url = this.getClass().getResource(resource);
        if (url == null) {
            File file2 = new File(resource);
            try {
                url = file2.toURI().toURL();
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        return url != null ? new ImageIcon(url) : null;
    }

    @Override
    public Component getListCellRendererComponent(JList list2, Object value, int index, boolean selected, boolean hasFocus) {
        super.getListCellRendererComponent((JList<?>)list2, value, index, selected, hasFocus);
        if (this.font != null) {
            this.setFont(this.font);
        }
        this.selected = selected;
        this.realBG = altBG != null && (index & 1) == 1 ? altBG : list2.getBackground();
        Completion c15 = (Completion)value;
        this.setIcon(c15.getIcon());
        if (c15 instanceof FunctionCompletion) {
            FunctionCompletion fc5 = (FunctionCompletion)value;
            this.prepareForFunctionCompletion(list2, fc5, index, selected, hasFocus);
        } else if (c15 instanceof VariableCompletion) {
            VariableCompletion vc5 = (VariableCompletion)value;
            this.prepareForVariableCompletion(list2, vc5, index, selected, hasFocus);
        } else if (c15 instanceof TemplateCompletion) {
            TemplateCompletion tc5 = (TemplateCompletion)value;
            this.prepareForTemplateCompletion(list2, tc5, index, selected, hasFocus);
        } else if (c15 instanceof MarkupTagCompletion) {
            MarkupTagCompletion mtc = (MarkupTagCompletion)value;
            this.prepareForMarkupTagCompletion(list2, mtc, index, selected, hasFocus);
        } else {
            this.prepareForOtherCompletion(list2, c15, index, selected, hasFocus);
        }
        if (this.delegate != null) {
            this.delegate.getListCellRendererComponent((JList<?>)list2, this.getText(), index, selected, hasFocus);
            this.delegate.setFont(this.getFont());
            this.delegate.setIcon(this.getIcon());
            return this.delegate;
        }
        if (!selected && (index & 1) == 1 && altBG != null) {
            this.setBackground(altBG);
        }
        return this;
    }

    public boolean getShowTypes() {
        return this.showTypes;
    }

    private void init() {
        this.setShowTypes(true);
        this.typeColor = this.createTypeColor();
        this.paramColor = this.createParamColor();
        this.paintTextR = new Rectangle();
    }

    @Override
    protected void paintComponent(Graphics g15) {
        String text;
        g15.setColor(this.realBG);
        int iconW = 0;
        if (this.getIcon() != null) {
            iconW = this.getIcon().getIconWidth();
        }
        if (this.selected && iconW > 0) {
            g15.fillRect(0, 0, iconW, this.getHeight());
            g15.setColor(this.getBackground());
            g15.fillRect(iconW, 0, this.getWidth() - iconW, this.getHeight());
        } else {
            g15.setColor(this.getBackground());
            g15.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.getIcon() != null) {
            Icon icon = this.getIcon();
            icon.paintIcon(this, g15, 0, (this.getHeight() - icon.getIconHeight()) / 2);
        }
        if ((text = this.getText()) != null) {
            this.paintTextR.setBounds(iconW, 0, this.getWidth() - iconW, this.getHeight());
            this.paintTextR.x += 3;
            int space = this.paintTextR.height - g15.getFontMetrics().getHeight();
            View v15 = (View)this.getClientProperty("html");
            if (v15 != null) {
                this.paintTextR.y += space / 2;
                this.paintTextR.height -= space;
                v15.paint(g15, this.paintTextR);
            } else {
                int textX = this.paintTextR.x;
                int textY = this.paintTextR.y;
                g15.drawString(text, textX, textY);
            }
        }
    }

    protected void prepareForFunctionCompletion(JList<?> list2, FunctionCompletion fc5, int index, boolean selected, boolean hasFocus) {
        StringBuilder sb5 = new StringBuilder(PREFIX);
        sb5.append(fc5.getName());
        char paramListStart = fc5.getProvider().getParameterListStart();
        if (paramListStart != '\u0000') {
            sb5.append(paramListStart);
        }
        int paramCount = fc5.getParamCount();
        for (int i15 = 0; i15 < paramCount; ++i15) {
            ParameterizedCompletion.Parameter param = fc5.getParam(i15);
            String type = param.getType();
            String name = param.getName();
            if (type != null) {
                if (!selected) {
                    sb5.append("<font color='").append(this.paramColor).append("'>");
                }
                sb5.append(type);
                if (!selected) {
                    sb5.append("</font>");
                }
                if (name != null) {
                    sb5.append(' ');
                }
            }
            if (name != null) {
                sb5.append(name);
            }
            if (i15 >= paramCount - 1) continue;
            sb5.append(fc5.getProvider().getParameterListSeparator());
        }
        char paramListEnd = fc5.getProvider().getParameterListEnd();
        if (paramListEnd != '\u0000') {
            sb5.append(paramListEnd);
        }
        this.appendTypeIfNecessary(sb5, fc5);
        this.setText(sb5.toString());
    }

    protected void prepareForMarkupTagCompletion(JList<?> list2, MarkupTagCompletion mc5, int index, boolean selected, boolean hasFocus) {
        this.setText(PREFIX + mc5.getName());
    }

    protected void prepareForOtherCompletion(JList<?> list2, Completion c15, int index, boolean selected, boolean hasFocus) {
        String definition;
        StringBuilder sb5 = new StringBuilder(PREFIX);
        sb5.append(c15.getInputText());
        if (c15 instanceof BasicCompletion && (definition = ((BasicCompletion)c15).getShortDescription()) != null) {
            this.appendShortDescription(sb5, definition);
        }
        this.setText(sb5.toString());
    }

    protected void prepareForTemplateCompletion(JList<?> list2, TemplateCompletion tc5, int index, boolean selected, boolean hasFocus) {
        StringBuilder sb5 = new StringBuilder(PREFIX);
        sb5.append(tc5.getInputText());
        String definition = tc5.getShortDescription();
        if (definition != null) {
            this.appendShortDescription(sb5, definition);
        }
        this.setText(sb5.toString());
    }

    protected void prepareForVariableCompletion(JList<?> list2, VariableCompletion vc5, int index, boolean selected, boolean hasFocus) {
        StringBuilder sb5 = new StringBuilder(PREFIX);
        sb5.append(vc5.getName());
        this.appendTypeIfNecessary(sb5, vc5);
        this.setText(sb5.toString());
    }

    public static void setAlternateBackground(Color altBG) {
        CompletionCellRenderer.altBG = altBG;
    }

    public void setDelegateRenderer(DefaultListCellRenderer delegate2) {
        this.delegate = delegate2;
    }

    public void setDisplayFont(Font font) {
        this.font = font;
    }

    protected void setIconWithDefault(Completion completion) {
        this.setIconWithDefault(completion, this.getEmptyIcon());
    }

    protected void setIconWithDefault(Completion completion, Icon defaultIcon) {
        Icon icon = completion.getIcon();
        this.setIcon(icon != null ? icon : (defaultIcon != null ? defaultIcon : this.emptyIcon));
    }

    public void setParamColor(Color color) {
        if (color != null) {
            this.paramColor = HtmlUtil.getHexString(color);
        }
    }

    public void setShowTypes(boolean show) {
        this.showTypes = show;
    }

    public void setTypeColor(Color color) {
        if (color != null) {
            this.typeColor = HtmlUtil.getHexString(color);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.delegate != null) {
            SwingUtilities.updateComponentTreeUI(this.delegate);
        }
        this.paramColor = this.createParamColor();
    }
}

