/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.section.diff;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.bined.EditMode;
import org.exbin.bined.basic.CodeAreaScrollPosition;
import org.exbin.bined.swing.section.SectCodeArea;
import org.exbin.bined.swing.section.SectionCodeAreaPainter;
import org.exbin.bined.swing.section.diff.DiffHighlightCodeAreaColorAssessor;

@ParametersAreNonnullByDefault
public class SectCodeAreaDiffPanel
extends JPanel {
    protected final SectCodeArea leftCodeArea;
    protected final SectCodeArea rightCodeArea;
    protected final DiffHighlightCodeAreaColorAssessor leftColorAssessor;
    protected final DiffHighlightCodeAreaColorAssessor rightColorAssessor;
    protected volatile boolean updatingScrolling = false;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JSplitPane splitPane;

    public SectCodeAreaDiffPanel() {
        this.initComponents();
        this.leftCodeArea = new SectCodeArea();
        this.rightCodeArea = new SectCodeArea();
        SectionCodeAreaPainter leftCodeAreaPainter = (SectionCodeAreaPainter)this.leftCodeArea.getPainter();
        this.leftColorAssessor = new DiffHighlightCodeAreaColorAssessor(this.leftCodeArea, leftCodeAreaPainter.getColorAssessor(), this.rightCodeArea.getContentData());
        leftCodeAreaPainter.setColorAssessor(this.leftColorAssessor);
        SectionCodeAreaPainter rightCodeAreaPainter = (SectionCodeAreaPainter)this.rightCodeArea.getPainter();
        this.rightColorAssessor = new DiffHighlightCodeAreaColorAssessor(this.rightCodeArea, rightCodeAreaPainter.getColorAssessor(), this.leftCodeArea.getContentData());
        rightCodeAreaPainter.setColorAssessor(this.rightColorAssessor);
        this.init();
    }

    private void init() {
        this.leftCodeArea.setEditMode(EditMode.READ_ONLY);
        this.rightCodeArea.setEditMode(EditMode.READ_ONLY);
        this.leftPanel.add((Component)this.leftCodeArea, "Center");
        this.rightPanel.add((Component)this.rightCodeArea, "Center");
        this.leftCodeArea.addScrollingListener(() -> {
            if (!this.updatingScrolling) {
                this.updatingScrolling = true;
                CodeAreaScrollPosition currentScrollPosition = this.rightCodeArea.getScrollPosition();
                CodeAreaScrollPosition scrollPosition = this.leftCodeArea.getScrollPosition();
                long maxRowPosition = this.rightCodeArea.getDataSize() / (long)this.rightCodeArea.getMaxBytesPerRow();
                if (scrollPosition.getRowPosition() > maxRowPosition) {
                    if (currentScrollPosition.getRowPosition() >= maxRowPosition) {
                        this.updatingScrolling = false;
                        return;
                    }
                    scrollPosition.setRowPosition(maxRowPosition);
                }
                this.rightCodeArea.setScrollPosition(scrollPosition);
                this.updatingScrolling = false;
            }
        });
        this.rightCodeArea.addScrollingListener(() -> {
            if (!this.updatingScrolling) {
                this.updatingScrolling = true;
                CodeAreaScrollPosition currentScrollPosition = this.leftCodeArea.getScrollPosition();
                CodeAreaScrollPosition scrollPosition = this.rightCodeArea.getScrollPosition();
                long maxRowPosition = this.leftCodeArea.getDataSize() / (long)this.leftCodeArea.getMaxBytesPerRow();
                if (scrollPosition.getRowPosition() > maxRowPosition) {
                    if (currentScrollPosition.getRowPosition() >= maxRowPosition) {
                        this.updatingScrolling = false;
                        return;
                    }
                    scrollPosition.setRowPosition(maxRowPosition);
                }
                this.leftCodeArea.setScrollPosition(scrollPosition);
                this.updatingScrolling = false;
            }
        });
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.leftPanel = new JPanel();
        this.rightPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.splitPane.setDividerLocation(300);
        this.splitPane.setResizeWeight(0.5);
        this.leftPanel.setLayout(new BorderLayout());
        this.splitPane.setLeftComponent(this.leftPanel);
        this.rightPanel.setLayout(new BorderLayout());
        this.splitPane.setRightComponent(this.rightPanel);
        this.add((Component)this.splitPane, "Center");
    }

    @Nonnull
    public SectCodeArea getLeftCodeArea() {
        return this.leftCodeArea;
    }

    @Nonnull
    public SectCodeArea getRightCodeArea() {
        return this.rightCodeArea;
    }

    public void setLeftContentData(BinaryData contentData) {
        this.leftCodeArea.setContentData(contentData);
        this.rightColorAssessor.setComparedData(contentData);
    }

    public void setRightContentData(BinaryData contentData) {
        this.rightCodeArea.setContentData(contentData);
        this.leftColorAssessor.setComparedData(contentData);
    }
}

