/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.section;

import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.exbin.bined.basic.ScrollBarVerticalScale;
import org.exbin.bined.basic.ScrollingDirection;
import org.exbin.bined.section.SectionCodeAreaStructure;
import org.exbin.bined.swing.CodeAreaSwingControl;
import org.exbin.bined.swing.basic.BasicCodeAreaMetrics;
import org.exbin.bined.swing.section.SectionCodeAreaDimensions;
import org.exbin.bined.swing.section.SectionCodeAreaScrolling;

@ParametersAreNonnullByDefault
public class SectionCodeAreaScrollPane
extends JScrollPane {
    protected volatile boolean scrollingByUser = false;
    protected volatile boolean scrollingUpdate = false;
    protected final VerticalScrollBarModel verticalScrollBarModel = new VerticalScrollBarModel();
    protected final HorizontalScrollBarModel horizontalScrollBarModel = new HorizontalScrollBarModel();
    @Nonnull
    protected final CodeAreaSwingControl control;
    @Nonnull
    protected final BasicCodeAreaMetrics metrics;
    @Nonnull
    protected final SectionCodeAreaStructure structure;
    @Nonnull
    protected final SectionCodeAreaScrolling scrolling;
    @Nonnull
    protected final SectionCodeAreaDimensions dimensions;

    public SectionCodeAreaScrollPane(CodeAreaSwingControl control, BasicCodeAreaMetrics metrics, SectionCodeAreaStructure structure, SectionCodeAreaScrolling scrolling, SectionCodeAreaDimensions dimensions) {
        this.control = control;
        this.metrics = metrics;
        this.structure = structure;
        this.dimensions = dimensions;
        this.scrolling = scrolling;
        this.init();
    }

    private void init() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setIgnoreRepaint(true);
        this.setOpaque(false);
        this.setInheritsPopupMenu(true);
        this.setViewportBorder(null);
        this.verticalScrollBar.setIgnoreRepaint(true);
        this.verticalScrollBar.addAdjustmentListener(new VerticalAdjustmentListener());
        this.verticalScrollBar.setModel(this.verticalScrollBarModel);
        this.verticalScrollBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e15) {
                if (e15.getButton() == 1) {
                    SectionCodeAreaScrollPane.this.scrollingByUser = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e15) {
                if (e15.getButton() == 1) {
                    SectionCodeAreaScrollPane.this.scrollingByUser = false;
                }
            }
        });
        this.horizontalScrollBar.setIgnoreRepaint(true);
        this.horizontalScrollBar.addAdjustmentListener(new HorizontalAdjustmentListener());
        this.horizontalScrollBar.setModel(this.horizontalScrollBarModel);
        this.horizontalScrollBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e15) {
                if (e15.getButton() == 1) {
                    SectionCodeAreaScrollPane.this.scrollingByUser = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e15) {
                if (e15.getButton() == 1) {
                    SectionCodeAreaScrollPane.this.scrollingByUser = false;
                }
            }
        });
    }

    @Override
    @Nonnull
    public JScrollBar createVerticalScrollBar() {
        return new JScrollPane.ScrollBar(1){

            @Override
            public void setValue(int value) {
                if (!SectionCodeAreaScrollPane.this.scrollingUpdate && !SectionCodeAreaScrollPane.this.scrollingByUser) {
                    SectionCodeAreaScrollPane.this.scrollingByUser = true;
                    super.setValue(value);
                    SectionCodeAreaScrollPane.this.scrollingByUser = false;
                } else {
                    super.setValue(value);
                }
            }
        };
    }

    @Override
    @Nonnull
    public JScrollBar createHorizontalScrollBar() {
        return new JScrollPane.ScrollBar(0){

            @Override
            public void setValue(int value) {
                if (!SectionCodeAreaScrollPane.this.scrollingUpdate && !SectionCodeAreaScrollPane.this.scrollingByUser) {
                    SectionCodeAreaScrollPane.this.scrollingByUser = true;
                    super.setValue(value);
                    SectionCodeAreaScrollPane.this.scrollingByUser = false;
                } else {
                    super.setValue(value);
                }
            }
        };
    }

    public void horizontalExtentChanged() {
        this.horizontalScrollBarModel.notifyChanged();
    }

    public void verticalExtentChanged() {
        this.verticalScrollBarModel.notifyChanged();
    }

    public void updateScrollBars(int verticalScrollValue, int horizontalScrollValue) {
        this.scrollingUpdate = true;
        this.verticalScrollBar.setValue(verticalScrollValue);
        this.horizontalScrollBar.setValue(horizontalScrollValue);
        this.scrollingUpdate = false;
    }

    protected class HorizontalAdjustmentListener
    implements AdjustmentListener {
        @Override
        public void adjustmentValueChanged(@Nullable AdjustmentEvent e15) {
            if (e15 == null || !SectionCodeAreaScrollPane.this.scrollingByUser || SectionCodeAreaScrollPane.this.scrollingUpdate) {
                return;
            }
            int scrollBarValue = SectionCodeAreaScrollPane.this.horizontalScrollBar.getValue();
            SectionCodeAreaScrollPane.this.scrolling.updateHorizontalScrollBarValue(scrollBarValue, SectionCodeAreaScrollPane.this.metrics.getCharacterWidth());
            SectionCodeAreaScrollPane.this.control.updateScrollPosition(SectionCodeAreaScrollPane.this.scrolling.getScrollPosition());
        }
    }

    protected class VerticalAdjustmentListener
    implements AdjustmentListener {
        private boolean wasAdjusting = false;

        @Override
        public void adjustmentValueChanged(@Nullable AdjustmentEvent e15) {
            if (e15 == null || SectionCodeAreaScrollPane.this.scrollingUpdate) {
                return;
            }
            if (!e15.getValueIsAdjusting()) {
                if (this.wasAdjusting) {
                    this.wasAdjusting = false;
                } else {
                    int lastValue = SectionCodeAreaScrollPane.this.scrolling.getLastVerticalScrollingValue();
                    if (SectionCodeAreaScrollPane.this.scrollingByUser && SectionCodeAreaScrollPane.this.scrolling.getScrollBarVerticalScale() == ScrollBarVerticalScale.SCALED && lastValue != -1) {
                        if (e15.getValue() == lastValue - 1 || lastValue == 0 && e15.getValue() == 0) {
                            SwingUtilities.invokeLater(() -> {
                                SectionCodeAreaScrollPane.this.scrolling.performScrolling(ScrollingDirection.UP, SectionCodeAreaScrollPane.this.dimensions.getRowsPerPage(), SectionCodeAreaScrollPane.this.structure.getRowsPerDocument());
                                SectionCodeAreaScrollPane.this.control.updateScrollPosition(SectionCodeAreaScrollPane.this.scrolling.getScrollPosition());
                            });
                            return;
                        }
                        int maxScroll = SectionCodeAreaScrollPane.this.verticalScrollBarModel.getMaximum() - SectionCodeAreaScrollPane.this.verticalScrollBarModel.getExtent();
                        if (e15.getValue() == lastValue + 1 || lastValue == maxScroll && e15.getValue() == maxScroll) {
                            SwingUtilities.invokeLater(() -> {
                                SectionCodeAreaScrollPane.this.scrolling.performScrolling(ScrollingDirection.DOWN, SectionCodeAreaScrollPane.this.dimensions.getRowsPerPage(), SectionCodeAreaScrollPane.this.structure.getRowsPerDocument());
                                SectionCodeAreaScrollPane.this.control.updateScrollPosition(SectionCodeAreaScrollPane.this.scrolling.getScrollPosition());
                            });
                            return;
                        }
                    }
                }
            } else {
                this.wasAdjusting = true;
            }
            if (SectionCodeAreaScrollPane.this.scrollingByUser) {
                int scrollBarValue = SectionCodeAreaScrollPane.this.verticalScrollBar.getValue();
                int maxValue = Integer.MAX_VALUE - SectionCodeAreaScrollPane.this.verticalScrollBar.getVisibleAmount();
                long rowsPerDocumentToLastPage = SectionCodeAreaScrollPane.this.structure.getRowsPerDocument() - (long)SectionCodeAreaScrollPane.this.dimensions.getRowsPerRect();
                SectionCodeAreaScrollPane.this.scrolling.updateVerticalScrollBarValue(scrollBarValue, SectionCodeAreaScrollPane.this.metrics.getRowHeight(), maxValue, rowsPerDocumentToLastPage);
                SectionCodeAreaScrollPane.this.control.updateScrollPosition(SectionCodeAreaScrollPane.this.scrolling.getScrollPosition());
            }
        }
    }

    protected class HorizontalScrollBarModel
    extends DefaultBoundedRangeModel {
        @Override
        public int getExtent() {
            return super.getExtent() - SectionCodeAreaScrollPane.this.scrolling.getHorizontalExtentDifference();
        }

        @Override
        public int getMaximum() {
            return super.getMaximum() - SectionCodeAreaScrollPane.this.scrolling.getHorizontalExtentDifference();
        }

        public void notifyChanged() {
            this.fireStateChanged();
        }
    }

    protected class VerticalScrollBarModel
    extends DefaultBoundedRangeModel {
        private volatile int depth = 0;

        @Override
        public int getExtent() {
            return super.getExtent() - SectionCodeAreaScrollPane.this.scrolling.getVerticalExtentDifference();
        }

        @Override
        public int getMaximum() {
            return super.getMaximum() - SectionCodeAreaScrollPane.this.scrolling.getVerticalExtentDifference();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setRangeProperties(int newValue, int newExtent, int newMin, int newMax, boolean adjusting) {
            super.setRangeProperties(newValue, newExtent, newMin, newMax, adjusting);
            if (!(SectionCodeAreaScrollPane.this.scrollingUpdate || newValue != SectionCodeAreaScrollPane.this.scrolling.getLastVerticalScrollingValue() || newValue > newMin && newValue < newMax - newExtent)) {
                ++this.depth;
                try {
                    if (this.depth < 5) {
                        this.fireStateChanged();
                    }
                }
                finally {
                    --this.depth;
                }
            }
        }

        @Override
        public void setValue(int n15) {
            SectionCodeAreaScrollPane.this.scrolling.setLastVerticalScrollingValue(this.getValue());
            super.setValue(n15);
        }

        public void notifyChanged() {
            this.fireStateChanged();
        }
    }
}

