/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.basic;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JScrollPane;
import org.exbin.bined.ScrollBarOrientation;
import org.exbin.bined.basic.SelectingMode;
import org.exbin.bined.capability.CaretCapable;
import org.exbin.bined.capability.ScrollingCapable;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public class DefaultCodeAreaMouseListener
extends MouseAdapter
implements MouseMotionListener,
MouseWheelListener {
    public static final int MOUSE_SCROLL_LINES = 3;
    protected final CodeAreaCore codeArea;
    protected final JScrollPane view;
    protected final Cursor defaultCursor = Cursor.getDefaultCursor();
    protected final Cursor textCursor = Cursor.getPredefinedCursor(2);
    protected Cursor currentCursor;
    protected boolean mouseDown = false;

    public DefaultCodeAreaMouseListener(CodeAreaCore codeArea, JScrollPane view) {
        this.codeArea = codeArea;
        this.view = view;
        this.currentCursor = codeArea.getCursor();
    }

    @Override
    public void mousePressed(MouseEvent me5) {
        this.codeArea.requestFocus();
        if (this.codeArea.isEnabled() && me5.getButton() == 1) {
            this.moveCaret(me5);
            this.mouseDown = true;
        }
    }

    private void moveCaret(MouseEvent me5) {
        SelectingMode selecting = (me5.getModifiersEx() & 0x40) > 0 ? SelectingMode.SELECTING : SelectingMode.NONE;
        this.codeArea.getCommandHandler().moveCaret(this.computeRelativeX(me5), this.computeRelativeY(me5), selecting);
        ((ScrollingCapable)((Object)this.codeArea)).revealCursor();
    }

    @Override
    public void mouseReleased(MouseEvent me5) {
        this.mouseDown = false;
    }

    @Override
    public void mouseExited(MouseEvent me5) {
        this.currentCursor = this.defaultCursor;
        this.codeArea.setCursor(this.defaultCursor);
    }

    @Override
    public void mouseEntered(MouseEvent me5) {
        this.updateMouseCursor(me5);
    }

    @Override
    public void mouseMoved(MouseEvent me5) {
        this.updateMouseCursor(me5);
    }

    private void updateMouseCursor(MouseEvent me5) {
        Cursor newCursor;
        int cursorShape = ((CaretCapable)((Object)this.codeArea)).getMouseCursorShape(this.computeRelativeX(me5), this.computeRelativeY(me5));
        Cursor cursor = newCursor = cursorShape == 0 ? this.defaultCursor : this.textCursor;
        if (newCursor != this.currentCursor) {
            this.currentCursor = newCursor;
            this.codeArea.setCursor(newCursor);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me5) {
        this.updateMouseCursor(me5);
        if (this.codeArea.isEnabled() && this.mouseDown) {
            this.codeArea.getCommandHandler().moveCaret(this.computeRelativeX(me5), this.computeRelativeY(me5), SelectingMode.SELECTING);
            ((ScrollingCapable)((Object)this.codeArea)).revealCursor();
        }
    }

    protected int computeRelativeX(MouseEvent me5) {
        boolean isDataView = me5.getSource() != this.codeArea;
        return isDataView ? me5.getX() + this.view.getX() : me5.getX();
    }

    protected int computeRelativeY(MouseEvent me5) {
        boolean isDataView = me5.getSource() != this.codeArea;
        return isDataView ? me5.getY() + this.view.getY() : me5.getY();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent me5) {
        if (!this.codeArea.isEnabled() || me5.getWheelRotation() == 0) {
            return;
        }
        ScrollBarOrientation orientation = me5.isShiftDown() ? ScrollBarOrientation.HORIZONTAL : ScrollBarOrientation.VERTICAL;
        int scrollAmount = me5.getWheelRotation() > 0 ? 3 : -3;
        this.codeArea.getCommandHandler().wheelScroll(scrollAmount, orientation);
    }
}

