/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.section;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.CodeType;
import org.exbin.bined.DataProvider;
import org.exbin.bined.PositionCodeType;
import org.exbin.bined.RowWrappingMode;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.basic.MovementDirection;
import org.exbin.bined.capability.CodeTypeCapable;
import org.exbin.bined.capability.RowWrappingCapable;
import org.exbin.bined.capability.ViewModeCapable;
import org.exbin.bined.section.capability.PositionCodeTypeCapable;
import org.exbin.bined.section.layout.SectionCodeAreaLayoutProfile;

@ParametersAreNonnullByDefault
public class SectionCodeAreaStructure {
    @Nonnull
    protected CodeAreaViewMode viewMode = CodeAreaViewMode.DUAL;
    @Nonnull
    protected CodeType codeType = CodeType.HEXADECIMAL;
    @Nonnull
    protected PositionCodeType positionCodeType = PositionCodeType.HEXADECIMAL;
    protected long dataSize;
    @Nonnull
    protected RowWrappingMode rowWrapping = RowWrappingMode.NO_WRAPPING;
    protected int maxBytesPerLine;
    protected int wrappingBytesGroupSize;
    protected SectionCodeAreaLayoutProfile layout;
    protected long rowsPerDocument;
    protected int bytesPerRow;
    protected int halfCharsPerRow;
    protected int codeLastHalfCharPos;

    public void updateCache(DataProvider codeArea, int halfCharsPerPage, SectionCodeAreaLayoutProfile layout) {
        this.layout = layout;
        this.viewMode = ((ViewModeCapable)((Object)codeArea)).getViewMode();
        this.codeType = ((CodeTypeCapable)((Object)codeArea)).getCodeType();
        this.positionCodeType = ((PositionCodeTypeCapable)((Object)codeArea)).getPositionCodeType();
        this.dataSize = codeArea.getDataSize();
        this.rowWrapping = ((RowWrappingCapable)((Object)codeArea)).getRowWrapping();
        this.maxBytesPerLine = ((RowWrappingCapable)((Object)codeArea)).getMaxBytesPerRow();
        this.wrappingBytesGroupSize = ((RowWrappingCapable)((Object)codeArea)).getWrappingBytesGroupSize();
        this.bytesPerRow = layout.computeBytesPerRow(halfCharsPerPage, this);
        this.halfCharsPerRow = layout.computeHalfCharsPerRow(this);
        this.codeLastHalfCharPos = this.viewMode == CodeAreaViewMode.TEXT_PREVIEW ? 0 : layout.computeLastByteHalfCharPos(this.bytesPerRow - 1, this.viewMode == CodeAreaViewMode.CODE_MATRIX ? BasicCodeAreaSection.CODE_MATRIX : BasicCodeAreaSection.TEXT_PREVIEW, this);
        this.rowsPerDocument = layout.computeRowsPerDocument(this);
    }

    public int computePositionByte(int rowHalfCharPosition) {
        return this.layout.computePositionByte(rowHalfCharPosition, this);
    }

    public int computeFirstCodeHalfCharPos(int byteOffset, CodeAreaSection section) {
        return this.layout.computeFirstByteHalfCharPos(byteOffset, section, this);
    }

    @Nonnull
    public CodeAreaCaretPosition computeMovePosition(CodeAreaCaretPosition position, MovementDirection direction, int rowsPerPage) {
        return this.layout.computeMovePosition(position, direction, this, rowsPerPage);
    }

    @Nonnull
    public CodeAreaViewMode getViewMode() {
        return this.viewMode;
    }

    @Nonnull
    public CodeType getCodeType() {
        return this.codeType;
    }

    @Nonnull
    public PositionCodeType getPositionCodeType() {
        return this.positionCodeType;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    @Nonnull
    public RowWrappingMode getRowWrapping() {
        return this.rowWrapping;
    }

    public int getMaxBytesPerLine() {
        return this.maxBytesPerLine;
    }

    public int getWrappingBytesGroupSize() {
        return this.wrappingBytesGroupSize;
    }

    public long getRowsPerDocument() {
        return this.rowsPerDocument;
    }

    public int getBytesPerRow() {
        return this.bytesPerRow;
    }

    public int getHalfCharsPerRow() {
        return this.halfCharsPerRow;
    }

    public int getCodeLastHalfCharPos() {
        return this.codeLastHalfCharPos;
    }
}

