/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.basic;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class CodeAreaScrollPosition {
    protected long rowPosition = 0L;
    protected int rowOffset = 0;
    protected int charPosition = 0;
    protected int charOffset = 0;

    public CodeAreaScrollPosition() {
    }

    public CodeAreaScrollPosition(long rowPosition, int rowOffset, int charPosition, int charOffset) {
        this.rowPosition = rowPosition;
        this.rowOffset = rowOffset;
        this.charPosition = charPosition;
        this.charOffset = charOffset;
    }

    public long getRowPosition() {
        return this.rowPosition;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public int getCharPosition() {
        return this.charPosition;
    }

    public int getCharOffset() {
        return this.charOffset;
    }

    public void setRowPosition(long rowPosition) {
        this.rowPosition = rowPosition;
    }

    public void setRowOffset(int rowOffset) {
        this.rowOffset = rowOffset;
    }

    public void setCharPosition(int charPosition) {
        this.charPosition = charPosition;
    }

    public void setCharOffset(int charOffset) {
        this.charOffset = charOffset;
    }

    public void setScrollPosition(@Nullable CodeAreaScrollPosition scrollPosition) {
        if (scrollPosition == null) {
            this.reset();
        } else {
            this.rowPosition = scrollPosition.getRowPosition();
            this.rowOffset = scrollPosition.getRowOffset();
            this.charPosition = scrollPosition.getCharPosition();
            this.charOffset = scrollPosition.getCharOffset();
        }
    }

    public void reset() {
        this.rowPosition = 0L;
        this.rowOffset = 0;
        this.charPosition = 0;
        this.charOffset = 0;
    }

    public int hashCode() {
        return Objects.hash(this.rowPosition, this.rowOffset, this.charPosition, this.charOffset);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeAreaScrollPosition other = (CodeAreaScrollPosition)obj;
        if (this.rowPosition != other.rowPosition) {
            return false;
        }
        if (this.rowOffset != other.rowOffset) {
            return false;
        }
        if (this.charPosition != other.charPosition) {
            return false;
        }
        return this.charOffset != other.charOffset;
    }

    public boolean isCharPositionGreaterThan(CodeAreaScrollPosition compPosition) {
        return this.charPosition > compPosition.charPosition || this.charPosition == compPosition.charPosition && this.charOffset > compPosition.charOffset;
    }

    public boolean isRowPositionGreaterThan(CodeAreaScrollPosition compPosition) {
        return this.rowPosition > compPosition.rowPosition || this.rowPosition == compPosition.rowPosition && this.rowOffset > compPosition.rowOffset;
    }
}

