/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.Utils;
import org.antlr.tool.Grammar;
import org.antlr.tool.ToolSTGroupFile;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDependencyGenerator {
    protected String grammarFileName;
    protected String tokenVocab;
    protected Tool tool;
    protected Grammar grammar;
    protected CodeGenerator generator;
    protected STGroup templates;

    public BuildDependencyGenerator(Tool tool, String grammarFileName) throws IOException {
        this.tool = tool;
        this.grammarFileName = grammarFileName;
        this.grammar = tool.getRootGrammar(grammarFileName);
        String language = (String)this.grammar.getOption("language");
        this.generator = new CodeGenerator(tool, this.grammar, language);
        this.generator.loadTemplates(language);
    }

    public List<File> getGeneratedFileList() {
        String suffix;
        ArrayList<File> files = new ArrayList<File>();
        File outputDir = this.tool.getOutputDirectory(this.grammarFileName);
        if (outputDir.getName().equals(".")) {
            outputDir = outputDir.getParentFile();
        } else if (outputDir.getName().indexOf(32) >= 0) {
            String escSpaces = Utils.replace(outputDir.toString(), " ", "\\ ");
            outputDir = new File(escSpaces);
        }
        String recognizer = this.generator.getRecognizerFileName(this.grammar.name, this.grammar.type);
        files.add(new File(outputDir, recognizer));
        files.add(new File(this.tool.getOutputDirectory(), this.generator.getVocabFileName()));
        ST headerExtST = null;
        ST extST = this.generator.getTemplates().getInstanceOf("codeFileExtension");
        if (this.generator.getTemplates().isDefined("headerFile")) {
            headerExtST = this.generator.getTemplates().getInstanceOf("headerFileExtension");
            suffix = Grammar.grammarTypeToFileNameSuffix[this.grammar.type];
            String fileName = this.grammar.name + suffix + headerExtST.render();
            files.add(new File(outputDir, fileName));
        }
        if (this.grammar.type == 4) {
            suffix = Grammar.grammarTypeToFileNameSuffix[1];
            String lexer = this.grammar.name + suffix + extST.render();
            files.add(new File(outputDir, lexer));
            if (headerExtST != null) {
                String header = this.grammar.name + suffix + headerExtST.render();
                files.add(new File(outputDir, header));
            }
        }
        List<Grammar> imports = this.grammar.composite.getDelegates(this.grammar.composite.getRootGrammar());
        for (Grammar g15 : imports) {
            outputDir = this.tool.getOutputDirectory(g15.getFileName());
            String fname = this.groomQualifiedFileName(outputDir.toString(), g15.getRecognizerName() + extST.render());
            files.add(new File(fname));
        }
        if (files.isEmpty()) {
            return null;
        }
        return files;
    }

    public List<File> getDependenciesFileList() {
        List<File> files = this.getNonImportDependenciesFileList();
        List<Grammar> imports = this.grammar.composite.getDelegates(this.grammar.composite.getRootGrammar());
        for (Grammar g15 : imports) {
            String libdir = this.tool.getLibraryDirectory();
            String fileName = this.groomQualifiedFileName(libdir, g15.fileName);
            files.add(new File(fileName));
        }
        if (files.isEmpty()) {
            return null;
        }
        return files;
    }

    public List<File> getNonImportDependenciesFileList() {
        ArrayList<File> files = new ArrayList<File>();
        this.tokenVocab = (String)this.grammar.getOption("tokenVocab");
        if (this.tokenVocab != null) {
            File vocabFile = this.tool.getImportedVocabFile(this.tokenVocab);
            files.add(vocabFile);
        }
        return files;
    }

    public ST getDependencies() {
        this.loadDependencyTemplates();
        ST dependenciesST = this.templates.getInstanceOf("dependencies");
        dependenciesST.add("in", this.getDependenciesFileList());
        dependenciesST.add("out", this.getGeneratedFileList());
        dependenciesST.add("grammarFileName", this.grammar.fileName);
        return dependenciesST;
    }

    public void loadDependencyTemplates() {
        if (this.templates != null) {
            return;
        }
        String fileName = "org/antlr/tool/templates/depend.stg";
        this.templates = new ToolSTGroupFile(fileName);
    }

    public String getTokenVocab() {
        return this.tokenVocab;
    }

    public CodeGenerator getGenerator() {
        return this.generator;
    }

    public String groomQualifiedFileName(String outputDir, String fileName) {
        if (outputDir.equals(".")) {
            return fileName;
        }
        if (outputDir.indexOf(32) >= 0) {
            String escSpaces = Utils.replace(outputDir.toString(), " ", "\\ ");
            return escSpaces + File.separator + fileName;
        }
        return outputDir + File.separator + fileName;
    }
}

