/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.InterfaceLexer;
import org.antlr.stringtemplate.language.InterfaceParser;

public class StringTemplateGroupInterface {
    protected String name;
    protected Map templates = new LinkedHashMap();
    protected StringTemplateGroupInterface superInterface = null;
    protected StringTemplateErrorListener listener = DEFAULT_ERROR_LISTENER;
    public static StringTemplateErrorListener DEFAULT_ERROR_LISTENER = new StringTemplateErrorListener(){

        public void error(String s15, Throwable e15) {
            System.err.println(s15);
            if (e15 != null) {
                e15.printStackTrace(System.err);
            }
        }

        public void warning(String s15) {
            System.out.println(s15);
        }
    };

    public StringTemplateGroupInterface(Reader r15) {
        this(r15, DEFAULT_ERROR_LISTENER, null);
    }

    public StringTemplateGroupInterface(Reader r15, StringTemplateErrorListener errors) {
        this(r15, errors, null);
    }

    public StringTemplateGroupInterface(Reader r15, StringTemplateErrorListener errors, StringTemplateGroupInterface superInterface) {
        this.listener = errors;
        this.setSuperInterface(superInterface);
        this.parseInterface(r15);
    }

    public StringTemplateGroupInterface getSuperInterface() {
        return this.superInterface;
    }

    public void setSuperInterface(StringTemplateGroupInterface superInterface) {
        this.superInterface = superInterface;
    }

    protected void parseInterface(Reader r15) {
        try {
            InterfaceLexer lexer = new InterfaceLexer(r15);
            InterfaceParser parser = new InterfaceParser(lexer);
            parser.groupInterface(this);
        }
        catch (Exception e15) {
            String name = "<unknown>";
            if (this.getName() != null) {
                name = this.getName();
            }
            this.error("problem parsing group " + name + ": " + e15, e15);
        }
    }

    public void defineTemplate(String name, LinkedHashMap formalArgs, boolean optional) {
        TemplateDefinition d15 = new TemplateDefinition(name, formalArgs, optional);
        this.templates.put(d15.name, d15);
    }

    public List getMissingTemplates(StringTemplateGroup group) {
        ArrayList<String> missing = new ArrayList<String>();
        Iterator it = this.templates.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            TemplateDefinition d15 = (TemplateDefinition)this.templates.get(name);
            if (d15.optional || group.isDefined(d15.name)) continue;
            missing.add(d15.name);
        }
        if (missing.size() == 0) {
            missing = null;
        }
        return missing;
    }

    public List getMismatchedTemplates(StringTemplateGroup group) {
        ArrayList<String> mismatched = new ArrayList<String>();
        Iterator it = this.templates.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            TemplateDefinition d15 = (TemplateDefinition)this.templates.get(name);
            if (!group.isDefined(d15.name)) continue;
            StringTemplate defST = group.getTemplateDefinition(d15.name);
            Map formalArgs = defST.getFormalArguments();
            boolean ack = false;
            if (d15.formalArgs != null && formalArgs == null || d15.formalArgs == null && formalArgs != null || d15.formalArgs.size() != formalArgs.size()) {
                ack = true;
            }
            if (!ack) {
                Iterator it22 = formalArgs.keySet().iterator();
                while (it22.hasNext()) {
                    String argName = (String)it22.next();
                    if (d15.formalArgs.get(argName) != null) continue;
                    ack = true;
                    break;
                }
            }
            if (!ack) continue;
            mismatched.add(this.getTemplateSignature(d15));
        }
        if (mismatched.size() == 0) {
            mismatched = null;
        }
        return mismatched;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void error(String msg, Exception e15) {
        if (this.listener != null) {
            this.listener.error(msg, e15);
        } else {
            System.err.println("StringTemplate: " + msg);
            if (e15 != null) {
                e15.printStackTrace();
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("interface ");
        buf.append(this.getName());
        buf.append(";\n");
        Iterator it = this.templates.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            TemplateDefinition d15 = (TemplateDefinition)this.templates.get(name);
            buf.append(this.getTemplateSignature(d15));
            buf.append(";\n");
        }
        return buf.toString();
    }

    protected String getTemplateSignature(TemplateDefinition d15) {
        StringBuffer buf = new StringBuffer();
        if (d15.optional) {
            buf.append("optional ");
        }
        buf.append(d15.name);
        if (d15.formalArgs != null) {
            StringBuffer args = new StringBuffer();
            args.append('(');
            int i15 = 1;
            Iterator it = d15.formalArgs.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                if (i15 > 1) {
                    args.append(", ");
                }
                args.append(name);
                ++i15;
            }
            args.append(')');
            buf.append(args);
        } else {
            buf.append("()");
        }
        return buf.toString();
    }

    static class TemplateDefinition {
        public String name;
        public LinkedHashMap formalArgs;
        public boolean optional = false;

        public TemplateDefinition(String name, LinkedHashMap formalArgs, boolean optional) {
            this.name = name;
            this.formalArgs = formalArgs;
            this.optional = optional;
        }
    }
}

