/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupInterface;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class PathGroupLoader
implements StringTemplateGroupLoader {
    protected List dirs = null;
    protected StringTemplateErrorListener errors = null;
    String fileCharEncoding = System.getProperty("file.encoding");

    public PathGroupLoader(StringTemplateErrorListener errors) {
        this.errors = errors;
    }

    public PathGroupLoader(String dirStr, StringTemplateErrorListener errors) {
        this.errors = errors;
        StringTokenizer tokenizer = new StringTokenizer(dirStr, ":", false);
        while (tokenizer.hasMoreElements()) {
            String dir = (String)tokenizer.nextElement();
            if (this.dirs == null) {
                this.dirs = new ArrayList();
            }
            this.dirs.add(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringTemplateGroup loadGroup(String groupName, Class templateLexer, StringTemplateGroup superGroup) {
        Class lexer;
        StringTemplateGroup group = null;
        BufferedReader br4 = null;
        Class clazz = lexer = AngleBracketTemplateLexer.class;
        if (templateLexer != null) {
            lexer = templateLexer;
        }
        try {
            br4 = this.locate(groupName + ".stg");
            if (br4 == null) {
                this.error("no such group file " + groupName + ".stg");
                StringTemplateGroup stringTemplateGroup = null;
                return stringTemplateGroup;
            }
            group = new StringTemplateGroup(br4, lexer, this.errors, superGroup);
            br4.close();
            br4 = null;
        }
        catch (IOException ioe) {
            this.error("can't load group " + groupName, ioe);
        }
        finally {
            if (br4 != null) {
                try {
                    br4.close();
                }
                catch (IOException ioe2) {
                    this.error("Cannot close template group file: " + groupName + ".stg", ioe2);
                }
            }
        }
        return group;
    }

    public StringTemplateGroup loadGroup(String groupName, StringTemplateGroup superGroup) {
        return this.loadGroup(groupName, null, superGroup);
    }

    public StringTemplateGroup loadGroup(String groupName) {
        return this.loadGroup(groupName, null);
    }

    public StringTemplateGroupInterface loadInterface(String interfaceName) {
        StringTemplateGroupInterface I11 = null;
        try {
            BufferedReader br4 = this.locate(interfaceName + ".sti");
            if (br4 == null) {
                this.error("no such interface file " + interfaceName + ".sti");
                return null;
            }
            I11 = new StringTemplateGroupInterface(br4, this.errors);
        }
        catch (IOException ioe) {
            this.error("can't load interface " + interfaceName, ioe);
        }
        return I11;
    }

    protected BufferedReader locate(String name) throws IOException {
        for (int i15 = 0; i15 < this.dirs.size(); ++i15) {
            String dir = (String)this.dirs.get(i15);
            String fileName = dir + "/" + name;
            if (!new File(fileName).exists()) continue;
            FileInputStream fis = new FileInputStream(fileName);
            InputStreamReader isr = this.getInputStreamReader(fis);
            return new BufferedReader(isr);
        }
        return null;
    }

    protected InputStreamReader getInputStreamReader(InputStream in4) {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(in4, this.fileCharEncoding);
        }
        catch (UnsupportedEncodingException uee) {
            this.error("Invalid file character encoding: " + this.fileCharEncoding);
        }
        return isr;
    }

    public String getFileCharEncoding() {
        return this.fileCharEncoding;
    }

    public void setFileCharEncoding(String fileCharEncoding) {
        this.fileCharEncoding = fileCharEncoding;
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void error(String msg, Exception e15) {
        if (this.errors != null) {
            this.errors.error(msg, e15);
        } else {
            System.err.println("StringTemplate: " + msg);
            if (e15 != null) {
                e15.printStackTrace();
            }
        }
    }
}

