/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.codegen.CodeGenerator;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SemanticContext {
    public static final SemanticContext EMPTY_SEMANTIC_CONTEXT = new Predicate(-2);

    public abstract SemanticContext getGatedPredicateContext();

    public abstract ST genExpr(CodeGenerator var1, STGroup var2, DFA var3);

    public abstract boolean hasUserSemanticPredicate();

    public abstract boolean isSyntacticPredicate();

    public void trackUseOfSyntacticPredicates(Grammar g15) {
    }

    public static SemanticContext and(SemanticContext a15, SemanticContext b15) {
        boolean factored;
        if (a15 instanceof FalsePredicate || b15 instanceof FalsePredicate) {
            return new FalsePredicate();
        }
        SemanticContext[] terms = SemanticContext.factorOr(a15, b15);
        SemanticContext commonTerms = terms[0];
        a15 = terms[1];
        b15 = terms[2];
        boolean bl4 = factored = commonTerms != null && commonTerms != EMPTY_SEMANTIC_CONTEXT && !(commonTerms instanceof TruePredicate);
        if (factored) {
            return SemanticContext.or(commonTerms, SemanticContext.and(a15, b15));
        }
        if (a15 instanceof FalsePredicate || b15 instanceof FalsePredicate) {
            return new FalsePredicate();
        }
        if (a15 == EMPTY_SEMANTIC_CONTEXT || a15 == null) {
            return b15;
        }
        if (b15 == EMPTY_SEMANTIC_CONTEXT || b15 == null) {
            return a15;
        }
        if (a15 instanceof TruePredicate) {
            return b15;
        }
        if (b15 instanceof TruePredicate) {
            return a15;
        }
        AND result = new AND(a15, b15);
        if (result.operands.size() == 1) {
            return (SemanticContext)result.operands.iterator().next();
        }
        return result;
    }

    public static SemanticContext or(SemanticContext a15, SemanticContext b15) {
        NOT n15;
        boolean factored;
        if (a15 instanceof TruePredicate || b15 instanceof TruePredicate) {
            return new TruePredicate();
        }
        SemanticContext[] terms = SemanticContext.factorAnd(a15, b15);
        SemanticContext commonTerms = terms[0];
        a15 = terms[1];
        b15 = terms[2];
        boolean bl4 = factored = commonTerms != null && commonTerms != EMPTY_SEMANTIC_CONTEXT && !(commonTerms instanceof FalsePredicate);
        if (factored) {
            return SemanticContext.and(commonTerms, SemanticContext.or(a15, b15));
        }
        if (a15 == EMPTY_SEMANTIC_CONTEXT || a15 == null || a15 instanceof FalsePredicate) {
            return b15;
        }
        if (b15 == EMPTY_SEMANTIC_CONTEXT || b15 == null || b15 instanceof FalsePredicate) {
            return a15;
        }
        if (a15 instanceof TruePredicate || b15 instanceof TruePredicate || commonTerms instanceof TruePredicate) {
            return new TruePredicate();
        }
        if (a15 instanceof NOT) {
            n15 = (NOT)a15;
            if (n15.ctx.equals(b15)) {
                return new TruePredicate();
            }
        } else if (b15 instanceof NOT) {
            n15 = (NOT)b15;
            if (n15.ctx.equals(a15)) {
                return new TruePredicate();
            }
        }
        OR result = new OR(a15, b15);
        if (result.operands.size() == 1) {
            return (SemanticContext)result.operands.iterator().next();
        }
        return result;
    }

    public static SemanticContext not(SemanticContext a15) {
        if (a15 instanceof NOT) {
            return ((NOT)a15).ctx;
        }
        if (a15 instanceof TruePredicate) {
            return new FalsePredicate();
        }
        if (a15 instanceof FalsePredicate) {
            return new TruePredicate();
        }
        return new NOT(a15);
    }

    public static SemanticContext[] factorAnd(SemanticContext a15, SemanticContext b15) {
        if (a15 == EMPTY_SEMANTIC_CONTEXT || a15 == null || a15 instanceof FalsePredicate) {
            return new SemanticContext[]{EMPTY_SEMANTIC_CONTEXT, a15, b15};
        }
        if (b15 == EMPTY_SEMANTIC_CONTEXT || b15 == null || b15 instanceof FalsePredicate) {
            return new SemanticContext[]{EMPTY_SEMANTIC_CONTEXT, a15, b15};
        }
        if (a15 instanceof TruePredicate || b15 instanceof TruePredicate) {
            return new SemanticContext[]{new TruePredicate(), EMPTY_SEMANTIC_CONTEXT, EMPTY_SEMANTIC_CONTEXT};
        }
        HashSet<SemanticContext> opsA = new HashSet<SemanticContext>(SemanticContext.getAndOperands(a15));
        HashSet<SemanticContext> opsB = new HashSet<SemanticContext>(SemanticContext.getAndOperands(b15));
        HashSet<SemanticContext> result = new HashSet<SemanticContext>(opsA);
        result.retainAll(opsB);
        if (result.isEmpty()) {
            return new SemanticContext[]{EMPTY_SEMANTIC_CONTEXT, a15, b15};
        }
        opsA.removeAll(result);
        a15 = opsA.isEmpty() ? new TruePredicate() : (opsA.size() == 1 ? opsA.iterator().next() : new AND(opsA));
        opsB.removeAll(result);
        b15 = opsB.isEmpty() ? new TruePredicate() : (opsB.size() == 1 ? opsB.iterator().next() : new AND(opsB));
        if (result.size() == 1) {
            return new SemanticContext[]{result.iterator().next(), a15, b15};
        }
        return new SemanticContext[]{new AND(result), a15, b15};
    }

    public static SemanticContext[] factorOr(SemanticContext a15, SemanticContext b15) {
        HashSet<SemanticContext> opsA = new HashSet<SemanticContext>(SemanticContext.getOrOperands(a15));
        HashSet<SemanticContext> opsB = new HashSet<SemanticContext>(SemanticContext.getOrOperands(b15));
        HashSet<SemanticContext> result = new HashSet<SemanticContext>(opsA);
        result.retainAll(opsB);
        if (result.isEmpty()) {
            return new SemanticContext[]{EMPTY_SEMANTIC_CONTEXT, a15, b15};
        }
        opsA.removeAll(result);
        a15 = opsA.isEmpty() ? new FalsePredicate() : (opsA.size() == 1 ? opsA.iterator().next() : new OR(opsA));
        opsB.removeAll(result);
        b15 = opsB.isEmpty() ? new FalsePredicate() : (opsB.size() == 1 ? opsB.iterator().next() : new OR(opsB));
        if (result.size() == 1) {
            return new SemanticContext[]{result.iterator().next(), a15, b15};
        }
        return new SemanticContext[]{new OR(result), a15, b15};
    }

    public static Collection<SemanticContext> getAndOperands(SemanticContext context) {
        if (context instanceof AND) {
            return ((AND)context).operands;
        }
        if (context instanceof NOT) {
            Collection<SemanticContext> operands = SemanticContext.getOrOperands(((NOT)context).ctx);
            ArrayList<SemanticContext> result = new ArrayList<SemanticContext>(operands.size());
            for (SemanticContext operand : operands) {
                result.add(SemanticContext.not(operand));
            }
            return result;
        }
        ArrayList<SemanticContext> result = new ArrayList<SemanticContext>();
        result.add(context);
        return result;
    }

    public static Collection<SemanticContext> getOrOperands(SemanticContext context) {
        if (context instanceof OR) {
            return ((OR)context).operands;
        }
        if (context instanceof NOT) {
            Collection<SemanticContext> operands = SemanticContext.getAndOperands(((NOT)context).ctx);
            ArrayList<SemanticContext> result = new ArrayList<SemanticContext>(operands.size());
            for (SemanticContext operand : operands) {
                result.add(SemanticContext.not(operand));
            }
            return result;
        }
        ArrayList<SemanticContext> result = new ArrayList<SemanticContext>();
        result.add(context);
        return result;
    }

    public static class NOT
    extends SemanticContext {
        protected SemanticContext ctx;

        public NOT(SemanticContext ctx) {
            this.ctx = ctx;
        }

        public ST genExpr(CodeGenerator generator, STGroup templates, DFA dfa) {
            ST eST = templates != null ? templates.getInstanceOf("notPredicate") : new ST("!(<pred>)");
            eST.add("pred", this.ctx.genExpr(generator, templates, dfa));
            return eST;
        }

        public SemanticContext getGatedPredicateContext() {
            SemanticContext p15 = this.ctx.getGatedPredicateContext();
            if (p15 == null) {
                return null;
            }
            return new NOT(p15);
        }

        public boolean hasUserSemanticPredicate() {
            return this.ctx.hasUserSemanticPredicate();
        }

        public boolean isSyntacticPredicate() {
            return this.ctx.isSyntacticPredicate();
        }

        public void trackUseOfSyntacticPredicates(Grammar g15) {
            this.ctx.trackUseOfSyntacticPredicates(g15);
        }

        public boolean equals(Object object) {
            if (!(object instanceof NOT)) {
                return false;
            }
            return this.ctx.equals(((NOT)object).ctx);
        }

        public int hashCode() {
            return ~this.ctx.hashCode();
        }

        public String toString() {
            return "!(" + this.ctx + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OR
    extends CommutativePredicate {
        public OR(SemanticContext a15, SemanticContext b15) {
            super(a15, b15);
        }

        public OR(HashSet<SemanticContext> contexts) {
            super(contexts);
        }

        @Override
        public ST genExpr(CodeGenerator generator, STGroup templates, DFA dfa) {
            ST eST = templates != null ? templates.getInstanceOf("orPredicates") : new ST("(<operands; separator=\"||\">)");
            for (SemanticContext semctx : this.operands) {
                eST.add("operands", semctx.genExpr(generator, templates, dfa));
            }
            return eST;
        }

        @Override
        public String getOperandString() {
            return "||";
        }

        @Override
        public SemanticContext combinePredicates(SemanticContext left, SemanticContext right) {
            return SemanticContext.or(left, right);
        }

        @Override
        public int calculateHashCode() {
            int hashcode = 0;
            for (SemanticContext context : this.operands) {
                hashcode = ~hashcode ^ context.hashCode();
            }
            return hashcode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AND
    extends CommutativePredicate {
        public AND(SemanticContext a15, SemanticContext b15) {
            super(a15, b15);
        }

        public AND(HashSet<SemanticContext> contexts) {
            super(contexts);
        }

        @Override
        public ST genExpr(CodeGenerator generator, STGroup templates, DFA dfa) {
            ST result = null;
            for (SemanticContext operand : this.operands) {
                if (result == null) {
                    result = operand.genExpr(generator, templates, dfa);
                    continue;
                }
                ST eST = templates != null ? templates.getInstanceOf("andPredicates") : new ST("(<left>&&<right>)");
                eST.add("left", result);
                eST.add("right", operand.genExpr(generator, templates, dfa));
                result = eST;
            }
            return result;
        }

        @Override
        public String getOperandString() {
            return "&&";
        }

        @Override
        public SemanticContext combinePredicates(SemanticContext left, SemanticContext right) {
            return SemanticContext.and(left, right);
        }

        @Override
        public int calculateHashCode() {
            int hashcode = 0;
            for (SemanticContext context : this.operands) {
                hashcode ^= context.hashCode();
            }
            return hashcode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CommutativePredicate
    extends SemanticContext {
        protected final Set<SemanticContext> operands = new HashSet<SemanticContext>();
        protected int hashcode;

        public CommutativePredicate(SemanticContext a15, SemanticContext b15) {
            CommutativePredicate predicate;
            if (a15.getClass() == this.getClass()) {
                predicate = (CommutativePredicate)a15;
                this.operands.addAll(predicate.operands);
            } else {
                this.operands.add(a15);
            }
            if (b15.getClass() == this.getClass()) {
                predicate = (CommutativePredicate)b15;
                this.operands.addAll(predicate.operands);
            } else {
                this.operands.add(b15);
            }
            this.hashcode = this.calculateHashCode();
        }

        public CommutativePredicate(HashSet<SemanticContext> contexts) {
            for (SemanticContext context : contexts) {
                if (context.getClass() == this.getClass()) {
                    CommutativePredicate predicate = (CommutativePredicate)context;
                    this.operands.addAll(predicate.operands);
                    continue;
                }
                this.operands.add(context);
            }
            this.hashcode = this.calculateHashCode();
        }

        @Override
        public SemanticContext getGatedPredicateContext() {
            SemanticContext result = null;
            for (SemanticContext semctx : this.operands) {
                SemanticContext gatedPred = semctx.getGatedPredicateContext();
                if (gatedPred == null) continue;
                result = this.combinePredicates(result, gatedPred);
            }
            return result;
        }

        @Override
        public boolean hasUserSemanticPredicate() {
            for (SemanticContext semctx : this.operands) {
                if (!semctx.hasUserSemanticPredicate()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isSyntacticPredicate() {
            for (SemanticContext semctx : this.operands) {
                if (!semctx.isSyntacticPredicate()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void trackUseOfSyntacticPredicates(Grammar g15) {
            for (SemanticContext semctx : this.operands) {
                semctx.trackUseOfSyntacticPredicates(g15);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                CommutativePredicate commutative = (CommutativePredicate)obj;
                Set<SemanticContext> otherOperands = commutative.operands;
                if (this.operands.size() != otherOperands.size()) {
                    return false;
                }
                return this.operands.containsAll(otherOperands);
            }
            if (obj instanceof NOT) {
                NOT not = (NOT)obj;
                if (not.ctx instanceof CommutativePredicate && not.ctx.getClass() != this.getClass()) {
                    Set<SemanticContext> otherOperands = ((CommutativePredicate)not.ctx).operands;
                    if (this.operands.size() != otherOperands.size()) {
                        return false;
                    }
                    ArrayList<SemanticContext> temp = new ArrayList<SemanticContext>(this.operands.size());
                    for (SemanticContext context : otherOperands) {
                        temp.add(CommutativePredicate.not(context));
                    }
                    return this.operands.containsAll(temp);
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("(");
            int i15 = 0;
            for (SemanticContext semctx : this.operands) {
                if (i15 > 0) {
                    buf.append(this.getOperandString());
                }
                buf.append(semctx.toString());
                ++i15;
            }
            buf.append(")");
            return buf.toString();
        }

        public abstract String getOperandString();

        public abstract SemanticContext combinePredicates(SemanticContext var1, SemanticContext var2);

        public abstract int calculateHashCode();
    }

    public static class FalsePredicate
    extends Predicate {
        public FalsePredicate() {
            super(0);
        }

        public ST genExpr(CodeGenerator generator, STGroup templates, DFA dfa) {
            if (templates != null) {
                return templates.getInstanceOf("false");
            }
            return new ST("false");
        }

        public boolean hasUserSemanticPredicate() {
            return false;
        }

        public String toString() {
            return "false";
        }
    }

    public static class TruePredicate
    extends Predicate {
        public TruePredicate() {
            super(-1);
        }

        public ST genExpr(CodeGenerator generator, STGroup templates, DFA dfa) {
            if (templates != null) {
                return templates.getInstanceOf("true_value");
            }
            return new ST("true");
        }

        public boolean hasUserSemanticPredicate() {
            return false;
        }

        public String toString() {
            return "true";
        }
    }

    public static class Predicate
    extends SemanticContext {
        public GrammarAST predicateAST;
        protected boolean gated = false;
        protected boolean synpred = false;
        public static final int INVALID_PRED_VALUE = -2;
        public static final int FALSE_PRED = 0;
        public static final int TRUE_PRED = -1;
        protected int constantValue = -2;

        public Predicate(int constantValue) {
            this.predicateAST = new GrammarAST();
            this.constantValue = constantValue;
        }

        public Predicate(GrammarAST predicate) {
            this.predicateAST = predicate;
            this.gated = predicate.getType() == 41 || predicate.getType() == 90;
            this.synpred = predicate.getType() == 90 || predicate.getType() == 14;
        }

        public Predicate(Predicate p15) {
            this.predicateAST = p15.predicateAST;
            this.gated = p15.gated;
            this.synpred = p15.synpred;
            this.constantValue = p15.constantValue;
        }

        public boolean equals(Object o15) {
            if (!(o15 instanceof Predicate)) {
                return false;
            }
            Predicate other = (Predicate)o15;
            if (this.constantValue != other.constantValue) {
                return false;
            }
            if (this.constantValue != -2) {
                return true;
            }
            return this.predicateAST.getText().equals(other.predicateAST.getText());
        }

        public int hashCode() {
            if (this.constantValue != -2) {
                return this.constantValue;
            }
            if (this.predicateAST == null) {
                return 0;
            }
            return this.predicateAST.getText().hashCode();
        }

        public ST genExpr(CodeGenerator generator, STGroup templates, DFA dfa) {
            ST eST;
            if (templates != null) {
                if (this.synpred) {
                    eST = templates.getInstanceOf("evalSynPredicate");
                } else {
                    eST = templates.getInstanceOf("evalPredicate");
                    generator.grammar.decisionsWhoseDFAsUsesSemPreds.add(dfa);
                }
                String predEnclosingRuleName = this.predicateAST.enclosingRuleName;
                if (generator != null) {
                    eST.add("pred", generator.translateAction(predEnclosingRuleName, this.predicateAST));
                }
            } else {
                ST eST2 = new ST("<pred>");
                eST2.add("pred", this.toString());
                return eST2;
            }
            if (generator != null) {
                String description = generator.target.getTargetStringLiteralFromString(this.toString());
                eST.add("description", description);
            }
            return eST;
        }

        public SemanticContext getGatedPredicateContext() {
            if (this.gated) {
                return this;
            }
            return null;
        }

        public boolean hasUserSemanticPredicate() {
            return this.predicateAST != null && (this.predicateAST.getType() == 41 || this.predicateAST.getType() == 83);
        }

        public boolean isSyntacticPredicate() {
            return this.predicateAST != null && (this.predicateAST.getType() == 90 || this.predicateAST.getType() == 14);
        }

        public void trackUseOfSyntacticPredicates(Grammar g15) {
            if (this.synpred) {
                g15.synPredNamesUsedInDFA.add(this.predicateAST.getText());
            }
        }

        public String toString() {
            if (this.predicateAST == null) {
                return "<nopred>";
            }
            return this.predicateAST.getText();
        }
    }
}

