/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import net.fabricmc.mappingio.tree.MappingTreeView;
import org.jetbrains.annotations.Nullable;

public interface MappingTree
extends MappingTreeView {
    @Nullable
    public String setSrcNamespace(String var1);

    public List<String> setDstNamespaces(List<String> var1);

    public List<? extends MetadataEntry> getMetadata();

    public List<? extends MetadataEntry> getMetadata(String var1);

    public void addMetadata(MetadataEntry var1);

    public boolean removeMetadata(String var1);

    public Collection<? extends ClassMapping> getClasses();

    @Override
    @Nullable
    public ClassMapping getClass(String var1);

    @Override
    @Nullable
    default public ClassMapping getClass(String name, int namespace) {
        return (ClassMapping)MappingTreeView.super.getClass(name, namespace);
    }

    public ClassMapping addClass(ClassMapping var1);

    @Nullable
    public ClassMapping removeClass(String var1);

    default public void propagateOuterClassNames(boolean processRemappedDstNames) {
        this.propagateOuterClassNames(this.getSrcNamespace(), this.getDstNamespaces(), processRemappedDstNames);
    }

    default public void propagateOuterClassNames(String srcNamespace, Collection<String> dstNamespaces, boolean processRemappedDstNames) {
        int srcNsId = this.getNamespaceId(srcNamespace);
        if (srcNsId == -2) {
            throw new IllegalArgumentException("Namespace " + srcNsId + " does not exist");
        }
        for (ClassMapping classMapping : this.getClasses()) {
            block1: for (String dstNs : dstNamespaces) {
                String[] dstParts;
                String srcName;
                int dstNsId = this.getNamespaceId(dstNs);
                if (dstNsId == -1) {
                    throw new UnsupportedOperationException("Cannot change source names");
                }
                if (dstNsId == -2) {
                    throw new IllegalArgumentException("Destination namespace " + dstNs + " does not exist");
                }
                if (dstNsId == srcNsId || (srcName = classMapping.getName(srcNsId)) == null) continue;
                String dstName = classMapping.getName(dstNsId);
                int idx = srcName.lastIndexOf(36);
                if (idx == -1 || !processRemappedDstNames && dstName != null && !dstName.equals(srcName)) continue;
                String[] srcParts = srcName.split(Pattern.quote("$"));
                String[] stringArray = dstParts = dstName == null ? srcParts : dstName.split(Pattern.quote("$"));
                if (!1.$assertionsDisabled && dstParts.length != srcParts.length) {
                    throw new AssertionError();
                }
                for (int pos = srcParts.length - 2; pos >= 0; --pos) {
                    String outerDstName;
                    ClassMapping outerCls;
                    String outerSrcName = String.join((CharSequence)"$", Arrays.copyOfRange(srcParts, 0, pos + 1));
                    if (dstName != null && !dstParts[pos].equals(srcParts[pos]) || (outerCls = this.getClass(outerSrcName, srcNsId)) == null || (outerDstName = outerCls.getName(dstNsId)) == null || outerDstName.equals(outerSrcName)) continue;
                    classMapping.setDstName(outerDstName + "$" + String.join((CharSequence)"$", Arrays.copyOfRange(dstParts, pos + 1, dstParts.length)), dstNsId);
                    continue block1;
                }
            }
        }
    }

    @Override
    @Nullable
    default public FieldMapping getField(String srcClsName, String srcName, @Nullable String srcDesc) {
        return (FieldMapping)MappingTreeView.super.getField(srcClsName, srcName, srcDesc);
    }

    @Override
    @Nullable
    default public FieldMapping getField(String clsName, String name, @Nullable String desc, int namespace) {
        return (FieldMapping)MappingTreeView.super.getField(clsName, name, desc, namespace);
    }

    @Override
    @Nullable
    default public MethodMapping getMethod(String srcClsName, String srcName, @Nullable String srcDesc) {
        return (MethodMapping)MappingTreeView.super.getMethod(srcClsName, srcName, srcDesc);
    }

    @Override
    @Nullable
    default public MethodMapping getMethod(String clsName, String name, @Nullable String desc, int namespace) {
        return (MethodMapping)MappingTreeView.super.getMethod(clsName, name, desc, namespace);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface ClassMapping
    extends ElementMapping,
    MappingTreeView.ClassMappingView {
        public Collection<? extends FieldMapping> getFields();

        @Override
        @Nullable
        public FieldMapping getField(String var1, @Nullable String var2);

        @Override
        @Nullable
        default public FieldMapping getField(String name, @Nullable String desc, int namespace) {
            return (FieldMapping)MappingTreeView.ClassMappingView.super.getField(name, desc, namespace);
        }

        public FieldMapping addField(FieldMapping var1);

        @Nullable
        public FieldMapping removeField(String var1, @Nullable String var2);

        public Collection<? extends MethodMapping> getMethods();

        @Override
        @Nullable
        public MethodMapping getMethod(String var1, @Nullable String var2);

        @Override
        @Nullable
        default public MethodMapping getMethod(String name, @Nullable String desc, int namespace) {
            return (MethodMapping)MappingTreeView.ClassMappingView.super.getMethod(name, desc, namespace);
        }

        public MethodMapping addMethod(MethodMapping var1);

        @Nullable
        public MethodMapping removeMethod(String var1, @Nullable String var2);
    }

    public static interface FieldMapping
    extends MemberMapping,
    MappingTreeView.FieldMappingView {
    }

    public static interface MethodMapping
    extends MemberMapping,
    MappingTreeView.MethodMappingView {
        public Collection<? extends MethodArgMapping> getArgs();

        @Override
        @Nullable
        public MethodArgMapping getArg(int var1, int var2, @Nullable String var3);

        public MethodArgMapping addArg(MethodArgMapping var1);

        @Nullable
        public MethodArgMapping removeArg(int var1, int var2, @Nullable String var3);

        public Collection<? extends MethodVarMapping> getVars();

        @Override
        @Nullable
        public MethodVarMapping getVar(int var1, int var2, int var3, int var4, @Nullable String var5);

        public MethodVarMapping addVar(MethodVarMapping var1);

        @Nullable
        public MethodVarMapping removeVar(int var1, int var2, int var3, int var4, @Nullable String var5);
    }

    public static interface MethodVarMapping
    extends ElementMapping,
    MappingTreeView.MethodVarMappingView {
        @Override
        public MethodMapping getMethod();

        public void setLvtRowIndex(int var1);

        public void setLvIndex(int var1, int var2, int var3);
    }

    public static interface MethodArgMapping
    extends ElementMapping,
    MappingTreeView.MethodArgMappingView {
        @Override
        public MethodMapping getMethod();

        public void setArgPosition(int var1);

        public void setLvIndex(int var1);
    }

    public static interface MemberMapping
    extends ElementMapping,
    MappingTreeView.MemberMappingView {
        @Override
        public ClassMapping getOwner();

        public void setSrcDesc(String var1);
    }

    public static interface ElementMapping
    extends MappingTreeView.ElementMappingView {
        @Override
        public MappingTree getTree();

        public void setDstName(String var1, int var2);

        public void setComment(String var1);
    }

    public static interface MetadataEntry
    extends MappingTreeView.MetadataEntryView {
    }
}

